/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util;

import java.io.PrintStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.lifecycle.Lifecycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReflectUtil {
    private static final String NAMESPACE_SEPARATOR = ".";
    public static final Class<Object> ROOT_CLASS = Object.class;
    public static final Class<?>[] NO_PARAMETERS = null;
    public static final Object[] NO_ARGUMENTS = null;
    private static final Method HASH_CODE_METHOD = ReflectUtil.lookupHashCodeMethod();
    private static final Map<Object, Long> ids = new WeakHashMap<Object, Long>();
    public static boolean DUMP_STATICS = false;
    private static long lastID;

    private ReflectUtil() {
    }

    public static Method getMethod(Class<?> c, String methodName, Class<?> ... parameterTypes) {
        try {
            try {
                return c.getDeclaredMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException ex) {
                Class<?> superclass = c.getSuperclass();
                if (superclass != null) {
                    return ReflectUtil.getMethod(superclass, methodName, parameterTypes);
                }
                throw ex;
            }
        }
        catch (Exception ex) {
            throw WrappedException.wrap(ex);
        }
    }

    public static Object invokeMethod(Method method, Object target, Object ... arguments) {
        boolean accessible = method.isAccessible();
        if (!accessible) {
            method.setAccessible(true);
        }
        try {
            Object object = method.invoke(target, arguments);
            return object;
        }
        catch (Exception ex) {
            throw WrappedException.wrap(ex);
        }
        finally {
            if (!accessible) {
                method.setAccessible(false);
            }
        }
    }

    public static Field getField(Class<?> c, String fieldName) {
        try {
            try {
                return c.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException ex) {
                Class<?> superclass = c.getSuperclass();
                if (superclass != null) {
                    return ReflectUtil.getField(superclass, fieldName);
                }
                return null;
            }
        }
        catch (Exception ex) {
            throw WrappedException.wrap(ex);
        }
    }

    public static void collectFields(Class<?> c, List<Field> fields) {
        if (c == ROOT_CLASS) {
            return;
        }
        ReflectUtil.collectFields(c.getSuperclass(), fields);
        try {
            Field[] declaredFields;
            Field[] fieldArray = declaredFields = c.getDeclaredFields();
            int n = declaredFields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (!field.isSynthetic() && ((field.getModifiers() & 8) == 0 || DUMP_STATICS) && field.getAnnotation(ExcludeFromDump.class) == null) {
                    fields.add(field);
                }
                ++n2;
            }
        }
        catch (Exception ex) {
            throw WrappedException.wrap(ex);
        }
    }

    public static Object getValue(Field field, Object target) {
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        try {
            return field.get(target);
        }
        catch (Exception ex) {
            throw WrappedException.wrap(ex);
        }
    }

    public static void setValue(Field field, Object target, Object value) {
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        try {
            field.set(target, value);
        }
        catch (Exception ex) {
            throw WrappedException.wrap(ex);
        }
    }

    public static void printStackTrace(PrintStream out, StackTraceElement[] stackTrace) {
        int i = 2;
        while (i < stackTrace.length) {
            StackTraceElement stackTraceElement = stackTrace[i];
            out.println("\tat " + stackTraceElement);
            ++i;
        }
    }

    public static void printStackTrace(StackTraceElement[] stackTrace) {
        ReflectUtil.printStackTrace(System.err, stackTrace);
    }

    public static Integer getHashCode(Object object) {
        try {
            return (Integer)HASH_CODE_METHOD.invoke(object, NO_ARGUMENTS);
        }
        catch (Exception ex) {
            IOUtil.print(ex);
            return 0;
        }
    }

    public static synchronized Long getID(Object object) {
        Long id = ids.get(object);
        if (id == null) {
            id = ++lastID;
            ids.put(object, id);
        }
        return id;
    }

    public static String getPackageName(Class<? extends Object> c) {
        if (c == null) {
            return null;
        }
        return ReflectUtil.getPackageName(c.getName());
    }

    public static String getPackageName(String className) {
        if (className == null) {
            return null;
        }
        int lastDot = className.lastIndexOf(46);
        if (lastDot != -1) {
            className = className.substring(0, lastDot);
        }
        return className;
    }

    public static String getSimpleName(Class<? extends Object> c) {
        if (c == null) {
            return null;
        }
        return c.getSimpleName();
    }

    public static String getSimpleClassName(String name) {
        if (name == null) {
            return null;
        }
        int lastDot = name.lastIndexOf(46);
        if (lastDot != -1) {
            name = name.substring(lastDot + 1);
        }
        return name.replace('$', '.');
    }

    public static String getSimpleClassName(Object object) {
        if (object == null) {
            return null;
        }
        return ReflectUtil.getSimpleName(object.getClass());
    }

    public static String getLabel(Object object) {
        if (object == null) {
            return null;
        }
        String name = object.getClass().getSimpleName();
        if (name.length() == 0) {
            name = "anonymous";
        }
        return String.valueOf(name) + "@" + ReflectUtil.getID(object);
    }

    public static void dump(Object object) {
        ReflectUtil.dump(object, "");
    }

    public static void dump(Object object, String prefix) {
        ReflectUtil.dump(object, prefix, IOUtil.OUT());
    }

    public static void dump(Object object, String prefix, PrintStream out) {
        out.print(ReflectUtil.toString(object, prefix));
    }

    public static Pair<Field, Object>[] dumpToArray(Object object) {
        ArrayList<Field> fields = new ArrayList<Field>();
        ReflectUtil.collectFields(object.getClass(), fields);
        Pair[] result = new Pair[fields.size()];
        int i = 0;
        for (Field field : fields) {
            Object value = ReflectUtil.getValue(field, object);
            result[i++] = new Pair<Field, Object>(field, value);
        }
        return result;
    }

    public static Object instantiate(Map<Object, Object> properties, String namespace, String classKey, ClassLoader classLoader) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method[] methods;
        if (namespace != null) {
            if (namespace.length() == 0) {
                namespace = null;
            } else if (!namespace.endsWith(NAMESPACE_SEPARATOR)) {
                namespace = String.valueOf(namespace) + NAMESPACE_SEPARATOR;
            }
        }
        String className = null;
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (!(entry.getKey() instanceof String)) continue;
            String key = (String)entry.getKey();
            if (namespace != null) {
                if (!key.startsWith(namespace)) continue;
                key = key.substring(namespace.length());
            }
            if (classKey.equals(key)) {
                Object classValue = entry.getValue();
                if (classValue instanceof String) {
                    className = (String)classValue;
                    continue;
                }
                OM.LOG.warn("Value of classKey " + classKey + " is not a String");
                continue;
            }
            values.put(key, entry.getValue());
        }
        if (className == null) {
            throw new IllegalArgumentException("Properties do not contain a valid class name for key " + classKey);
        }
        Class<?> c = classLoader.loadClass(className);
        Object instance = c.newInstance();
        Method[] methodArray = methods = c.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            Object value;
            Method method = methodArray[n2];
            if (ReflectUtil.isSetter(method) && (value = values.get(name = StringUtil.uncap(method.getName().substring(3)))) != null) {
                Class<?> type = method.getParameterTypes()[0];
                if (!type.isAssignableFrom(value.getClass())) {
                    if (value instanceof String) {
                        String str = (String)value;
                        value = null;
                        if (type.isAssignableFrom(Boolean.class)) {
                            value = Boolean.parseBoolean(str);
                        } else if (type.isAssignableFrom(Byte.class)) {
                            value = Byte.parseByte(str);
                        } else if (type.isAssignableFrom(Short.class)) {
                            value = Short.parseShort(str);
                        } else if (type.isAssignableFrom(Integer.class)) {
                            value = Integer.parseInt(str);
                        } else if (type.isAssignableFrom(Long.class)) {
                            value = Long.parseLong(str);
                        } else if (type.isAssignableFrom(Float.class)) {
                            value = Float.valueOf(Float.parseFloat(str));
                        } else if (type.isAssignableFrom(Double.class)) {
                            value = Double.parseDouble(str);
                        }
                    } else {
                        value = null;
                    }
                }
                if (value == null) {
                    throw new IllegalArgumentException("Value of property " + name + " can not be assigned to type " + type.getName());
                }
                method.invoke(instance, value);
            }
            ++n2;
        }
        return instance;
    }

    public static boolean isSetter(Method method) {
        return method.getParameterTypes().length == 1 && ReflectUtil.isSetterName(method.getName());
    }

    public static boolean isSetterName(String name) {
        return name.startsWith("set") && name.length() > 3 && Character.isUpperCase(name.charAt(3));
    }

    public static String toString(Object object) {
        return ReflectUtil.toString(object, "  ");
    }

    public static String toString(Object object, String prefix) {
        StringBuilder builder = new StringBuilder();
        builder.append(prefix);
        builder.append(ReflectUtil.getLabel(object));
        builder.append(StringUtil.NL);
        ReflectUtil.toString(object.getClass(), object, prefix, builder);
        return builder.toString();
    }

    private static void toString(Class<? extends Object> segment, Object object, String prefix, StringBuilder builder) {
        if (segment == ROOT_CLASS || segment == Lifecycle.class) {
            return;
        }
        ReflectUtil.toString(segment.getSuperclass(), object, prefix, builder);
        String segmentPrefix = segment == object.getClass() ? "" : String.valueOf(ReflectUtil.getSimpleName(segment)) + NAMESPACE_SEPARATOR;
        Field[] fieldArray = segment.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (!field.isSynthetic() && ((field.getModifiers() & 8) == 0 || DUMP_STATICS) && field.getAnnotation(ExcludeFromDump.class) == null) {
                builder.append(prefix);
                builder.append(segmentPrefix);
                builder.append(field.getName());
                builder.append(" = ");
                Set value = ReflectUtil.getValue(field, object);
                if (value instanceof Map) {
                    value = ((Map)((Object)value)).entrySet();
                }
                if (value instanceof Collection) {
                    builder.append(StringUtil.NL);
                    for (Object element : (Collection)value) {
                        builder.append("    ");
                        builder.append(element);
                        builder.append(StringUtil.NL);
                    }
                } else {
                    builder.append(value);
                    builder.append(StringUtil.NL);
                }
            }
            ++n2;
        }
    }

    private static Method lookupHashCodeMethod() {
        Method method;
        try {
            method = ROOT_CLASS.getMethod("hashCode", NO_PARAMETERS);
        }
        catch (Exception ex) {
            throw new AssertionError();
        }
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        return method;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface ExcludeFromDump {
    }
}

