/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.eclipse.net4j.util.om.OMPlatform;

public final class StringUtil {
    public static final String EMPTY = "";
    public static final String NL = OMPlatform.INSTANCE.getProperty("line.separator");

    private StringUtil() {
    }

    public static String formatException(Throwable t) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream s = new PrintStream(baos);
        t.printStackTrace(s);
        return baos.toString();
    }

    public static String replace(String text, String[] find, String[] replace) {
        int i = 0;
        while (i < find.length) {
            int start;
            int end = 0;
            while ((start = text.indexOf(find[i], end)) != -1) {
                end = start + find[i].length();
                text = String.valueOf(text.substring(0, start)) + replace[i] + text.substring(end);
            }
            ++i;
        }
        return text;
    }

    public static String safe(String str) {
        if (str == null) {
            return EMPTY;
        }
        return str;
    }

    public static int compare(String s1, String s2) {
        if (s1 == null) {
            return s2 == null ? 0 : -1;
        }
        if (s2 == null) {
            return 1;
        }
        return s1.compareTo(s2);
    }

    public static String capAll(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        boolean inWhiteSpace = true;
        StringBuilder builder = new StringBuilder(str);
        int i = 0;
        while (i < builder.length()) {
            char c = builder.charAt(i);
            boolean isWhiteSpace = Character.isWhitespace(c);
            if (!isWhiteSpace && inWhiteSpace) {
                builder.setCharAt(i, Character.toUpperCase(c));
            }
            inWhiteSpace = isWhiteSpace;
            ++i;
        }
        return builder.toString();
    }

    public static String uncapAll(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        boolean inWhiteSpace = true;
        StringBuilder builder = new StringBuilder(str);
        int i = 0;
        while (i < builder.length()) {
            char c = builder.charAt(i);
            boolean isWhiteSpace = Character.isWhitespace(c);
            if (!isWhiteSpace && inWhiteSpace) {
                builder.setCharAt(i, Character.toLowerCase(c));
            }
            inWhiteSpace = isWhiteSpace;
            ++i;
        }
        return builder.toString();
    }

    public static String cap(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        char first = str.charAt(0);
        if (Character.isUpperCase(first)) {
            return str;
        }
        if (str.length() == 1) {
            return str.toUpperCase();
        }
        StringBuilder builder = new StringBuilder(str);
        builder.setCharAt(0, Character.toUpperCase(first));
        return builder.toString();
    }

    public static String uncap(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        char first = str.charAt(0);
        if (Character.isLowerCase(first)) {
            return str;
        }
        if (str.length() == 1) {
            return str.toLowerCase();
        }
        StringBuilder builder = new StringBuilder(str);
        builder.setCharAt(0, Character.toLowerCase(first));
        return builder.toString();
    }

    public static int occurrences(String str, char c) {
        int count = 0;
        int i = 0;
        while ((i = str.indexOf(c, i)) != -1) {
            ++count;
            ++i;
        }
        return count;
    }

    public static int occurrences(String str, String c) {
        int count = 0;
        int i = 0;
        while ((i = str.indexOf(c, i)) != -1) {
            ++count;
            i += c.length();
        }
        return count;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean glob(String pattern, String string) {
        return StringUtil.glob(pattern, string, null);
    }

    public static boolean glob(String pattern, String string, String[] subStrings) {
        return StringUtil.globRecurse(pattern, 0, string, 0, subStrings, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean globRecurse(String pattern, int patternIndex, String string, int stringIndex, String[] subStrings, int subStringsIndex) {
        int patternLength = pattern.length();
        int stringLength = string.length();
        block8: while (true) {
            boolean endReached;
            char patternChar = pattern.charAt(patternIndex);
            boolean bl = endReached = stringIndex == stringLength;
            if (patternIndex == patternLength) {
                return endReached;
            }
            if (endReached && patternChar != '*') {
                return false;
            }
            switch (patternChar) {
                case '*': {
                    int startIndex = stringIndex;
                    if (++patternIndex >= patternLength) {
                        StringUtil.globRemember(string, startIndex, stringLength, subStrings, subStringsIndex);
                        return true;
                    }
                    while (true) {
                        if (StringUtil.globRecurse(pattern, patternIndex, string, stringIndex, subStrings, subStringsIndex + 1)) {
                            StringUtil.globRemember(string, startIndex, stringIndex, subStrings, subStringsIndex);
                            return true;
                        }
                        if (endReached) {
                            return false;
                        }
                        ++stringIndex;
                    }
                }
                case '?': {
                    ++patternIndex;
                    StringUtil.globRemember(string, stringIndex++, stringIndex, subStrings, subStringsIndex++);
                    continue block8;
                }
                case '[': {
                    try {
                        ++patternIndex;
                        char stringChar = string.charAt(stringIndex);
                        char rangeStartChar = patternChar;
                        while (true) {
                            if (rangeStartChar == ']') {
                                return false;
                            }
                            if (rangeStartChar == stringChar) break;
                            ++patternIndex;
                            char nextPatternChar = patternChar;
                            if (nextPatternChar == '-') {
                                ++patternIndex;
                                char rangeEndChar = patternChar;
                                if (rangeStartChar <= stringChar && stringChar <= rangeEndChar) break;
                                ++patternIndex;
                                nextPatternChar = patternChar;
                            }
                            rangeStartChar = nextPatternChar;
                        }
                        patternIndex = pattern.indexOf(93, patternIndex) + 1;
                        if (patternIndex <= 0) {
                            return false;
                        }
                        StringUtil.globRemember(string, stringIndex++, stringIndex, subStrings, subStringsIndex++);
                        continue block8;
                    }
                    catch (StringIndexOutOfBoundsException ex) {
                        return false;
                    }
                }
                case '\\': {
                    if (++patternIndex < patternLength) break;
                    return false;
                }
            }
            char c = patternChar;
            patternChar = (char)(c + '\u0001');
            if (c != string.charAt(stringIndex++)) break;
        }
        return false;
    }

    private static void globRemember(String string, int start, int end, String[] subStrings, int subStringsIndex) {
        if (subStrings != null && subStringsIndex < subStrings.length) {
            subStrings[subStringsIndex] = string.substring(start, end);
        }
    }
}

