/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FastList<E> {
    protected E[] elements;

    public boolean isEmpty() {
        return this.elements == null;
    }

    public E[] get() {
        return this.elements;
    }

    public synchronized void add(E element) {
        if (this.elements == null) {
            E[] array = this.newArray(1);
            array[0] = element;
            this.elements = array;
            this.firstElementAdded();
        } else {
            int length = this.elements.length;
            E[] array = this.newArray(length + 1);
            System.arraycopy(this.elements, 0, array, 0, length);
            array[length] = element;
            this.elements = array;
        }
    }

    public synchronized boolean remove(E element) {
        if (this.elements != null) {
            int length = this.elements.length;
            if (length == 1) {
                if (this.elements[0] == element) {
                    this.elements = null;
                    this.lastElementRemoved();
                    return true;
                }
            } else {
                int i = 0;
                while (i < length) {
                    E e = this.elements[i];
                    if (e == element) {
                        E[] array = this.newArray(length - 1);
                        if (i > 0) {
                            System.arraycopy(this.elements, 0, array, 0, i);
                        }
                        if (i + 1 <= length - 1) {
                            System.arraycopy(this.elements, i + 1, array, i, length - 1 - i);
                        }
                        this.elements = array;
                        return true;
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    protected void firstElementAdded() {
    }

    protected void lastElementRemoved() {
    }

    protected abstract E[] newArray(int var1);
}

