/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.io;

import java.io.File;
import java.io.IOException;
import org.eclipse.net4j.util.io.IORuntimeException;
import org.eclipse.net4j.util.om.OMPlatform;

public final class TMPUtil {
    public static final String TEMP_FOLDER_PROPERTY = "org.eclipse.net4j.util.io.tmpdir";
    public static final String SYSTEM_TEMP_FOLDER = OMPlatform.INSTANCE.getProperty("java.io.tmpdir");

    private TMPUtil() {
    }

    public static File getTempFolder() {
        String tempFolder = OMPlatform.INSTANCE.getProperty(TEMP_FOLDER_PROPERTY);
        if (tempFolder == null) {
            tempFolder = SYSTEM_TEMP_FOLDER;
        }
        return new File(tempFolder);
    }

    public static void setTempFolder(String tempFolder) {
        System.setProperty(TEMP_FOLDER_PROPERTY, tempFolder);
    }

    public static File createTempFolder() throws IORuntimeException {
        return TMPUtil.createTempFolder("tmp");
    }

    public static File createTempFolder(String prefix) throws IORuntimeException {
        return TMPUtil.createTempFolder(prefix, "");
    }

    public static File createTempFolder(String prefix, String suffix) throws IORuntimeException {
        return TMPUtil.createTempFolder(prefix, suffix, TMPUtil.getTempFolder());
    }

    public static File createTempFolder(String prefix, String suffix, File directory) throws IORuntimeException {
        try {
            File tmp = File.createTempFile(prefix, suffix, directory);
            String tmpPath = tmp.getAbsolutePath();
            tmp.delete();
            tmp = new File(tmpPath);
            tmp.mkdirs();
            return tmp;
        }
        catch (IOException ex) {
            throw new IORuntimeException(ex);
        }
    }
}

