/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.om;

import org.eclipse.net4j.internal.util.bundle.AbstractBundle;
import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.util.om.OMBundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public abstract class OSGiActivator
implements BundleActivator {
    private OMBundle omBundle;
    protected BundleContext bundleContext;

    public OSGiActivator(OMBundle omBundle) {
        this.omBundle = omBundle;
    }

    public final OMBundle getOMBundle() {
        return this.omBundle;
    }

    public final void start(BundleContext context) throws Exception {
        this.bundleContext = context;
        OSGiActivator.traceStart(context);
        if (this.omBundle == null) {
            throw new IllegalStateException("bundle == null");
        }
        try {
            this.omBundle.setBundleContext(context);
            ((AbstractBundle)this.omBundle).start();
            this.doStart();
        }
        catch (Error error) {
            this.omBundle.logger().error(error);
            throw error;
        }
        catch (Exception ex) {
            this.omBundle.logger().error(ex);
            throw ex;
        }
    }

    public final void stop(BundleContext context) throws Exception {
        OSGiActivator.traceStop(context);
        if (this.omBundle == null) {
            throw new IllegalStateException("bundle == null");
        }
        try {
            this.doStop();
            ((AbstractBundle)this.omBundle).stop();
            this.omBundle.setBundleContext(null);
        }
        catch (Error error) {
            this.omBundle.logger().error(error);
            throw error;
        }
        catch (Exception ex) {
            this.omBundle.logger().error(ex);
            throw ex;
        }
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final String toString() {
        return super.toString();
    }

    protected final Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    protected final void finalize() throws Throwable {
        super.finalize();
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }

    public static void traceStart(BundleContext context) {
        try {
            if (OM.TRACER.isEnabled()) {
                OM.TRACER.format("Starting bundle {0}", context.getBundle().getSymbolicName());
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public static void traceStop(BundleContext context) {
        try {
            if (OM.TRACER.isEnabled()) {
                OM.TRACER.format("Stopping bundle {0}", context.getBundle().getSymbolicName());
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

