/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.om;

import java.util.concurrent.CountDownLatch;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class OSGiApplication
implements IApplication {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_OM, OSGiApplication.class);
    private String applicationID;
    private IApplicationContext context;
    private CountDownLatch stopLatch;

    public OSGiApplication(String applicationID) {
        this.applicationID = applicationID;
    }

    public String getApplicationID() {
        return this.applicationID;
    }

    public IApplicationContext getApplicationContext() {
        return this.context;
    }

    public boolean isRunning() {
        return this.stopLatch != null;
    }

    public final Object start(IApplicationContext context) throws Exception {
        this.context = context;
        OSGiApplication.traceStart(this.applicationID);
        try {
            this.doStart();
        }
        catch (Error error) {
            OM.LOG.error(error);
            throw error;
        }
        catch (Exception ex) {
            OM.LOG.error(ex);
            throw ex;
        }
        context.applicationRunning();
        this.stopLatch = new CountDownLatch(1);
        this.stopLatch.await();
        this.stopLatch = null;
        return EXIT_OK;
    }

    public final void stop() {
        OSGiApplication.traceStop(this.applicationID);
        try {
            this.doStop();
        }
        catch (Error error) {
            OM.LOG.error(error);
            throw error;
        }
        catch (Exception ex) {
            OM.LOG.error(ex);
        }
        this.context = null;
        if (this.stopLatch != null) {
            this.stopLatch.countDown();
        }
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }

    public static void traceStart(String applicationID) {
        try {
            if (TRACER.isEnabled()) {
                TRACER.format("Starting application {0}", applicationID);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public static void traceStop(String applicationID) {
        try {
            if (TRACER.isEnabled()) {
                TRACER.format("Stopping application {0}", applicationID);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

