/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.signal;

import org.eclipse.internal.net4j.bundle.OM;
import org.eclipse.net4j.signal.Indication;
import org.eclipse.net4j.signal.RemoteException;
import org.eclipse.net4j.signal.RemoteExceptionRequest;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RemoteExceptionIndication
extends Indication {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_SIGNAL, RemoteExceptionIndication.class);
    private Throwable t;

    public RemoteExceptionIndication(SignalProtocol<?> protocol) {
        super(protocol, (short)-1);
    }

    @Override
    protected void indicating(ExtendedDataInputStream in) throws Exception {
        int correlationID = in.readInt();
        boolean responding = in.readBoolean();
        String message = in.readString();
        if (TRACER.isEnabled()) {
            String msg = RemoteExceptionRequest.getFirstLine(message);
            TRACER.format("Reading remote exception for signal {0}: {1}", new Object[]{correlationID, msg});
        }
        try {
            this.t = (Throwable)in.readObject(OM.class.getClassLoader());
        }
        catch (Throwable couldNotLoadExceptionClass) {
            this.t = new RemoteException(message, responding);
        }
        this.getProtocol().handleRemoteException(correlationID, this.t, responding);
    }
}

