/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.modelregistry.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ocl.examples.modelregistry.environment.ModelRegistryEnvironment;
import org.eclipse.ocl.examples.modelregistry.model.Accessor;
import org.eclipse.ocl.examples.modelregistry.model.ModelNameAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceRegistry {
    private final Map<String, Accessor.Namespace<?>> nameToNamespaceMap = new HashMap();

    public <A extends Accessor<A>> void addNamespace(Accessor.Namespace<A> namespace) {
        this.nameToNamespaceMap.put(namespace.getName(), namespace);
    }

    public <A extends Accessor<A>> A createAccessor(String namespaceName, String accessorName) {
        Accessor.Namespace<?> namespace = this.nameToNamespaceMap.get(namespaceName != null ? namespaceName : ModelNameAccessor.NAMESPACE);
        if (namespace == null) {
            return null;
        }
        return (A)this.createAccessor(namespace, accessorName);
    }

    public <A extends Accessor<A>> A createAccessor(Accessor.Namespace<A> namespace, String accessorName) {
        try {
            return namespace.newInstance(accessorName);
        }
        catch (Exception e) {
            ModelRegistryEnvironment.logError("Unable to construct '" + namespace.getName() + "' instance", e);
            return null;
        }
    }

    public Accessor.Namespace<?> getNamespace(String namespaceName) {
        return this.nameToNamespaceMap.get(namespaceName);
    }

    public Collection<Accessor.Namespace<?>> getNamespaces() {
        return this.nameToNamespaceMap.values();
    }
}

