/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.modelregistry.model;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.ocl.examples.modelregistry.ModelRegistration;
import org.eclipse.ocl.examples.modelregistry.ModelRegistry;
import org.eclipse.ocl.examples.modelregistry.ModelRegistryFactory;
import org.eclipse.ocl.examples.modelregistry.ModelRegistryPackage;
import org.eclipse.ocl.examples.modelregistry.ModelRegistrySettings;
import org.eclipse.ocl.examples.modelregistry.environment.FileHandle;
import org.eclipse.ocl.examples.modelregistry.environment.ModelRegistryEnvironment;
import org.eclipse.ocl.examples.modelregistry.environment.ModelSerializationRegistry;
import org.eclipse.ocl.examples.modelregistry.environment.ProjectHandle;
import org.eclipse.ocl.examples.modelregistry.model.Accessor;
import org.eclipse.ocl.examples.modelregistry.model.AccessorRegistry;
import org.eclipse.ocl.examples.modelregistry.model.FileHandleRegistry;
import org.eclipse.ocl.examples.modelregistry.model.ModelNameAccessor;
import org.eclipse.ocl.examples.modelregistry.model.ModelSerialization;
import org.eclipse.ocl.examples.modelregistry.model.NamespaceRegistry;
import org.eclipse.ocl.examples.modelregistry.model.Registration;
import org.eclipse.ocl.examples.modelregistry.model.UnregisteredAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectRegistry {
    public static final String DEFAULT_SERIALISATION_NAME = "XML";
    private final ProjectHandle projectHandle;
    private final Map<FileHandle, FileHandleRegistry> map = new HashMap<FileHandle, FileHandleRegistry>();
    private final ResourceSet resourceSet;
    private Resource model = null;
    private Map<String, String> unregisteredNamespaces = null;

    public ProjectRegistry(ProjectHandle projectHandle) {
        this.projectHandle = projectHandle;
        this.resourceSet = new ResourceSetImpl();
        this.resourceSet.getPackageRegistry().put((Object)ModelRegistryPackage.eINSTANCE.getNsURI(), (Object)ModelRegistryPackage.eINSTANCE);
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
    }

    public FileHandleRegistry add(FileHandle fileHandle) {
        FileHandleRegistry fileHandleRegistry = new FileHandleRegistry(this, fileHandle);
        this.map.put(fileHandle, fileHandleRegistry);
        return fileHandleRegistry;
    }

    public <A extends Accessor<A>> Registration<A> add(Registration<A> registration) {
        FileHandle fileHandle = registration.getFileHandle();
        FileHandleRegistry fileHandleRegistry = this.getOrCreate(fileHandle);
        return fileHandleRegistry.add(registration);
    }

    private ModelRegistrySettings exportToModel() {
        ModelRegistrySettings modelRegistrySettings = ModelRegistryFactory.eINSTANCE.createModelRegistrySettings();
        ArrayList<FileHandleRegistry> fileHandleRegistries = new ArrayList<FileHandleRegistry>(this.map.values());
        Collections.sort(fileHandleRegistries);
        for (FileHandleRegistry fileHandleRegistry : fileHandleRegistries) {
            FileHandle fileHandle = fileHandleRegistry.getFileHandle();
            ModelRegistry modelRegistry = ModelRegistryFactory.eINSTANCE.createModelRegistry();
            modelRegistry.setName(fileHandle.getProjectRelativeName());
            modelRegistrySettings.getResource().add((Object)modelRegistry);
            ArrayList accessorRegistries = new ArrayList(fileHandleRegistry.getRegistries());
            Collections.sort(accessorRegistries);
            for (AccessorRegistry accessorRegistry : accessorRegistries) {
                ArrayList registrations = new ArrayList(accessorRegistry.getRegistrations());
                Collections.sort(registrations);
                for (Registration registration : registrations) {
                    Object accessor = registration.getAccessor();
                    ModelRegistration modelRegistration = ModelRegistryFactory.eINSTANCE.createModelRegistration();
                    modelRegistration.setAccessor(accessor.getName());
                    modelRegistration.setKind(accessor.getNamespace().getName());
                    if (!DEFAULT_SERIALISATION_NAME.equals(registration.getSerializationName())) {
                        modelRegistration.setSerialization(registration.getSerializationName());
                    }
                    modelRegistration.setUri(registration.getURIString());
                    modelRegistry.getEntry().add((Object)modelRegistration);
                }
            }
        }
        return modelRegistrySettings;
    }

    public FileHandleRegistry get(FileHandle fileHandle) {
        return this.map.get(fileHandle);
    }

    public FileHandleRegistry getOrCreate(FileHandle fileHandle) {
        FileHandleRegistry fileHandleRegistry = this.map.get(fileHandle);
        if (fileHandleRegistry == null) {
            fileHandleRegistry = new FileHandleRegistry(this, fileHandle);
            this.map.put(fileHandle, fileHandleRegistry);
        }
        return fileHandleRegistry;
    }

    public ProjectHandle getProject() {
        return this.projectHandle;
    }

    public <A extends Accessor<A>> Registration<A> getRegistration(FileHandle fileHandle, A accessor) {
        FileHandle ancestorHandle = fileHandle;
        while (ancestorHandle != null) {
            Registration<A> registration;
            FileHandleRegistry fileHandleRegistry = this.get(ancestorHandle);
            if (fileHandleRegistry != null && (registration = fileHandleRegistry.getRegistration(accessor)) != null) {
                return registration;
            }
            ancestorHandle = ancestorHandle.getParentFileHandle();
        }
        return null;
    }

    public <A extends Accessor<A>> Collection<Registration<A>> getRegistrations(FileHandle fileHandle, Accessor.Namespace<A> namespace) {
        AccessorRegistry<A> flatAccessorRegistry = new AccessorRegistry<A>(this.get(fileHandle), namespace);
        FileHandle ancestorHandle = fileHandle;
        while (ancestorHandle != null) {
            AccessorRegistry<A> accessorRegistry;
            FileHandleRegistry fileHandleRegistry = this.get(ancestorHandle);
            if (fileHandleRegistry != null && (accessorRegistry = fileHandleRegistry.get(namespace)) != null) {
                for (Registration<A> registration : accessorRegistry.getRegistrations()) {
                    if (flatAccessorRegistry.get(registration.getAccessor()) != null) continue;
                    flatAccessorRegistry.add(registration);
                }
            }
            ancestorHandle = ancestorHandle.getParentFileHandle();
        }
        return flatAccessorRegistry.getRegistrations();
    }

    public <A extends Accessor<A>> URI getResolvedURI(FileHandle fileHandle, A accessor) {
        return this.resolveURI(this.getURI(fileHandle, accessor));
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public <A extends Accessor<A>> URI getURI(FileHandle fileHandle, A accessor) {
        Registration<A> registration = this.getRegistration(fileHandle, accessor);
        return registration != null ? registration.getURI() : null;
    }

    private <A extends Accessor<A>> void importFromModel(Resource model, URI registryURI, Accessor.Namespace<A> unusedNamespace) {
        this.map.clear();
        NamespaceRegistry namespaceRegistry = ModelRegistryEnvironment.getInstance().getNamespaceRegistry();
        ModelSerializationRegistry modelSerializationRegistry = ModelRegistryEnvironment.getInstance().getModelSerializationRegistry();
        for (EObject content : model.getContents()) {
            ModelRegistrySettings settings = (ModelRegistrySettings)content;
            for (ModelRegistry modelRegistry : settings.getResource()) {
                String name = modelRegistry.getName();
                FileHandle fileHandle = null;
                try {
                    fileHandle = this.projectHandle.getFileHandle(name);
                }
                catch (IOException e) {
                    ModelRegistryEnvironment.logError("Illegal model registry file handle name", e);
                }
                if (fileHandle == null) continue;
                FileHandleRegistry fileHandleRegistry = this.add(fileHandle);
                for (ModelRegistration modelRegistration : modelRegistry.getEntry()) {
                    String namespaceName = modelRegistration.getKind();
                    Object accessor = namespaceRegistry.createAccessor(namespaceName, modelRegistration.getAccessor());
                    if (accessor == null) {
                        if (this.unregisteredNamespaces == null) {
                            this.unregisteredNamespaces = new HashMap<String, String>();
                        }
                        if (!this.unregisteredNamespaces.containsKey(namespaceName)) {
                            this.unregisteredNamespaces.put(namespaceName, namespaceName);
                            ModelRegistryEnvironment.logError("Unregistered accessor namespace '" + namespaceName + "' used in '" + registryURI + "'", null);
                        }
                        UnregisteredAccessor castAccessor = new UnregisteredAccessor(namespaceName, modelRegistration.getAccessor());
                        accessor = castAccessor;
                    }
                    URI ecoreURI = URI.createURI((String)modelRegistration.getUri(), (boolean)false);
                    String serializationName = modelRegistration.getSerialization();
                    if (serializationName == null) {
                        serializationName = DEFAULT_SERIALISATION_NAME;
                    }
                    ModelSerialization modelSerialisation = modelSerializationRegistry.getSerializationOrCreate(serializationName);
                    fileHandleRegistry.add(accessor, ecoreURI, modelSerialisation);
                }
            }
        }
    }

    public boolean loadModel() {
        List<URI> registryURIs = this.projectHandle.getRegistryURIs();
        for (URI registryURI : registryURIs) {
            try {
                if (this.model == null) {
                    this.model = this.resourceSet.getResource(registryURI, true);
                }
                this.importFromModel(this.model, registryURI, ModelNameAccessor.NAMESPACE);
                return true;
            }
            catch (WrappedException e) {
                try {
                    throw e.exception();
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (Exception e2) {
                    ModelRegistryEnvironment.logError("Failed to get model registry from '" + registryURI + "'", e2);
                }
            }
        }
        return false;
    }

    public <A extends Accessor<A>> Registration<A> remove(Registration<A> registration) {
        FileHandle fileHandle = registration.getFileHandle();
        FileHandleRegistry fileHandleRegistry = this.map.get(fileHandle);
        return fileHandleRegistry.remove(registration);
    }

    public URI resolveURI(URI uri) {
        if (uri == null) {
            return uri;
        }
        return uri.resolve(this.projectHandle.getURI());
    }

    public boolean saveModel() {
        URI registryURI = this.projectHandle.getRegistryURI();
        ModelRegistrySettings settings = this.exportToModel();
        this.model = this.resourceSet.createResource(registryURI);
        this.model.getContents().add((Object)settings);
        try {
            this.model.save(null);
            this.projectHandle.refreshRegistry();
        }
        catch (IOException e) {
            ModelRegistryEnvironment.logError("Failed to create model registry at '" + registryURI + "'", e);
            return false;
        }
        return true;
    }

    public String toString() {
        return this.getProject().toString();
    }
}

