/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.modelregistry.model;

import org.eclipse.emf.common.util.URI;
import org.eclipse.ocl.examples.modelregistry.environment.FileHandle;
import org.eclipse.ocl.examples.modelregistry.model.Accessor;
import org.eclipse.ocl.examples.modelregistry.model.AccessorRegistry;
import org.eclipse.ocl.examples.modelregistry.model.FileHandleRegistry;
import org.eclipse.ocl.examples.modelregistry.model.ModelSerialization;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Registration<A extends Accessor<A>>
implements Comparable<Registration<?>> {
    private final AccessorRegistry<A> parent;
    private final A accessor;
    private final URI uri;
    private final ModelSerialization modelSerialization;

    public Registration(AccessorRegistry<A> parent, A accessor, URI uri, ModelSerialization modelSerialization) {
        this.parent = parent;
        this.accessor = accessor;
        this.uri = uri;
        this.modelSerialization = modelSerialization;
    }

    @Override
    public int compareTo(Registration<?> registration) {
        int comparison = this.getFileHandleRegistry().compareTo(registration.getFileHandleRegistry());
        if (comparison != 0) {
            return comparison;
        }
        return this.getAccessorName().compareTo(registration.getAccessorName());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Registration)) {
            return false;
        }
        if (!this.getAccessorName().equals(((Registration)obj).getAccessorName())) {
            return false;
        }
        if (!this.getSerializationName().equals(((Registration)obj).getSerializationName())) {
            return false;
        }
        return this.getURI().equals((Object)((Registration)obj).getURI());
    }

    public A getAccessor() {
        return this.accessor;
    }

    public String getAccessorName() {
        return this.getAccessor().getName();
    }

    public AccessorRegistry<A> getAccessorRegistry() {
        return this.parent;
    }

    public FileHandle getFileHandle() {
        return this.parent.getFileHandle();
    }

    public FileHandleRegistry getFileHandleRegistry() {
        return this.parent.getFileHandleRegistry();
    }

    public String getModelKindName() {
        return this.modelSerialization.getName();
    }

    public Accessor.Namespace<A> getNamespace() {
        return this.accessor.getNamespace();
    }

    public ModelSerialization getSerialization() {
        return this.modelSerialization;
    }

    public String getSerializationName() {
        return this.modelSerialization.getName();
    }

    public URI getURI() {
        return this.uri;
    }

    public String getURIString() {
        return URI.decode((String)this.getURI().toString());
    }

    public int hashCode() {
        return this.uri.hashCode() + 55;
    }

    public String toString() {
        return String.valueOf(this.getAccessorName()) + " -> " + this.getURIString();
    }
}

