/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.parser.ocl.environment;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.ocl.LookupException;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.cst.OCLDocumentCS;
import org.eclipse.ocl.examples.common.plugin.OCLExamplesCommonPlugin;
import org.eclipse.ocl.examples.common.utils.StringUtils;
import org.eclipse.ocl.examples.modelregistry.environment.AbstractModelResolver;
import org.eclipse.ocl.examples.modelregistry.model.ModelNameAccessor;
import org.eclipse.ocl.examples.modelregistry.model.Registration;
import org.eclipse.ocl.examples.parser.environment.ecore.CSTRootEcoreEnvironment;
import org.eclipse.ocl.examples.parser.environment.ecore.ICSTFileEcoreEnvironment;
import org.eclipse.ocl.examples.parser.ocl.environment.IOCLEnvironment;
import org.eclipse.ocl.examples.parser.ocl.environment.OCLEnvironment;
import org.eclipse.ocl.examples.parser.ocl.environment.OCLFileEnvironment;
import org.eclipse.ocl.parser.OCLAnalyzer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCLTopLevelEnvironment
extends CSTRootEcoreEnvironment<OCLEnvironment<?, ?, ?>, OCLDocumentCS>
implements IOCLEnvironment {
    public static final String PACKAGE_NAME_SEPARATOR = ".";
    private Map<String, List<EPackage>> packagePath = null;

    public OCLTopLevelEnvironment(OCLFileEnvironment parent, XMIResource astResource, OCLDocumentCS cstNode) {
        super((ICSTFileEcoreEnvironment)parent, astResource, (CSTNode)cstNode);
    }

    public void addToPackagePath(EList<? extends EObject> contents, String path) {
        for (EObject eObject : contents) {
            if (!(eObject instanceof EPackage)) continue;
            EPackage ePackage = (EPackage)eObject;
            String fullPackageName = path != null ? String.valueOf(path) + PACKAGE_NAME_SEPARATOR + ePackage.getName() : ePackage.getName();
            List<EPackage> ePackages = this.packagePath.get(fullPackageName);
            if (ePackages == null) {
                ePackages = new ArrayList<EPackage>();
                this.packagePath.put(fullPackageName, ePackages);
            }
            ePackages.add(ePackage);
            this.addToPackagePath((EList<? extends EObject>)ePackage.getESubpackages(), fullPackageName);
        }
    }

    public OCLEnvironment<?, ?, ?> createNestedEnvironment(CSTNode cstNode) {
        return new OCLEnvironment<OCLTopLevelEnvironment, Object, CSTNode>(this, null, cstNode);
    }

    public Map<String, List<EPackage>> getPackagePath() {
        if (this.packagePath == null) {
            this.packagePath = new HashMap<String, List<EPackage>>();
            AbstractModelResolver resolver = this.getFileEnvironment().getResolver();
            for (Registration registration : resolver.getRegistrations(ModelNameAccessor.NAMESPACE)) {
                try {
                    Resource resource = resolver.getResource(registration);
                    if (resource == null) continue;
                    this.addToPackagePath((EList<? extends EObject>)resource.getContents(), null);
                }
                catch (IOException e) {
                    OCLExamplesCommonPlugin.logError((String)("Failed to load " + registration), (Throwable)e);
                }
                catch (WrappedException e) {
                    OCLExamplesCommonPlugin.logError((String)("Failed to load " + registration), (Throwable)e.exception());
                }
            }
        }
        return this.packagePath;
    }

    public void postParse() {
        super.postParse();
        for (EObject eObject : ((XMIResource)this.ast).getContents()) {
            EPackage ePackage;
            if (!(eObject instanceof EPackage) || (ePackage = (EPackage)eObject).getNsURI() != null) continue;
            this.getFileEnvironment().initializePackageNs((Object)ePackage);
        }
    }

    public EClassifier tryLookupClassifier(List<String> names) throws LookupException {
        List<String> newNames;
        EPackage pkg;
        EClassifier eClassifier = (EClassifier)super.tryLookupClassifier(names);
        if (eClassifier != null) {
            return eClassifier;
        }
        if (names.size() > 1 && (pkg = this.tryLookupPackage(newNames = names.subList(0, names.size() - 1))) != null) {
            String name = names.get(names.size() - 1);
            EClassifier result = pkg.getEClassifier(name);
            if (result == null && OCLAnalyzer.isEscaped((String)name)) {
                result = pkg.getEClassifier(OCLAnalyzer.unescape((String)name));
            }
            return result;
        }
        return null;
    }

    public EPackage tryLookupPackage(List<String> path) throws LookupException {
        EPackage ePackage = (EPackage)super.tryLookupPackage(path);
        if (ePackage != null) {
            return ePackage;
        }
        String fullPackagePath = StringUtils.splice(path, (String)PACKAGE_NAME_SEPARATOR);
        Map<String, List<EPackage>> packagePath = this.getPackagePath();
        List<EPackage> ePackages = packagePath.get(fullPackagePath);
        if (ePackages == null || ePackages.size() == 0) {
            return null;
        }
        if (ePackages.size() > 1) {
            throw new LookupException("Ambiguous package '" + this.formatString(fullPackagePath) + "'");
        }
        return ePackages.get(0);
    }
}

