/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.parser.environment;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.ocl.examples.common.utils.EcoreUtils;
import org.eclipse.ocl.examples.modelregistry.environment.FileHandle;
import org.eclipse.ocl.examples.parser.environment.ICSTFileEnvironment;
import org.eclipse.ocl.examples.parser.environment.ICSTRootEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnresolvedEnvironment {
    public static final String UNRESOLVED_PACKAGE_NAME = "$unresolved$";
    protected final ICSTRootEnvironment<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> rootEnvironment;
    private EPackage rootPackage = null;

    public static String computePackageNs(FileHandle file, EPackage ePackage) {
        StringBuilder s = new StringBuilder();
        s.append("http://");
        s.append(file.getProjectHandle().getName());
        s.append("/");
        s.append(file.getProjectRelativeName());
        s.append("/");
        UnresolvedEnvironment.computePackageNs(s, (ENamedElement)ePackage);
        String string = s.toString();
        return string;
    }

    private static void computePackageNs(StringBuilder s, ENamedElement eNamedElement) {
        EObject eContainer = eNamedElement.eContainer();
        if (eContainer instanceof ENamedElement) {
            UnresolvedEnvironment.computePackageNs(s, (ENamedElement)eContainer);
            s.append(".");
        }
        s.append(eNamedElement.getName());
    }

    public UnresolvedEnvironment(ICSTRootEnvironment<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> rootEnvironment) {
        this.rootEnvironment = rootEnvironment;
    }

    public String computePackageNs(EPackage ePackage) {
        ICSTFileEnvironment fileEnvironment = this.rootEnvironment.getFileEnvironment();
        return UnresolvedEnvironment.computePackageNs(fileEnvironment.getFile(), ePackage);
    }

    public EAttribute getUnresolvedEAttribute(EClassifier classifier, String featureName) {
        String name;
        EClass unresolvedEClass = this.getUnresolvedEClass(classifier);
        EAttribute unresolvedEAttribute = (EAttribute)unresolvedEClass.getEStructuralFeature(name = "attribute$" + featureName);
        if (unresolvedEAttribute == null) {
            unresolvedEAttribute = EcoreFactory.eINSTANCE.createEAttribute();
            unresolvedEAttribute.setName(name);
            unresolvedEAttribute.setEType((EClassifier)EcorePackage.Literals.ESTRING);
            unresolvedEClass.getEStructuralFeatures().add((Object)unresolvedEAttribute);
        }
        return unresolvedEAttribute;
    }

    public EClass getUnresolvedEClass(EClassifier eClass) {
        String name;
        if (this.isUnresolved((EObject)eClass)) {
            return (EClass)eClass;
        }
        EPackage unresolvedEPackage = eClass != null ? this.getUnresolvedEPackage(eClass.getEPackage()) : this.getUnresolvedEPackage();
        EClass unresolvedEClassifier = (EClass)unresolvedEPackage.getEClassifier(name = eClass != null ? "class$" + eClass.getName() : "$class$");
        if (unresolvedEClassifier == null) {
            unresolvedEClassifier = EcoreFactory.eINSTANCE.createEClass();
            unresolvedEClassifier.setName(name);
            unresolvedEPackage.getEClassifiers().add((Object)unresolvedEClassifier);
        }
        return unresolvedEClassifier;
    }

    public EClass getUnresolvedEClass(List<String> path) {
        if (path == null) {
            return this.getUnresolvedEClass((EClassifier)null);
        }
        EPackage unresolvedEPackage = this.getUnresolvedEPackage();
        int i = 0;
        while (i < path.size() - 1) {
            unresolvedEPackage = this.getUnresolvedEPackage(unresolvedEPackage, path.get(i));
            ++i;
        }
        String name = "class$" + path.get(path.size() - 1);
        EClass unresolvedEClass = (EClass)unresolvedEPackage.getEClassifier(name);
        if (unresolvedEClass == null) {
            unresolvedEClass = EcoreFactory.eINSTANCE.createEClass();
            unresolvedEClass.setName(name);
            unresolvedEPackage.getEClassifiers().add((Object)unresolvedEClass);
        }
        return unresolvedEClass;
    }

    public EDataType getUnresolvedEDataType(EPackage resolvedEPackage, String typeName) {
        String name;
        EPackage unresolvedEPackage = this.getUnresolvedEPackage(resolvedEPackage);
        EDataType unresolvedEDataType = (EDataType)unresolvedEPackage.getEClassifier(name = "datatype$" + typeName);
        if (unresolvedEDataType == null) {
            unresolvedEDataType = EcoreFactory.eINSTANCE.createEDataType();
            unresolvedEDataType.setName(name);
            unresolvedEPackage.getEClassifiers().add((Object)unresolvedEDataType);
        }
        return unresolvedEDataType;
    }

    public EOperation getUnresolvedEOperation(EClassifier resolvedEClass, String operationName) {
        EClass unresolvedEClass = this.getUnresolvedEClass(resolvedEClass);
        String name = "reference$" + operationName;
        EOperation unresolvedEOperation = (EOperation)EcoreUtils.getNamedElement((Collection)unresolvedEClass.getEOperations(), (String)name);
        if (unresolvedEOperation == null) {
            unresolvedEOperation = EcoreFactory.eINSTANCE.createEOperation();
            unresolvedEOperation.setName(name);
            unresolvedEClass.getEOperations().add((Object)unresolvedEOperation);
        }
        return unresolvedEOperation;
    }

    public EPackage getUnresolvedEPackage() {
        if (this.rootPackage == null) {
            this.rootPackage = EcoreFactory.eINSTANCE.createEPackage();
            this.rootPackage.setName(UNRESOLVED_PACKAGE_NAME);
            this.rootPackage.setNsPrefix("_unresolved_");
            this.rootPackage.setNsURI(this.computePackageNs(this.rootPackage));
        }
        return this.rootPackage;
    }

    public EPackage getUnresolvedEPackage(List<String> sequenceOfNames) {
        EPackage ePackage = this.getUnresolvedEPackage();
        for (String name : sequenceOfNames) {
            ePackage = this.getUnresolvedEPackage(ePackage, name);
        }
        return ePackage;
    }

    public EPackage getUnresolvedEPackage(EPackage ePackage) {
        if (ePackage == null) {
            return this.getUnresolvedEPackage();
        }
        if (this.isUnresolved((EObject)ePackage)) {
            return ePackage;
        }
        EPackage unresolvedParentEPackage = this.getUnresolvedEPackage(ePackage.getESuperPackage());
        return this.getUnresolvedEPackage(unresolvedParentEPackage, ePackage.getName());
    }

    public EPackage getUnresolvedEPackage(EPackage unresolvedPackage, String name) {
        EPackage ePackage;
        if (unresolvedPackage == null) {
            unresolvedPackage = this.getUnresolvedEPackage();
        }
        if ((ePackage = (EPackage)EcoreUtils.getNamedElement((Collection)unresolvedPackage.getESubpackages(), (String)name)) == null) {
            ePackage = EcoreFactory.eINSTANCE.createEPackage();
            ePackage.setName(name);
            ePackage.setNsPrefix(name);
            ePackage.setNsURI(this.computePackageNs(ePackage));
            unresolvedPackage.getESubpackages().add((Object)ePackage);
        }
        return ePackage;
    }

    public EReference getUnresolvedEReference(EClassifier resolvedEClass, String featureName) {
        String name;
        EClass unresolvedEClass = this.getUnresolvedEClass(resolvedEClass);
        EReference unresolvedEReference = (EReference)unresolvedEClass.getEStructuralFeature(name = "reference$" + featureName);
        if (unresolvedEReference == null) {
            unresolvedEReference = EcoreFactory.eINSTANCE.createEReference();
            unresolvedEReference.setName(featureName);
            unresolvedEReference.setEType((EClassifier)unresolvedEClass);
            unresolvedEClass.getEStructuralFeatures().add((Object)unresolvedEReference);
        }
        return unresolvedEReference;
    }

    public boolean isUnresolved(EObject eObject) {
        if (this.rootPackage != null) {
            while (eObject != null) {
                if (eObject == this.rootPackage) {
                    return true;
                }
                eObject = eObject.eContainer();
            }
        }
        return false;
    }
}

