/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.parser.environment.ecore;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.TypeResolver;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.ecore.EcorePackage;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.ecore.internal.OCLFactoryImpl;
import org.eclipse.ocl.ecore.internal.OCLStandardLibraryImpl;
import org.eclipse.ocl.ecore.internal.UMLReflectionImpl;
import org.eclipse.ocl.examples.modelregistry.environment.FileHandle;
import org.eclipse.ocl.examples.parser.environment.CSTFileEnvironment;
import org.eclipse.ocl.examples.parser.environment.ecore.EcoreTypeResolverImpl;
import org.eclipse.ocl.examples.parser.environment.ecore.ICSTFileEcoreEnvironment;
import org.eclipse.ocl.examples.parser.environment.ecore.ICSTNodeEcoreEnvironment;
import org.eclipse.ocl.examples.parser.environment.ecore.ICSTRootEcoreEnvironment;
import org.eclipse.ocl.expressions.ExpressionsPackage;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.expressions.impl.ExpressionsPackageImpl;
import org.eclipse.ocl.parser.AbstractOCLAnalyzer;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.types.TypesPackage;
import org.eclipse.ocl.utilities.OCLFactory;
import org.eclipse.ocl.utilities.UMLReflection;
import org.eclipse.ocl.utilities.UtilitiesPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CSTFileEcoreEnvironment<RV extends ICSTRootEcoreEnvironment, V extends ICSTNodeEcoreEnvironment, CST extends CSTNode>
extends CSTFileEnvironment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject, RV, V, CST>
implements ICSTFileEcoreEnvironment {
    public static final Map<List<String>, EPackage> OCL_PACKAGES = new HashMap<List<String>, EPackage>();
    private EnvironmentFactory<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> factory;

    static {
        ArrayList<String> names = new ArrayList<String>();
        names.add(ExpressionsPackageImpl.OCL_ROOT_PACKAGE.getName());
        OCL_PACKAGES.put(names, ExpressionsPackageImpl.OCL_ROOT_PACKAGE);
        names = new ArrayList(names);
        names.add(ExpressionsPackage.eINSTANCE.getName());
        OCL_PACKAGES.put(names, (EPackage)ExpressionsPackage.eINSTANCE);
        names = new ArrayList(names);
        names.set(1, TypesPackage.eINSTANCE.getName());
        OCL_PACKAGES.put(names, (EPackage)TypesPackage.eINSTANCE);
        names = new ArrayList(names);
        names.set(1, UtilitiesPackage.eINSTANCE.getName());
        OCL_PACKAGES.put(names, (EPackage)UtilitiesPackage.eINSTANCE);
        names = new ArrayList(names);
        names.set(1, EcorePackage.eINSTANCE.getName());
        OCL_PACKAGES.put(names, (EPackage)EcorePackage.eINSTANCE);
    }

    protected CSTFileEcoreEnvironment(FileHandle file, ResourceSet resourceSet, XMIResource astResource) {
        super(file, resourceSet, astResource);
    }

    protected void collectStates(EClassifier owner, List<String> pathPrefix, List<EObject> states) {
    }

    public EnvironmentFactory<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> createFactory() {
        EPackage.Registry registry = this.getRegistry();
        if (registry == EPackage.Registry.INSTANCE) {
            return EcoreEnvironmentFactory.INSTANCE;
        }
        return new EcoreEnvironmentFactory(registry);
    }

    protected TypeResolver<EClassifier, EOperation, EStructuralFeature> createTypeResolver() {
        return new EcoreTypeResolverImpl(this, (Resource)this.ast);
    }

    @Override
    @Deprecated
    protected TypeResolver<EClassifier, EOperation, EStructuralFeature> createTypeResolver(Resource resource) {
        return new EcoreTypeResolverImpl(this, resource);
    }

    protected UMLReflection<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint> createUMLReflection() {
        return UMLReflectionImpl.INSTANCE;
    }

    public EStructuralFeature defineAttribute(EClassifier owner, Variable<EClassifier, EParameter> variable, Constraint constraint) {
        String name = variable.getName();
        EClassifier type = (EClassifier)variable.getType();
        Object result = type instanceof EClass ? EcoreFactory.eINSTANCE.createEReference() : EcoreFactory.eINSTANCE.createEAttribute();
        result.setName(name);
        result.setEType(type);
        Constraint existing = this.getDefinition(result);
        if (existing != null) {
            EcoreUtil.replace((EObject)existing, (EObject)constraint);
        } else {
            EAnnotation ann = result.getEAnnotation("http://www.eclipse.org/ocl/1.1.0/OCL");
            if (ann == null) {
                ann = EcoreFactory.eINSTANCE.createEAnnotation();
                ann.setSource("http://www.eclipse.org/ocl/1.1.0/OCL");
                result.getEAnnotations().add((Object)ann);
            }
            ann.getContents().add((Object)constraint);
        }
        this.addHelperProperty(owner, result);
        return result;
    }

    public EOperation defineOperation(EClassifier owner, String name, EClassifier type, List<Variable<EClassifier, EParameter>> params, Constraint constraint) {
        EOperation result = EcoreFactory.eINSTANCE.createEOperation();
        result.setName(name);
        result.setEType(type == null ? (EClassifier)this.getOCLStandardLibrary().getOclVoid() : type);
        for (Variable<EClassifier, EParameter> next : params) {
            EParameter param = EcoreFactory.eINSTANCE.createEParameter();
            param.setName(next.getName());
            param.setEType(next.getType() == null ? (EClassifier)this.getOCLStandardLibrary().getOclVoid() : (EClassifier)next.getType());
            result.getEParameters().add((Object)param);
        }
        Constraint existing = this.getDefinition(result);
        if (existing != null) {
            EcoreUtil.replace((EObject)existing, (EObject)constraint);
        } else {
            EAnnotation ann = result.getEAnnotation("http://www.eclipse.org/ocl/1.1.0/OCL");
            if (ann == null) {
                ann = EcoreFactory.eINSTANCE.createEAnnotation();
                ann.setSource("http://www.eclipse.org/ocl/1.1.0/OCL");
                result.getEAnnotations().add((Object)ann);
            }
            ann.getContents().add((Object)constraint);
        }
        this.addHelperOperation(owner, result);
        return result;
    }

    public EClassifier getClassifier(EPackage pkg, String name) {
        EClassifier result = pkg.getEClassifier(name);
        if (result == null && AbstractOCLAnalyzer.isEscaped((String)name)) {
            result = pkg.getEClassifier(AbstractOCLAnalyzer.unescape((String)name));
        }
        return result;
    }

    public Constraint getDefinition(Object feature) {
        Constraint result = null;
        ETypedElement typedFeature = (ETypedElement)feature;
        EAnnotation ann = typedFeature.getEAnnotation("http://www.eclipse.org/ocl/1.1.0/OCL");
        if (ann != null && !ann.getContents().isEmpty()) {
            for (EObject o : ann.getContents()) {
                if (!(o instanceof Constraint) || !"definition".equals(((Constraint)o).getStereotype())) continue;
                result = (Constraint)o;
                break;
            }
        }
        return result;
    }

    @Deprecated
    public EClassifier getEClassifier(EPackage pkg, String name) {
        return this.getClassifier(pkg, name);
    }

    public EnvironmentFactory<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> getFactory() {
        if (this.factory == null) {
            this.factory = this.registry == EPackage.Registry.INSTANCE ? EcoreEnvironmentFactory.INSTANCE : new EcoreEnvironmentFactory(this.registry);
        }
        return this.factory;
    }

    public EPackage getNestedPackage(EPackage pkg, String name) {
        for (EPackage sub : pkg.getESubpackages()) {
            if (!name.equals(sub.getName())) continue;
            return sub;
        }
        if (AbstractOCLAnalyzer.isEscaped((String)name)) {
            name = AbstractOCLAnalyzer.unescape((String)name);
            for (EPackage sub : pkg.getESubpackages()) {
                if (!name.equals(sub.getName())) continue;
                return sub;
            }
        }
        return null;
    }

    public OCLFactory getOCLFactory() {
        return OCLFactoryImpl.INSTANCE;
    }

    public OCLStandardLibrary<EClassifier> getOCLStandardLibrary() {
        return OCLStandardLibraryImpl.INSTANCE;
    }

    public List<EObject> getStates(EClassifier owner, List<String> pathPrefix) {
        BasicEList result = new BasicEList();
        this.collectStates(owner, pathPrefix, (List<EObject>)result);
        if (owner instanceof EClass) {
            for (EClass superclass : ((EClass)owner).getEAllSuperTypes()) {
                this.collectStates((EClassifier)superclass, pathPrefix, (List<EObject>)result);
            }
        }
        return result;
    }

    public UMLReflection<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint> getUMLReflection() {
        return UMLReflectionImpl.INSTANCE;
    }

    public boolean isInPostcondition(OCLExpression<EClassifier> exp) {
        Constraint constraint = null;
        EObject parent = exp;
        while (parent != null) {
            if (parent instanceof Constraint) {
                constraint = (Constraint)parent;
                break;
            }
            parent = parent.eContainer();
        }
        return constraint != null && "postcondition".equals(constraint.getStereotype());
    }

    public EClassifier lookupClassifier(List<String> names) {
        return this.lookupClassifier((EPackage)this.getContextPackage(), names);
    }

    @Override
    public EClassifier lookupClassifier(EPackage contextPackage, List<String> names) {
        EPackage pkg = null;
        EPackage currPkg = contextPackage;
        UMLReflection<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint> reflection = this.getUMLReflection();
        if (names.size() > 1) {
            EPackage.Registry registry;
            List<String> newNames;
            List<String> lookup = names;
            if (currPkg != null) {
                while (currPkg != null) {
                    pkg = currPkg;
                    int i = 0;
                    while (i < lookup.size() - 1) {
                        String name = lookup.get(i);
                        if ((pkg = this.getNestedPackage(pkg, name)) == null) break;
                        ++i;
                    }
                    if (pkg != null) {
                        return this.getClassifier(pkg, lookup.get(lookup.size() - 1));
                    }
                    if (currPkg == contextPackage && lookup.size() > 1 && this.isNamed((EObject)currPkg, lookup.get(0))) {
                        lookup = lookup.subList(1, lookup.size());
                        continue;
                    }
                    lookup = names;
                    currPkg = (EPackage)reflection.getNestingPackage((Object)currPkg);
                }
            }
            if ((pkg = EcoreEnvironment.findPackage(newNames = names.subList(0, names.size() - 1), (EPackage.Registry)(registry = this.getRegistry()))) == null) {
                return null;
            }
            return this.getClassifier(pkg, names.get(names.size() - 1));
        }
        if (contextPackage != null) {
            String name = names.get(0);
            EClassifier result = null;
            while (currPkg != null) {
                result = this.getClassifier(currPkg, name);
                if (result != null) {
                    return result;
                }
                currPkg = (EPackage)reflection.getNestingPackage((Object)currPkg);
            }
        }
        return null;
    }

    @Override
    protected boolean isNamed(EObject element, String name) {
        return element instanceof ENamedElement && AbstractOCLAnalyzer.equalName((String)name, (String)((ENamedElement)element).getName());
    }

    public EPackage lookupPackage(List<String> path) {
        if (!path.isEmpty() && OCL_PACKAGES.containsKey(path)) {
            return OCL_PACKAGES.get(path);
        }
        EPackage pkg = null;
        EPackage currPkg = (EPackage)this.getContextPackage();
        if (currPkg != null) {
            List<String> lookup = path;
            while (currPkg != null) {
                pkg = currPkg;
                int i = 0;
                while (i < lookup.size()) {
                    String name = lookup.get(i);
                    if ((pkg = this.getNestedPackage(pkg, name)) == null) break;
                    ++i;
                }
                if (pkg != null) {
                    return pkg;
                }
                if (currPkg == this.getContextPackage() && lookup.size() > 0 && this.isNamed((EObject)currPkg, lookup.get(0))) {
                    lookup = lookup.subList(1, lookup.size());
                    continue;
                }
                lookup = path;
                currPkg = currPkg.getESuperPackage();
            }
        }
        EPackage.Registry registry = this.getRegistry();
        return EcoreEnvironment.findPackage(path, (EPackage.Registry)registry);
    }

    public void undefine(Object feature) {
        Constraint definition = this.getDefinition(feature);
        if (definition == null) {
            throw new IllegalArgumentException("not an additional feature: " + feature);
        }
        EcoreUtil.remove((EObject)((EObject)feature));
        EcoreUtil.remove((EObject)definition);
        definition.getConstrainedElements().clear();
    }
}

