/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.parser.utils;

import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.ocl.ecore.EcoreFactory;
import org.eclipse.ocl.examples.parser.unresolved.UnresolvedPackage;
import org.eclipse.ocl.expressions.CollectionKind;

public class OCLUtils {
    public static final String OCL_ORPHANS_PACKAGE_NAME = "oclOrphans";

    public static CollectionKind commonCollectionKind(CollectionKind kind1, CollectionKind kind2) {
        boolean isUnique;
        if (kind1 == null && kind2 == null) {
            return null;
        }
        assert (kind1 != null && kind2 != null);
        boolean isOrdered = OCLUtils.isOrdered(kind1) || OCLUtils.isOrdered(kind2);
        boolean bl = isUnique = OCLUtils.isUnique(kind1) || OCLUtils.isUnique(kind2);
        return isOrdered ? (isUnique ? CollectionKind.ORDERED_SET_LITERAL : CollectionKind.SEQUENCE_LITERAL) : (isUnique ? CollectionKind.SET_LITERAL : CollectionKind.BAG_LITERAL);
    }

    public static String getKindName(CollectionKind collectionKind) {
        if (collectionKind == null) {
            return "scalar";
        }
        return collectionKind.getName();
    }

    public static EClassifier getOCLCollectionType(EClassifier type, boolean isOrdered, boolean isUnique) {
        Object resultType = type;
        resultType = isOrdered ? (isUnique ? EcoreFactory.eINSTANCE.createOrderedSetType() : EcoreFactory.eINSTANCE.createSequenceType()) : (isUnique ? EcoreFactory.eINSTANCE.createSetType() : EcoreFactory.eINSTANCE.createBagType());
        return resultType;
    }

    public static boolean isOrdered(CollectionKind collectionKind) {
        assert (collectionKind != null);
        return collectionKind == CollectionKind.ORDERED_SET_LITERAL || collectionKind == CollectionKind.SEQUENCE_LITERAL;
    }

    @Deprecated
    public static boolean isUnresolved(EClassifier eClassifier) {
        return eClassifier.getEPackage() == UnresolvedPackage.eINSTANCE;
    }

    public static boolean isUnique(CollectionKind collectionKind) {
        assert (collectionKind != null);
        return collectionKind == CollectionKind.SET_LITERAL || collectionKind == CollectionKind.SEQUENCE_LITERAL;
    }
}

