/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.base.scope;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.examples.xtext.base.baseCST.ClassifierCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ModelElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypeBindingsCS;
import org.eclipse.ocl.examples.xtext.base.scope.BaseScopeView;
import org.eclipse.ocl.examples.xtext.base.scope.DocumentScopeAdapter;
import org.eclipse.ocl.examples.xtext.base.scope.EnvironmentView;
import org.eclipse.ocl.examples.xtext.base.scope.ScopeAdapter;
import org.eclipse.ocl.examples.xtext.base.scope.ScopeView;
import org.eclipse.xtext.parsetree.CompositeNode;
import org.eclipse.xtext.parsetree.LeafNode;
import org.eclipse.xtext.parsetree.NodeAdapter;
import org.eclipse.xtext.parsetree.NodeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractScopeAdapter<T extends EObject>
extends AdapterImpl
implements ScopeAdapter {
    private static Map<EPackage, ScopeAdapter.Switch> switchMap = new HashMap<EPackage, ScopeAdapter.Switch>();
    protected final ScopeAdapter parent;
    protected final DocumentScopeAdapter document;
    protected long unresolveableModificationCount = -1L;
    protected final Class<T> targetClass;

    public static void addSwitch(EPackage ePackage, ScopeAdapter.Switch iSwitch) {
        switchMap.put(ePackage, iSwitch);
    }

    public static DocumentScopeAdapter getDocumentScopeAdapter(EObject context) {
        ScopeAdapter scopeAdapter = AbstractScopeAdapter.getScopeAdapter(context);
        while (scopeAdapter != null) {
            if (scopeAdapter instanceof DocumentScopeAdapter) {
                return (DocumentScopeAdapter)scopeAdapter;
            }
            scopeAdapter = scopeAdapter.getParent();
        }
        return null;
    }

    public static ScopeAdapter getScopeAdapter(EObject eObject) {
        if (eObject == null) {
            return null;
        }
        if (eObject.eIsProxy()) {
            return null;
        }
        EList eAdapters = eObject.eAdapters();
        ScopeAdapter adapter = (ScopeAdapter)EcoreUtil.getAdapter((List)eAdapters, ScopeAdapter.class);
        if (adapter != null) {
            return adapter;
        }
        EClass eClass = eObject.eClass();
        ScopeAdapter.Switch adapterSwitch = switchMap.get(eClass.getEPackage());
        if (adapterSwitch != null) {
            adapter = adapterSwitch.doInPackageSwitch(eObject);
        }
        if (adapter != null) {
            if (adapter.getTarget() == null) {
                eAdapters.add((Object)adapter);
            }
            return adapter;
        }
        return null;
    }

    protected AbstractScopeAdapter(T csElement) {
        this(csElement.eContainer(), csElement);
    }

    protected AbstractScopeAdapter(EObject csDocumentElement, T csElement) {
        this(AbstractScopeAdapter.getScopeAdapter(csDocumentElement), csElement);
    }

    private AbstractScopeAdapter(ScopeAdapter containerScopeAdapter, T csElement) {
        this.parent = containerScopeAdapter;
        this.document = this.parent != null ? this.parent.getDocumentScopeAdapter() : null;
        this.targetClass = csElement.getClass();
    }

    @Override
    public ScopeView computeLookup(EnvironmentView environmentView, ScopeView scopeView) {
        return scopeView.getOuterScope();
    }

    @Override
    public final void computeLookup(EnvironmentView environmentView, EReference targetReference, TypeBindingsCS bindings) {
        ScopeView scopeView = this.getInnerScopeView(targetReference, bindings);
        this.computeLookup(environmentView, scopeView);
    }

    @Override
    public DocumentScopeAdapter getDocumentScopeAdapter() {
        return this.document;
    }

    @Override
    public ScopeView getInnerScopeView(EReference targetReference, TypeBindingsCS bindings) {
        return new BaseScopeView(this, null, targetReference, bindings);
    }

    @Override
    public ScopeView getOuterScopeView(EReference targetReference, TypeBindingsCS bindings) {
        ScopeAdapter parent = this.getParent();
        T target = this.getTarget();
        return new BaseScopeView(parent, target.eContainingFeature(), targetReference, bindings);
    }

    @Override
    public ScopeAdapter getParent() {
        return this.parent;
    }

    @Override
    public final String getSignature() {
        T target = this.getTarget();
        if (target instanceof ModelElementCS) {
            return ((ModelElementCS)target).getSignature();
        }
        return target.toString();
    }

    @Override
    public ScopeAdapter getSourceScope(EStructuralFeature containmentFeature) {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getSimpleName()) + ".getSourceScope for " + this.getTarget().eClass().getName());
    }

    @Override
    public ClassifierCS getSynthesizedType(TypeBindingsCS bindings) {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getSimpleName()) + ".getSynthesizedType for " + this.getTarget().eClass().getName());
    }

    public T getTarget() {
        return (T)((EObject)this.target);
    }

    public String getText() {
        NodeAdapter nodeAdapter = NodeUtil.getNodeAdapter(this.getTarget());
        if (nodeAdapter == null) {
            return null;
        }
        CompositeNode compositeNode = nodeAdapter.getParserNode();
        if (compositeNode == null) {
            return null;
        }
        String string = null;
        StringBuffer s = null;
        for (LeafNode leaf : compositeNode.getLeafNodes()) {
            if (leaf.isHidden()) continue;
            String text = leaf.getText();
            if (s != null) {
                s.append(text);
                continue;
            }
            if (string != null) {
                s = new StringBuffer();
                s.append(string);
                s.append(text);
                continue;
            }
            string = text;
        }
        return s != null ? s.toString() : string;
    }

    public boolean isAdapterForType(Object type) {
        return type == ScopeAdapter.class;
    }

    @Override
    public boolean isUnresolvable() {
        return this.document == null || this.unresolveableModificationCount >= this.document.getModificationCount();
    }

    public void setTarget(Notifier newTarget) {
        assert (newTarget == null || this.targetClass.isAssignableFrom(newTarget.getClass()));
        super.setTarget(newTarget);
    }

    @Override
    public void setUnresolvable() {
        if (this.document != null) {
            this.unresolveableModificationCount = this.document.getModificationCount();
        }
    }

    public String toString() {
        return String.valueOf(this.getSignature());
    }
}

