/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.base.scope;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ocl.examples.xtext.base.baseCST.QualifiedRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypeBindingCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypeBindingsCS;
import org.eclipse.ocl.examples.xtext.base.scope.EnvironmentView;
import org.eclipse.ocl.examples.xtext.base.scope.ScopeAdapter;
import org.eclipse.ocl.examples.xtext.base.scope.ScopeView;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.impl.AbstractScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseScopeView
extends AbstractScope
implements ScopeView {
    protected final ScopeAdapter scopeAdapter;
    protected final EStructuralFeature containmentFeature;
    protected final EReference targetReference;
    protected final TypeBindingsCS bindings;

    public BaseScopeView(ScopeAdapter scopeAdapter, EStructuralFeature containmentFeature, EReference targetReference, TypeBindingsCS bindings) {
        this.scopeAdapter = scopeAdapter;
        this.containmentFeature = containmentFeature;
        this.targetReference = targetReference;
        this.bindings = bindings;
        assert (bindings != null);
    }

    public BaseScopeView(ScopeView scopeView, TypeBindingsCS bindings) {
        this.scopeAdapter = scopeView.getScopeAdapter();
        this.containmentFeature = scopeView.getContainmentFeature();
        this.targetReference = scopeView.getTargetReference();
        this.bindings = bindings;
        assert (bindings != null);
    }

    @Override
    public IEObjectDescription computeLookup(EnvironmentView environmentView) {
        ScopeView outerScope = this.scopeAdapter.computeLookup(environmentView, this);
        int size = environmentView.getSize();
        if (size == 0 || environmentView.getName() == null) {
            if (outerScope != null) {
                return outerScope.computeLookup(environmentView);
            }
            return null;
        }
        if (size == 1) {
            return environmentView.getContent();
        }
        List<IEObjectDescription> contents = environmentView.getContents();
        return contents.get(0);
    }

    @Override
    public void computeLookupWithParents(EnvironmentView environmentView) {
        ScopeView outerScope = this.scopeAdapter.computeLookup(environmentView, this);
        if (outerScope != null && (environmentView.getSize() == 0 || environmentView.getName() == null)) {
            outerScope.computeLookupWithParents(environmentView);
        }
    }

    @Override
    public TypeBindingsCS getBindings() {
        return this.bindings;
    }

    @Override
    public EStructuralFeature getContainmentFeature() {
        return this.containmentFeature;
    }

    public IEObjectDescription getContentByName(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        EnvironmentView environmentView = new EnvironmentView((EStructuralFeature)this.targetReference, name);
        return this.computeLookup(environmentView);
    }

    @Override
    public final ScopeView getOuterScope() {
        ScopeAdapter parent = this.scopeAdapter.getParent();
        if (parent == null) {
            return ScopeView.NULLSCOPEVIEW;
        }
        EStructuralFeature eContainingFeature = this.getTarget().eContainingFeature();
        return new BaseScopeView(parent, eContainingFeature, this.targetReference, this.bindings);
    }

    @Override
    public ScopeAdapter getScopeAdapter() {
        return this.scopeAdapter;
    }

    @Override
    public EObject getTarget() {
        return this.scopeAdapter.getTarget();
    }

    @Override
    public EReference getTargetReference() {
        return this.targetReference;
    }

    @Override
    public ScopeView getUnqualifiedOuterScope(TypeBindingsCS bindings) {
        ScopeAdapter parent = this.scopeAdapter.getParent();
        while (parent != null) {
            EObject target = parent.getTarget();
            if (!(target instanceof QualifiedRefCS)) {
                EStructuralFeature eContainingFeature = target.eContainingFeature();
                return new BaseScopeView(parent, eContainingFeature, this.targetReference, bindings);
            }
            parent = parent.getParent();
        }
        return ScopeView.NULLSCOPEVIEW;
    }

    protected final Iterable<IEObjectDescription> internalGetContents() {
        EnvironmentView environmentView = new EnvironmentView((EStructuralFeature)this.targetReference, null);
        this.scopeAdapter.computeLookup(environmentView, this);
        return environmentView.getContents();
    }

    public String toString() {
        EObject target = this.getTarget();
        StringBuffer s = new StringBuffer();
        s.append("[");
        s.append(target.eClass().getName());
        if (this.containmentFeature != null) {
            s.append("::");
            s.append(this.containmentFeature.getName());
        }
        if (!this.bindings.getBindings().isEmpty()) {
            s.append("<");
            String prefix = "";
            for (TypeBindingCS binding : this.bindings.getBindings()) {
                s.append(prefix);
                s.append(binding.getSignature());
                prefix = ",";
            }
            s.append(">");
        }
        s.append("] ");
        s.append(String.valueOf(target));
        return s.toString();
    }
}

