/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.base.scope;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ocl.examples.xtext.base.baseCST.NamedElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.OperationCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypeBindingsCS;
import org.eclipse.ocl.examples.xtext.base.scope.ScopeAdapter;
import org.eclipse.ocl.examples.xtext.base.scope.ScopeView;
import org.eclipse.ocl.examples.xtext.base.util.ElementUtil;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvironmentView {
    private final Map<String, Object> contentsByName = new HashMap<String, Object>();
    private final EStructuralFeature reference;
    private List<EClass> requiredAlternatives = null;
    private final String name;

    public EnvironmentView(EStructuralFeature reference, String name) {
        this.reference = reference;
        this.name = name;
    }

    public boolean accepts(EClass eClass) {
        return ElementUtil.conformsTo(this.reference, (EClassifier)eClass);
    }

    public int addElement(String elementName, EObject element, TypeBindingsCS bindings) {
        if (element != null && (this.name == null || this.name.equals(elementName))) {
            Object value;
            if (!bindings.getBindings().isEmpty() && element instanceof OperationCS) {
                element = ElementUtil.specializeOperation((OperationCS)element, bindings);
            }
            if ((value = this.contentsByName.get(elementName)) == null) {
                this.contentsByName.put(elementName, element);
            } else {
                List<EObject> values;
                if (value instanceof EObject) {
                    values = new ArrayList<EObject>();
                    values.add((EObject)value);
                } else {
                    List castValue = (List)value;
                    values = castValue;
                }
                values.add(element);
            }
            return 1;
        }
        return 0;
    }

    public void addElementsOfScope(EObject element, ScopeView scopeView) {
        ScopeAdapter scopeAdapter = ElementUtil.getScopeAdapter(element);
        if (scopeAdapter != null) {
            scopeAdapter.computeLookup(this, scopeView);
        }
    }

    public int addNamedElement(NamedElementCS namedElement, TypeBindingsCS bindings) {
        if (namedElement != null) {
            return this.addElement(namedElement.getName(), namedElement, bindings);
        }
        return 0;
    }

    public int addNamedElement(EClass eClass, NamedElementCS namedElement, TypeBindingsCS bindings) {
        if (namedElement != null && this.accepts(eClass) && eClass.isSuperTypeOf(namedElement.eClass())) {
            if (this.requiredAlternatives != null) {
                for (EClass requiredAlternative : this.requiredAlternatives) {
                    if (!requiredAlternative.isSuperTypeOf(namedElement.eClass())) continue;
                    return this.addNamedElement(namedElement, bindings);
                }
            } else {
                return this.addNamedElement(namedElement, bindings);
            }
        }
        return 0;
    }

    public int addNamedElements(List<? extends NamedElementCS> namedElements, TypeBindingsCS bindings) {
        int additions = 0;
        for (NamedElementCS namedElementCS : namedElements) {
            additions += this.addElement(namedElementCS.getName(), namedElementCS, bindings);
        }
        return additions;
    }

    public int addNamedElements(EClass eClass, List<? extends NamedElementCS> namedElements, TypeBindingsCS bindings) {
        int additions = 0;
        if (namedElements != null && this.accepts(eClass)) {
            for (NamedElementCS namedElementCS : namedElements) {
                if (!eClass.isSuperTypeOf(namedElementCS.eClass())) continue;
                if (this.requiredAlternatives != null) {
                    for (EClass requiredAlternative : this.requiredAlternatives) {
                        if (!requiredAlternative.isSuperTypeOf(namedElementCS.eClass())) continue;
                        additions += this.addElement(namedElementCS.getName(), namedElementCS, bindings);
                    }
                    continue;
                }
                additions += this.addElement(namedElementCS.getName(), namedElementCS, bindings);
            }
        }
        return additions;
    }

    public IEObjectDescription getContent() {
        assert (this.contentsByName.size() == 1);
        for (Map.Entry<String, Object> entry : this.contentsByName.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof List) {
                List values = (List)value;
                value = values.get(values.size() - 1);
            }
            if (!(value instanceof EObject)) continue;
            return EObjectDescription.create((String)entry.getKey(), (EObject)((EObject)value));
        }
        return null;
    }

    public List<IEObjectDescription> getContents() {
        ArrayList<IEObjectDescription> contents = new ArrayList<IEObjectDescription>();
        for (Map.Entry<String, Object> entry : this.contentsByName.entrySet()) {
            Object values = entry.getValue();
            if (values instanceof EObject) {
                contents.add(EObjectDescription.create((String)entry.getKey(), (EObject)((EObject)values)));
                continue;
            }
            if (!(values instanceof List)) continue;
            for (Object value : (List)values) {
                contents.add(EObjectDescription.create((String)entry.getKey(), (EObject)((EObject)value)));
            }
        }
        return contents;
    }

    public Object getName() {
        return this.name;
    }

    public EClassifier getRequiredType() {
        return this.reference != null ? this.reference.getEType() : null;
    }

    public int getSize() {
        return this.contentsByName.size();
    }

    public void require(EClass ... requiredClasses) {
        if (requiredClasses != null) {
            if (this.requiredAlternatives == null) {
                this.requiredAlternatives = new ArrayList<EClass>();
            }
            EClass[] eClassArray = requiredClasses;
            int n = requiredClasses.length;
            int n2 = 0;
            while (n2 < n) {
                EClass requiredClass = eClassArray[n2];
                this.requiredAlternatives.add(requiredClass);
                ++n2;
            }
        }
    }

    public String toString() {
        String prefix;
        StringBuffer s = new StringBuffer();
        if (this.reference != null) {
            s.append(this.reference.getName());
            s.append(" : ");
            s.append(this.reference.getEType().getName());
            if (this.requiredAlternatives != null) {
                s.append(" && (");
                prefix = "";
                for (EClass requiredAlternative : this.requiredAlternatives) {
                    s.append(prefix);
                    s.append(requiredAlternative.getName());
                    prefix = " || ";
                }
                s.append(")");
            }
        }
        s.append(" \"");
        if (this.name != null) {
            s.append(this.name);
        }
        s.append("\" {");
        prefix = "";
        for (String contentName : this.contentsByName.keySet()) {
            s.append(prefix);
            s.append(contentName);
            prefix = ",";
        }
        s.append("}");
        return s.toString();
    }
}

