/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.base.util;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.examples.xtext.base.baseCST.ElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.NamedElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ParameterCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypeBindingCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypeBindingsCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypeParameterCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypeRefCS;
import org.eclipse.ocl.examples.xtext.base.util.ElementUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Signature {
    private StringBuffer s = new StringBuffer();

    public void append(char c) {
        this.s.append(c);
    }

    public void append(int i) {
        this.s.append(i);
    }

    public void append(String string) {
        this.s.append(string != null ? string : "null");
    }

    public void appendElement(ElementCS csElement, TypeBindingsCS typeBindings) {
        if (csElement != null) {
            csElement.getSignature(this, typeBindings);
        } else {
            this.s.append("null");
        }
    }

    public void appendIndex(EObject eObject) {
        Object objects;
        EObject parent;
        if (eObject != null && (parent = eObject.eContainer()) != null && (objects = parent.eGet(eObject.eContainingFeature())) instanceof List) {
            this.append(((List)objects).indexOf(eObject));
            return;
        }
        this.append(0);
    }

    public void appendName(NamedElementCS csNamedElement) {
        this.append(csNamedElement != null ? csNamedElement.getName() : null);
    }

    public void appendParameters(List<ParameterCS> parameters, TypeBindingsCS typeBindings) {
        this.s.append('(');
        String prefix = "";
        for (ParameterCS csParameter : parameters) {
            this.s.append(prefix);
            csParameter.getType().getSignature(this, typeBindings);
            prefix = ",";
        }
        this.s.append(')');
    }

    public void appendParent(ElementCS csElement, String parentSeparator, TypeBindingsCS typeBindings) {
        EObject parent = csElement != null ? csElement.eContainer() : null;
        this.appendElement((ElementCS)parent, typeBindings);
        this.append(parentSeparator);
    }

    public void appendTypeArguments(List<TypeRefCS> typeArguments, TypeBindingsCS typeBindings) {
        if (!typeArguments.isEmpty()) {
            this.s.append('<');
            String prefix = "";
            for (TypeRefCS csTypeArgument : typeArguments) {
                this.s.append(prefix);
                csTypeArgument.getSignature(this, typeBindings);
                prefix = ",";
            }
            this.s.append('>');
        }
    }

    public void appendTypeBinding(TypeParameterCS typeParameter, TypeBindingsCS typeBindings) {
        TypeBindingCS binding = ElementUtil.getTypeBinding(typeParameter, typeBindings);
        if (binding != null) {
            this.appendElement(binding.getTypeArgument(), typeBindings);
        } else {
            this.appendName(typeParameter);
        }
    }

    public void appendTypeBindings(TypeBindingsCS typeBindings) {
        this.s.append('<');
        if (typeBindings != null) {
            String prefix = "";
            for (TypeBindingCS csTypeBinding : typeBindings.getBindings()) {
                this.s.append(prefix);
                this.s.append(csTypeBinding.toString());
                prefix = ",";
            }
        }
        this.s.append("> ");
    }

    public void appendTypeParameters(List<TypeParameterCS> typeParameters, TypeBindingsCS typeBindings) {
        if (!typeParameters.isEmpty()) {
            this.s.append('<');
            String prefix = "";
            for (TypeParameterCS csTypeParameter : typeParameters) {
                this.s.append(prefix);
                this.appendTypeBinding(csTypeParameter, typeBindings);
                prefix = ",";
            }
            this.s.append('>');
        }
    }

    public String toString() {
        return this.s.toString();
    }
}

