/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.oclinecore.ui;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceFactory;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.ui.editor.model.JavaClassPathResourceForIEditorInputFactory;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;

public class OCLinEcoreResourceForEditorInputFactory
extends JavaClassPathResourceForIEditorInputFactory {
    @Inject
    private IStorage2UriMapper storageToUriMapper;
    @Inject
    private Provider<XtextResource> provider;
    @Inject
    private Provider<XtextResourceSet> resourceSetProvider;
    private ResourceSet resourceSet = null;

    public Resource createResource(IEditorInput editorInput) {
        try {
            if (editorInput instanceof IStorageEditorInput) {
                IStorage storage = ((IStorageEditorInput)editorInput).getStorage();
                if (storage instanceof IFile) {
                    return this.createResourceFor((IFile)storage);
                }
                if (storage instanceof IJarEntryResource) {
                    return this.createResourceFor((IJarEntryResource)storage);
                }
            }
            throw new IllegalArgumentException("Couldn't create EMF Resource for input " + editorInput);
        }
        catch (CoreException e) {
            throw new WrappedException((Exception)((Object)e));
        }
    }

    protected Resource createResourceFor(IFile storage) {
        ResourceSet resourceSet = this.getResourceSet(null);
        URI uri = URI.createPlatformResourceURI((String)storage.getFullPath().toString(), (boolean)true);
        this.configureResourceSet(resourceSet, uri);
        XtextResource resource = (XtextResource)resourceSet.getResource(uri, false);
        if (resource == null) {
            resource = (XtextResource)new XtextResourceFactory(this.provider).createResource(uri);
            resourceSet.getResources().add((Object)resource);
        }
        resource.setValidationDisabled(false);
        return resource;
    }

    protected Resource createResourceFor(IJarEntryResource storage) {
        ResourceSet resourceSet = this.getResourceSet((IStorage)storage);
        URI uri = this.storageToUriMapper.getUri((IStorage)storage);
        this.configureResourceSet(resourceSet, uri);
        XtextResource resource = (XtextResource)resourceSet.getResource(uri, false);
        if (resource == null) {
            resource = (XtextResource)new XtextResourceFactory(this.provider).createResource(uri);
            resourceSet.getResources().add((Object)resource);
        }
        resource.setValidationDisabled(true);
        return resource;
    }

    public ResourceSet getResourceSet() {
        if (this.resourceSet == null) {
            this.resourceSet = (ResourceSet)this.resourceSetProvider.get();
        }
        return this.resourceSet;
    }

    protected ResourceSet getResourceSet(IStorage storage) {
        if (storage == null) {
            return this.getResourceSet();
        }
        return super.getResourceSet(storage);
    }
}

