/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.oclinecore.ui.commands;

import java.util.Collection;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.presentation.DynamicModelWizard;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ocl.examples.common.utils.EcoreUtils;
import org.eclipse.ocl.examples.xtext.base.baseCST.ClassCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ClassifierCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.DocumentCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.PackageCS;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parsetree.AbstractNode;
import org.eclipse.xtext.parsetree.CompositeNode;
import org.eclipse.xtext.parsetree.NodeUtil;
import org.eclipse.xtext.parsetree.ParseTreeUtil;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class CreateDynamicInstanceHandler
extends AbstractHandler {
    protected static final URI PLATFORM_RESOURCE = URI.createPlatformResourceURI((String)"/", (boolean)false);
    private EClass selectedClass = null;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (this.selectedClass != null) {
            IFile file;
            URI uri = this.selectedClass.eResource().getURI();
            StructuredSelection selection = StructuredSelection.EMPTY;
            if (uri.isHierarchical() && (uri.isRelative() || (uri = uri.deresolve(PLATFORM_RESOURCE)).isRelative()) && (file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toString()))).exists()) {
                selection = new StructuredSelection((Object)file);
            }
            DynamicModelWizard dynamicModelWizard = new DynamicModelWizard(this.selectedClass);
            dynamicModelWizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)selection);
            WizardDialog wizardDialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)dynamicModelWizard);
            wizardDialog.open();
        }
        return null;
    }

    private EClassifier findClassifier(Resource resource, ClassifierCS csClass) {
        EPackage ePackage = this.findPackage(resource, (PackageCS)csClass.eContainer());
        return ePackage != null ? ePackage.getEClassifier(csClass.getName()) : null;
    }

    private EPackage findPackage(Resource resource, PackageCS csPackage) {
        String name = csPackage.getName();
        EObject eContainer = csPackage.eContainer();
        if (eContainer instanceof DocumentCS) {
            for (EObject eObject : resource.getContents()) {
                EPackage ePackage;
                if (!(eObject instanceof EPackage) || !name.equals((ePackage = (EPackage)eObject).getName())) continue;
                return ePackage;
            }
            return null;
        }
        if (eContainer instanceof PackageCS) {
            EPackage ePackage = this.findPackage(resource, (PackageCS)eContainer);
            if (ePackage == null) {
                return null;
            }
            return (EPackage)EcoreUtils.getNamedElement((Collection)ePackage.getESubpackages(), (String)name);
        }
        return null;
    }

    public boolean isEnabled() {
        return this.selectedClass != null && super.isEnabled();
    }

    public void setEnabled(Object evaluationContext) {
        IEvaluationContext evalContext;
        XtextEditor xtextEditor;
        this.selectedClass = null;
        if (evaluationContext instanceof IEvaluationContext && (xtextEditor = CreateDynamicInstanceHandler.getActiveXtextEditor(evalContext = (IEvaluationContext)evaluationContext)) != null) {
            final ITextSelection selection = (ITextSelection)xtextEditor.getSelectionProvider().getSelection();
            IXtextDocument document = xtextEditor.getDocument();
            this.selectedClass = (EClass)document.readOnly((IUnitOfWork)new IUnitOfWork<EClass, XtextResource>(){

                public EClass exec(XtextResource xtextResource) {
                    IParseResult parseResult = xtextResource.getParseResult();
                    if (parseResult == null) {
                        throw new NullPointerException("parseResult is null");
                    }
                    CompositeNode rootNode = parseResult.getRootNode();
                    AbstractNode lastVisibleNode = ParseTreeUtil.getLastCompleteNodeByOffset((AbstractNode)rootNode, (int)selection.getOffset());
                    EObject currentModel = NodeUtil.getNearestSemanticObject((AbstractNode)lastVisibleNode);
                    if (!(currentModel instanceof ClassCS)) {
                        return null;
                    }
                    ResourceSetImpl localResourceSet = new ResourceSetImpl();
                    ClassCS oclInEcoreClass = (ClassCS)currentModel;
                    URI resourceURI = oclInEcoreClass.eResource().getURI().trimFragment();
                    Resource ecoreResource = localResourceSet.getResource(resourceURI, true);
                    EClassifier eClassifier = CreateDynamicInstanceHandler.this.findClassifier(ecoreResource, (ClassifierCS)oclInEcoreClass);
                    if (!(eClassifier instanceof EClass)) {
                        return null;
                    }
                    return (EClass)eClassifier;
                }
            });
        }
    }

    public static XtextEditor getActiveXtextEditor(IEvaluationContext evaluationContext) {
        Object o = HandlerUtil.getVariable((Object)evaluationContext, (String)"activeEditor");
        if (!(o instanceof IEditorPart)) {
            return null;
        }
        XtextEditor xtextEditor = (XtextEditor)((IEditorPart)o).getAdapter(XtextEditor.class);
        return xtextEditor;
    }
}

