/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.oclinecore.ui.model;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ocl.examples.xtext.oclinecore.resource.Ecore2OCLinEcore;
import org.eclipse.ocl.examples.xtext.oclinecore.ui.OCLinEcoreResourceForEditorInputFactory;
import org.eclipse.ocl.examples.xtext.oclinecore.ui.OCLinEcoreUiPluginHelper;
import org.eclipse.ocl.examples.xtext.oclinecore.ui.model.OCLinEcoreDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.xtext.parsetree.reconstr.XtextSerializationException;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.XtextDocumentProvider;

public class OCLinEcoreDocumentProvider
extends XtextDocumentProvider {
    private Map<IDocument, Boolean> loadedAsEcoreMap = new HashMap<IDocument, Boolean>();
    private Map<IDocument, Boolean> saveAsEcoreMap = new HashMap<IDocument, Boolean>();
    private Map<IDocument, URI> uriMap = new HashMap<IDocument, URI>();

    public static InputStream createResettableInputStream(InputStream inputStream) throws IOException {
        int len;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        while ((len = inputStream.read(buffer, 0, buffer.length)) > 0) {
            outputStream.write(buffer, 0, len);
        }
        return new ByteArrayInputStream(outputStream.toByteArray());
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        if (element instanceof IFileEditorInput && document instanceof OCLinEcoreDocument && this.saveAsEcoreMap.get(document) == Boolean.TRUE) {
            StringWriter ecoreWriter = new StringWriter();
            try {
                URI uri = EditUIUtil.getURI((IEditorInput)((IFileEditorInput)element));
                ResourceSet resourceSet = this.getResourceSet();
                ((OCLinEcoreDocument)document).saveAsEcore(resourceSet, uri, ecoreWriter);
                Document saveDocument = new Document();
                saveDocument.set(ecoreWriter.toString());
                super.doSaveDocument(monitor, element, (IDocument)saveDocument, overwrite);
                this.loadedAsEcoreMap.put(document, Boolean.TRUE);
            }
            catch (Exception e) {
                OCLinEcoreUiPluginHelper helper = OCLinEcoreUiPluginHelper.INSTANCE;
                String title = helper.getString("_UI_SaveFailure_title", true);
                String message = helper.getString("_UI_SaveFailure_message", true);
                ErrorDialog.openError(null, (String)title, (String)message, (IStatus)helper.createErrorStatus(e));
            }
        } else {
            super.doSaveDocument(monitor, element, document, overwrite);
        }
    }

    public ResourceSet getResourceSet() {
        return ((OCLinEcoreResourceForEditorInputFactory)this.getResourceForEditorInputFactory()).getResourceSet();
    }

    public boolean isDeleted(Object element) {
        Boolean saveIsEcore;
        IDocument document = this.getDocument(element);
        Boolean loadIsEcore = this.loadedAsEcoreMap.get(document);
        if (loadIsEcore != (saveIsEcore = this.saveAsEcoreMap.get(document))) {
            return true;
        }
        return super.isDeleted(element);
    }

    protected boolean isXML(InputStream inputStream) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        String line = reader.readLine();
        inputStream.reset();
        return line != null && line.startsWith("<?xml");
    }

    protected boolean setDocumentContent(IDocument document, IEditorInput editorInput, String encoding) throws CoreException {
        URI uri = EditUIUtil.getURI((IEditorInput)editorInput);
        this.uriMap.put(document, uri);
        return super.setDocumentContent(document, editorInput, encoding);
    }

    /*
     * Unable to fully structure code
     */
    protected void setDocumentContent(IDocument document, InputStream inputStream, String encoding) throws CoreException {
        block10: {
            try {
                block11: {
                    block12: {
                        if (!inputStream.markSupported()) {
                            inputStream = OCLinEcoreDocumentProvider.createResettableInputStream(inputStream);
                        }
                        asEcore = this.isXML(inputStream);
                        this.loadedAsEcoreMap.put(document, asEcore);
                        this.saveAsEcoreMap.put(document, asEcore);
                        if (!asEcore) break block10;
                        resourceSet = this.getResourceSet();
                        uri = this.uriMap.get(document);
                        ecoreResource = resourceSet.createResource(uri, "org.eclipse.emf.ecore");
                        ecoreResource.load(inputStream, null);
                        allErrors = null;
                        for (Resource resource : resourceSet.getResources()) {
                            errors = resource.getErrors();
                            if (errors.size() <= 0) continue;
                            if (allErrors == null) {
                                allErrors = new ArrayList<E>();
                            }
                            allErrors.addAll(errors);
                        }
                        if (allErrors != null) {
                            s = new StringBuffer();
                            for (Resource.Diagnostic diagnostic : allErrors) {
                                s.append("\n");
                                s.append(diagnostic.toString());
                            }
                            throw new CoreException((IStatus)new Status(4, "org.eclipse.ocl.examples.common", s.toString()));
                        }
                        documentCS = Ecore2OCLinEcore.importFromEcore((ResourceSet)resourceSet, (String)"", (Resource)ecoreResource);
                        xtextResource = documentCS.eResource();
                        outputStream = new ByteArrayOutputStream();
                        try {
                            xtextResource.save((OutputStream)outputStream, null);
                            break block11;
                        }
                        catch (XtextSerializationException e) {
                            diagnostics = ((XtextResource)xtextResource).validateConcreteSyntax();
                            if (diagnostics.size() <= 0) break block12;
                            s = new StringBuffer();
                            s.append("Concrete Syntax validation failed");
                            ** for (diagnostic : diagnostics)
                        }
lbl-1000:
                        // 1 sources

                        {
                            s.append("\n");
                            s.append(diagnostic.toString());
                            continue;
                        }
lbl50:
                        // 1 sources

                        throw new CoreException((IStatus)new Status(4, "org.eclipse.ocl.examples.common", s.toString(), (Throwable)e));
                    }
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.ocl.examples.common", "Failed to load", (Throwable)e));
                }
                xtextResource.unload();
                resourceSet.getResources().remove((Object)xtextResource);
                resourceSet.getResources().remove((Object)ecoreResource);
                inputStream = new ByteArrayInputStream(outputStream.toByteArray());
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.ocl.examples.common", "Failed to load", (Throwable)e));
            }
        }
        super.setDocumentContent(document, inputStream, encoding);
    }

    public void setPersistAsEcore(Object element, Boolean asEcore) {
        this.saveAsEcoreMap.put(this.getDocument(element), asEcore);
        this.setCanSaveDocument(element);
    }
}

