/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.oclinecore.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreSwitch;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIException;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.ocl.examples.xtext.base.baseCST.AnnotationElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.AttributeCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.AttributeCSRef;
import org.eclipse.ocl.examples.xtext.base.baseCST.BaseCSTFactory;
import org.eclipse.ocl.examples.xtext.base.baseCST.BaseCSTPackage;
import org.eclipse.ocl.examples.xtext.base.baseCST.ClassifierCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.DetailCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.EnumLiteralCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ImportCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ModelElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ModelElementCSRef;
import org.eclipse.ocl.examples.xtext.base.baseCST.NamedElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.NamespaceCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.PackageCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ParameterCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.PrimitiveTypeRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ReferenceCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ReferenceCSRef;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypeCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypeParameterCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypeRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypedElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypedRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypedTypeRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.WildcardTypeRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.util.BaseCSTSwitch;
import org.eclipse.ocl.examples.xtext.oclinecore.oclinEcoreCST.AnnotationCS;
import org.eclipse.ocl.examples.xtext.oclinecore.oclinEcoreCST.ConstraintCS;
import org.eclipse.ocl.examples.xtext.oclinecore.oclinEcoreCST.DataTypeCS;
import org.eclipse.ocl.examples.xtext.oclinecore.oclinEcoreCST.DataTypeOrEnumCS;
import org.eclipse.ocl.examples.xtext.oclinecore.oclinEcoreCST.DocumentationCS;
import org.eclipse.ocl.examples.xtext.oclinecore.oclinEcoreCST.EnumCS;
import org.eclipse.ocl.examples.xtext.oclinecore.oclinEcoreCST.OCLinEcoreAttributeCS;
import org.eclipse.ocl.examples.xtext.oclinecore.oclinEcoreCST.OCLinEcoreCSTFactory;
import org.eclipse.ocl.examples.xtext.oclinecore.oclinEcoreCST.OCLinEcoreClassCS;
import org.eclipse.ocl.examples.xtext.oclinecore.oclinEcoreCST.OCLinEcoreClassifierCS;
import org.eclipse.ocl.examples.xtext.oclinecore.oclinEcoreCST.OCLinEcoreDocumentCS;
import org.eclipse.ocl.examples.xtext.oclinecore.oclinEcoreCST.OCLinEcoreOperationCS;
import org.eclipse.ocl.examples.xtext.oclinecore.oclinEcoreCST.OCLinEcorePackageCS;
import org.eclipse.ocl.examples.xtext.oclinecore.oclinEcoreCST.OCLinEcoreReferenceCS;
import org.eclipse.ocl.examples.xtext.oclinecore.oclinEcoreCST.OCLinEcoreStructuralFeatureCS;
import org.eclipse.ocl.examples.xtext.oclinecore.oclinEcoreCST.util.OCLinEcoreCSTSwitch;
import org.eclipse.ocl.examples.xtext.oclinecore.resource.AbstractConversion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ecore2OCLinEcore
extends AbstractConversion
implements Adapter {
    private Map<EObject, ModelElementCS> createMap = new HashMap<EObject, ModelElementCS>();
    private Set<ModelElementCS> deferred = new HashSet<ModelElementCS>();
    private Set<EClassifier> allEClassifiers = new HashSet<EClassifier>();
    private Set<String> allNames = new HashSet<String>();
    private Map<String, EPackage> alias2ePackage = new HashMap<String, EPackage>();
    private Map<EPackage, String> ePackage2alias = new HashMap<EPackage, String>();
    private List<Resource.Diagnostic> errors = null;
    protected Resource ecoreResource;
    protected OCLinEcoreDocumentCS documentCS = null;
    protected final EcoreSwitch<ModelElementCS> pass1 = new EcoreSwitch<ModelElementCS>(){

        public AnnotationElementCS caseEAnnotation(EAnnotation eAnnotation) {
            String source = eAnnotation.getSource();
            if (source.equals("http://www.eclipse.org/emf/2002/GenModel")) {
                DocumentationCS csDocumentation = OCLinEcoreCSTFactory.eINSTANCE.createDocumentationCS();
                this.copyDetails(csDocumentation, eAnnotation, Collections.singletonList("documentation"));
                String documentation = (String)eAnnotation.getDetails().get((Object)"documentation");
                if (documentation != null) {
                    csDocumentation.setValue(documentation);
                }
                return csDocumentation;
            }
            AnnotationCS csAnnotation = OCLinEcoreCSTFactory.eINSTANCE.createAnnotationCS();
            this.copyDetails(csAnnotation, eAnnotation, null);
            if (Ecore2OCLinEcore.isId(source)) {
                csAnnotation.setIdSource(source);
            } else {
                csAnnotation.setStringSource(source);
            }
            this.doSwitchAll((List)csAnnotation.getContents(), (List<? extends EObject>)eAnnotation.getContents());
            if (!eAnnotation.getReferences().isEmpty()) {
                Ecore2OCLinEcore.this.deferred.add(csAnnotation);
            }
            return csAnnotation;
        }

        public OCLinEcoreAttributeCS caseEAttribute(EAttribute eAttribute) {
            OCLinEcoreAttributeCS csAttribute = OCLinEcoreCSTFactory.eINSTANCE.createOCLinEcoreAttributeCS();
            this.copyStructuralFeature(csAttribute, (EStructuralFeature)eAttribute, null);
            EList qualifiers = csAttribute.getQualifiers();
            this.setAttribute((EList<String>)qualifiers, "id", "!id", (EObject)eAttribute, EcorePackage.Literals.EATTRIBUTE__ID);
            return csAttribute;
        }

        public OCLinEcoreClassCS caseEClass(EClass eClass) {
            OCLinEcoreClassCS csClass = OCLinEcoreCSTFactory.eINSTANCE.createOCLinEcoreClassCS();
            this.copyClassifier(csClass, (EClassifier)eClass);
            EList<String> qualifiers = csClass.getQualifiers();
            this.setAttribute(qualifiers, "abstract", "!abstract", (EObject)eClass, EcorePackage.Literals.ECLASS__ABSTRACT);
            this.setAttribute(qualifiers, "interface", "!interface", (EObject)eClass, EcorePackage.Literals.ECLASS__INTERFACE);
            this.doSwitchAll((List)csClass.getSuperTypes(), (List<? extends EObject>)eClass.getEGenericSuperTypes());
            this.doSwitchAll((List)csClass.getOperations(), (List<? extends EObject>)eClass.getEOperations());
            this.doSwitchAll((List)csClass.getStructuralFeatures(), (List<? extends EObject>)eClass.getEStructuralFeatures());
            return csClass;
        }

        public DataTypeCS caseEDataType(EDataType eDataType) {
            DataTypeCS csDataType = OCLinEcoreCSTFactory.eINSTANCE.createDataTypeCS();
            this.copyDataTypeOrEnum(csDataType, eDataType);
            return csDataType;
        }

        public EnumCS caseEEnum(EEnum eEnum) {
            EnumCS csEnum = OCLinEcoreCSTFactory.eINSTANCE.createEnumCS();
            this.copyDataTypeOrEnum(csEnum, (EDataType)eEnum);
            this.doSwitchAll((List)csEnum.getLiterals(), (List<? extends EObject>)eEnum.getELiterals());
            return csEnum;
        }

        public EnumLiteralCS caseEEnumLiteral(EEnumLiteral eEnumLiteral) {
            EnumLiteralCS csEnumLiteral = BaseCSTFactory.eINSTANCE.createEnumLiteralCS();
            this.copyNamedElement((NamedElementCS)csEnumLiteral, (ENamedElement)eEnumLiteral);
            this.copyAnnotatedElement((ModelElementCS)csEnumLiteral, (EModelElement)eEnumLiteral, null);
            csEnumLiteral.setValue(eEnumLiteral.getValue());
            String literal = Ecore2OCLinEcore.basicGet((EObject)eEnumLiteral, EcorePackage.Literals.EENUM_LITERAL__LITERAL, String.class);
            if (literal != null) {
                AnnotationCS csAnnotation = OCLinEcoreCSTFactory.eINSTANCE.createAnnotationCS();
                csAnnotation.setIdSource("http://www.eclipse.org/emf/2002/Ecore");
                DetailCS csDetail = BaseCSTFactory.eINSTANCE.createDetailCS();
                csDetail.setIdName("literal");
                this.copyDetailLines((List<String>)csDetail.getValue(), literal);
                csAnnotation.getDetails().add((Object)csDetail);
                csEnumLiteral.getAnnotations().add((Object)csAnnotation);
            }
            return csEnumLiteral;
        }

        public TypeRefCS caseEGenericType(EGenericType eGenericType) {
            EClassifier eClassifier = eGenericType.getEClassifier();
            if (eClassifier instanceof EDataType && eClassifier.getEPackage() == EcorePackage.eINSTANCE) {
                String primitiveTypeName = null;
                if (eClassifier == EcorePackage.Literals.EBOOLEAN) {
                    primitiveTypeName = "Boolean";
                } else if (eClassifier == EcorePackage.Literals.EBIG_INTEGER) {
                    primitiveTypeName = "Integer";
                } else if (eClassifier == EcorePackage.Literals.EBIG_DECIMAL) {
                    primitiveTypeName = "Real";
                } else if (eClassifier == EcorePackage.Literals.ESTRING) {
                    primitiveTypeName = "String";
                }
                if (primitiveTypeName != null) {
                    PrimitiveTypeRefCS csTypeRef = BaseCSTFactory.eINSTANCE.createPrimitiveTypeRefCS();
                    csTypeRef.setName(primitiveTypeName);
                    this.setOriginalMapping((ModelElementCS)csTypeRef, (EObject)eGenericType);
                    return csTypeRef;
                }
            }
            if (eClassifier != null) {
                TypedTypeRefCS csTypeRef = BaseCSTFactory.eINSTANCE.createTypedTypeRefCS();
                this.setOriginalMapping((ModelElementCS)csTypeRef, (EObject)eGenericType);
                Ecore2OCLinEcore.this.deferred.add(csTypeRef);
                this.doSwitchAll((List)csTypeRef.getTypeArguments(), (List<? extends EObject>)eGenericType.getETypeArguments());
                return csTypeRef;
            }
            ETypeParameter eTypeParameter = eGenericType.getETypeParameter();
            if (eTypeParameter != null) {
                TypedTypeRefCS csTypeRef = BaseCSTFactory.eINSTANCE.createTypedTypeRefCS();
                this.setOriginalMapping((ModelElementCS)csTypeRef, (EObject)eGenericType);
                Ecore2OCLinEcore.this.deferred.add(csTypeRef);
                return csTypeRef;
            }
            WildcardTypeRefCS csTypeRef = BaseCSTFactory.eINSTANCE.createWildcardTypeRefCS();
            this.setOriginalMapping((ModelElementCS)csTypeRef, (EObject)eGenericType);
            return csTypeRef;
        }

        public OCLinEcoreOperationCS caseEOperation(EOperation eOperation) {
            OCLinEcoreOperationCS csOperation = OCLinEcoreCSTFactory.eINSTANCE.createOCLinEcoreOperationCS();
            ArrayList<EAnnotation> excludedAnnotations = null;
            EAnnotation oclAnnotation = eOperation.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore/OCL");
            if (oclAnnotation != null) {
                excludedAnnotations = new ArrayList<EAnnotation>();
                excludedAnnotations.add(oclAnnotation);
                EList<ConstraintCS> csConstraints = csOperation.getConstraints();
                for (Map.Entry entry : oclAnnotation.getDetails().entrySet()) {
                    ConstraintCS csConstraint = OCLinEcoreCSTFactory.eINSTANCE.createConstraintCS();
                    String key = (String)entry.getKey();
                    if (key.equals("body")) {
                        csConstraint.setStereotype("body");
                    } else if (key.startsWith("body_")) {
                        csConstraint.setStereotype("body");
                        csConstraint.setName(key.substring(5));
                    } else if (key.equals("pre")) {
                        csConstraint.setStereotype("precondition");
                    } else if (key.startsWith("pre_")) {
                        csConstraint.setStereotype("precondition");
                        csConstraint.setName(key.substring(4));
                    } else if (key.equals("post")) {
                        csConstraint.setStereotype("postcondition");
                    } else if (key.startsWith("post_")) {
                        csConstraint.setStereotype("postcondition");
                        csConstraint.setName(key.substring(5));
                    } else {
                        Ecore2OCLinEcore.this.error("Unsupported operation constraint " + key);
                        csConstraint = null;
                    }
                    if (csConstraint == null) continue;
                    csConstraint.setExprString((String)entry.getValue());
                    csConstraints.add(csConstraint);
                }
            }
            this.copyTypedElement((TypedElementCS)csOperation, (ETypedElement)eOperation, excludedAnnotations);
            this.doSwitchAll((List)csOperation.getParameters(), (List<? extends EObject>)eOperation.getEParameters());
            this.doSwitchAll((List)csOperation.getTypeParameters(), (List<? extends EObject>)eOperation.getETypeParameters());
            this.doSwitchAll((List)csOperation.getExceptions(), (List<? extends EObject>)eOperation.getEGenericExceptions());
            return csOperation;
        }

        public PackageCS caseEPackage(EPackage ePackage) {
            OCLinEcorePackageCS csPackage = OCLinEcoreCSTFactory.eINSTANCE.createOCLinEcorePackageCS();
            EAnnotation eAnnotation = ePackage.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore");
            List<EAnnotation> exclusions = eAnnotation == null ? Collections.emptyList() : Collections.singletonList(eAnnotation);
            this.copyNamedElement((NamedElementCS)csPackage, (ENamedElement)ePackage);
            this.copyAnnotatedElement((ModelElementCS)csPackage, (EModelElement)ePackage, exclusions);
            String prefix = Ecore2OCLinEcore.basicGet((EObject)ePackage, EcorePackage.Literals.EPACKAGE__NS_PREFIX, String.class);
            String uri = Ecore2OCLinEcore.basicGet((EObject)ePackage, EcorePackage.Literals.EPACKAGE__NS_URI, String.class);
            if (prefix != null && uri != null) {
                csPackage.setPrefix(prefix);
                csPackage.setUri(uri);
            }
            this.doSwitchAll((List)csPackage.getSubpackages(), (List<? extends EObject>)ePackage.getESubpackages());
            this.doSwitchAll((List)csPackage.getClassifiers(), (List<? extends EObject>)ePackage.getEClassifiers());
            return csPackage;
        }

        public ParameterCS caseEParameter(EParameter eParameter) {
            ParameterCS csParameter = BaseCSTFactory.eINSTANCE.createParameterCS();
            this.copyTypedElement((TypedElementCS)csParameter, (ETypedElement)eParameter, null);
            return csParameter;
        }

        public OCLinEcoreReferenceCS caseEReference(EReference eReference) {
            OCLinEcoreReferenceCS csReference = OCLinEcoreCSTFactory.eINSTANCE.createOCLinEcoreReferenceCS();
            Object oppositeRole = null;
            List<Object> excludedAnnotations = oppositeRole != null ? Collections.singletonList(oppositeRole) : null;
            this.copyStructuralFeature(csReference, (EStructuralFeature)eReference, excludedAnnotations);
            if (eReference.getEOpposite() != null || excludedAnnotations != null || !eReference.getEKeys().isEmpty()) {
                Ecore2OCLinEcore.this.deferred.add(csReference);
            }
            EList qualifiers = csReference.getQualifiers();
            this.setAttribute((EList<String>)qualifiers, "composes", "!composes", (EObject)eReference, EcorePackage.Literals.EREFERENCE__CONTAINMENT);
            this.setAttribute((EList<String>)qualifiers, "resolve", "!resolve", (EObject)eReference, EcorePackage.Literals.EREFERENCE__RESOLVE_PROXIES);
            return csReference;
        }

        public ModelElementCS caseETypeParameter(ETypeParameter eTypeParameter) {
            TypeParameterCS csTypeParameter = BaseCSTFactory.eINSTANCE.createTypeParameterCS();
            this.copyNamedElement((NamedElementCS)csTypeParameter, (ENamedElement)eTypeParameter);
            this.copyAnnotatedElement((ModelElementCS)csTypeParameter, (EModelElement)eTypeParameter, null);
            this.doSwitchAll((List)csTypeParameter.getExtends(), (List<? extends EObject>)eTypeParameter.getEBounds());
            return csTypeParameter;
        }

        protected void copyClassifier(OCLinEcoreClassifierCS csClassifier, EClassifier eClassifier) {
            EAnnotation ecoreAnnotation;
            ArrayList<EAnnotation> excludedAnnotations = null;
            EMap oclAnnotationDetails = null;
            EAnnotation oclAnnotation = eClassifier.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore/OCL");
            if (oclAnnotation != null) {
                excludedAnnotations = new ArrayList<EAnnotation>();
                excludedAnnotations.add(oclAnnotation);
                EList<ConstraintCS> csConstraints = csClassifier.getConstraints();
                oclAnnotationDetails = oclAnnotation.getDetails();
                for (Map.Entry entry : oclAnnotationDetails.entrySet()) {
                    ConstraintCS csConstraint = OCLinEcoreCSTFactory.eINSTANCE.createConstraintCS();
                    csConstraint.setStereotype("invariant");
                    csConstraint.setName((String)entry.getKey());
                    csConstraint.setExprString((String)entry.getValue());
                    csConstraints.add(csConstraint);
                }
            }
            if ((ecoreAnnotation = eClassifier.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore")) != null) {
                if (excludedAnnotations == null) {
                    excludedAnnotations = new ArrayList();
                }
                excludedAnnotations.add(ecoreAnnotation);
                String constraintNameList = (String)ecoreAnnotation.getDetails().get((Object)"constraints");
                if (constraintNameList != null) {
                    String[] constraintNames;
                    EList<ConstraintCS> csConstraints = csClassifier.getConstraints();
                    String[] stringArray = constraintNames = constraintNameList.split(" ");
                    int n = constraintNames.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String constraintName = stringArray[n2];
                        if (oclAnnotationDetails == null || oclAnnotationDetails.get((Object)constraintName) == null) {
                            ConstraintCS csConstraint = OCLinEcoreCSTFactory.eINSTANCE.createConstraintCS();
                            csConstraint.setStereotype("invariant");
                            csConstraint.setName(constraintName);
                            csConstraints.add(csConstraint);
                        }
                        ++n2;
                    }
                }
            }
            this.copyNamedElement((NamedElementCS)csClassifier, (ENamedElement)eClassifier);
            this.copyAnnotatedElement((ModelElementCS)csClassifier, (EModelElement)eClassifier, excludedAnnotations);
            String instanceClassName = Ecore2OCLinEcore.basicGet((EObject)eClassifier, EcorePackage.Literals.ECLASSIFIER__INSTANCE_CLASS_NAME, String.class);
            if (instanceClassName != null) {
                csClassifier.setInstanceClassName(instanceClassName);
            }
            this.doSwitchAll((List)csClassifier.getTypeParameters(), (List<? extends EObject>)eClassifier.getETypeParameters());
        }

        protected void copyDataTypeOrEnum(DataTypeOrEnumCS csDataType, EDataType eDataType) {
            this.copyClassifier(csDataType, (EClassifier)eDataType);
            EList<String> qualifiers = csDataType.getQualifiers();
            this.setAttribute(qualifiers, "serializable", "!serializable", (EObject)eDataType, EcorePackage.Literals.EDATA_TYPE__SERIALIZABLE);
        }

        public void copyDetailLines(List<String> lines, String value) {
            String[] splitLines = value.split("\n");
            int i = 0;
            while (i < splitLines.length - 1) {
                lines.add(String.valueOf(splitLines[i]) + '\n');
                ++i;
            }
            if (splitLines.length > 0) {
                lines.add(splitLines[splitLines.length - 1]);
            }
        }

        protected void copyDetails(AnnotationElementCS csAnnotation, EAnnotation eAnnotation, List<String> excludedKeys) {
            this.copyModelElement((ModelElementCS)csAnnotation, (EModelElement)eAnnotation);
            this.copyAnnotatedElement((ModelElementCS)csAnnotation, (EModelElement)eAnnotation, null);
            ListIterator it = eAnnotation.getDetails().listIterator();
            while (it.hasNext()) {
                Map.Entry eDetail = (Map.Entry)it.next();
                String name = (String)eDetail.getKey();
                if (excludedKeys != null && excludedKeys.contains(name)) continue;
                DetailCS csDetail = BaseCSTFactory.eINSTANCE.createDetailCS();
                if (Ecore2OCLinEcore.isId(name)) {
                    csDetail.setIdName(name);
                } else {
                    csDetail.setStringName(name);
                }
                this.copyDetailLines((List<String>)csDetail.getValue(), (String)eDetail.getValue());
                csAnnotation.getDetails().add((Object)csDetail);
            }
        }

        protected void copyModelElement(ModelElementCS csModelElement, EModelElement eModelElement) {
            this.setOriginalMapping(csModelElement, (EObject)eModelElement);
        }

        protected void copyAnnotatedElement(ModelElementCS csModelElement, EModelElement eModelElement, List<EAnnotation> excludedAnnotations) {
            EList csAnnotations = csModelElement.getAnnotations();
            for (EAnnotation eAnnotation : eModelElement.getEAnnotations()) {
                if (excludedAnnotations != null && excludedAnnotations.contains(eAnnotation)) continue;
                AnnotationElementCS csAnnotation = (AnnotationElementCS)this.doSwitch((EObject)eAnnotation);
                csAnnotations.add(csAnnotation);
            }
        }

        public void setOriginalMapping(ModelElementCS csModelElement, EObject eModelElement) {
            String xmiId;
            csModelElement.setOriginalObject(eModelElement);
            if (Ecore2OCLinEcore.this.ecoreResource instanceof XMLResource && (xmiId = ((XMLResource)Ecore2OCLinEcore.this.ecoreResource).getID(eModelElement)) != null) {
                csModelElement.setOriginalXmiId(xmiId);
            }
            Ecore2OCLinEcore.this.createMap.put(eModelElement, csModelElement);
        }

        protected void copyNamedElement(NamedElementCS csNamedElement, ENamedElement eNamedElement) {
            this.copyModelElement((ModelElementCS)csNamedElement, (EModelElement)eNamedElement);
            String name = eNamedElement.getName();
            csNamedElement.setName(name);
            Ecore2OCLinEcore.this.allNames.add(name);
        }

        protected void copyStructuralFeature(OCLinEcoreStructuralFeatureCS csStructuralFeature, EStructuralFeature eStructuralFeature, List<EAnnotation> excludedAnnotations) {
            EAnnotation oclAnnotation = eStructuralFeature.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore/OCL");
            if (oclAnnotation != null) {
                excludedAnnotations = new ArrayList<EAnnotation>();
                excludedAnnotations.add(oclAnnotation);
                EList<ConstraintCS> csConstraints = csStructuralFeature.getConstraints();
                for (Map.Entry entry : oclAnnotation.getDetails().entrySet()) {
                    ConstraintCS csConstraint = OCLinEcoreCSTFactory.eINSTANCE.createConstraintCS();
                    String key = (String)entry.getKey();
                    if (key.equals("derivation")) {
                        csConstraint.setStereotype("derivation");
                    } else if (key.equals("initial")) {
                        csConstraint.setStereotype("initial");
                    } else {
                        Ecore2OCLinEcore.this.error("Unsupported feature constraint " + key);
                        csConstraint = null;
                    }
                    if (csConstraint == null) continue;
                    csConstraint.setExprString((String)entry.getValue());
                    csConstraints.add(csConstraint);
                }
            }
            this.copyTypedElement((TypedElementCS)csStructuralFeature, (ETypedElement)eStructuralFeature, excludedAnnotations);
            EList qualifiers = csStructuralFeature.getQualifiers();
            this.setAttribute((EList<String>)qualifiers, "!readonly", "readonly", (EObject)eStructuralFeature, EcorePackage.Literals.ESTRUCTURAL_FEATURE__CHANGEABLE);
            this.setAttribute((EList<String>)qualifiers, "derived", "!derived", (EObject)eStructuralFeature, EcorePackage.Literals.ESTRUCTURAL_FEATURE__DERIVED);
            this.setAttribute((EList<String>)qualifiers, "transient", "!transient", (EObject)eStructuralFeature, EcorePackage.Literals.ESTRUCTURAL_FEATURE__TRANSIENT);
            this.setAttribute((EList<String>)qualifiers, "unsettable", "!unsettable", (EObject)eStructuralFeature, EcorePackage.Literals.ESTRUCTURAL_FEATURE__UNSETTABLE);
            this.setAttribute((EList<String>)qualifiers, "volatile", "!volatile", (EObject)eStructuralFeature, EcorePackage.Literals.ESTRUCTURAL_FEATURE__VOLATILE);
            String defaultValueLiteral = Ecore2OCLinEcore.basicGet((EObject)eStructuralFeature, EcorePackage.Literals.ESTRUCTURAL_FEATURE__DEFAULT_VALUE_LITERAL, String.class);
            if (defaultValueLiteral != null) {
                csStructuralFeature.setDefaultValueLiteral(defaultValueLiteral);
            }
        }

        protected void copyTypedElement(TypedElementCS csTypedElement, ETypedElement eTypedElement, List<EAnnotation> excludedAnnotations) {
            this.copyNamedElement((NamedElementCS)csTypedElement, (ENamedElement)eTypedElement);
            this.copyAnnotatedElement((ModelElementCS)csTypedElement, (EModelElement)eTypedElement, excludedAnnotations);
            EGenericType eGenericType = eTypedElement.getEGenericType();
            if (eGenericType != null) {
                EClassifier eClassifier = eGenericType.getEClassifier();
                if (eClassifier != null) {
                    Ecore2OCLinEcore.this.allEClassifiers.add(eClassifier);
                }
                ModelElementCS csType = (ModelElementCS)this.doSwitch((EObject)eGenericType);
                csTypedElement.setType((TypedRefCS)csType);
            }
            int lower = eTypedElement.getLowerBound();
            int upper = eTypedElement.getUpperBound();
            if (upper == -1) {
                if (lower == 0) {
                    csTypedElement.setMultiplicity("*");
                } else if (lower == 1) {
                    csTypedElement.setMultiplicity("+");
                } else {
                    csTypedElement.setLower(lower);
                    csTypedElement.setUpper(upper);
                }
            } else if (lower == 0 && upper == 1) {
                csTypedElement.setMultiplicity("?");
            } else {
                csTypedElement.setLower(lower);
                if (upper != lower) {
                    csTypedElement.setUpper(upper);
                }
            }
            EList qualifiers = csTypedElement.getQualifiers();
            this.setAttribute((EList<String>)qualifiers, "ordered", "!ordered", (EObject)eTypedElement, EcorePackage.Literals.ETYPED_ELEMENT__ORDERED);
            this.setAttribute((EList<String>)qualifiers, "unique", "!unique", (EObject)eTypedElement, EcorePackage.Literals.ETYPED_ELEMENT__UNIQUE);
        }

        public ModelElementCS defaultCase(EObject object) {
            Ecore2OCLinEcore.this.error("Unsupported " + object + " in pass1");
            return null;
        }

        public <T extends ModelElementCS> void doSwitchAll(List<T> csObjects, List<? extends EObject> eObjects) {
            for (EObject eObject : eObjects) {
                ModelElementCS csObject = (ModelElementCS)this.doSwitch(eObject);
                csObjects.add(csObject);
            }
        }

        protected void setAttribute(EList<String> qualifiers, String trueName, String falseName, EObject eObject, EAttribute eAttribute) {
            if (eObject.eIsSet((EStructuralFeature)eAttribute)) {
                boolean isTrue = eObject.eGet((EStructuralFeature)eAttribute) == Boolean.TRUE;
                qualifiers.add((Object)(isTrue ? trueName : falseName));
            }
        }
    };
    protected final OCLinEcoreCSTSwitch<Object> pass2 = new OCLinEcoreCSTSwitch<Object>(){
        protected final BaseCSTSwitch<EObject> emofPass2 = new BaseCSTSwitch<EObject>(){

            public EObject caseTypedTypeRefCS(TypedTypeRefCS csTypeRef) {
                EGenericType eGenericType = (EGenericType)csTypeRef.getOriginalObject();
                EClassifier eClassifier = eGenericType.getEClassifier();
                if (eClassifier != null) {
                    Ecore2OCLinEcore.this.allEClassifiers.add(eClassifier);
                    ClassifierCS csClassifier = Ecore2OCLinEcore.this.getCS((EObject)eClassifier, ClassifierCS.class);
                    csTypeRef.setType((TypeCS)csClassifier);
                } else {
                    ETypeParameter eTypeParameter = eGenericType.getETypeParameter();
                    if (eTypeParameter != null) {
                        TypeParameterCS csTypeParameter = (TypeParameterCS)Ecore2OCLinEcore.this.createMap.get(eTypeParameter);
                        csTypeRef.setType((TypeCS)csTypeParameter);
                    }
                }
                return null;
            }
        };

        @Override
        public Object caseAnnotationCS(AnnotationCS csAnnotation) {
            EAnnotation eAnnotation = (EAnnotation)csAnnotation.getOriginalObject();
            for (EObject eReference : eAnnotation.getReferences()) {
                ModelElementCSRef objectRef = this.copyObjectRef(eReference);
                if (objectRef == null) continue;
                csAnnotation.getReferences().add((Object)objectRef);
            }
            return null;
        }

        @Override
        public EObject caseOCLinEcoreReferenceCS(OCLinEcoreReferenceCS csReference) {
            ReferenceCSRef referenceRef;
            EAnnotation oppositeRole;
            EReference eReference = (EReference)csReference.getOriginalObject();
            EReference eOpposite = eReference.getEOpposite();
            if (eOpposite == null && (oppositeRole = eReference.getEAnnotation("http://schema.omg.org/spec/MOF/2.0/emof.xml#Property.oppositeRoleName")) != null) {
                String oppositeName = (String)oppositeRole.getDetails().get((Object)"body");
                EClass eReferenceType = eReference.getEReferenceType();
                eOpposite = (EReference)eReferenceType.getEStructuralFeature(oppositeName);
            }
            if (eOpposite != null && (referenceRef = this.copyReferenceRef(eOpposite)) != null) {
                csReference.setOpposite(referenceRef);
            }
            for (EAttribute eKey : eReference.getEKeys()) {
                AttributeCSRef attributeRef = this.copyAttributeRef(eKey);
                if (attributeRef == null) continue;
                csReference.getKeys().add((Object)attributeRef);
            }
            return null;
        }

        protected AttributeCSRef copyAttributeRef(EAttribute eKey) {
            AttributeCSRef attributeRef = null;
            ModelElementCS csObject = (ModelElementCS)Ecore2OCLinEcore.this.createMap.get(eKey);
            if (csObject instanceof OCLinEcoreAttributeCS) {
                AttributeCSRef AttributeCSRef2 = BaseCSTFactory.eINSTANCE.createAttributeCSRef();
                AttributeCSRef2.setRef((AttributeCS)csObject);
                attributeRef = AttributeCSRef2;
            } else {
                Ecore2OCLinEcore.this.error("Unresolved " + eKey + " in pass2");
            }
            return attributeRef;
        }

        protected ModelElementCSRef copyObjectRef(EObject eObject) {
            ModelElementCSRef objectRef = null;
            ModelElementCS csObject = (ModelElementCS)Ecore2OCLinEcore.this.createMap.get(eObject);
            if (csObject != null) {
                ModelElementCSRef modelElementCSRef = BaseCSTFactory.eINSTANCE.createModelElementCSRef();
                modelElementCSRef.setRef(csObject);
                objectRef = modelElementCSRef;
            } else {
                Ecore2OCLinEcore.this.error("Unresolved " + eObject + " in pass2");
            }
            return objectRef;
        }

        protected ReferenceCSRef copyReferenceRef(EReference eOpposite) {
            ReferenceCSRef referenceRef = null;
            ModelElementCS csObject = (ModelElementCS)Ecore2OCLinEcore.this.createMap.get(eOpposite);
            if (csObject instanceof OCLinEcoreReferenceCS) {
                ReferenceCSRef referenceCSRef = BaseCSTFactory.eINSTANCE.createReferenceCSRef();
                referenceCSRef.setRef((ReferenceCS)csObject);
                referenceRef = referenceCSRef;
            } else {
                Ecore2OCLinEcore.this.error("Unresolved " + eOpposite + " in pass2");
            }
            return referenceRef;
        }

        @Override
        public EObject doSwitch(EObject eObject) {
            EPackage ePackage = eObject.eClass().getEPackage();
            if (ePackage == BaseCSTPackage.eINSTANCE) {
                return (EObject)this.emofPass2.doSwitch(eObject);
            }
            return (EObject)super.doSwitch(eObject);
        }
    };

    public static OCLinEcoreDocumentCS importFromEcore(ResourceSet resourceSet, String alias, Resource ecoreResource) {
        if (ecoreResource == null) {
            return null;
        }
        Ecore2OCLinEcore conversion = Ecore2OCLinEcore.importDocument(resourceSet, ecoreResource);
        return conversion.getDocument();
    }

    public static Ecore2OCLinEcore importDocument(ResourceSet resourceSet, Resource ecoreResource) {
        EList eAdapters = ecoreResource.eAdapters();
        Ecore2OCLinEcore conversion = (Ecore2OCLinEcore)EcoreUtil.getAdapter((List)eAdapters, Ecore2OCLinEcore.class);
        if (conversion == null) {
            conversion = new Ecore2OCLinEcore(resourceSet);
            eAdapters.add((Object)conversion);
        }
        return conversion;
    }

    public static ModelElementCS importFromEcore(ResourceSet resourceSet, String alias, EObject eObject) {
        if (eObject == null) {
            return null;
        }
        Resource ecoreResource = eObject.eResource();
        Ecore2OCLinEcore conversion = Ecore2OCLinEcore.importDocument(resourceSet, ecoreResource);
        OCLinEcoreDocumentCS documentCS = conversion.getDocument();
        if (documentCS == null) {
            return null;
        }
        return conversion.createMap.get(eObject);
    }

    public Ecore2OCLinEcore(ResourceSet resourceSet) {
        super(resourceSet);
    }

    protected void error(String message) {
        if (this.errors == null) {
            this.errors = new ArrayList<Resource.Diagnostic>();
        }
        this.errors.add((Resource.Diagnostic)new XMIException(message));
    }

    public <T extends ModelElementCS> T getCS(EObject eObject, Class<T> csClass) {
        Resource resource;
        ModelElementCS csModelElement = this.createMap.get(eObject);
        if (csModelElement == null && (resource = eObject.eResource()) != null) {
            Ecore2OCLinEcore conversion = Ecore2OCLinEcore.importDocument(this.resourceSet, resource);
            OCLinEcoreDocumentCS importResource = conversion.getDocument();
            this.allEClassifiers.addAll(conversion.allEClassifiers);
            this.allNames.addAll(conversion.allNames);
            for (Map.Entry<EObject, ModelElementCS> entry : conversion.createMap.entrySet()) {
                this.createMap.put(entry.getKey(), entry.getValue());
            }
            URI uri = resource.getURI();
            if (uri != null) {
                importResource.setName(uri.lastSegment());
            }
        }
        if ((csModelElement = this.createMap.get(eObject)) == null) {
            this.error("Unresolved " + eObject);
        } else if (!csClass.isAssignableFrom(csModelElement.getClass())) {
            this.error("Incompatible " + eObject);
        } else {
            ModelElementCS castModelElement = csModelElement;
            return (T)castModelElement;
        }
        return null;
    }

    public Collection<EPackage> getReferencedEPackages() {
        HashSet<EPackage> ePackages = new HashSet<EPackage>();
        for (EClassifier eClassifier : this.allEClassifiers) {
            EPackage ePackage = eClassifier.getEPackage();
            if (ePackage == null) continue;
            ePackages.add(ePackage);
        }
        return ePackages;
    }

    public OCLinEcoreDocumentCS getDocument() {
        if (this.documentCS == null) {
            this.importResource();
        }
        return this.documentCS;
    }

    protected void importResource() {
        URI oclinecoreURI = this.ecoreResource.getURI().appendFileExtension("oclinecore");
        Resource xtextResource = this.resourceSet.createResource(oclinecoreURI, "org.eclipse.ocl.examples.xtext.oclinecore");
        this.documentCS = OCLinEcoreCSTFactory.eINSTANCE.createOCLinEcoreDocumentCS();
        xtextResource.getContents().add((Object)this.documentCS);
        EList<OCLinEcorePackageCS> packages = this.documentCS.getPackages();
        for (EObject eObject : this.ecoreResource.getContents()) {
            packages.add((OCLinEcorePackageCS)this.pass1.doSwitch(eObject));
        }
        for (ModelElementCS csModelElement : this.deferred) {
            this.pass2.doSwitch((EObject)csModelElement);
        }
        ArrayList<EPackage> ePackages = new ArrayList<EPackage>(this.getReferencedEPackages());
        EList imports = this.documentCS.getImports();
        for (EPackage ePackage : ePackages) {
            ModelElementCS csElement = this.createMap.get(ePackage);
            if (csElement != null && csElement.eResource() == xtextResource) continue;
            ImportCS importCS = BaseCSTFactory.eINSTANCE.createImportCS();
            String alias = this.ePackage2alias.get(ePackage);
            if (alias == null) {
                String suffixedAlias = alias = ePackage.getNsPrefix();
                int i = 0;
                while (this.alias2ePackage.containsKey(suffixedAlias) || this.allNames.contains(suffixedAlias)) {
                    suffixedAlias = String.valueOf(alias) + "_" + i;
                    ++i;
                }
                alias = suffixedAlias;
                this.alias2ePackage.put(alias, ePackage);
                this.ePackage2alias.put(ePackage, alias);
            }
            importCS.setName(alias);
            URI fullURI = EcoreUtil.getURI((EObject)ePackage);
            URI deresolvedURI = fullURI.deresolve(oclinecoreURI);
            importCS.setUri(deresolvedURI.toString());
            PackageCS csPackage = this.getCS((EObject)ePackage, PackageCS.class);
            importCS.setNamespace((NamespaceCS)csPackage);
            imports.add(importCS);
        }
        if (this.errors != null) {
            xtextResource.getErrors().addAll(this.errors);
        }
    }

    public boolean isAdapterForType(Object type) {
        return type == Ecore2OCLinEcore.class;
    }

    public void notifyChanged(Notification notification) {
    }

    public Notifier getTarget() {
        return this.ecoreResource;
    }

    public void setTarget(Notifier newTarget) {
        this.ecoreResource = (Resource)newTarget;
    }
}

