/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.oclinecore.resource;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreSwitch;
import org.eclipse.emf.ecore.xmi.XMIException;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.ocl.examples.common.utils.StringUtils;
import org.eclipse.ocl.examples.xtext.base.baseCST.AnnotationElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.AttributeCSRef;
import org.eclipse.ocl.examples.xtext.base.baseCST.BaseCSTPackage;
import org.eclipse.ocl.examples.xtext.base.baseCST.DetailCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.EnumLiteralCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ModelElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ModelElementCSRef;
import org.eclipse.ocl.examples.xtext.base.baseCST.NamedElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ParameterCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.PrimitiveTypeRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.QualifiedTypeRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ReferenceCSRef;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypeCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypeParameterCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypedElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypedRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypedTypeRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.WildcardTypeRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.util.BaseCSTSwitch;
import org.eclipse.ocl.examples.xtext.base.util.ElementUtil;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.ExpCS;
import org.eclipse.ocl.examples.xtext.oclinecore.oclinEcoreCST.AnnotationCS;
import org.eclipse.ocl.examples.xtext.oclinecore.oclinEcoreCST.ConstraintCS;
import org.eclipse.ocl.examples.xtext.oclinecore.oclinEcoreCST.DataTypeCS;
import org.eclipse.ocl.examples.xtext.oclinecore.oclinEcoreCST.DataTypeOrEnumCS;
import org.eclipse.ocl.examples.xtext.oclinecore.oclinEcoreCST.DocumentationCS;
import org.eclipse.ocl.examples.xtext.oclinecore.oclinEcoreCST.EnumCS;
import org.eclipse.ocl.examples.xtext.oclinecore.oclinEcoreCST.OCLinEcoreAttributeCS;
import org.eclipse.ocl.examples.xtext.oclinecore.oclinEcoreCST.OCLinEcoreCSTPackage;
import org.eclipse.ocl.examples.xtext.oclinecore.oclinEcoreCST.OCLinEcoreClassCS;
import org.eclipse.ocl.examples.xtext.oclinecore.oclinEcoreCST.OCLinEcoreClassifierCS;
import org.eclipse.ocl.examples.xtext.oclinecore.oclinEcoreCST.OCLinEcoreDocumentCS;
import org.eclipse.ocl.examples.xtext.oclinecore.oclinEcoreCST.OCLinEcoreOperationCS;
import org.eclipse.ocl.examples.xtext.oclinecore.oclinEcoreCST.OCLinEcorePackageCS;
import org.eclipse.ocl.examples.xtext.oclinecore.oclinEcoreCST.OCLinEcoreReferenceCS;
import org.eclipse.ocl.examples.xtext.oclinecore.oclinEcoreCST.OCLinEcoreStructuralFeatureCS;
import org.eclipse.ocl.examples.xtext.oclinecore.oclinEcoreCST.util.OCLinEcoreCSTSwitch;
import org.eclipse.ocl.examples.xtext.oclinecore.resource.AbstractConversion;
import org.eclipse.xtext.parsetree.CompositeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCLinEcore2Ecore
extends AbstractConversion {
    private Map<ModelElementCS, EObject> createMap = new HashMap<ModelElementCS, EObject>();
    private Map<EObject, ModelElementCS> deferMap = new HashMap<EObject, ModelElementCS>();
    private List<Resource.Diagnostic> errors = null;
    protected final OCLinEcoreCSTSwitch<EObject> pass1 = new OCLinEcoreCSTSwitch<EObject>(){
        protected final BaseCSTSwitch<EObject> emofPass1 = new BaseCSTSwitch<EObject>(){

            public EObject caseEnumLiteralCS(EnumLiteralCS csEnumLiteral) {
                EEnumLiteral eEnumLiteral = EcoreFactory.eINSTANCE.createEEnumLiteral();
                this.setMapping((ModelElementCS)csEnumLiteral, (EModelElement)eEnumLiteral);
                for (AnnotationElementCS csAnnotation : csEnumLiteral.getAnnotations()) {
                    if (csAnnotation instanceof AnnotationCS && "http://www.eclipse.org/emf/2002/Ecore".equals(((AnnotationCS)csAnnotation).getIdSource())) {
                        for (DetailCS csDetail : ((AnnotationCS)csAnnotation).getDetails()) {
                            String name = csDetail.getIdName();
                            if ("literal".equals(name)) {
                                eEnumLiteral.setLiteral(StringUtils.splice((List)csDetail.getValue(), (String)""));
                                continue;
                            }
                            OCLinEcore2Ecore.this.error("Unsupported namespace detail " + name + " in pass1");
                        }
                        continue;
                    }
                    EAnnotation eObject = (EAnnotation)this.doSwitch((EObject)csAnnotation);
                    eEnumLiteral.getEAnnotations().add((Object)eObject);
                }
                eEnumLiteral.setName(csEnumLiteral.getName());
                eEnumLiteral.setValue(csEnumLiteral.getValue());
                return eEnumLiteral;
            }

            public EParameter caseParameterCS(ParameterCS csParameter) {
                EParameter eParameter = EcoreFactory.eINSTANCE.createEParameter();
                this.copyTypedElement((ETypedElement)eParameter, (TypedElementCS)csParameter);
                return eParameter;
            }

            public EObject caseQualifiedTypeRefCS(QualifiedTypeRefCS csQualifiedTypeRef) {
                return (EObject)this.doSwitch((EObject)csQualifiedTypeRef.getElement());
            }

            public EObject caseTypeParameterCS(TypeParameterCS csTypeParameter) {
                ETypeParameter eTypeParameter = EcoreFactory.eINSTANCE.createETypeParameter();
                this.copyNamedElement((ENamedElement)eTypeParameter, (NamedElementCS)csTypeParameter);
                this.doSwitchAll(eTypeParameter.getEAnnotations(), (EList<? extends ModelElementCS>)csTypeParameter.getAnnotations());
                this.doSwitchAll(eTypeParameter.getEBounds(), (EList<? extends ModelElementCS>)csTypeParameter.getExtends());
                return eTypeParameter;
            }

            public EGenericType caseTypedTypeRefCS(TypedTypeRefCS csTypeRef) {
                EGenericType eGenericType = EcoreFactory.eINSTANCE.createEGenericType();
                OCLinEcore2Ecore.this.deferMap.put(eGenericType, csTypeRef);
                this.doSwitchAll(eGenericType.getETypeArguments(), (EList<? extends ModelElementCS>)csTypeRef.getTypeArguments());
                return eGenericType;
            }

            public EGenericType caseWildcardTypeRefCS(WildcardTypeRefCS csTypeRef) {
                EGenericType eGenericType = EcoreFactory.eINSTANCE.createEGenericType();
                return eGenericType;
            }
        };

        @Override
        public EObject caseAnnotationCS(AnnotationCS csAnnotation) {
            EAnnotation eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            this.copyDetails(eAnnotation, csAnnotation);
            String source = csAnnotation.getIdSource();
            if (source == null) {
                source = csAnnotation.getStringSource();
            }
            eAnnotation.setSource(source);
            this.doSwitchAll((List)eAnnotation.getContents(), (EList<? extends ModelElementCS>)csAnnotation.getContents());
            if (!csAnnotation.getReferences().isEmpty()) {
                OCLinEcore2Ecore.this.deferMap.put(eAnnotation, csAnnotation);
            }
            return eAnnotation;
        }

        @Override
        public EObject caseConstraintCS(ConstraintCS csConstraint) {
            ExpCS exprValue = csConstraint.getExprValue();
            String exprString = null;
            if (exprValue == null) {
                exprString = csConstraint.getExprString();
            } else {
                CompositeNode parserNode = ElementUtil.getParserNode((EObject)exprValue);
                if (parserNode != null) {
                    exprString = parserNode.serialize();
                    int i = 0;
                    while (i < exprString.length()) {
                        if (exprString.charAt(i) != ' ') {
                            exprString = exprString.substring(i);
                            break;
                        }
                        ++i;
                    }
                }
            }
            if (exprString == null) {
                return csConstraint;
            }
            EAnnotation oclAnnotation = this.getOCLAnnotation(csConstraint);
            String stereotype = csConstraint.getStereotype();
            String name = csConstraint.getName();
            if ("invariant".equals(stereotype)) {
                oclAnnotation.getDetails().put((Object)name, (Object)exprString);
            } else if ("derivation".equals(stereotype)) {
                oclAnnotation.getDetails().put((Object)"derivation", (Object)exprString);
            } else if ("initial".equals(stereotype)) {
                oclAnnotation.getDetails().put((Object)"initial", (Object)exprString);
            } else if ("body".equals(stereotype)) {
                String key = name != null ? "body_" + name : "body";
                oclAnnotation.getDetails().put((Object)key, (Object)exprString);
            } else if ("precondition".equals(stereotype)) {
                oclAnnotation.getDetails().put((Object)("pre_" + name), (Object)exprString);
            } else if ("postcondition".equals(stereotype)) {
                oclAnnotation.getDetails().put((Object)("post_" + name), (Object)exprString);
            } else {
                OCLinEcore2Ecore.this.error("Unsupported " + csConstraint);
            }
            return csConstraint;
        }

        @Override
        public EObject caseDataTypeCS(DataTypeCS csDataType) {
            EDataType eDataType = EcoreFactory.eINSTANCE.createEDataType();
            this.copyDataTypeOrEnum(eDataType, csDataType);
            return eDataType;
        }

        @Override
        public EObject caseDocumentationCS(DocumentationCS csDocumentation) {
            EAnnotation eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            this.copyDetails(eAnnotation, csDocumentation);
            eAnnotation.setSource("http://www.eclipse.org/emf/2002/GenModel");
            String documentation = OCLinEcore2Ecore.basicGet((EObject)csDocumentation, OCLinEcoreCSTPackage.Literals.DOCUMENTATION_CS__VALUE, String.class);
            if (documentation != null) {
                eAnnotation.getDetails().put((Object)"documentation", (Object)documentation);
            }
            return eAnnotation;
        }

        @Override
        public EObject caseEnumCS(EnumCS csEnum) {
            EEnum eEnum = EcoreFactory.eINSTANCE.createEEnum();
            this.copyDataTypeOrEnum((EDataType)eEnum, csEnum);
            this.doSwitchAll((List)eEnum.getELiterals(), (EList<? extends ModelElementCS>)csEnum.getLiterals());
            return eEnum;
        }

        @Override
        public EObject caseOCLinEcoreAttributeCS(OCLinEcoreAttributeCS csAttribute) {
            EAttribute eAttribute = EcoreFactory.eINSTANCE.createEAttribute();
            this.copyStructuralFeature((EStructuralFeature)eAttribute, csAttribute);
            EList qualifiers = csAttribute.getQualifiers();
            this.setAttribute((EObject)eAttribute, EcorePackage.Literals.EATTRIBUTE__ID, (List<String>)qualifiers, "id", "!id");
            return eAttribute;
        }

        @Override
        public EObject caseOCLinEcoreClassCS(OCLinEcoreClassCS csClass) {
            EClass eClass = EcoreFactory.eINSTANCE.createEClass();
            this.copyClassifier((EClassifier)eClass, csClass);
            EList<String> qualifiers = csClass.getQualifiers();
            this.setAttribute((EObject)eClass, EcorePackage.Literals.ECLASS__ABSTRACT, (List<String>)qualifiers, "abstract", "!abstract");
            this.setAttribute((EObject)eClass, EcorePackage.Literals.ECLASS__INTERFACE, (List<String>)qualifiers, "interface", "!interface");
            OCLinEcore2Ecore.this.deferMap.put(eClass, csClass);
            this.doSwitchAll((List)eClass.getEGenericSuperTypes(), (EList<? extends ModelElementCS>)csClass.getSuperTypes());
            this.doSwitchAll((List)eClass.getEOperations(), (EList<? extends ModelElementCS>)csClass.getOperations());
            this.doSwitchAll((List)eClass.getEStructuralFeatures(), (EList<? extends ModelElementCS>)csClass.getStructuralFeatures());
            return eClass;
        }

        @Override
        public EObject caseOCLinEcoreOperationCS(OCLinEcoreOperationCS csOperation) {
            EOperation eOperation = EcoreFactory.eINSTANCE.createEOperation();
            this.copyTypedElement((ETypedElement)eOperation, (TypedElementCS)csOperation);
            this.doSwitchAll((List)eOperation.getEParameters(), (EList<? extends ModelElementCS>)csOperation.getParameters());
            this.doSwitchAll((List)eOperation.getETypeParameters(), (EList<? extends ModelElementCS>)csOperation.getTypeParameters());
            this.doSwitchAll((List)eOperation.getEGenericExceptions(), (EList<? extends ModelElementCS>)csOperation.getExceptions());
            for (ConstraintCS csConstraint : csOperation.getConstraints()) {
                this.doSwitch((EObject)csConstraint);
            }
            return eOperation;
        }

        @Override
        public EObject caseOCLinEcorePackageCS(OCLinEcorePackageCS csPackage) {
            EPackage ePackage = EcoreFactory.eINSTANCE.createEPackage();
            this.copyNamedElement((ENamedElement)ePackage, (NamedElementCS)csPackage);
            this.doSwitchAll((List)ePackage.getEAnnotations(), (EList<? extends ModelElementCS>)csPackage.getAnnotations());
            OCLinEcore2Ecore.this.deferMap.put(ePackage, csPackage);
            String prefix = OCLinEcore2Ecore.basicGet((EObject)csPackage, BaseCSTPackage.Literals.PACKAGE_CS__PREFIX, String.class);
            String uri = OCLinEcore2Ecore.basicGet((EObject)csPackage, BaseCSTPackage.Literals.PACKAGE_CS__URI, String.class);
            if (prefix != null && uri != null) {
                ePackage.setNsPrefix(prefix);
                ePackage.setNsURI(uri);
            }
            this.doSwitchAll((List)ePackage.getESubpackages(), (EList<? extends ModelElementCS>)csPackage.getSubpackages());
            this.doSwitchAll((List)ePackage.getEClassifiers(), (EList<? extends ModelElementCS>)csPackage.getClassifiers());
            return ePackage;
        }

        @Override
        public EReference caseOCLinEcoreReferenceCS(OCLinEcoreReferenceCS csReference) {
            EReference eReference = EcoreFactory.eINSTANCE.createEReference();
            this.copyStructuralFeature((EStructuralFeature)eReference, csReference);
            if (csReference.getOpposite() != null || !csReference.getKeys().isEmpty()) {
                OCLinEcore2Ecore.this.deferMap.put(eReference, csReference);
            }
            EList qualifiers = csReference.getQualifiers();
            this.setAttribute((EObject)eReference, EcorePackage.Literals.EREFERENCE__CONTAINMENT, (List<String>)qualifiers, "composes", "!composes");
            this.setAttribute((EObject)eReference, EcorePackage.Literals.EREFERENCE__RESOLVE_PROXIES, (List<String>)qualifiers, "resolve", "!resolve");
            return eReference;
        }

        protected void copyClassifier(EClassifier eClassifier, OCLinEcoreClassifierCS csClassifier) {
            this.copyNamedElement((ENamedElement)eClassifier, (NamedElementCS)csClassifier);
            this.doSwitchAll((List)eClassifier.getEAnnotations(), (EList<? extends ModelElementCS>)csClassifier.getAnnotations());
            if (csClassifier.eIsSet((EStructuralFeature)OCLinEcoreCSTPackage.Literals.OC_LIN_ECORE_CLASSIFIER_CS__INSTANCE_CLASS_NAME)) {
                eClassifier.setInstanceClassName(csClassifier.getInstanceClassName());
            }
            this.doSwitchAll((List)eClassifier.getETypeParameters(), (EList<? extends ModelElementCS>)csClassifier.getTypeParameters());
            StringBuffer s = null;
            for (ConstraintCS csConstraint : csClassifier.getConstraints()) {
                this.doSwitch((EObject)csConstraint);
                if (s == null) {
                    s = new StringBuffer();
                } else {
                    s.append(" ");
                }
                s.append(csConstraint.getName());
            }
            EAnnotation eAnnotation = eClassifier.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore");
            if (s != null) {
                if (eAnnotation == null) {
                    eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
                    eAnnotation.setSource("http://www.eclipse.org/emf/2002/Ecore");
                    eClassifier.getEAnnotations().add(0, (Object)eAnnotation);
                }
                eAnnotation.getDetails().put((Object)"constraints", (Object)s.toString());
            } else {
                eClassifier.getEAnnotations().remove((Object)eAnnotation);
            }
        }

        protected void copyDataTypeOrEnum(EDataType eDataType, DataTypeOrEnumCS csDataType) {
            this.copyClassifier((EClassifier)eDataType, csDataType);
            EList<String> qualifiers = csDataType.getQualifiers();
            this.setAttribute((EObject)eDataType, EcorePackage.Literals.EDATA_TYPE__SERIALIZABLE, (List<String>)qualifiers, "serializable", "!serializable");
        }

        protected void copyDetails(EAnnotation eAnnotation, AnnotationElementCS csAnnotationElement) {
            this.copyModelElement((EModelElement)eAnnotation, (ModelElementCS)csAnnotationElement);
            this.doSwitchAll((List)eAnnotation.getEAnnotations(), (EList<? extends ModelElementCS>)csAnnotationElement.getAnnotations());
            for (DetailCS csDetail : csAnnotationElement.getDetails()) {
                String name = csDetail.getIdName();
                if (name == null) {
                    name = csDetail.getStringName();
                }
                eAnnotation.getDetails().put((Object)name, (Object)StringUtils.splice((List)csDetail.getValue(), (String)""));
            }
        }

        protected void copyModelElement(EModelElement eModelElement, ModelElementCS csModelElement) {
            this.setMapping(csModelElement, eModelElement);
        }

        protected void copyNamedElement(ENamedElement eNamedElement, NamedElementCS csNamedElement) {
            this.copyModelElement((EModelElement)eNamedElement, (ModelElementCS)csNamedElement);
            eNamedElement.setName(csNamedElement.getName());
        }

        protected void copyStructuralFeature(EStructuralFeature eStructuralFeature, OCLinEcoreStructuralFeatureCS csStructuralFeature) {
            this.copyTypedElement((ETypedElement)eStructuralFeature, (TypedElementCS)csStructuralFeature);
            EList qualifiers = csStructuralFeature.getQualifiers();
            this.setAttribute((EObject)eStructuralFeature, EcorePackage.Literals.ESTRUCTURAL_FEATURE__DERIVED, (List<String>)qualifiers, "derived", "!derived");
            this.setAttribute((EObject)eStructuralFeature, EcorePackage.Literals.ESTRUCTURAL_FEATURE__CHANGEABLE, (List<String>)qualifiers, "!readonly", "readonly");
            this.setAttribute((EObject)eStructuralFeature, EcorePackage.Literals.ESTRUCTURAL_FEATURE__TRANSIENT, (List<String>)qualifiers, "transient", "!transient");
            this.setAttribute((EObject)eStructuralFeature, EcorePackage.Literals.ESTRUCTURAL_FEATURE__UNSETTABLE, (List<String>)qualifiers, "unsettable", "!unsettable");
            this.setAttribute((EObject)eStructuralFeature, EcorePackage.Literals.ESTRUCTURAL_FEATURE__VOLATILE, (List<String>)qualifiers, "volatile", "!volatile");
            if (csStructuralFeature.eIsSet((EStructuralFeature)OCLinEcoreCSTPackage.Literals.OC_LIN_ECORE_STRUCTURAL_FEATURE_CS__DEFAULT_VALUE_LITERAL)) {
                eStructuralFeature.setDefaultValueLiteral(csStructuralFeature.getDefaultValueLiteral());
            }
            for (ConstraintCS csConstraint : csStructuralFeature.getConstraints()) {
                this.doSwitch((EObject)csConstraint);
            }
        }

        protected void copyTypedElement(ETypedElement eTypedElement, TypedElementCS csTypedElement) {
            String multiplicity;
            this.copyNamedElement((ENamedElement)eTypedElement, (NamedElementCS)csTypedElement);
            this.doSwitchAll((List)eTypedElement.getEAnnotations(), (EList<? extends ModelElementCS>)csTypedElement.getAnnotations());
            TypedRefCS type = csTypedElement.getType();
            if (type != null) {
                if (type instanceof PrimitiveTypeRefCS) {
                    String name = ((PrimitiveTypeRefCS)type).getName();
                    if ("Boolean".equals(name)) {
                        eTypedElement.setEType((EClassifier)EcorePackage.Literals.EBOOLEAN);
                    } else if ("Integer".equals(name)) {
                        eTypedElement.setEType((EClassifier)EcorePackage.Literals.EBIG_INTEGER);
                    } else if ("Real".equals(name)) {
                        eTypedElement.setEType((EClassifier)EcorePackage.Literals.EBIG_DECIMAL);
                    } else if ("String".equals(name)) {
                        eTypedElement.setEType((EClassifier)EcorePackage.Literals.ESTRING);
                    } else if ("UnlimitedNatural".equals(name)) {
                        eTypedElement.setEType((EClassifier)EcorePackage.Literals.EBIG_INTEGER);
                    } else {
                        OCLinEcore2Ecore.this.error("Unsupported primitive type '" + name + "' in pass1");
                    }
                } else {
                    eTypedElement.setEGenericType((EGenericType)this.doSwitch((EObject)type));
                }
            }
            if ((multiplicity = csTypedElement.getMultiplicity()) != null) {
                if ("?".equals(multiplicity)) {
                    eTypedElement.setLowerBound(0);
                    eTypedElement.setUpperBound(1);
                } else if ("*".equals(multiplicity)) {
                    eTypedElement.setLowerBound(0);
                    eTypedElement.setUpperBound(-1);
                } else if ("+".equals(multiplicity)) {
                    eTypedElement.setLowerBound(1);
                    eTypedElement.setUpperBound(-1);
                } else {
                    OCLinEcore2Ecore.this.error("Unsupported multiplicity " + multiplicity + " in pass1");
                }
            } else {
                int lower = csTypedElement.getLower();
                eTypedElement.setLowerBound(lower);
                if (!csTypedElement.eIsSet((EStructuralFeature)BaseCSTPackage.Literals.TYPED_ELEMENT_CS__UPPER)) {
                    eTypedElement.setUpperBound(lower != 0 ? lower : 1);
                } else {
                    eTypedElement.setUpperBound(csTypedElement.getUpper());
                }
            }
            EList qualifiers = csTypedElement.getQualifiers();
            this.setAttribute((EObject)eTypedElement, EcorePackage.Literals.ETYPED_ELEMENT__ORDERED, (List<String>)qualifiers, "ordered", "!ordered");
            this.setAttribute((EObject)eTypedElement, EcorePackage.Literals.ETYPED_ELEMENT__UNIQUE, (List<String>)qualifiers, "unique", "!unique");
        }

        @Override
        public EObject defaultCase(EObject object) {
            OCLinEcore2Ecore.this.error("Unsupported " + object + " in pass1");
            this.doSwitch(object);
            return null;
        }

        @Override
        public EObject doSwitch(EObject eObject) {
            EPackage ePackage = eObject.eClass().getEPackage();
            if (ePackage == BaseCSTPackage.eINSTANCE) {
                return (EObject)this.emofPass1.doSwitch(eObject);
            }
            return (EObject)super.doSwitch(eObject);
        }

        public <T extends EObject> void doSwitchAll(List<T> eObjects, EList<? extends ModelElementCS> csObjects) {
            for (EObject csObject : csObjects) {
                EObject eObject = this.doSwitch(csObject);
                if (eObject == null) continue;
                eObjects.add(eObject);
            }
        }

        protected EAnnotation getOCLAnnotation(ConstraintCS csConstraint) {
            ModelElementCS csModelElement = (ModelElementCS)csConstraint.eContainer();
            EModelElement eModelElement = (EModelElement)OCLinEcore2Ecore.this.createMap.get(csModelElement);
            EAnnotation oclAnnotation = eModelElement.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore/OCL");
            if (oclAnnotation == null) {
                oclAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
                oclAnnotation.setSource("http://www.eclipse.org/emf/2002/Ecore/OCL");
                eModelElement.getEAnnotations().add((Object)oclAnnotation);
            }
            return oclAnnotation;
        }

        protected void setAttribute(EObject eObject, EAttribute eAttribute, List<String> qualifiers, String trueName, String falseName) {
            boolean isTrue = qualifiers.contains(trueName);
            boolean isFalse = qualifiers.contains(falseName);
            if (isTrue && isFalse) {
                OCLinEcore2Ecore.this.error("Conflicting " + trueName + " and " + falseName);
            } else if (isTrue || isFalse) {
                eObject.eSet((EStructuralFeature)eAttribute, (Object)isTrue);
            }
        }

        protected void setMapping(ModelElementCS csModelElement, EModelElement eModelElement) {
            OCLinEcore2Ecore.this.createMap.put(csModelElement, eModelElement);
            String originalXmiId = csModelElement.getOriginalXmiId();
            if (originalXmiId != null) {
                OCLinEcore2Ecore.this.eResource.setID((EObject)eModelElement, originalXmiId);
            }
        }
    };
    protected final EcoreSwitch<Object> pass2 = new EcoreSwitch<Object>(){

        public Object caseEAnnotation(EAnnotation eAnnotation) {
            AnnotationCS csAnnotation = (AnnotationCS)OCLinEcore2Ecore.this.deferMap.get(eAnnotation);
            for (ModelElementCSRef csReference : csAnnotation.getReferences()) {
                EObject eObject = (EObject)OCLinEcore2Ecore.this.createMap.get(csReference.getRef());
                if (eObject == null) continue;
                eAnnotation.getReferences().add((Object)eObject);
            }
            return null;
        }

        public Object caseEGenericType(EGenericType eGenericType) {
            TypedTypeRefCS csTypeRef = (TypedTypeRefCS)OCLinEcore2Ecore.this.deferMap.get(eGenericType);
            TypeCS typeRef = csTypeRef.getType();
            if (typeRef != null) {
                EModelElement eType = (EModelElement)OCLinEcore2Ecore.this.createMap.get(typeRef);
                if (eType == null) {
                    eGenericType.setEClassifier((EClassifier)((ModelElementCS)typeRef).getOriginalObject());
                } else if (eType instanceof EClassifier) {
                    eGenericType.setEClassifier((EClassifier)eType);
                } else if (eType instanceof ETypeParameter) {
                    eGenericType.setETypeParameter((ETypeParameter)eType);
                }
            }
            return null;
        }

        public Object caseEPackage(EPackage ePackage) {
            boolean needsDelegates = false;
            for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                EAnnotation classifierAnnotation = eClassifier.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore/OCL");
                if (classifierAnnotation != null && !classifierAnnotation.getDetails().isEmpty()) {
                    needsDelegates = true;
                    break;
                }
                if (!(eClassifier instanceof EClass)) continue;
                EClass eClass = (EClass)eClassifier;
                for (EStructuralFeature eFeature : eClass.getEStructuralFeatures()) {
                    EAnnotation featureAnnotation = eFeature.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore/OCL");
                    if (featureAnnotation == null || featureAnnotation.getDetails().isEmpty()) continue;
                    needsDelegates = true;
                    break;
                }
                if (needsDelegates) break;
                for (EOperation eOperation : eClass.getEOperations()) {
                    EAnnotation operationAnnotation = eOperation.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore/OCL");
                    if (operationAnnotation == null || operationAnnotation.getDetails().isEmpty()) continue;
                    needsDelegates = true;
                    break;
                }
                if (needsDelegates) break;
            }
            if (needsDelegates) {
                EAnnotation packageAnnotation = ePackage.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore");
                if (packageAnnotation == null) {
                    packageAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
                    packageAnnotation.setSource("http://www.eclipse.org/emf/2002/Ecore");
                    ePackage.getEAnnotations().add((Object)packageAnnotation);
                }
                EMap details = packageAnnotation.getDetails();
                details.put((Object)"invocationDelegates", (Object)"http://www.eclipse.org/emf/2002/Ecore/OCL");
                details.put((Object)"settingDelegates", (Object)"http://www.eclipse.org/emf/2002/Ecore/OCL");
                details.put((Object)"validationDelegates", (Object)"http://www.eclipse.org/emf/2002/Ecore/OCL");
            }
            return null;
        }

        public Object caseEReference(EReference eReference) {
            EReference eOpposite;
            OCLinEcoreReferenceCS csReference = (OCLinEcoreReferenceCS)OCLinEcore2Ecore.this.deferMap.get(eReference);
            ReferenceCSRef csOpposite = csReference.getOpposite();
            if (csOpposite != null && (eOpposite = (EReference)OCLinEcore2Ecore.this.createMap.get(csOpposite.getRef())) != null) {
                eReference.setEOpposite(eOpposite);
            }
            for (AttributeCSRef csKey : csReference.getKeys()) {
                EAttribute eAttribute = (EAttribute)OCLinEcore2Ecore.this.createMap.get(csKey.getRef());
                if (eAttribute == null) continue;
                eReference.getEKeys().add((Object)eAttribute);
            }
            return null;
        }

        public Object caseETypeParameter(ETypeParameter eTypeParameter) {
            TypeParameterCS cfr_ignored_0 = (TypeParameterCS)OCLinEcore2Ecore.this.deferMap.get(eTypeParameter);
            return null;
        }
    };
    protected final Resource csResource;
    protected final XMLResource eResource;

    public OCLinEcore2Ecore(ResourceSet resourceSet, Resource csResource, URI ecoreURI) {
        super(resourceSet);
        this.csResource = csResource;
        this.eResource = (XMLResource)new EcoreResourceFactoryImpl().createResource(ecoreURI);
    }

    protected EObject convert(EObject csObject) {
        EObject eObject = this.pass1.doSwitch(csObject);
        for (EObject eKey : this.deferMap.keySet()) {
            this.pass2.doSwitch(eKey);
        }
        return eObject;
    }

    protected List<EObject> convertAll(List<? extends EObject> csObjects) {
        ArrayList<EObject> eObjects = new ArrayList<EObject>();
        for (EObject eObject : csObjects) {
            eObjects.add(this.pass1.doSwitch(eObject));
        }
        for (EObject eObject : this.deferMap.keySet()) {
            this.pass2.doSwitch(eObject);
        }
        return eObjects;
    }

    protected void error(String message) {
        if (this.errors == null) {
            this.errors = new ArrayList<Resource.Diagnostic>();
        }
        this.errors.add((Resource.Diagnostic)new XMIException(message));
    }

    public XMLResource exportToEcore() {
        OCLinEcoreDocumentCS document = (OCLinEcoreDocumentCS)this.csResource.getContents().get(0);
        List<EObject> ecoreContents = this.convertAll((List<? extends EObject>)document.getPackages());
        this.eResource.getContents().addAll(ecoreContents);
        if (this.errors != null) {
            this.eResource.getErrors().addAll(this.errors);
        }
        return this.eResource;
    }
}

