/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.oclinecore.services;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.ocl.examples.xtext.base.baseCST.BaseCSTPackage;
import org.eclipse.ocl.examples.xtext.base.baseCST.ImportCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ModelElementCSRef;
import org.eclipse.ocl.examples.xtext.base.baseCST.NamedElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.PackageCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ReferenceCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ReferenceCSRef;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypedTypeRefCS;
import org.eclipse.ocl.examples.xtext.base.scope.AbstractScopeAdapter;
import org.eclipse.ocl.examples.xtext.base.scope.DocumentScopeAdapter;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.linking.ILinkingService;
import org.eclipse.xtext.linking.impl.LinkingHelper;
import org.eclipse.xtext.parsetree.AbstractNode;
import org.eclipse.xtext.parsetree.reconstr.impl.CrossReferenceSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCLinEcoreCrossReferenceSerializer
extends CrossReferenceSerializer {
    @Inject
    private LinkingHelper linkingHelper;
    @Inject
    private ILinkingService linkingService;
    @Inject
    private IValueConverterService valueConverter;

    protected String getConvertedLinkText(EObject object, EReference reference, EObject context) {
        if (reference == BaseCSTPackage.Literals.TYPED_TYPE_REF_CS__TYPE && context instanceof TypedTypeRefCS) {
            DocumentScopeAdapter documentScopeAdapter = AbstractScopeAdapter.getDocumentScopeAdapter((EObject)context);
            List<PathElement> contextPath = this.getPath(documentScopeAdapter, context);
            List<PathElement> objectPath = this.getPath(documentScopeAdapter, object);
            return this.getDivergentPath(objectPath, contextPath);
        }
        return null;
    }

    private String getDivergentPath(List<PathElement> objectPath, List<PathElement> contextPath) {
        int i = 0;
        int iSize = objectPath.size();
        int iMax = Math.min(iSize, contextPath.size());
        while (i < iMax) {
            EObject objectElement = objectPath.get((int)i).element;
            EObject contextElement = contextPath.get((int)i).element;
            if (!objectElement.equals(contextElement)) break;
            ++i;
        }
        StringBuffer s = new StringBuffer();
        while (i < iSize - 1) {
            s.append(this.valueConverter.toString((Object)objectPath.get((int)i).name, "ID"));
            s.append("::");
            ++i;
        }
        if (iSize > 0) {
            s.append(this.valueConverter.toString((Object)objectPath.get((int)(iSize - 1)).name, "ID"));
        }
        return s.toString();
    }

    private List<PathElement> getPath(DocumentScopeAdapter documentScopeAdapter, EObject eObject) {
        String alias;
        if (eObject instanceof PackageCS && (alias = documentScopeAdapter.getAlias((PackageCS)eObject)) != null) {
            ArrayList<PathElement> result = new ArrayList<PathElement>();
            result.add(new PathElement(alias, eObject));
            return result;
        }
        EObject eContainer = eObject.eContainer();
        if (eContainer == null) {
            return new ArrayList<PathElement>();
        }
        List<PathElement> result = this.getPath(documentScopeAdapter, eContainer);
        if (eObject instanceof ENamedElement) {
            result.add(new PathElement(((ENamedElement)eObject).getName(), eObject));
        } else if (eObject instanceof NamedElementCS) {
            result.add(new PathElement(((NamedElementCS)eObject).getName(), eObject));
        }
        return result;
    }

    protected String getUnconvertedLinkText(EObject object, EReference reference, EObject context) {
        if (reference == BaseCSTPackage.Literals.IMPORT_CS__NAMESPACE && context instanceof ImportCS) {
            return ((ImportCS)context).getUri();
        }
        if (reference == BaseCSTPackage.Literals.REFERENCE_CS_REF__REF && context instanceof ReferenceCSRef) {
            return ((ReferenceCS)object).getName();
        }
        if (reference == BaseCSTPackage.Literals.MODEL_ELEMENT_CS_REF__REF && context instanceof ModelElementCSRef) {
            return ((NamedElementCS)object).getName();
        }
        return super.getUnconvertedLinkText(object, reference, context);
    }

    public String serializeCrossRef(EObject context, CrossReference grammarElement, EObject target, AbstractNode node) {
        List objects;
        EReference ref = GrammarUtil.getReference((CrossReference)grammarElement, (EClass)context.eClass());
        String text = null;
        if (node != null && (objects = this.linkingService.getLinkedObjects(context, ref, node)).contains(target)) {
            return "<KEEP_VALUE_FROM_NODE_MODEL>";
        }
        text = this.getConvertedLinkText(target, ref, context);
        if (text != null) {
            return text;
        }
        text = this.getUnconvertedLinkText(target, ref, context);
        if (text != null) {
            return this.getConvertedValue(text, grammarElement);
        }
        if (node != null) {
            return this.linkingHelper.getCrossRefNodeAsString(node, false);
        }
        return null;
    }

    private class PathElement {
        public final String name;
        public final EObject element;

        public PathElement(String name, EObject element) {
            this.name = name;
            this.element = element;
        }
    }
}

