/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.oclinecore.services;

import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.ocl.examples.xtext.base.baseCST.BaseCSTPackage;
import org.eclipse.ocl.examples.xtext.base.baseCST.ElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ImportCS;
import org.eclipse.ocl.examples.xtext.base.scope.ScopeAdapter;
import org.eclipse.ocl.examples.xtext.base.scoping.ImportScopeAdapter;
import org.eclipse.ocl.examples.xtext.base.util.ElementUtil;
import org.eclipse.ocl.examples.xtext.oclinecore.resource.Ecore2OCLinEcore;
import org.eclipse.ocl.examples.xtext.oclstdlib.services.OCLstdlibLinkingService;
import org.eclipse.xtext.linking.impl.IllegalNodeException;
import org.eclipse.xtext.parsetree.AbstractNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCLinEcoreLinkingService
extends OCLstdlibLinkingService {
    private static final Logger log = Logger.getLogger(OCLinEcoreLinkingService.class);

    public List<EObject> getLinkedObjects(EObject context, EReference ref, AbstractNode node) throws IllegalNodeException {
        if (ref == BaseCSTPackage.Literals.IMPORT_CS__NAMESPACE && context instanceof ImportCS) {
            return this.getLinkedImport(context, node);
        }
        return super.getLinkedObjects(context, ref, node);
    }

    private List<EObject> getLinkedImport(EObject context, AbstractNode node) {
        ScopeAdapter scopeAdapter = ElementUtil.getScopeAdapter((EObject)context);
        String text = this.getText(node);
        if (scopeAdapter instanceof ImportScopeAdapter && text != null) {
            EObject importedElement;
            ImportScopeAdapter importScopeAdapter;
            URI oldURI;
            Resource eResource = context.eResource();
            URI uri = URI.createURI((String)text);
            if ((uri = uri.resolve(eResource.getURI())).equals((Object)(oldURI = (importScopeAdapter = (ImportScopeAdapter)scopeAdapter).getURI()))) {
                importedElement = importScopeAdapter.getImportedElement();
            } else {
                ResourceSet resourceSet = eResource.getResourceSet();
                importedElement = this.loadResource(uri, ((ImportCS)context).getName(), resourceSet);
                importScopeAdapter.setImportedElement(uri, importedElement);
            }
            if (importedElement != null) {
                return Collections.singletonList(importedElement);
            }
        }
        return Collections.emptyList();
    }

    private ElementCS loadResource(URI uri, String alias, ResourceSet resourceSet) {
        try {
            Resource resource = resourceSet.getResource(uri.trimFragment(), true);
            if (resource != null) {
                String fragment = uri.fragment();
                if (fragment == null) {
                    return Ecore2OCLinEcore.importFromEcore(resourceSet, alias, resource);
                }
                EObject eObject = resource.getEObject(fragment);
                if (eObject instanceof ElementCS) {
                    return (ElementCS)eObject;
                }
                return Ecore2OCLinEcore.importFromEcore(resourceSet, alias, eObject);
            }
            log.trace((Object)("Cannot load package with URI '" + uri + "'"));
            return null;
        }
        catch (RuntimeException ex) {
            log.trace((Object)("Cannot load package with URI '" + uri + "'"), (Throwable)ex);
            return null;
        }
    }
}

