/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.oclinecore.services;

import org.eclipse.ocl.examples.xtext.essentialocl.services.EssentialOCLValueConverterService;
import org.eclipse.xtext.conversion.IValueConverter;
import org.eclipse.xtext.conversion.ValueConverter;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.impl.AbstractNullSafeConverter;
import org.eclipse.xtext.parsetree.AbstractNode;
import org.eclipse.xtext.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCLinEcoreValueConverterService
extends EssentialOCLValueConverterService {
    @ValueConverter(rule="LOWER")
    public IValueConverter<Integer> LOWER() {
        return new AbstractNullSafeConverter<Integer>(){

            public Integer internalToValue(String string, AbstractNode node) {
                if (Strings.isEmpty((String)string)) {
                    throw new ValueConverterException("Couldn't convert empty string to integer", node, null);
                }
                try {
                    return Integer.valueOf(string);
                }
                catch (NumberFormatException e) {
                    throw new ValueConverterException("Couldn't convert '" + string + "' to integer", node, (Exception)e);
                }
            }

            public String internalToString(Integer value) {
                return value.toString();
            }
        };
    }

    @ValueConverter(rule="UNQUOTED_STRING")
    public IValueConverter<String> UNQUOTED_STRING() {
        return new AbstractNullSafeConverter<String>(){

            protected String internalToValue(String string, AbstractNode node) {
                try {
                    return Strings.convertFromJavaString((String)string.substring(1, string.length() - 1), (boolean)false);
                }
                catch (IllegalArgumentException e) {
                    throw new ValueConverterException(e.getMessage(), node, (Exception)e);
                }
            }

            protected String internalToString(String value) {
                return value;
            }
        };
    }

    @ValueConverter(rule="UPPER")
    public IValueConverter<Integer> UPPER() {
        return new AbstractNullSafeConverter<Integer>(){

            public Integer internalToValue(String string, AbstractNode node) {
                if (Strings.isEmpty((String)string)) {
                    throw new ValueConverterException("Couldn't convert empty string to integer", node, null);
                }
                try {
                    if ("*".equals(string)) {
                        return -1;
                    }
                    return Integer.valueOf(string);
                }
                catch (NumberFormatException e) {
                    throw new ValueConverterException("Couldn't convert '" + string + "' to integer", node, (Exception)e);
                }
            }

            public String internalToString(Integer value) {
                return value >= 0 ? value.toString() : "*";
            }
        };
    }
}

