/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.oclstdlib.ui.labeling;

import com.google.inject.Inject;
import java.net.URL;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ocl.examples.xtext.base.baseCST.AnnotationElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ClassCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ClassifierCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.CollectionTypeRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.DocumentCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.EnumLiteralCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ImportCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.NamedElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.OperationCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.PackageCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ParameterCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.PrimitiveTypeRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.QualifiedTypeRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.StructuralFeatureCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypeCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypeParameterCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypeRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypedElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypedRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypedTypeRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.WildcardTypeRefCS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.ui.label.DefaultEObjectLabelProvider;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseLabelProvider
extends DefaultEObjectLabelProvider {
    @Inject
    public BaseLabelProvider(AdapterFactoryLabelProvider delegate) {
        super(delegate);
    }

    protected void appendClass(StringBuffer s, Object object) {
        s.append("<");
        s.append(object != null ? object.getClass().getSimpleName() : "null");
        s.append(">");
    }

    protected void appendMultiplicity(StringBuffer s, TypedElementCS ele) {
        String multiplicity = ele.getMultiplicity();
        if (multiplicity != null) {
            s.append("[");
            s.append(multiplicity);
            s.append("]");
        } else {
            int lower = ele.getLower();
            int upper = ele.getUpper();
            if (lower != 1 || upper != 1) {
                s.append("[");
                if (upper < 0) {
                    if (lower == 1) {
                        s.append("+");
                    } else {
                        if (lower != 0) {
                            s.append(lower);
                            s.append("..");
                        }
                        s.append("*");
                    }
                } else if (lower == 0 && upper == 1) {
                    s.append("?");
                } else {
                    s.append(lower);
                    if (lower != upper) {
                        s.append("..");
                        s.append(upper);
                    }
                }
                s.append("]");
            }
        }
    }

    protected void appendName(StringBuffer s, NamedElementCS csElement) {
        if (csElement != null) {
            if (csElement.eIsProxy()) {
                EcoreUtil.resolve((EObject)csElement, (EObject)csElement);
            }
            this.appendString(s, csElement.getName());
        }
    }

    protected void appendOptionalName(StringBuffer s, NamedElementCS csElement) {
        if (csElement != null) {
            this.appendOptionalString(s, csElement.getName());
        }
    }

    protected void appendOptionalString(StringBuffer s, String string) {
        if (string != null) {
            s.append(string);
        }
    }

    protected void appendParameters(StringBuffer s, List<ParameterCS> parameters) {
        s.append("(");
        String prefix = "";
        for (ParameterCS csParameter : parameters) {
            s.append(prefix);
            this.appendType(s, (TypeRefCS)csParameter.getType());
            this.appendMultiplicity(s, (TypedElementCS)csParameter);
            prefix = ", ";
        }
        s.append(")");
    }

    protected void appendString(StringBuffer s, String string) {
        if (string != null) {
            s.append(string);
        } else {
            s.append("<null>");
        }
    }

    protected void appendSuperTypes(StringBuffer s, List<TypedRefCS> superTypes) {
        if (!superTypes.isEmpty()) {
            String prefix = " -> ";
            for (TypedRefCS superType : superTypes) {
                s.append(prefix);
                this.appendType(s, (TypeRefCS)superType);
                prefix = ", ";
            }
        }
    }

    protected void appendType(StringBuffer s, TypeRefCS type) {
        if (type instanceof PrimitiveTypeRefCS) {
            this.appendName(s, (NamedElementCS)((PrimitiveTypeRefCS)type));
        } else if (type instanceof CollectionTypeRefCS) {
            this.appendName(s, (NamedElementCS)((CollectionTypeRefCS)type));
            s.append("<");
            this.appendType(s, ((CollectionTypeRefCS)type).getTypeArguments());
            s.append(">");
        } else if (type instanceof QualifiedTypeRefCS) {
            this.appendType(s, (TypeRefCS)((QualifiedTypeRefCS)type).getElement());
        } else if (type instanceof TypedTypeRefCS) {
            this.appendType(s, ((TypedTypeRefCS)type).getType());
            EList typeArguments = ((TypedTypeRefCS)type).getTypeArguments();
            if (!typeArguments.isEmpty()) {
                s.append("<");
                String prefix = "";
                for (TypeRefCS typeArg : typeArguments) {
                    s.append(prefix);
                    this.appendType(s, typeArg);
                    prefix = ", ";
                }
                s.append(">");
            }
        } else if (type instanceof WildcardTypeRefCS) {
            s.append("?");
        }
    }

    protected void appendType(StringBuffer s, TypeCS type) {
        if (type instanceof NamedElementCS) {
            this.appendName(s, (NamedElementCS)type);
        } else if (type != null) {
            this.appendClass(s, type);
        }
    }

    protected void appendTypeParameters(StringBuffer s, List<TypeParameterCS> typeParameters) {
        if (!typeParameters.isEmpty()) {
            s.append("<");
            String prefix = "";
            for (TypeParameterCS typeParameter : typeParameters) {
                s.append(prefix);
                this.appendType(s, (TypeCS)typeParameter);
                prefix = ", ";
            }
            s.append(">");
        }
    }

    protected Image convertToImage(Object imageDescription) {
        String imageFile;
        Path path;
        URL imgUrl;
        String bundlePath;
        Bundle bundle;
        int index;
        String imagePath;
        if (imageDescription instanceof String && (imagePath = (String)imageDescription).startsWith("/") && (index = imagePath.indexOf(47, 1)) > 1 && (bundle = Platform.getBundle((String)(bundlePath = imagePath.substring(1, index)))) != null && (imgUrl = FileLocator.find((Bundle)bundle, (IPath)(path = new Path(imageFile = imagePath.substring(index + 1))), null)) != null) {
            return super.convertToImage((Object)ImageDescriptor.createFromURL((URL)imgUrl));
        }
        return super.convertToImage(imageDescription);
    }

    protected Object doGetText(Object element) {
        Object object = super.doGetText(element);
        if (object instanceof String) {
            String text = (String)object;
            int index = text.indexOf(10);
            if (index >= 0) {
                text = text.substring(0, index);
            }
            object = text.trim();
        }
        return object;
    }

    protected String text(ElementCS ele) {
        return "<" + ele.getClass().getSimpleName() + ">";
    }

    protected String image(AnnotationElementCS ele) {
        return "/org.eclipse.uml2.uml.edit/icons/full/obj16/Comment.gif";
    }

    protected String text(ClassCS ele) {
        StringBuffer s = new StringBuffer();
        this.appendName(s, (NamedElementCS)ele);
        this.appendTypeParameters(s, (List<TypeParameterCS>)ele.getTypeParameters());
        this.appendSuperTypes(s, (List<TypedRefCS>)ele.getSuperTypes());
        return s.toString();
    }

    protected String image(ClassifierCS ele) {
        return "/org.eclipse.uml2.uml.edit/icons/full/obj16/Class.gif";
    }

    protected String text(ClassifierCS ele) {
        StringBuffer s = new StringBuffer();
        this.appendName(s, (NamedElementCS)ele);
        this.appendTypeParameters(s, (List<TypeParameterCS>)ele.getTypeParameters());
        return s.toString();
    }

    protected String image(DocumentCS ele) {
        return "/org.eclipse.uml2.uml.edit/icons/full/obj16/Model.gif";
    }

    protected String image(EnumLiteralCS ele) {
        return "/org.eclipse.uml2.uml.edit/icons/full/obj16/EnumerationLiteral.gif";
    }

    protected String text(EnumLiteralCS ele) {
        return ele.getName();
    }

    protected String image(ImportCS ele) {
        return "/org.eclipse.uml2.uml.edit/icons/full/obj16/PackageImport.gif";
    }

    protected String text(ImportCS ele) {
        StringBuffer s = new StringBuffer();
        this.appendOptionalName(s, (NamedElementCS)ele);
        s.append(" : ");
        return s.toString();
    }

    protected String image(OperationCS ele) {
        return "/org.eclipse.uml2.uml.edit/icons/full/obj16/Operation.gif";
    }

    protected String text(OperationCS ele) {
        StringBuffer s = new StringBuffer();
        this.appendName(s, (NamedElementCS)ele);
        this.appendTypeParameters(s, (List<TypeParameterCS>)ele.getTypeParameters());
        this.appendParameters(s, (List<ParameterCS>)ele.getParameters());
        s.append(" : ");
        this.appendType(s, (TypeRefCS)ele.getType());
        this.appendMultiplicity(s, (TypedElementCS)ele);
        return s.toString();
    }

    protected String image(PackageCS ele) {
        return "/org.eclipse.uml2.uml.edit/icons/full/obj16/Package.gif";
    }

    protected String text(PackageCS ele) {
        return ele.getName();
    }

    protected String image(ParameterCS ele) {
        return "/org.eclipse.uml2.uml.edit/icons/full/obj16/Parameter_in.gif";
    }

    protected String text(ParameterCS ele) {
        StringBuffer s = new StringBuffer();
        this.appendName(s, (NamedElementCS)ele);
        s.append(" : ");
        this.appendType(s, (TypeRefCS)ele.getType());
        this.appendMultiplicity(s, (TypedElementCS)ele);
        return s.toString();
    }

    protected String image(PrimitiveTypeRefCS ele) {
        return "/org.eclipse.uml2.uml.edit/icons/full/obj16/PrimitiveType.gif";
    }

    protected String image(StructuralFeatureCS ele) {
        return "/org.eclipse.uml2.uml.edit/icons/full/obj16/Property.gif";
    }

    protected String text(StructuralFeatureCS ele) {
        StringBuffer s = new StringBuffer();
        this.appendName(s, (NamedElementCS)ele);
        s.append(" : ");
        this.appendType(s, (TypeRefCS)ele.getType());
        this.appendMultiplicity(s, (TypedElementCS)ele);
        return s.toString();
    }

    protected String text(TypeCS ele) {
        StringBuffer s = new StringBuffer();
        this.appendType(s, ele);
        return s.toString();
    }

    protected String image(TypeParameterCS ele) {
        return "/org.eclipse.uml2.uml.edit/icons/full/obj16/TemplateParameter.gif";
    }

    protected String text(TypeRefCS ele) {
        StringBuffer s = new StringBuffer();
        this.appendType(s, ele);
        return s.toString();
    }
}

