/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.oclstdlib.scoping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.ocl.examples.xtext.base.baseCST.BaseCSTFactory;
import org.eclipse.ocl.examples.xtext.base.baseCST.BoundClassifierCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.BoundElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ClassCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ClassifierCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.PrimitiveTypeRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.QualifiedTypeRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypeBindingCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypeBindingsCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypeCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypeParameterCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypeRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypedElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypedRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypedTypeRefCS;
import org.eclipse.ocl.examples.xtext.base.scope.AbstractScopeAdapter;
import org.eclipse.ocl.examples.xtext.base.scope.DocumentScopeAdapter;
import org.eclipse.ocl.examples.xtext.base.util.ElementUtil;
import org.eclipse.ocl.examples.xtext.oclstdlib.oclstdlibCST.LibBoundClassCS;
import org.eclipse.ocl.examples.xtext.oclstdlib.oclstdlibCST.LibClassCS;
import org.eclipse.ocl.examples.xtext.oclstdlib.scoping.StandardDocumentScopeAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OCLstdlibScopeAdapter<T extends ElementCS>
extends AbstractScopeAdapter<T> {
    protected OCLstdlibScopeAdapter(T csElement) {
        super(csElement);
    }

    protected OCLstdlibScopeAdapter(EObject csDocumentElement, T csElement) {
        super(csDocumentElement, csElement);
    }

    protected ClassifierCS commonConformantType(ClassifierCS firstTypeCS, ClassifierCS secondTypeCS) {
        return firstTypeCS;
    }

    protected boolean conformsTo(ClassifierCS candidateType, ClassifierCS requiredType, TypeBindingsCS bindings) {
        LibBoundClassCS boundCandidateType;
        LibClassCS superType;
        if (candidateType == requiredType) {
            return true;
        }
        if (candidateType instanceof LibClassCS) {
            for (TypedRefCS superType2 : ((LibClassCS)candidateType).getConformsTo()) {
                ClassifierCS libType = this.getLibraryType((ElementCS)superType2, bindings);
                if (!this.conformsTo(libType, requiredType, bindings)) continue;
                return true;
            }
        } else if (candidateType instanceof LibBoundClassCS ? this.conformsTo((ClassifierCS)(superType = (LibClassCS)(boundCandidateType = (LibBoundClassCS)candidateType).getBinds()), requiredType, boundCandidateType.getBindings()) : (candidateType instanceof BoundClassifierCS ? this.conformsTo(superType = (ClassifierCS)(boundCandidateType = (BoundClassifierCS)candidateType).getBinds(), requiredType, boundCandidateType.getBindings()) : (candidateType = this.getLibraryClassifierType()) == requiredType)) {
            return true;
        }
        return false;
    }

    public List<ClassifierCS> getConformsTo(ClassCS csClass, TypeBindingsCS bindings) {
        if (csClass instanceof LibClassCS) {
            EList<TypedRefCS> conformsTo = ((LibClassCS)csClass).getConformsTo();
            int size = conformsTo.size();
            if (size == 1) {
                ClassifierCS result = this.getLibraryType((ElementCS)conformsTo.get(0), bindings);
                if (result != null) {
                    return Collections.singletonList(result);
                }
            } else if (size > 1) {
                ArrayList<ClassifierCS> results = new ArrayList<ClassifierCS>(size);
                for (TypedRefCS csTypedRefCS : conformsTo) {
                    ClassifierCS result = this.getLibraryType((ElementCS)csTypedRefCS, bindings);
                    if (result == null) continue;
                    results.add(result);
                }
                return results;
            }
        } else {
            EList superTypes = csClass.getSuperTypes();
            int size = superTypes.size();
            if (size == 0) {
                ClassifierCS libType = this.getLibraryClassifierType();
                return Collections.singletonList(libType);
            }
            if (size == 1) {
                ClassifierCS result = this.getLibraryType((ElementCS)superTypes.get(0), bindings);
                if (result != null) {
                    return Collections.singletonList(result);
                }
            } else {
                ArrayList<ClassifierCS> results = new ArrayList<ClassifierCS>(size);
                for (TypedRefCS csTypedRefCS : superTypes) {
                    ClassifierCS result = this.getLibraryType((ElementCS)csTypedRefCS, bindings);
                    if (result == null) continue;
                    results.add(result);
                }
                return results;
            }
        }
        return Collections.emptyList();
    }

    public ClassifierCS getLibraryBooleanType() {
        return this.getLibraryType("Boolean");
    }

    public ClassifierCS getLibraryClassifierType() {
        return this.getLibraryType("Classifier");
    }

    public ClassifierCS getLibraryCollectionType() {
        return this.getLibraryType("Collection");
    }

    public ClassifierCS getLibraryIntegerType() {
        return this.getLibraryType("Integer");
    }

    public ClassifierCS getLibraryOclAnyType() {
        return this.getLibraryType("OclAny");
    }

    public ClassifierCS getLibraryOclInvalidType() {
        return this.getLibraryType("OclInvalid");
    }

    public ClassifierCS getLibraryOclVoidType() {
        return this.getLibraryType("OclVoid");
    }

    public ClassifierCS getLibraryRealType() {
        return this.getLibraryType("Real");
    }

    public ClassifierCS getLibrarySetType(TypeCS type) {
        return this.getLibraryType("Set");
    }

    public ClassifierCS getLibraryStringType() {
        return this.getLibraryType("String");
    }

    public ClassifierCS getLibraryTupleType() {
        return this.getLibraryType("Tuple");
    }

    protected StandardDocumentScopeAdapter<?> getLibraryAdapter() {
        DocumentScopeAdapter documentScopeAdapter = this.getDocumentScopeAdapter();
        if (documentScopeAdapter instanceof StandardDocumentScopeAdapter) {
            return (StandardDocumentScopeAdapter)documentScopeAdapter;
        }
        return null;
    }

    protected ClassifierCS getLibraryType(String name) {
        return this.getLibraryAdapter().getLibType(name);
    }

    public ClassifierCS getLibraryType(String collectionTypeName, ClassifierCS elementTypeCS) {
        StandardDocumentScopeAdapter<?> libraryAdapter = this.getLibraryAdapter();
        return libraryAdapter.getLibraryType(collectionTypeName, elementTypeCS);
    }

    public ClassifierCS getLibraryType(ElementCS csElement, TypeBindingsCS bindings) {
        if (csElement == null) {
            return null;
        }
        if (csElement.eIsProxy()) {
            return null;
        }
        if (csElement instanceof ClassCS) {
            return ElementUtil.specializeClass((ClassCS)((ClassCS)csElement), (TypeBindingsCS)bindings);
        }
        if (csElement instanceof ClassifierCS) {
            StandardDocumentScopeAdapter<?> libraryAdapter = this.getLibraryAdapter();
            EObject eObject = ((ClassifierCS)csElement).getOriginalObject();
            if (eObject == EcorePackage.Literals.EBIG_DECIMAL) {
                return libraryAdapter.getLibType("Real");
            }
            if (eObject == EcorePackage.Literals.EBIG_INTEGER) {
                return libraryAdapter.getLibType("Integer");
            }
            if (eObject == EcorePackage.Literals.EBOOLEAN) {
                return libraryAdapter.getLibType("Boolean");
            }
            if (eObject == EcorePackage.Literals.EBOOLEAN_OBJECT) {
                return libraryAdapter.getLibType("Boolean");
            }
            if (eObject == EcorePackage.Literals.EDOUBLE) {
                return libraryAdapter.getLibType("Real");
            }
            if (eObject == EcorePackage.Literals.EDOUBLE_OBJECT) {
                return libraryAdapter.getLibType("Real");
            }
            if (eObject == EcorePackage.Literals.EINT) {
                return libraryAdapter.getLibType("Integer");
            }
            if (eObject == EcorePackage.Literals.EINTEGER_OBJECT) {
                return libraryAdapter.getLibType("Integer");
            }
            if (eObject == EcorePackage.Literals.ESTRING) {
                return libraryAdapter.getLibType("String");
            }
            return (ClassifierCS)csElement;
        }
        if (csElement instanceof BoundElementCS) {
            BoundElementCS boundElement = (BoundElementCS)csElement;
            TypeBindingsCS nestedBindings = boundElement.getBindings();
            return this.getLibraryType((ElementCS)boundElement.getBinds(), nestedBindings);
        }
        if (csElement instanceof TypedElementCS) {
            TypedElementCS typedElement = (TypedElementCS)csElement;
            TypedRefCS type = typedElement.getType();
            String collectionTypeName = ElementUtil.getCollectionTypeName((TypedElementCS)typedElement);
            ClassifierCS csType = this.getLibraryType((ElementCS)type, bindings);
            if (collectionTypeName != null) {
                return this.getLibraryType(collectionTypeName, csType);
            }
            return csType;
        }
        if (csElement instanceof PrimitiveTypeRefCS) {
            PrimitiveTypeRefCS primitiveTypeRefCS = (PrimitiveTypeRefCS)csElement;
            String name = primitiveTypeRefCS.getName();
            return this.getLibraryType(name);
        }
        if (csElement instanceof QualifiedTypeRefCS) {
            QualifiedTypeRefCS qualifiedTypeRefCS = (QualifiedTypeRefCS)csElement;
            TypedRefCS type = (TypedRefCS)qualifiedTypeRefCS.getElement();
            return this.getLibraryType((ElementCS)type, bindings);
        }
        if (csElement instanceof TypedTypeRefCS) {
            TypeBindingsCS nestedBindings = bindings;
            TypedTypeRefCS typedTypeRefCS = (TypedTypeRefCS)csElement;
            TypeCS type = typedTypeRefCS.getType();
            if (type instanceof ClassifierCS) {
                ClassifierCS classifierCS = (ClassifierCS)type;
                EList typeArguments = typedTypeRefCS.getTypeArguments();
                EList typeParameters = classifierCS.getTypeParameters();
                nestedBindings = BaseCSTFactory.eINSTANCE.createTypeBindingsCS();
                nestedBindings.setBoundDocument(bindings.getBoundDocument());
                int iMax = Math.min(typeArguments.size(), typeParameters.size());
                int i = 0;
                while (i < iMax) {
                    TypeBindingCS csTypeBinding = BaseCSTFactory.eINSTANCE.createTypeBindingCS();
                    TypeRefCS typeArgument = (TypeRefCS)typeArguments.get(i);
                    ClassifierCS typeArgCS = this.getLibraryType((ElementCS)typeArgument, bindings);
                    csTypeBinding.setTypeArgument(typeArgCS);
                    csTypeBinding.setTypeParameter((TypeParameterCS)typeParameters.get(i));
                    nestedBindings.getBindings().add((Object)csTypeBinding);
                    ++i;
                }
                bindings.getNested().add((Object)nestedBindings);
            }
            return this.getLibraryType((ElementCS)type, nestedBindings);
        }
        if (csElement instanceof TypeParameterCS) {
            TypeParameterCS typeParameter = (TypeParameterCS)csElement;
            if (bindings != null) {
                for (TypeBindingCS binding : bindings.getBindings()) {
                    if (!this.isSameTypeParameter(typeParameter, binding)) continue;
                    return this.getLibraryType((ElementCS)binding.getTypeArgument(), bindings);
                }
            }
            throw new UnsupportedOperationException("getLibraryType(TypeParameterCS)");
        }
        throw new UnsupportedOperationException("getLibraryType()");
    }

    protected boolean isSameTypeParameter(TypeParameterCS typeParameter, TypeBindingCS binding) {
        TypeParameterCS bindingTypeParameter = binding.getTypeParameter();
        return bindingTypeParameter == typeParameter;
    }

    public ClassifierCS getLibraryUnlimitedNaturalType() {
        return this.getLibraryType("UnlimitedNatural");
    }
}

