/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.oclstdlib.scoping;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.ocl.examples.xtext.base.baseCST.BaseCSTFactory;
import org.eclipse.ocl.examples.xtext.base.baseCST.ClassifierCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.DocumentCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.NamedElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypeBindingCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypeBindingsCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypeParameterCS;
import org.eclipse.ocl.examples.xtext.base.scope.AbstractDocumentScopeAdapter;
import org.eclipse.ocl.examples.xtext.base.scope.ScopeAdapter;
import org.eclipse.ocl.examples.xtext.oclstdlib.oclstdlibCST.LibBoundClassCS;
import org.eclipse.ocl.examples.xtext.oclstdlib.oclstdlibCST.LibClassCS;
import org.eclipse.ocl.examples.xtext.oclstdlib.oclstdlibCST.LibClassifierCS;
import org.eclipse.ocl.examples.xtext.oclstdlib.oclstdlibCST.LibDocumentCS;
import org.eclipse.ocl.examples.xtext.oclstdlib.oclstdlibCST.LibPackageCS;
import org.eclipse.ocl.examples.xtext.oclstdlib.oclstdlibCST.OCLstdlibCSTFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StandardDocumentScopeAdapter<T extends DocumentCS>
extends AbstractDocumentScopeAdapter<T> {
    public static final String OCLSTDLIB_URI = "platform:/plugin/org.eclipse.ocl.examples.xtext.essentialocl/model/oclstdlib.oclstdlib";
    protected Map<String, LibPackageCS> libraryNameMap = new HashMap<String, LibPackageCS>();
    protected Map<String, ClassifierCS> libraryTypeMap = new HashMap<String, ClassifierCS>();

    public StandardDocumentScopeAdapter(T csElement) {
        super(csElement);
    }

    public StandardDocumentScopeAdapter<?> getDocumentScopeAdapter() {
        return this;
    }

    public LibClassifierCS getLibType(String name) {
        if (this.libraryNameMap.isEmpty()) {
            URI uri = URI.createURI((String)OCLSTDLIB_URI);
            this.importLibrary(((DocumentCS)this.getTarget()).eResource().getResourceSet(), "ocl", uri);
        }
        return (LibClassifierCS)this.libraryTypeMap.get(name);
    }

    protected List<EObject> importLibrary(ResourceSet resourceSet, String alias, URI uri) {
        try {
            LibDocumentCS csDocument;
            EList<LibPackageCS> csPackages;
            Object csElement;
            if (uri.fragment() == null) {
                Resource resource = resourceSet.getResource(uri, true);
                csElement = (LibDocumentCS)resource.getContents().get(0);
            } else {
                csElement = (LibPackageCS)resourceSet.getEObject(uri, true);
            }
            if (csElement instanceof LibDocumentCS && !(csPackages = (csDocument = (LibDocumentCS)csElement).getPackages()).isEmpty()) {
                if (alias == null) {
                    alias = "";
                }
                LibPackageCS csPackage = (LibPackageCS)csPackages.get(0);
                this.libraryNameMap.put(alias, csPackage);
                for (ClassifierCS csClassifier : csPackage.getClassifiers()) {
                    this.libraryTypeMap.put(csClassifier.getName(), csClassifier);
                }
                csElement = csPackage;
            }
            return Collections.singletonList(csElement);
        }
        catch (RuntimeException ex) {
            this.getLogger().trace((Object)("Cannot load library with URI '" + uri + "'"), (Throwable)ex);
            return Collections.emptyList();
        }
    }

    public ClassifierCS getLibraryType(String collectionTypeName, ClassifierCS elementTypeCS) {
        ScopeAdapter elementScopeAdapter = StandardDocumentScopeAdapter.getScopeAdapter((EObject)elementTypeCS);
        if (elementScopeAdapter == null) {
            return null;
        }
        String elementSignature = elementScopeAdapter.getSignature();
        String netSignature = String.valueOf(collectionTypeName) + "(" + elementSignature + ")";
        LibClassifierCS specializedClassifier = this.getLibType(netSignature);
        if (specializedClassifier == null) {
            LibClassifierCS collectionClassifier = this.getLibType(collectionTypeName);
            LibBoundClassCS parameterizedClassifier = OCLstdlibCSTFactory.eINSTANCE.createLibBoundClassCS();
            parameterizedClassifier.setName(netSignature);
            parameterizedClassifier.setBinds((NamedElementCS)((LibClassCS)collectionClassifier));
            TypeBindingCS binding = BaseCSTFactory.eINSTANCE.createTypeBindingCS();
            binding.setTypeParameter((TypeParameterCS)collectionClassifier.getTypeParameters().get(0));
            binding.setTypeArgument(elementTypeCS);
            List<TypeBindingCS> newBindings = Collections.singletonList(binding);
            TypeBindingsCS bindings = parameterizedClassifier.getBindings();
            TypeBindingsCS nestedBindings = BaseCSTFactory.eINSTANCE.createTypeBindingsCS();
            nestedBindings.setBoundDocument(this.getBoundDocument());
            nestedBindings.getBindings().addAll(newBindings);
            if (bindings != null) {
                bindings.getNested().add((Object)nestedBindings);
            }
            parameterizedClassifier.setBindings(nestedBindings);
            this.libraryTypeMap.put(netSignature, (ClassifierCS)parameterizedClassifier);
            specializedClassifier = parameterizedClassifier;
        }
        return specializedClassifier;
    }
}

