/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.oclstdlib.services;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.ocl.examples.xtext.base.baseCST.ElementCS;
import org.eclipse.ocl.examples.xtext.base.scope.ScopeAdapter;
import org.eclipse.ocl.examples.xtext.base.scope.ScopeView;
import org.eclipse.ocl.examples.xtext.base.scoping.BaseScopeProvider;
import org.eclipse.ocl.examples.xtext.base.util.ElementUtil;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.linking.impl.DefaultLinkingService;
import org.eclipse.xtext.linking.impl.IllegalNodeException;
import org.eclipse.xtext.parsetree.AbstractNode;
import org.eclipse.xtext.parsetree.LeafNode;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCLstdlibLinkingService
extends DefaultLinkingService {
    private static int depth = -1;
    @Inject
    private IValueConverterService valueConverterService;

    public List<EObject> getLinkedObjects(EObject context, EReference ref, AbstractNode node) throws IllegalNodeException {
        try {
            ++depth;
            String text = this.getText(node);
            boolean traceLookup = BaseScopeProvider.LOOKUP.isActive();
            if (text == null) {
                if (traceLookup) {
                    BaseScopeProvider.LOOKUP.println(depth + " Lookup null");
                }
                List<EObject> list = Collections.emptyList();
                return list;
            }
            ScopeAdapter scopeAdapter = ElementUtil.getScopeAdapter((EObject)context);
            if (scopeAdapter.isUnresolvable()) {
                if (traceLookup) {
                    BaseScopeProvider.LOOKUP.println(depth + " Lookup " + text + " already unresolvable");
                }
                List<EObject> list = Collections.emptyList();
                return list;
            }
            IScope scope = this.getScope(context, ref);
            if (scope instanceof ScopeView) {
                IEObjectDescription eObjectDescription;
                if (traceLookup) {
                    BaseScopeProvider.LOOKUP.println(depth + " Lookup " + text);
                }
                if ((eObjectDescription = scope.getContentByName(text)) != null) {
                    EObject eObjectOrProxy = eObjectDescription.getEObjectOrProxy();
                    if (traceLookup) {
                        if (eObjectOrProxy instanceof ElementCS) {
                            BaseScopeProvider.LOOKUP.println(depth + " Lookup " + text + " => " + ((ElementCS)eObjectOrProxy).getSignature());
                        } else {
                            BaseScopeProvider.LOOKUP.println(depth + " Lookup " + text + " => " + eObjectOrProxy);
                        }
                    }
                    List<EObject> list = Collections.singletonList(eObjectOrProxy);
                    return list;
                }
                if (traceLookup) {
                    BaseScopeProvider.LOOKUP.println(depth + " Lookup " + text + " failed");
                }
            }
            scopeAdapter.setUnresolvable();
            List<EObject> list = Collections.emptyList();
            return list;
        }
        finally {
            --depth;
        }
    }

    protected IScope getScope(EObject context, EReference reference) {
        IScopeProvider scopeProvider = this.getScopeProvider();
        if (scopeProvider == null) {
            throw new IllegalStateException("scopeProvider must not be null.");
        }
        return scopeProvider.getScope(context, reference);
    }

    public String getText(AbstractNode node) {
        LeafNode leafNode = null;
        if (node instanceof LeafNode) {
            leafNode = (LeafNode)node;
        } else {
            for (LeafNode lNode : node.getLeafNodes()) {
                if (lNode.isHidden()) continue;
                leafNode = lNode;
                break;
            }
        }
        if (leafNode == null) {
            return null;
        }
        EObject grammarElement = leafNode.getGrammarElement();
        String ruleName = this.getLinkingHelper().getRuleNameFrom(grammarElement);
        return (String)this.valueConverterService.toValue(leafNode.getText(), ruleName, (AbstractNode)leafNode);
    }
}

