/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.oclstdlib.services;

import com.google.common.collect.ImmutableSet;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Set;
import org.eclipse.ocl.examples.xtext.base.util.ElementUtil;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.conversion.IValueConverter;
import org.eclipse.xtext.conversion.ValueConverter;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.impl.AbstractDeclarativeValueConverterService;
import org.eclipse.xtext.conversion.impl.AbstractNullSafeConverter;
import org.eclipse.xtext.parsetree.AbstractNode;
import org.eclipse.xtext.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCLstdlibValueConverterService
extends AbstractDeclarativeValueConverterService {
    @ValueConverter(rule="DOUBLE_QUOTED_STRING")
    public IValueConverter<String> DOUBLE_QUOTED_STRING() {
        return new AbstractNullSafeConverter<String>(){

            protected String internalToValue(String string, AbstractNode node) {
                try {
                    return Strings.convertFromJavaString((String)string.substring(1, string.length() - 1), (boolean)true);
                }
                catch (IllegalArgumentException e) {
                    throw new ValueConverterException(e.getMessage(), node, (Exception)e);
                }
            }

            protected String internalToString(String value) {
                return String.valueOf('\"') + Strings.convertToJavaString((String)value, (boolean)true) + '\"';
            }
        };
    }

    @ValueConverter(rule="ID")
    public IValueConverter<String> ID() {
        return new AbstractNullSafeConverter<String>(){
            private Set<String> allKeywords;
            {
                this.allKeywords = ImmutableSet.copyOf((Iterable)GrammarUtil.getAllKeywords((Grammar)OCLstdlibValueConverterService.this.getGrammar()));
            }

            protected String internalToValue(String string, AbstractNode node) {
                int length = string.length();
                return string.startsWith("_'") && length >= 3 && string.endsWith("'") ? string.substring(2, length - 1) : string;
            }

            protected String internalToString(String value) {
                if (this.allKeywords.contains(value) || !ElementUtil.isValidIdentifier((String)value)) {
                    return "_'" + value + "'";
                }
                return value;
            }
        };
    }

    @ValueConverter(rule="NUMBER_LITERAL")
    public IValueConverter<Number> NUMBER_LITERAL() {
        return new IValueConverter<Number>(){

            public Number toValue(String string, AbstractNode node) {
                if (Strings.isEmpty((String)string)) {
                    throw new ValueConverterException("Couldn't convert empty string to number", node, null);
                }
                try {
                    if (string.contains(".") || string.contains("e") || string.contains("e")) {
                        return new BigDecimal(string);
                    }
                    return new BigInteger(string);
                }
                catch (NumberFormatException e) {
                    throw new ValueConverterException("Couldn't convert '" + string + "' to number", node, (Exception)e);
                }
            }

            public String toString(Number value) {
                return value.toString();
            }
        };
    }

    @ValueConverter(rule="SINGLE_QUOTED_STRING")
    public IValueConverter<String> SINGLE_QUOTED_STRING() {
        return new AbstractNullSafeConverter<String>(){

            protected String internalToValue(String string, AbstractNode node) {
                try {
                    return Strings.convertFromJavaString((String)string.substring(1, string.length() - 1), (boolean)true);
                }
                catch (IllegalArgumentException e) {
                    throw new ValueConverterException(e.getMessage(), node, (Exception)e);
                }
            }

            protected String internalToString(String value) {
                return "'" + Strings.convertToJavaString((String)value, (boolean)true) + "'";
            }
        };
    }
}

