/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ocl.AbstractEnvironmentFactory;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.EvaluationHaltedException;
import org.eclipse.ocl.EvaluationVisitor;
import org.eclipse.ocl.OCLInput;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.Query;
import org.eclipse.ocl.SemanticException;
import org.eclipse.ocl.SyntaxException;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.helper.OCLHelper;
import org.eclipse.ocl.internal.OCLDebugOptions;
import org.eclipse.ocl.internal.OCLPlugin;
import org.eclipse.ocl.internal.evaluation.QueryImpl;
import org.eclipse.ocl.internal.helper.HelperUtil;
import org.eclipse.ocl.lpg.ProblemHandler;
import org.eclipse.ocl.parser.OCLAnalyzer;
import org.eclipse.ocl.parser.ValidationVisitor;
import org.eclipse.ocl.parser.backtracking.OCLBacktrackingLexer;
import org.eclipse.ocl.parser.backtracking.OCLBacktrackingParser;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.util.OCLUtil;
import org.eclipse.ocl.util.ObjectUtil;
import org.eclipse.ocl.utilities.ExpressionInOCL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCL<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> {
    private final EnvironmentFactory<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> environmentFactory;
    private final Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> rootEnvironment;
    private EvaluationEnvironment<C, O, P, CLS, E> evalEnv;
    private Map<CLS, ? extends Set<? extends E>> extentMap;
    private List<CT> constraints = new ArrayList<CT>();
    private Diagnostic problems;
    private Diagnostic evaluationProblems;
    private int parserRepairCount = 0;
    private boolean traceParsing = OCLPlugin.shouldTrace(OCLDebugOptions.PARSING);
    private boolean traceEvaluation = OCLPlugin.shouldTrace(OCLDebugOptions.EVALUATION);

    protected OCL(EnvironmentFactory<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> envFactory) {
        this(envFactory, envFactory.createEnvironment());
    }

    protected OCL(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) {
        this(env.getFactory(), env);
    }

    protected OCL(EnvironmentFactory<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> envFactory, Resource resource) {
        this(envFactory, envFactory.loadEnvironment(resource));
    }

    protected OCL(EnvironmentFactory<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> envFactory, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> rootEnv) {
        this.environmentFactory = envFactory;
        this.rootEnvironment = rootEnv;
        if (envFactory instanceof AbstractEnvironmentFactory) {
            AbstractEnvironmentFactory abstractFactory = (AbstractEnvironmentFactory)envFactory;
            abstractFactory.setEvaluationTracingEnabled(this.traceEvaluation);
        }
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> OCL<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> newInstance(EnvironmentFactory<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> envFactory) {
        return new OCL<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>(envFactory);
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> OCL<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> newInstance(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) {
        return new OCL<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>(env);
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> OCL<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> newInstance(EnvironmentFactory<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> envFactory, Resource resource) {
        return new OCL<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>(envFactory, resource);
    }

    public Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> getEnvironment() {
        return this.rootEnvironment;
    }

    public EvaluationEnvironment<C, O, P, CLS, E> getEvaluationEnvironment() {
        if (this.evalEnv == null) {
            this.evalEnv = this.environmentFactory.createEvaluationEnvironment();
        }
        return this.evalEnv;
    }

    public Map<CLS, ? extends Set<? extends E>> getExtentMap() {
        return this.extentMap;
    }

    public void setExtentMap(Map<CLS, ? extends Set<? extends E>> extentMap) {
        this.extentMap = extentMap;
    }

    public OCLAnalyzer<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> createAnalyzer(String input) {
        OCLAnalyzer<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> analyzer;
        if (this.parserRepairCount != 0) {
            OCLBacktrackingLexer lexer = new OCLBacktrackingLexer(this.rootEnvironment, input.toCharArray());
            OCLBacktrackingParser parser = new OCLBacktrackingParser(lexer);
            parser.setDefaultRepairCount(this.parserRepairCount);
            lexer.lexer(parser.getIPrsStream());
            analyzer = new OCLAnalyzer(parser);
        } else {
            analyzer = new OCLAnalyzer<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>(this.rootEnvironment, input);
        }
        return analyzer;
    }

    public List<CT> parse(OCLInput input) throws ParserException {
        String inputString = input.getContentAsString();
        OCLAnalyzer analyzer = this.createAnalyzer(inputString);
        ProblemHandler ph = OCLUtil.getAdapter(this.rootEnvironment, ProblemHandler.class);
        if (ph != null) {
            ph.beginParse();
        }
        ArrayList result = new ArrayList();
        analyzer.parseOCLDocument(result);
        this.constraints.addAll(result);
        EList resContents = this.rootEnvironment.getTypeResolver().getResource().getContents();
        for (Object ct : result) {
            EObject constraintEObject = (EObject)ct;
            if (constraintEObject.eResource() != null) continue;
            resContents.add(constraintEObject);
        }
        if (ph != null) {
            ph.endParse();
            try {
                this.problems = OCLUtil.checkForErrors(ph);
            }
            catch (ParserException e) {
                this.problems = e.getDiagnostic();
                throw e;
            }
        }
        return result;
    }

    public List<CT> getConstraints() {
        return this.constraints;
    }

    public void validate(OCLExpression<C> expression) throws SemanticException {
        ProblemHandler ph = OCLUtil.getAdapter(this.rootEnvironment, ProblemHandler.class);
        if (ph != null) {
            ph.beginValidation();
        }
        expression.accept(ValidationVisitor.getInstance(this.rootEnvironment));
        if (ph != null) {
            ph.endValidation();
            try {
                OCLUtil.checkForErrors(ph);
            }
            catch (SyntaxException e) {
                throw new SemanticException(e.getDiagnostic());
            }
        }
    }

    public void validate(CT constraint) throws SemanticException {
        ProblemHandler ph = OCLUtil.getAdapter(this.rootEnvironment, ProblemHandler.class);
        if (ph != null) {
            ph.beginValidation();
        }
        ValidationVisitor.getInstance(this.rootEnvironment).visitConstraint(constraint);
        if (ph != null) {
            ph.endValidation();
            try {
                OCLUtil.checkForErrors(ph);
            }
            catch (SyntaxException e) {
                throw new SemanticException(e.getDiagnostic());
            }
        }
    }

    public Object evaluate(Object context, OCLExpression<C> expression) {
        Object result;
        this.evaluationProblems = null;
        context = HelperUtil.getConstraintContext(this.rootEnvironment, context, expression);
        EvaluationEnvironment<C, O, P, CLS, E> localEvalEnv = this.getEvaluationEnvironment();
        localEvalEnv.add("self", context);
        Map<CLS, Set<E>> extents = this.getExtentMap();
        if (extents == null) {
            extents = localEvalEnv.createExtentMap(context);
        }
        EvaluationVisitor<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> ev = this.environmentFactory.createEvaluationVisitor(this.rootEnvironment, localEvalEnv, extents);
        try {
            try {
                result = ev.visitExpression(expression);
            }
            catch (EvaluationHaltedException e) {
                this.evaluationProblems = e.getDiagnostic();
                result = this.rootEnvironment.getOCLStandardLibrary().getInvalid();
                localEvalEnv.remove("self");
            }
        }
        finally {
            localEvalEnv.remove("self");
        }
        return result;
    }

    public boolean isInvalid(Object value) {
        return this.getEnvironment().getOCLStandardLibrary().getInvalid() == value;
    }

    public boolean check(Object context, CT constraint) {
        ExpressionInOCL<C, PM> specification = this.rootEnvironment.getUMLReflection().getSpecification(constraint);
        return this.check(context, specification.getBodyExpression());
    }

    public boolean check(Object context, OCLExpression<C> constraint) {
        OCLStandardLibrary<C> stdlib = this.getEnvironment().getOCLStandardLibrary();
        if (constraint.getType() != stdlib.getBoolean()) {
            throw new IllegalArgumentException("constraint is not boolean");
        }
        Object result = this.evaluate(context, constraint);
        return Boolean.TRUE.equals(result);
    }

    public OCLHelper<C, O, P, CT> createOCLHelper() {
        return HelperUtil.createOCLHelper(this);
    }

    public Query<C, CLS, E> createQuery(OCLExpression<C> query) {
        return new QueryImpl<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>(this.rootEnvironment, query, this.extentMap);
    }

    public Query<C, CLS, E> createQuery(CT constraint) {
        return new QueryImpl<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>(this.rootEnvironment, this.rootEnvironment.getUMLReflection().getSpecification(constraint).getBodyExpression(), this.extentMap);
    }

    public boolean isParseTracingEnabled() {
        return this.traceParsing;
    }

    public void setParseTracingEnabled(boolean b) {
        this.traceParsing = b;
    }

    public int getParserRepairCount() {
        return this.parserRepairCount;
    }

    public void setParserRepairCount(int parserRepairCount) {
        if (parserRepairCount < 0) {
            throw new IllegalArgumentException("negative repair count");
        }
        this.parserRepairCount = parserRepairCount;
    }

    public boolean isEvaluationTracingEnabled() {
        return this.traceEvaluation;
    }

    public void setEvaluationTracingEnabled(boolean b) {
        this.traceEvaluation = b;
        if (this.environmentFactory instanceof AbstractEnvironmentFactory) {
            AbstractEnvironmentFactory abstractFactory = (AbstractEnvironmentFactory)this.environmentFactory;
            abstractFactory.setEvaluationTracingEnabled(this.traceEvaluation);
        }
    }

    public Diagnostic getProblems() {
        return this.problems;
    }

    public Diagnostic getEvaluationProblems() {
        return this.evaluationProblems;
    }

    public void dispose() {
        for (CT constraint : this.getConstraints()) {
            EObject eObject = (EObject)constraint;
            if (eObject.eResource() != null) continue;
            ObjectUtil.dispose(constraint);
        }
        this.getConstraints().clear();
        if (this.getEnvironment() instanceof Environment.Internal) {
            Environment.Internal env = (Environment.Internal)this.getEnvironment();
            env.dispose();
        }
    }
}

