/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.lpg;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lpg.runtime.IToken;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.internal.OCLDebugOptions;
import org.eclipse.ocl.internal.OCLPlugin;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.ocl.lpg.AbstractFormattingHelper;
import org.eclipse.ocl.lpg.AbstractParser;
import org.eclipse.ocl.lpg.BasicEnvironment;
import org.eclipse.ocl.lpg.BasicEnvironment2;
import org.eclipse.ocl.lpg.FormattingHelper;
import org.eclipse.ocl.lpg.ProblemHandler;
import org.eclipse.ocl.options.Option;
import org.eclipse.ocl.parser.OCLProblemHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBasicEnvironment
implements BasicEnvironment2 {
    private BasicEnvironment parent;
    private ProblemHandler problemHandler = null;
    private FormattingHelper formatter = null;
    private Map<Object, CSTNode> astNodeToCSTNodeMap = null;
    private AbstractParser parser = null;
    private final Map<Option<?>, Object> options = new HashMap();

    protected AbstractBasicEnvironment(BasicEnvironment parent) {
        this.parent = parent;
    }

    @Override
    public <T> T getAdapter(Class<T> adapterType) {
        Object result = adapterType.isAssignableFrom(this.getClass()) ? this : (adapterType == ProblemHandler.class ? this.getProblemHandler() : null);
        return (T)result;
    }

    @Override
    public void analyzerError(String problemMessage, String problemContext, Object problemObject) {
        CSTNode cstNode = this.getASTMapping(problemObject);
        int startOffset = cstNode != null ? cstNode.getStartOffset() : -1;
        int endOffset = cstNode != null ? cstNode.getEndOffset() : -1;
        this.analyzerError(problemMessage, problemContext, startOffset, endOffset);
    }

    @Override
    public void analyzerError(String problemMessage, String problemContext, List<?> problemObjects) {
        int startOffset = -1;
        int endOffset = -1;
        if (problemObjects != null && !problemObjects.isEmpty()) {
            CSTNode startNode = this.getASTMapping(problemObjects.get(0));
            CSTNode endNode = this.getASTMapping(problemObjects.get(problemObjects.size() - 1));
            startOffset = startNode != null ? startNode.getStartOffset() : -1;
            endOffset = endNode != null ? endNode.getEndOffset() : -1;
        }
        this.analyzerError(problemMessage, problemContext, startOffset, endOffset);
    }

    @Override
    public void analyzerError(String problemMessage, String problemContext, int startOffset, int endOffset) {
        ProblemHandler problemHandler = this.getProblemHandler();
        if (problemHandler != null) {
            problemHandler.analyzerProblem(ProblemHandler.Severity.ERROR, problemMessage, problemContext, startOffset, endOffset);
        }
    }

    @Override
    public void analyzerWarning(String problemMessage, String problemContext, Object problemObject) {
        ProblemHandler problemHandler = this.getProblemHandler();
        if (problemHandler != null) {
            CSTNode cstNode = this.getASTMapping(problemObject);
            int startOffset = cstNode != null ? cstNode.getStartOffset() : -1;
            int endOffset = cstNode != null ? cstNode.getEndOffset() : -1;
            problemHandler.analyzerProblem(ProblemHandler.Severity.WARNING, problemMessage, problemContext, startOffset, endOffset);
        }
    }

    protected ProblemHandler createDefaultProblemHandler(AbstractParser parser) {
        return new OCLProblemHandler(parser);
    }

    public BasicEnvironment getParent() {
        return this.parent;
    }

    @Override
    public AbstractParser getParser() {
        return this.parser;
    }

    public Map<Object, CSTNode> getASTNodeToCSTNodeMap() {
        if (this.astNodeToCSTNodeMap == null) {
            this.astNodeToCSTNodeMap = new HashMap<Object, CSTNode>();
        }
        return this.astNodeToCSTNodeMap;
    }

    @Override
    public CSTNode getASTMapping(Object object) {
        if (object instanceof CSTNode) {
            return (CSTNode)object;
        }
        if (this.astNodeToCSTNodeMap != null) {
            return this.astNodeToCSTNodeMap.get(object);
        }
        return null;
    }

    @Override
    public FormattingHelper getFormatter() {
        if (this.formatter == null) {
            this.formatter = this.createFormattingHelper();
        }
        return this.formatter;
    }

    protected FormattingHelper createFormattingHelper() {
        return AbstractFormattingHelper.INSTANCE;
    }

    @Override
    public ProblemHandler getProblemHandler() {
        if (this.problemHandler == null) {
            BasicEnvironment parent = this.getParent();
            if (this.parser == null && parent != null) {
                return parent.getProblemHandler();
            }
            this.problemHandler = this.createDefaultProblemHandler(this.parser);
        }
        return this.problemHandler;
    }

    @Override
    public void initASTMapping(Object astNode, CSTNode cstNode) {
        this.initASTMapping(astNode, cstNode, astNode);
    }

    @Override
    public void initASTMapping(Object fromAstNode, CSTNode cstNode, Object toAstNode) {
        if (cstNode != null) {
            if (fromAstNode != null) {
                Map<Object, CSTNode> nodeToCSTNodeMap = this.getASTNodeToCSTNodeMap();
                CSTNode oldCSTNode = nodeToCSTNodeMap.get(fromAstNode);
                if (oldCSTNode == null) {
                    nodeToCSTNodeMap.put(fromAstNode, cstNode);
                } else if (oldCSTNode != cstNode && OCLPlugin.shouldTrace(OCLDebugOptions.PARSING)) {
                    OCLPlugin.trace("Preserved AST mapping of " + fromAstNode.getClass().getSimpleName() + " to " + oldCSTNode.getClass().getSimpleName() + " rather than " + cstNode.getClass().getSimpleName());
                }
            }
            if (toAstNode != null) {
                Object oldAstNode = cstNode.getAst();
                if (oldAstNode == null) {
                    cstNode.setAst(toAstNode);
                } else if (oldAstNode != toAstNode && OCLPlugin.shouldTrace(OCLDebugOptions.PARSING)) {
                    OCLPlugin.trace("Preserved CST mapping of " + cstNode.getClass().getSimpleName() + " to " + oldAstNode.getClass().getSimpleName() + " rather than " + toAstNode.getClass().getSimpleName());
                }
            }
        }
    }

    @Override
    public void lexerError(int errorCode, int startOffset, int endOffset) {
        ProblemHandler problemHandler = this.getProblemHandler();
        if (problemHandler != null) {
            String inputText = String.valueOf('\"') + this.parser.computeInputString(startOffset, endOffset) + '\"';
            int tokenIndex = this.parser.getIPrsStream().getTokenIndexAtCharacter(startOffset);
            if (tokenIndex < 0) {
                tokenIndex = -tokenIndex;
            }
            String locInfo = String.valueOf(this.parser.getIPrsStream().getEndLineNumberOfTokenAt(tokenIndex)) + ":" + this.parser.getIPrsStream().getEndColumnOfTokenAt(tokenIndex);
            String messageTemplate = ProblemHandler.ERROR_MESSAGES[errorCode];
            String message = OCLMessages.bind(messageTemplate, locInfo, inputText);
            problemHandler.lexerProblem(ProblemHandler.Severity.ERROR, message, null, startOffset, endOffset);
        }
    }

    @Override
    public void parserError(int errorCode, int leftToken, int rightToken, String tokenText) {
        String message;
        int line;
        ProblemHandler problemHandler = this.getProblemHandler();
        if (problemHandler == null) {
            return;
        }
        int leftTokenLoc = leftToken > rightToken ? rightToken : leftToken;
        int rightTokenLoc = rightToken;
        int startOffset = this.parser.getIPrsStream().getStartOffset(leftTokenLoc);
        int endOffset = this.parser.getIPrsStream().getEndOffset(rightTokenLoc);
        int n = line = leftTokenLoc >= 0 ? this.parser.getIPrsStream().getLine(leftTokenLoc) : -1;
        if (line <= 0) {
            message = OCLMessages.InvalidOCL_ERROR_;
        } else {
            String locInfo = "";
            String messageTemplate = ProblemHandler.ERROR_MESSAGES[errorCode].substring(4);
            String inputText = String.valueOf('\"') + this.parser.computeInputString(startOffset, endOffset) + '\"';
            switch (errorCode) {
                case 6: 
                case 8: 
                case 10: 
                case 11: {
                    message = OCLMessages.bind(messageTemplate, locInfo, inputText);
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 7: {
                    message = OCLMessages.bind(messageTemplate, new Object[]{locInfo, tokenText, inputText});
                    break;
                }
                default: {
                    message = OCLMessages.bind(messageTemplate, locInfo, tokenText);
                }
            }
        }
        problemHandler.parserProblem(ProblemHandler.Severity.ERROR, message, null, startOffset, endOffset);
    }

    public void setASTNodeToCSTNodeMap(Map<Object, CSTNode> astNodeToCstNodeMap) {
        this.astNodeToCSTNodeMap = astNodeToCstNodeMap;
    }

    protected void setParent(BasicEnvironment parent) {
        this.parent = parent;
    }

    @Override
    public void setParser(AbstractParser parser) {
        this.parser = parser;
        if (this.problemHandler != null) {
            this.problemHandler.setParser(parser);
        }
    }

    @Override
    public ProblemHandler setProblemHandler(ProblemHandler newProblemHandler) {
        ProblemHandler oldProblemHandler = this.problemHandler;
        this.problemHandler = newProblemHandler;
        return oldProblemHandler;
    }

    @Override
    public void utilityError(String problemMessage, String problemContext, Object problemObject) {
        ProblemHandler problemHandler = this.getProblemHandler();
        if (problemHandler != null) {
            CSTNode cstNode = this.getASTMapping(problemObject);
            int startOffset = cstNode != null ? cstNode.getStartOffset() : -1;
            int endOffset = cstNode != null ? cstNode.getEndOffset() : -1;
            problemHandler.utilityProblem(ProblemHandler.Severity.ERROR, problemMessage, problemContext, startOffset, endOffset);
        }
    }

    @Override
    public void validatorError(String problemMessage, String problemContext, Object problemObject) {
        ProblemHandler problemHandler = this.getProblemHandler();
        if (problemHandler != null) {
            CSTNode cstNode = this.getASTMapping(problemObject);
            int startOffset = cstNode != null ? cstNode.getStartOffset() : -1;
            int endOffset = cstNode != null ? cstNode.getEndOffset() : -1;
            problemHandler.validatorProblem(ProblemHandler.Severity.ERROR, problemMessage, problemContext, startOffset, endOffset);
        }
    }

    @Override
    public void problem(ProblemHandler.Severity severity, ProblemHandler.Phase phase, String problemMessage, String problemContext, Object problemObject) {
        ProblemHandler problemHandler = this.getProblemHandler();
        if (problemHandler != null) {
            int startOffset = -1;
            int endOffset = -1;
            CSTNode cstNode = this.getASTMapping(problemObject);
            if (cstNode != null) {
                startOffset = cstNode.getStartOffset();
                endOffset = cstNode.getEndOffset();
            } else if (problemObject instanceof IToken) {
                IToken token = (IToken)problemObject;
                startOffset = token.getStartOffset();
                endOffset = token.getEndOffset();
            }
            problemHandler.handleProblem(severity, phase, problemMessage, problemContext, startOffset, endOffset);
        }
    }

    protected Map<Option<?>, Object> basicGetOptions() {
        return this.options;
    }

    @Override
    public Map<Option<?>, Object> getOptions() {
        HashMap result = this.getParent() != null ? new HashMap(this.getParent().getOptions()) : new HashMap();
        result.putAll(this.basicGetOptions());
        return result;
    }

    @Override
    public <T> void setOption(Option<T> option, T value) {
        this.basicGetOptions().put(option, value);
    }

    @Override
    public <T> void putOptions(Map<? extends Option<T>, ? extends T> options) {
        Map<Option<?>, Object> myOptions = this.basicGetOptions();
        myOptions.clear();
        myOptions.putAll(options);
    }

    @Override
    public <T> T removeOption(Option<T> option) {
        T result = this.getValue(option);
        this.basicGetOptions().remove(option);
        return result;
    }

    @Override
    public <T> Map<Option<T>, T> removeOptions(Collection<Option<T>> options) {
        HashMap<Option<T>, T> result = new HashMap<Option<T>, T>();
        Map<Option<?>, Object> myOptions = this.basicGetOptions();
        for (Option<T> next : options) {
            result.put(next, this.getValue(next));
            myOptions.remove(next);
        }
        return result;
    }

    @Override
    public Map<Option<?>, Object> clearOptions() {
        Map<Option<?>, Object> myOptions = this.basicGetOptions();
        HashMap result = new HashMap(myOptions);
        myOptions.clear();
        return result;
    }

    @Override
    public boolean isEnabled(Option<Boolean> option) {
        Boolean result = this.getValue(option);
        return result == null ? false : result;
    }

    @Override
    public <T> T getValue(Option<T> option) {
        Object result = this.getOptions().get(option);
        if (result == null) {
            result = this.getParent() != null ? this.getParent().getValue(option) : option.getDefaultValue();
        }
        return (T)result;
    }
}

