/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.util;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.expressions.AssociationClassCallExp;
import org.eclipse.ocl.expressions.BooleanLiteralExp;
import org.eclipse.ocl.expressions.CollectionItem;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.expressions.CollectionLiteralExp;
import org.eclipse.ocl.expressions.CollectionRange;
import org.eclipse.ocl.expressions.EnumLiteralExp;
import org.eclipse.ocl.expressions.FeatureCallExp;
import org.eclipse.ocl.expressions.IfExp;
import org.eclipse.ocl.expressions.IntegerLiteralExp;
import org.eclipse.ocl.expressions.InvalidLiteralExp;
import org.eclipse.ocl.expressions.IterateExp;
import org.eclipse.ocl.expressions.IteratorExp;
import org.eclipse.ocl.expressions.LetExp;
import org.eclipse.ocl.expressions.MessageExp;
import org.eclipse.ocl.expressions.NullLiteralExp;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.OperationCallExp;
import org.eclipse.ocl.expressions.PropertyCallExp;
import org.eclipse.ocl.expressions.RealLiteralExp;
import org.eclipse.ocl.expressions.StateExp;
import org.eclipse.ocl.expressions.StringLiteralExp;
import org.eclipse.ocl.expressions.TupleLiteralExp;
import org.eclipse.ocl.expressions.TupleLiteralPart;
import org.eclipse.ocl.expressions.TypeExp;
import org.eclipse.ocl.expressions.UnlimitedNaturalLiteralExp;
import org.eclipse.ocl.expressions.UnspecifiedValueExp;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.expressions.VariableExp;
import org.eclipse.ocl.types.CollectionType;
import org.eclipse.ocl.types.VoidType;
import org.eclipse.ocl.util.TypeUtil;
import org.eclipse.ocl.utilities.AbstractVisitor;
import org.eclipse.ocl.utilities.ExpressionInOCL;
import org.eclipse.ocl.utilities.TypedElement;
import org.eclipse.ocl.utilities.UMLReflection;
import org.eclipse.ocl.utilities.Visitable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToStringVisitor<C, O, P, EL, PM, S, COA, SSA, CT>
extends AbstractVisitor<String, C, O, P, EL, PM, S, COA, SSA, CT> {
    private final Environment<?, C, O, P, EL, PM, S, COA, SSA, CT, ?, ?> env;
    private final UMLReflection<?, C, O, P, EL, PM, S, COA, SSA, CT> uml;
    protected static String NULL_PLACEHOLDER = "\"<null>\"";

    protected ToStringVisitor(Environment<?, C, O, P, EL, PM, S, COA, SSA, CT, ?, ?> env) {
        this.env = env;
        this.uml = env == null ? null : env.getUMLReflection();
    }

    public static <C, O, P, EL, PM, S, COA, SSA, CT> ToStringVisitor<C, O, P, EL, PM, S, COA, SSA, CT> getInstance(Environment<?, C, O, P, EL, PM, S, COA, SSA, CT, ?, ?> env) {
        return new ToStringVisitor<C, O, P, EL, PM, S, COA, SSA, CT>(env);
    }

    public static <C, O, P, EL, PM, S, COA, SSA, CT> ToStringVisitor<C, O, P, EL, PM, S, COA, SSA, CT> getInstance(TypedElement<C> element) {
        return new ToStringVisitor(Environment.Registry.INSTANCE.getEnvironmentFor(element));
    }

    protected String getName(Object named) {
        return this.uml == null ? NULL_PLACEHOLDER : this.uml.getName(named);
    }

    protected String getQualifiedName(Object named) {
        return this.uml == null ? NULL_PLACEHOLDER : this.uml.getQualifiedName(named);
    }

    @Override
    protected String handleOperationCallExp(OperationCallExp<C, O> oc, String sourceResult, List<String> argumentResults) {
        OCLExpression source = oc.getSource();
        Object sourceType = source != null ? source.getType() : null;
        O oper = oc.getReferredOperation();
        StringBuffer result = new StringBuffer();
        result.append(sourceResult);
        result.append(sourceType instanceof CollectionType ? "->" : ".");
        result.append(this.getName(oper));
        result.append('(');
        Iterator<String> iter = argumentResults.iterator();
        while (iter.hasNext()) {
            result.append(iter.next());
            if (!iter.hasNext()) continue;
            result.append(", ");
        }
        result.append(')');
        return this.maybeAtPre(oc, result.toString());
    }

    @Override
    public String visitEnumLiteralExp(EnumLiteralExp<C, EL> el) {
        EL l = el.getReferredEnumLiteral();
        return this.getQualifiedName(l);
    }

    @Override
    public String visitVariableExp(VariableExp<C, PM> v) {
        String result;
        Variable<C, PM> vd = v.getReferredVariable();
        String string = result = vd == null ? null : vd.getName();
        if (result == null) {
            result = NULL_PLACEHOLDER;
        }
        return result;
    }

    @Override
    protected String handlePropertyCallExp(PropertyCallExp<C, P> pc, String sourceResult, List<String> qualifierResults) {
        P property = pc.getReferredProperty();
        if (sourceResult == null) {
            return this.getName(property);
        }
        StringBuffer result = new StringBuffer(this.maybeAtPre(pc, String.valueOf(sourceResult) + "." + this.getName(property)));
        if (!qualifierResults.isEmpty()) {
            result.append('[');
            Iterator<String> iter = qualifierResults.iterator();
            while (iter.hasNext()) {
                result.append(iter.next());
                if (!iter.hasNext()) continue;
                result.append(", ");
            }
            result.append(']');
        }
        return result.toString();
    }

    @Override
    protected String handleAssociationClassCallExp(AssociationClassCallExp<C, P> ac, String sourceResult, List<String> qualifierResults) {
        C ref = ac.getReferredAssociationClass();
        String name = this.initialLower(this.getName(ref));
        StringBuffer result = new StringBuffer(this.maybeAtPre(ac, String.valueOf(sourceResult) + "." + name));
        if (!qualifierResults.isEmpty()) {
            result.append('[').append(qualifierResults.get(0)).append(']');
        }
        return result.toString();
    }

    protected String initialLower(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        StringBuffer result = new StringBuffer(name);
        result.setCharAt(0, Character.toLowerCase(result.charAt(0)));
        return result.toString();
    }

    @Override
    protected String handleVariable(Variable<C, PM> vd, String initResult) {
        String varName = vd.getName();
        if (varName == null) {
            varName = NULL_PLACEHOLDER;
        }
        Object type = vd.getType();
        String result = varName;
        if (type != null) {
            result = String.valueOf(result) + " : " + this.getName(type);
        }
        if (initResult != null) {
            result = String.valueOf(result) + " = " + initResult;
        }
        return result;
    }

    @Override
    protected String handleIfExp(IfExp<C> ifExp, String conditionResult, String thenResult, String elseResult) {
        StringBuffer result = new StringBuffer();
        result.append("if ").append(conditionResult);
        result.append(" then ").append(thenResult);
        result.append(" else ").append(elseResult);
        result.append(" endif");
        return result.toString();
    }

    @Override
    public String visitTypeExp(TypeExp<C> t) {
        return this.getQualifiedName(t.getReferredType());
    }

    @Override
    public String visitStateExp(StateExp<C, S> s) {
        return this.getName(s);
    }

    @Override
    public String visitUnspecifiedValueExp(UnspecifiedValueExp<C> uv) {
        StringBuffer result = new StringBuffer();
        result.append("?");
        if (uv.getType() != null && !(uv.getType() instanceof VoidType)) {
            result.append(" : ");
            result.append(this.getName(uv.getType()));
        }
        return result.toString();
    }

    @Override
    public String visitIntegerLiteralExp(IntegerLiteralExp<C> il) {
        return il.getIntegerSymbol() == null ? NULL_PLACEHOLDER : il.getIntegerSymbol().toString();
    }

    @Override
    public String visitUnlimitedNaturalLiteralExp(UnlimitedNaturalLiteralExp<C> unl) {
        if (unl.isUnlimited()) {
            return "*";
        }
        return unl.getIntegerSymbol() == null ? NULL_PLACEHOLDER : unl.getIntegerSymbol().toString();
    }

    @Override
    public String visitRealLiteralExp(RealLiteralExp<C> rl) {
        return rl.getRealSymbol() == null ? NULL_PLACEHOLDER : rl.getRealSymbol().toString();
    }

    @Override
    public String visitStringLiteralExp(StringLiteralExp<C> sl) {
        return "'" + (sl.getStringSymbol() == null ? NULL_PLACEHOLDER : sl.getStringSymbol()) + "'";
    }

    @Override
    public String visitBooleanLiteralExp(BooleanLiteralExp<C> bl) {
        return bl.getBooleanSymbol() == null ? NULL_PLACEHOLDER : bl.getBooleanSymbol().toString();
    }

    @Override
    protected String handleLetExp(LetExp<C, PM> letExp, String variableResult, String inResult) {
        StringBuffer result = new StringBuffer();
        result.append("let ").append(variableResult);
        result.append(" in ").append(inResult);
        return result.toString();
    }

    @Override
    protected String handleIterateExp(IterateExp<C, PM> callExp, String sourceResult, List<String> variableResults, String resultResult, String bodyResult) {
        StringBuffer result = new StringBuffer();
        result.append(sourceResult).append("->iterate(");
        Iterator<String> iter = variableResults.iterator();
        while (iter.hasNext()) {
            result.append(iter.next());
            if (!iter.hasNext()) continue;
            result.append(", ");
        }
        result.append("; ").append(resultResult).append(" | ");
        result.append(bodyResult).append(')');
        return result.toString();
    }

    @Override
    protected String handleIteratorExp(IteratorExp<C, PM> callExp, String sourceResult, List<String> variableResults, String bodyResult) {
        StringBuffer result = new StringBuffer();
        String name = callExp.getName();
        result.append(sourceResult).append("->").append(name).append('(');
        Iterator<String> iter = variableResults.iterator();
        while (iter.hasNext()) {
            result.append(iter.next());
            if (!iter.hasNext()) continue;
            result.append(", ");
        }
        result.append(" | ").append(bodyResult).append(')');
        return result.toString();
    }

    @Override
    protected String handleCollectionLiteralExp(CollectionLiteralExp<C> cl, List<String> partResults) {
        StringBuffer result = new StringBuffer();
        CollectionKind kind = cl.getKind();
        switch (kind) {
            case SET_LITERAL: {
                result.append("Set {");
                break;
            }
            case ORDERED_SET_LITERAL: {
                result.append("OrderedSet {");
                break;
            }
            case BAG_LITERAL: {
                result.append("Bag {");
                break;
            }
            case SEQUENCE_LITERAL: {
                result.append("Sequence {");
                break;
            }
            default: {
                result.append("Collection {");
            }
        }
        Iterator<String> iter = partResults.iterator();
        while (iter.hasNext()) {
            result.append(iter.next());
            if (!iter.hasNext()) continue;
            result.append(", ");
        }
        result.append('}');
        return result.toString();
    }

    @Override
    protected String handleCollectionItem(CollectionItem<C> item, String itemResult) {
        return itemResult;
    }

    @Override
    protected String handleCollectionRange(CollectionRange<C> range, String firstResult, String lastResult) {
        return String.valueOf(firstResult) + ".." + lastResult;
    }

    @Override
    protected String handleTupleLiteralExp(TupleLiteralExp<C, P> literalExp, List<String> partResults) {
        StringBuffer result = new StringBuffer();
        result.append("Tuple{");
        Iterator<String> iter = partResults.iterator();
        while (iter.hasNext()) {
            result.append(iter.next());
            if (!iter.hasNext()) continue;
            result.append(", ");
        }
        result.append('}');
        return result.toString();
    }

    @Override
    protected String handleTupleLiteralPart(TupleLiteralPart<C, P> part, String valueResult) {
        String varName = part.getName();
        Object type = part.getType();
        StringBuffer result = new StringBuffer();
        result.append(varName);
        if (type != null) {
            result.append(" : ").append(this.getName(type));
        }
        if (valueResult != null) {
            result.append(" = ").append(valueResult);
        }
        return result.toString();
    }

    @Override
    protected String handleMessageExp(MessageExp<C, COA, SSA> messageExp, String targetResult, List<String> argumentResults) {
        StringBuffer result = new StringBuffer();
        result.append(targetResult);
        result.append(messageExp.getType() instanceof CollectionType ? "^^" : "^");
        if (messageExp.getCalledOperation() != null) {
            result.append(this.getName(this.getOperation(messageExp.getCalledOperation())));
        } else if (messageExp.getSentSignal() != null) {
            result.append(this.getName(this.getSignal(messageExp.getSentSignal())));
        }
        result.append('(');
        Iterator<String> iter = argumentResults.iterator();
        while (iter.hasNext()) {
            result.append(iter.next());
            if (!iter.hasNext()) continue;
            result.append(", ");
        }
        result.append(')');
        return result.toString();
    }

    protected O getOperation(COA callOperationAction) {
        return this.uml == null ? null : (O)this.uml.getOperation(callOperationAction);
    }

    protected C getSignal(SSA sendSignalAction) {
        return this.uml == null ? null : (C)this.uml.getSignal(sendSignalAction);
    }

    @Override
    public String visitExpressionInOCL(ExpressionInOCL<C, PM> expression) {
        return (String)expression.getBodyExpression().accept(this);
    }

    @Override
    public String visitConstraint(CT constraint) {
        String stereo;
        StringBuffer result = new StringBuffer();
        List<EObject> constrained = this.getConstrainedElements(constraint);
        if (!constrained.isEmpty()) {
            EObject elem = constrained.get(0);
            result.append("context ");
            if (this.isClassifier(elem)) {
                result.append(this.getName(elem));
            } else if (this.isOperation(elem)) {
                EObject oper = elem;
                this.appendOperationSignature(result, oper);
            } else if (this.isProperty(elem)) {
                EObject prop = elem;
                this.appendPropertySignature(result, prop);
            }
            result.append(' ');
        }
        if ("precondition".equals(stereo = this.getStereotype(constraint))) {
            result.append("pre: ");
        } else if ("postcondition".equals(stereo)) {
            result.append("post: ");
        } else if ("body".equals(stereo)) {
            result.append("body: ");
        } else if ("initial".equals(stereo)) {
            result.append("init: ");
        } else if ("derivation".equals(stereo)) {
            result.append("derive: ");
        } else if ("postcondition".equals(stereo)) {
            result.append("def: ");
            EObject elem = constrained.get(1);
            if (this.isOperation(elem)) {
                EObject oper = elem;
                this.appendOperationSignature(result, oper);
            } else if (this.isProperty(elem)) {
                EObject prop = elem;
                this.appendPropertySignature(result, prop);
            }
            result.append(" = ");
        } else {
            result.append("inv ");
            result.append(this.getName(constraint));
            result.append(": ");
        }
        result.append(this.visit(this.getSpecification(constraint)));
        return result.toString();
    }

    protected boolean isClassifier(Object element) {
        return this.uml == null ? null : Boolean.valueOf(this.uml.isClassifier(element));
    }

    protected boolean isOperation(Object element) {
        return this.uml == null ? null : Boolean.valueOf(this.uml.isOperation(element));
    }

    protected boolean isProperty(Object element) {
        return this.uml == null ? null : Boolean.valueOf(this.uml.isProperty(element));
    }

    protected List<? extends EObject> getConstrainedElements(CT constraint) {
        return this.uml == null ? null : this.uml.getConstrainedElements(constraint);
    }

    protected String getStereotype(CT constraint) {
        return this.uml == null ? null : this.uml.getStereotype(constraint);
    }

    @Override
    protected ExpressionInOCL<C, PM> getSpecification(CT constraint) {
        return this.uml == null ? null : this.uml.getSpecification(constraint);
    }

    private void appendOperationSignature(StringBuffer buf, O operation) {
        buf.append(this.getName(operation)).append('(');
        boolean comma = false;
        for (PM parm : this.getParameters(operation)) {
            if (comma) {
                buf.append(", ");
            } else {
                comma = true;
            }
            buf.append(this.getName(parm)).append(" : ");
            if (this.getType(parm) != null) {
                buf.append(this.getName(this.getType(parm)));
                continue;
            }
            buf.append("OclVoid");
        }
        buf.append(") :");
        if (this.getType(operation) != null) {
            buf.append(' ').append(this.getName(this.getType(operation)));
        }
    }

    protected C getType(Object typedElement) {
        return this.uml == null ? null : (C)TypeUtil.resolveType(this.env, this.uml.getOCLType(typedElement));
    }

    protected List<PM> getParameters(O operation) {
        return this.uml == null ? null : this.uml.getParameters(operation);
    }

    private void appendPropertySignature(StringBuffer buf, P property) {
        buf.append(this.getName(property));
        if (this.getType(property) != null) {
            buf.append(" : ").append(this.getName(this.getType(property)));
        }
    }

    private String maybeAtPre(FeatureCallExp<C> mpc, String base) {
        return mpc.isMarkedPre() ? String.valueOf(base) + "@pre" : base;
    }

    @Override
    public String visitInvalidLiteralExp(InvalidLiteralExp<C> il) {
        return "invalid";
    }

    @Override
    public String visitNullLiteralExp(NullLiteralExp<C> il) {
        return "null";
    }

    private String visit(Visitable visitable) {
        return visitable == null ? NULL_PLACEHOLDER : (String)visitable.accept(this);
    }
}

