/* The following code was generated by JFlex 1.4.1 on 10/11/10 3:38 AM */

/*******************************************************************************
 * Copyright (c) 2006 Zend Corporation and IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Zend and IBM - Initial implementation
 *******************************************************************************/

package org.eclipse.php.internal.core.ast.scanner.php4;

import org.eclipse.php.internal.core.ast.nodes.AST;
import java.util.LinkedList;
import java.util.List;

import org.eclipse.php.internal.core.ast.nodes.Comment;
import java_cup.sym;
import java_cup.runtime.Symbol;
import org.eclipse.php.internal.core.ast.scanner.StateStack;
import org.eclipse.php.internal.core.ast.nodes.IDocumentorLexer;
import org.eclipse.php.internal.core.PHPVersion;



/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.1
 * on 10/11/10 3:38 AM from the specification file
 * <tt>ast_scanner.flex</tt>
 */
public class PhpAstLexer implements org.eclipse.php.internal.core.ast.scanner.AstLexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int ST_DOCBLOCK = 18;
  public static final int ST_IN_SCRIPTING = 2;
  public static final int ST_LOOKING_FOR_PROPERTY = 12;
  public static final int ST_SINGLE_QUOTE = 6;
  public static final int ST_ONE_LINE_COMMENT = 20;
  public static final int ST_COMMENT = 16;
  public static final int ST_BACKQUOTE = 8;
  public static final int ST_DOUBLE_QUOTES = 4;
  public static final int YYINITIAL = 0;
  public static final int ST_HEREDOC = 10;
  public static final int ST_LOOKING_FOR_VARNAME = 14;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  6,  7,  7,  8,  8, 
     9,  9, 10, 10, 11, 11
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\12\1\14\2\0\1\11\22\0\1\12\1\52\1\75\1\13"+
    "\1\67\1\56\1\57\1\76\1\42\1\44\1\54\1\4\1\63\1\36"+
    "\1\2\1\55\1\5\7\101\2\1\1\40\1\62\1\53\1\51\1\37"+
    "\1\70\1\71\1\33\1\7\1\26\1\17\1\3\1\23\1\43\1\32"+
    "\1\15\1\46\1\34\1\21\1\50\1\25\1\20\1\35\1\47\1\30"+
    "\1\27\1\16\1\24\1\41\1\31\1\6\1\45\1\10\1\64\1\77"+
    "\1\65\1\61\1\22\1\100\1\33\1\7\1\26\1\17\1\3\1\23"+
    "\1\43\1\32\1\15\1\46\1\34\1\21\1\50\1\25\1\20\1\35"+
    "\1\47\1\30\1\74\1\16\1\24\1\41\1\31\1\6\1\45\1\10"+
    "\1\72\1\60\1\73\1\66\201\10\uff00\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\14\0\2\1\1\2\1\3\1\4\1\5\1\6\1\3"+
    "\3\5\1\7\1\10\16\5\1\11\1\12\1\13\1\5"+
    "\1\14\1\5\1\15\1\16\1\17\1\20\1\21\1\22"+
    "\1\23\1\24\1\25\1\26\1\27\1\30\1\31\1\32"+
    "\1\33\1\34\1\35\1\36\1\37\1\40\1\41\1\42"+
    "\1\43\1\44\1\45\1\44\1\45\1\34\1\46\1\47"+
    "\1\50\1\2\2\51\1\52\1\2\1\51\1\2\1\53"+
    "\1\51\1\45\1\2\1\5\1\54\1\55\1\56\1\57"+
    "\1\7\1\60\3\7\3\61\2\60\1\0\1\62\1\63"+
    "\1\1\1\64\1\0\1\65\6\5\1\66\1\67\1\0"+
    "\2\5\1\70\4\5\1\71\1\5\1\72\20\5\1\73"+
    "\2\5\1\74\1\75\1\76\1\77\1\100\1\101\1\5"+
    "\12\0\1\5\1\102\1\103\2\104\1\105\1\106\1\0"+
    "\1\107\1\110\1\111\1\112\1\113\1\114\1\115\1\116"+
    "\1\117\1\120\1\121\1\122\1\0\1\123\4\0\1\75"+
    "\1\124\1\125\1\126\1\127\1\130\1\127\1\130\1\0"+
    "\2\131\1\0\1\132\1\133\1\134\1\135\2\0\1\64"+
    "\1\0\7\5\1\64\1\136\5\5\1\137\5\5\1\140"+
    "\2\5\1\141\1\142\10\5\1\143\2\5\1\144\1\145"+
    "\11\0\1\5\1\146\1\147\1\150\3\0\1\151\1\0"+
    "\2\112\2\122\1\44\2\130\2\0\1\5\1\152\5\5"+
    "\1\153\1\154\10\5\1\155\12\5\1\156\7\5\11\0"+
    "\1\5\2\0\1\157\3\0\2\5\1\160\4\5\1\161"+
    "\1\162\1\5\1\163\12\5\1\164\1\5\1\165\1\166"+
    "\4\5\1\167\1\170\1\171\3\0\1\172\7\0\1\5"+
    "\2\173\2\0\2\174\1\0\1\5\1\175\1\5\1\176"+
    "\3\5\1\177\12\5\1\200\1\201\1\202\1\5\2\0"+
    "\1\203\5\0\1\204\1\0\1\205\3\0\1\206\4\5"+
    "\1\207\1\210\1\211\5\5\1\212\2\5\1\213\3\0"+
    "\1\214\1\0\1\215\3\0\3\5\1\216\2\5\1\217"+
    "\1\220\2\5\1\221\1\222\1\5\1\223\1\224\4\0"+
    "\2\5\1\225\3\5\1\226\1\5\2\0\1\227\1\230"+
    "\4\5\2\0\4\5\3\0\1\231\1\232\1\233\1\234"+
    "\1\235\16\0\1\63\2\0";

  private static int [] zzUnpackAction() {
    int [] result = new int[506];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\102\0\204\0\306\0\u0108\0\u014a\0\u018c\0\u01ce"+
    "\0\u0210\0\u0252\0\u0294\0\u02d6\0\u0318\0\u035a\0\u039c\0\u03de"+
    "\0\u0420\0\u0462\0\u04a4\0\u04e6\0\u0528\0\u056a\0\u05ac\0\u05ee"+
    "\0\u039c\0\u0630\0\u0672\0\u06b4\0\u06f6\0\u0738\0\u077a\0\u07bc"+
    "\0\u07fe\0\u0840\0\u0882\0\u08c4\0\u0906\0\u0948\0\u098a\0\u09cc"+
    "\0\u0a0e\0\u0a50\0\u0a92\0\u0ad4\0\u0b16\0\u039c\0\u0b58\0\u0b9a"+
    "\0\u0bdc\0\u0c1e\0\u0c60\0\u0ca2\0\u0ce4\0\u0d26\0\u0d68\0\u039c"+
    "\0\u039c\0\u039c\0\u039c\0\u039c\0\u0daa\0\u0dec\0\u039c\0\u039c"+
    "\0\u039c\0\u0e2e\0\u0e70\0\u039c\0\u0eb2\0\u0ef4\0\u0f36\0\u0f78"+
    "\0\u0fba\0\u0ffc\0\u039c\0\u039c\0\u103e\0\u1080\0\u10c2\0\u039c"+
    "\0\u1104\0\u1146\0\u1188\0\u039c\0\u11ca\0\u120c\0\u124e\0\u1290"+
    "\0\u039c\0\u12d2\0\u039c\0\u1314\0\u1356\0\u1398\0\u039c\0\u13da"+
    "\0\u141c\0\u145e\0\u14a0\0\u039c\0\u039c\0\u14e2\0\u1524\0\u1566"+
    "\0\u15a8\0\u15ea\0\u162c\0\u166e\0\u039c\0\u16b0\0\u16f2\0\u1734"+
    "\0\u1776\0\u17b8\0\u17fa\0\u039c\0\u039c\0\u183c\0\u187e\0\u18c0"+
    "\0\u05ac\0\u1902\0\u1944\0\u1986\0\u19c8\0\u05ac\0\u1a0a\0\u05ac"+
    "\0\u1a4c\0\u1a8e\0\u1ad0\0\u1b12\0\u1b54\0\u1b96\0\u1bd8\0\u1c1a"+
    "\0\u1c5c\0\u1c9e\0\u1ce0\0\u1d22\0\u1d64\0\u1da6\0\u1de8\0\u1e2a"+
    "\0\u05ac\0\u1e6c\0\u1eae\0\u039c\0\u039c\0\u039c\0\u1ef0\0\u039c"+
    "\0\u039c\0\u1f32\0\u1f74\0\u0ad4\0\u1fb6\0\u1ff8\0\u203a\0\u207c"+
    "\0\u20be\0\u2100\0\u2142\0\u2184\0\u21c6\0\u039c\0\u2208\0\u224a"+
    "\0\u039c\0\u039c\0\u228c\0\u22ce\0\u039c\0\u039c\0\u2310\0\u2352"+
    "\0\u039c\0\u039c\0\u039c\0\u039c\0\u039c\0\u039c\0\u2394\0\u23d6"+
    "\0\u0e2e\0\u039c\0\u2418\0\u0e70\0\u245a\0\u249c\0\u0ef4\0\u039c"+
    "\0\u039c\0\u039c\0\u039c\0\u24de\0\u2520\0\u039c\0\u2562\0\u25a4"+
    "\0\u039c\0\u25e6\0\u039c\0\u039c\0\u039c\0\u039c\0\u2628\0\u266a"+
    "\0\u26ac\0\u26ac\0\u26ee\0\u2730\0\u2772\0\u27b4\0\u27f6\0\u2838"+
    "\0\u287a\0\u183c\0\u05ac\0\u28bc\0\u28fe\0\u2940\0\u2982\0\u29c4"+
    "\0\u05ac\0\u2a06\0\u2a48\0\u2a8a\0\u2acc\0\u2b0e\0\u2b50\0\u2b92"+
    "\0\u2bd4\0\u05ac\0\u05ac\0\u2c16\0\u2c58\0\u2c9a\0\u2cdc\0\u2d1e"+
    "\0\u2d60\0\u2da2\0\u2de4\0\u05ac\0\u2e26\0\u2e68\0\u039c\0\u05ac"+
    "\0\u2eaa\0\u2eec\0\u2f2e\0\u2f70\0\u2fb2\0\u2ff4\0\u3036\0\u3078"+
    "\0\u30ba\0\u30fc\0\u039c\0\u039c\0\u039c\0\u313e\0\u3180\0\u31c2"+
    "\0\u3204\0\u3246\0\u3288\0\u039c\0\u32ca\0\u039c\0\u249c\0\u330c"+
    "\0\u334e\0\u3390\0\u33d2\0\u3414\0\u3456\0\u3498\0\u34da\0\u351c"+
    "\0\u355e\0\u35a0\0\u05ac\0\u05ac\0\u35e2\0\u3624\0\u3666\0\u36a8"+
    "\0\u36ea\0\u372c\0\u376e\0\u37b0\0\u05ac\0\u37f2\0\u3834\0\u3876"+
    "\0\u38b8\0\u38fa\0\u393c\0\u397e\0\u39c0\0\u3a02\0\u3a44\0\u05ac"+
    "\0\u3a86\0\u3ac8\0\u3b0a\0\u3b4c\0\u3b8e\0\u3bd0\0\u3c12\0\u3c54"+
    "\0\u3c96\0\u3cd8\0\u3d1a\0\u3d5c\0\u3d9e\0\u3de0\0\u3e22\0\u3e64"+
    "\0\u3ea6\0\u3ee8\0\u3f2a\0\u039c\0\u3f6c\0\u3fae\0\u3ff0\0\u4032"+
    "\0\u4074\0\u05ac\0\u40b6\0\u40f8\0\u413a\0\u417c\0\u05ac\0\u05ac"+
    "\0\u41be\0\u05ac\0\u4200\0\u4242\0\u4284\0\u42c6\0\u4308\0\u434a"+
    "\0\u438c\0\u43ce\0\u4410\0\u4452\0\u05ac\0\u4494\0\u05ac\0\u05ac"+
    "\0\u44d6\0\u4518\0\u455a\0\u459c\0\u05ac\0\u05ac\0\u05ac\0\u45de"+
    "\0\u4620\0\u4662\0\u039c\0\u46a4\0\u46e6\0\u4728\0\u476a\0\u47ac"+
    "\0\u47ee\0\u4830\0\u4872\0\u48b4\0\u039c\0\u48f6\0\u4938\0\u497a"+
    "\0\u039c\0\u49bc\0\u49fe\0\u05ac\0\u4a40\0\u4a82\0\u4ac4\0\u4b06"+
    "\0\u4b48\0\u05ac\0\u4b8a\0\u4bcc\0\u4c0e\0\u4c50\0\u4c92\0\u4cd4"+
    "\0\u4d16\0\u4d58\0\u4d9a\0\u4ddc\0\u05ac\0\u05ac\0\u05ac\0\u4e1e"+
    "\0\u4e60\0\u4ea2\0\u039c\0\u4ee4\0\u4f26\0\u4f68\0\u4faa\0\u4fec"+
    "\0\u039c\0\u502e\0\u05ac\0\u5070\0\u50b2\0\u50f4\0\u05ac\0\u5136"+
    "\0\u5178\0\u51ba\0\u51fc\0\u523e\0\u05ac\0\u05ac\0\u5280\0\u52c2"+
    "\0\u5304\0\u5346\0\u5388\0\u05ac\0\u53ca\0\u540c\0\u544e\0\u5490"+
    "\0\u54d2\0\u5514\0\u039c\0\u5556\0\u039c\0\u5598\0\u55da\0\u561c"+
    "\0\u565e\0\u56a0\0\u56e2\0\u05ac\0\u5724\0\u5766\0\u05ac\0\u05ac"+
    "\0\u57a8\0\u57ea\0\u05ac\0\u05ac\0\u582c\0\u039c\0\u039c\0\u586e"+
    "\0\u58b0\0\u58f2\0\u5934\0\u5976\0\u59b8\0\u05ac\0\u59fa\0\u5a3c"+
    "\0\u5a7e\0\u05ac\0\u5ac0\0\u5b02\0\u5b44\0\u05ac\0\u05ac\0\u5b86"+
    "\0\u5bc8\0\u5c0a\0\u5c4c\0\u5c8e\0\u5cd0\0\u5d12\0\u5d54\0\u5d96"+
    "\0\u5dd8\0\u5e1a\0\u5e5c\0\u5e9e\0\u05ac\0\u05ac\0\u05ac\0\u05ac"+
    "\0\u039c\0\u5ee0\0\u5f22\0\u5f64\0\u5fa6\0\u5fe8\0\u602a\0\u606c"+
    "\0\u60ae\0\u60f0\0\u6132\0\u6174\0\u61b6\0\u61f8\0\u623a\0\u039c"+
    "\0\u627c\0\u62be";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[506];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\53\15\1\16\26\15\1\17\1\20\1\21\1\22\1\23"+
    "\1\24\1\25\1\26\1\27\2\30\1\31\1\30\1\32"+
    "\1\27\1\33\1\34\1\35\1\36\1\37\1\40\1\41"+
    "\1\42\1\43\1\44\1\45\1\27\1\46\1\27\1\47"+
    "\1\50\1\51\1\52\1\53\1\54\1\55\1\56\4\27"+
    "\1\57\1\60\1\61\1\62\1\63\1\64\1\65\1\66"+
    "\1\67\1\70\1\71\1\72\1\73\1\74\1\75\1\76"+
    "\1\77\1\100\1\101\1\43\1\102\1\103\1\17\1\104"+
    "\1\20\1\17\1\105\1\106\1\27\1\106\1\107\3\27"+
    "\4\106\21\27\1\110\2\106\1\27\1\106\1\27\1\106"+
    "\4\27\13\106\1\72\1\73\1\106\1\111\2\106\1\112"+
    "\1\113\1\27\1\114\1\106\1\115\1\116\1\105\76\117"+
    "\1\120\1\121\2\117\1\17\1\105\1\106\1\27\1\106"+
    "\1\107\3\27\4\106\21\27\1\110\2\106\1\27\1\106"+
    "\1\27\1\106\4\27\13\106\1\72\1\73\1\106\1\111"+
    "\2\106\1\112\1\113\1\27\1\122\1\106\1\123\1\124"+
    "\1\105\1\17\1\105\1\106\1\27\1\106\1\107\3\27"+
    "\4\106\21\27\1\110\2\106\1\27\1\106\1\27\1\106"+
    "\4\27\13\106\1\72\1\73\1\106\1\111\2\106\1\112"+
    "\1\113\1\27\1\125\1\126\1\127\1\125\1\105\1\17"+
    "\1\105\1\106\1\130\1\106\1\107\3\130\4\106\21\130"+
    "\1\110\2\106\1\130\1\106\1\130\1\106\4\130\13\106"+
    "\1\72\1\73\1\106\1\111\2\106\1\112\1\113\1\130"+
    "\1\125\1\126\1\127\1\125\1\105\3\131\1\132\2\131"+
    "\3\132\4\131\21\132\3\131\1\132\1\131\1\132\1\131"+
    "\4\132\23\131\1\132\5\131\3\133\1\134\2\133\3\134"+
    "\4\133\21\134\3\133\1\134\1\133\1\134\1\133\4\134"+
    "\23\133\1\134\5\133\54\135\1\136\25\135\11\137\1\140"+
    "\42\137\1\141\25\137\11\142\1\143\2\142\1\144\22\142"+
    "\1\145\16\142\1\146\11\142\1\146\11\142\53\15\1\147"+
    "\101\15\1\0\2\15\1\150\11\15\1\151\3\15\1\152"+
    "\5\15\103\0\1\20\1\153\1\154\1\0\1\20\73\0"+
    "\1\20\1\0\1\153\3\0\1\153\43\0\1\155\27\0"+
    "\1\153\1\0\1\27\1\0\1\27\1\0\1\27\1\156"+
    "\2\27\4\0\4\27\1\157\3\27\1\160\1\161\7\27"+
    "\3\0\1\162\1\0\1\27\1\0\3\27\1\163\23\0"+
    "\1\27\4\0\1\27\4\0\1\164\44\0\1\165\31\0"+
    "\1\20\1\153\1\154\1\0\1\20\1\166\72\0\1\20"+
    "\1\0\1\27\1\0\1\27\1\0\4\27\4\0\3\27"+
    "\1\167\15\27\3\0\1\27\1\0\1\27\1\0\4\27"+
    "\23\0\1\27\4\0\1\27\1\0\1\27\1\0\1\27"+
    "\1\0\4\27\4\0\13\27\1\170\5\27\3\0\1\27"+
    "\1\0\1\27\1\0\4\27\23\0\1\27\4\0\1\27"+
    "\1\0\1\27\1\0\1\27\1\0\4\27\4\0\21\27"+
    "\3\0\1\27\1\0\1\27\1\0\4\27\23\0\1\27"+
    "\4\0\1\27\11\0\2\30\1\0\1\30\66\0\1\27"+
    "\1\0\1\27\1\0\4\27\4\0\6\27\1\171\1\27"+
    "\1\172\1\27\1\173\6\27\3\0\1\27\1\0\1\27"+
    "\1\0\4\27\23\0\1\173\4\0\1\27\1\0\1\27"+
    "\1\0\1\174\1\0\4\27\4\0\1\175\2\27\1\176"+
    "\15\27\3\0\1\27\1\0\1\27\1\0\4\27\23\0"+
    "\1\27\4\0\1\27\1\0\1\27\1\0\1\27\1\0"+
    "\4\27\4\0\4\27\1\177\6\27\1\200\5\27\3\0"+
    "\1\27\1\0\1\27\1\0\4\27\23\0\1\27\4\0"+
    "\1\27\1\0\1\27\1\0\1\27\1\0\4\27\4\0"+
    "\1\201\20\27\3\0\1\27\1\0\1\27\1\0\4\27"+
    "\23\0\1\27\4\0\1\27\1\0\1\27\1\0\1\27"+
    "\1\0\4\27\4\0\5\27\1\202\13\27\3\0\1\27"+
    "\1\0\1\27\1\0\4\27\23\0\1\27\4\0\1\27"+
    "\1\0\1\27\1\0\1\27\1\0\4\27\4\0\3\27"+
    "\1\203\3\27\1\204\11\27\3\0\1\27\1\0\1\27"+
    "\1\0\4\27\23\0\1\27\4\0\1\27\1\0\1\27"+
    "\1\0\1\27\1\0\4\27\4\0\10\27\1\205\1\27"+
    "\1\206\6\27\3\0\1\27\1\0\1\27\1\0\4\27"+
    "\23\0\1\206\4\0\1\27\1\0\1\27\1\0\1\207"+
    "\1\0\4\27\4\0\21\27\3\0\1\27\1\0\1\27"+
    "\1\0\4\27\23\0\1\27\4\0\1\27\1\0\1\27"+
    "\1\0\1\27\1\0\4\27\4\0\3\27\1\210\1\211"+
    "\1\27\1\212\7\27\1\213\2\27\3\0\1\27\1\0"+
    "\1\27\1\0\4\27\23\0\1\27\4\0\1\27\1\0"+
    "\1\27\1\0\1\27\1\0\4\27\4\0\1\27\1\214"+
    "\12\27\1\215\4\27\3\0\1\27\1\0\1\27\1\0"+
    "\4\27\23\0\1\27\4\0\1\27\1\0\1\27\1\0"+
    "\1\216\1\0\4\27\4\0\21\27\3\0\1\27\1\0"+
    "\1\27\1\0\4\27\23\0\1\27\4\0\1\27\1\0"+
    "\1\27\1\0\1\27\1\0\4\27\4\0\15\27\1\217"+
    "\3\27\3\0\1\27\1\0\1\27\1\0\4\27\23\0"+
    "\1\27\4\0\1\27\1\0\1\27\1\0\1\27\1\0"+
    "\4\27\4\0\10\27\1\220\1\27\1\221\1\222\5\27"+
    "\3\0\1\27\1\0\1\27\1\0\4\27\23\0\1\221"+
    "\4\0\1\27\1\0\1\27\1\0\1\27\1\0\4\27"+
    "\4\0\13\27\1\223\5\27\3\0\1\27\1\0\1\27"+
    "\1\0\4\27\23\0\1\27\4\0\1\27\36\0\1\224"+
    "\1\225\11\0\1\226\67\0\1\227\11\0\1\230\70\0"+
    "\1\231\42\0\1\27\1\0\1\27\1\0\4\27\4\0"+
    "\16\27\1\232\2\27\3\0\1\27\1\0\1\27\1\0"+
    "\4\27\23\0\1\27\4\0\1\27\7\0\1\233\2\0"+
    "\1\234\2\0\1\235\1\0\1\236\1\237\2\0\1\240"+
    "\1\241\2\0\1\242\1\243\2\0\1\244\40\0\1\242"+
    "\6\0\1\27\1\0\1\27\1\0\4\27\4\0\4\27"+
    "\1\245\14\27\3\0\1\27\1\0\1\27\1\0\4\27"+
    "\23\0\1\27\4\0\1\27\37\0\1\246\11\0\1\247"+
    "\101\0\1\250\67\0\1\251\11\0\1\252\1\0\1\253"+
    "\1\0\1\254\75\0\1\255\101\0\1\256\2\0\1\257"+
    "\1\31\63\0\1\260\11\0\1\261\101\0\1\262\5\0"+
    "\1\263\73\0\1\264\6\0\1\265\72\0\1\266\33\0"+
    "\1\267\2\0\3\267\4\0\21\267\3\0\1\267\1\0"+
    "\1\267\1\0\4\267\23\0\1\267\44\0\1\270\42\0"+
    "\67\271\1\0\5\271\1\272\1\271\1\273\2\271\76\274"+
    "\1\272\1\275\2\274\1\0\1\105\3\0\1\105\73\0"+
    "\1\105\2\0\1\106\1\0\1\106\4\0\4\106\21\0"+
    "\3\106\1\0\1\106\1\0\1\106\4\0\13\106\2\0"+
    "\1\106\1\0\2\106\4\0\1\106\4\0\1\105\3\0"+
    "\1\105\1\276\72\0\1\105\2\0\1\106\1\0\1\106"+
    "\4\0\4\106\21\0\1\106\1\277\1\106\1\0\1\106"+
    "\1\0\1\106\4\0\13\106\2\0\1\106\1\0\2\106"+
    "\4\0\1\106\3\0\3\300\1\267\2\300\3\267\4\300"+
    "\21\267\3\300\1\267\1\300\1\267\1\300\4\267\21\300"+
    "\1\301\1\300\1\267\5\300\67\0\1\302\12\0\5\303"+
    "\1\304\1\305\66\303\1\306\3\303\1\304\100\0\1\116"+
    "\1\0\76\117\1\0\1\307\100\117\2\306\2\117\75\0"+
    "\1\122\4\0\5\303\1\304\1\305\71\303\1\306\1\304"+
    "\75\0\2\125\1\0\1\125\3\0\1\106\1\0\1\106"+
    "\4\0\4\106\21\0\3\106\1\0\1\106\1\0\1\106"+
    "\4\0\13\106\2\0\1\106\1\0\2\106\3\0\1\125"+
    "\1\126\1\0\1\125\1\0\5\303\1\304\1\305\72\303"+
    "\1\304\1\0\1\130\1\0\1\130\1\0\4\130\1\310"+
    "\2\0\1\311\21\130\3\0\1\130\1\0\1\130\1\0"+
    "\4\130\11\0\1\312\11\0\1\130\4\0\1\130\1\0"+
    "\1\132\1\0\1\132\1\0\4\132\4\0\21\132\3\0"+
    "\1\132\1\0\1\132\1\0\4\132\23\0\1\132\4\0"+
    "\1\132\1\0\1\134\1\0\1\134\1\0\4\134\4\0"+
    "\21\134\3\0\1\134\1\0\1\134\1\0\4\134\23\0"+
    "\1\134\4\0\1\134\54\135\1\0\25\135\55\0\1\313"+
    "\40\0\1\137\142\0\1\314\24\0\11\142\1\143\2\142"+
    "\1\144\22\142\1\144\16\142\1\144\11\142\1\144\11\142"+
    "\14\0\1\144\124\0\1\315\42\0\53\15\1\0\2\15"+
    "\1\0\11\15\1\0\3\15\1\0\5\15\51\0\1\316"+
    "\65\0\1\317\13\0\1\316\56\0\1\320\54\0\1\153"+
    "\1\0\1\154\1\0\1\153\73\0\1\153\1\0\1\321"+
    "\2\0\1\322\1\321\30\0\1\322\42\0\1\321\1\0"+
    "\1\27\1\0\1\27\1\0\4\27\4\0\1\323\1\324"+
    "\17\27\3\0\1\27\1\0\1\27\1\0\4\27\23\0"+
    "\1\27\4\0\1\27\1\0\1\27\1\0\1\27\1\0"+
    "\4\27\4\0\12\27\1\325\6\27\3\0\1\27\1\0"+
    "\1\27\1\0\4\27\23\0\1\325\4\0\1\27\1\0"+
    "\1\27\1\0\1\27\1\0\4\27\4\0\2\27\1\326"+
    "\16\27\3\0\1\27\1\0\1\27\1\0\4\27\23\0"+
    "\1\27\4\0\1\27\1\0\1\27\1\0\1\27\1\0"+
    "\4\27\4\0\15\27\1\327\3\27\3\0\1\27\1\0"+
    "\1\27\1\0\4\27\23\0\1\27\4\0\1\27\1\0"+
    "\1\27\1\0\1\27\1\0\4\27\4\0\16\27\1\330"+
    "\2\27\3\0\1\27\1\0\1\27\1\0\4\27\23\0"+
    "\1\27\4\0\1\27\1\0\1\27\1\0\1\27\1\0"+
    "\4\27\4\0\20\27\1\331\3\0\1\27\1\0\1\27"+
    "\1\0\4\27\23\0\1\27\4\0\1\27\1\0\1\332"+
    "\1\0\1\332\1\0\1\332\1\0\1\332\7\0\1\332"+
    "\3\0\1\332\2\0\1\332\4\0\1\332\45\0\1\332"+
    "\1\0\1\27\1\0\1\27\1\0\4\27\4\0\13\27"+
    "\1\333\5\27\3\0\1\27\1\0\1\27\1\0\4\27"+
    "\23\0\1\27\4\0\1\27\1\0\1\27\1\0\1\334"+
    "\1\0\4\27\4\0\21\27\3\0\1\27\1\0\1\27"+
    "\1\0\4\27\23\0\1\27\4\0\1\27\1\0\1\27"+
    "\1\0\1\27\1\0\4\27\4\0\11\27\1\335\7\27"+
    "\3\0\1\27\1\0\1\27\1\0\4\27\23\0\1\27"+
    "\4\0\1\27\1\0\1\27\1\0\1\27\1\0\4\27"+
    "\4\0\12\27\1\336\6\27\3\0\1\27\1\0\1\27"+
    "\1\0\4\27\23\0\1\336\4\0\1\27\1\0\1\27"+
    "\1\0\1\27\1\0\4\27\4\0\6\27\1\337\2\27"+
    "\1\340\7\27\3\0\1\27\1\0\1\27\1\0\4\27"+
    "\23\0\1\27\4\0\1\27\1\0\1\27\1\0\1\341"+
    "\1\0\4\27\4\0\21\27\3\0\1\27\1\0\1\27"+
    "\1\0\4\27\23\0\1\27\4\0\1\27\1\0\1\27"+
    "\1\0\1\27\1\0\4\27\4\0\2\27\1\342\16\27"+
    "\3\0\1\27\1\0\1\27\1\0\4\27\23\0\1\27"+
    "\4\0\1\27\1\0\1\27\1\0\1\27\1\0\4\27"+
    "\4\0\12\27\1\343\6\27\3\0\1\27\1\0\1\27"+
    "\1\0\4\27\23\0\1\343\4\0\1\27\1\0\1\27"+
    "\1\0\1\27\1\0\4\27\4\0\4\27\1\344\1\27"+
    "\1\345\2\27\1\346\7\27\3\0\1\27\1\0\1\27"+
    "\1\0\4\27\23\0\1\27\4\0\1\27\1\0\1\27"+
    "\1\0\1\27\1\0\4\27\4\0\13\27\1\347\5\27"+
    "\3\0\1\27\1\0\1\27\1\0\4\27\23\0\1\27"+
    "\4\0\1\27\1\0\1\27\1\0\1\27\1\0\4\27"+
    "\4\0\10\27\1\350\10\27\3\0\1\27\1\0\1\27"+
    "\1\0\4\27\23\0\1\27\4\0\1\27\1\0\1\27"+
    "\1\0\1\27\1\0\4\27\4\0\12\27\1\351\6\27"+
    "\3\0\1\27\1\0\1\27\1\0\4\27\23\0\1\351"+
    "\4\0\1\27\1\0\1\27\1\0\1\352\1\0\4\27"+
    "\4\0\21\27\3\0\1\27\1\0\1\27\1\0\4\27"+
    "\23\0\1\27\4\0\1\27\1\0\1\27\1\0\1\27"+
    "\1\0\4\27\4\0\14\27\1\353\4\27\3\0\1\27"+
    "\1\0\1\27\1\0\4\27\23\0\1\27\4\0\1\27"+
    "\1\0\1\27\1\0\1\27\1\0\4\27\4\0\10\27"+
    "\1\354\10\27\3\0\1\27\1\0\1\27\1\0\4\27"+
    "\23\0\1\27\4\0\1\27\1\0\1\27\1\0\1\27"+
    "\1\0\4\27\4\0\16\27\1\355\2\27\3\0\1\27"+
    "\1\0\1\27\1\0\4\27\23\0\1\27\4\0\1\27"+
    "\1\0\1\27\1\0\1\27\1\0\4\27\4\0\7\27"+
    "\1\204\11\27\3\0\1\27\1\0\1\27\1\0\4\27"+
    "\23\0\1\27\4\0\1\27\1\0\1\27\1\0\1\27"+
    "\1\0\4\27\4\0\12\27\1\356\6\27\3\0\1\27"+
    "\1\0\1\27\1\0\4\27\23\0\1\356\4\0\1\27"+
    "\1\0\1\27\1\0\1\27\1\0\4\27\4\0\16\27"+
    "\1\357\2\27\3\0\1\27\1\0\1\27\1\0\4\27"+
    "\23\0\1\27\4\0\1\27\1\0\1\27\1\0\1\27"+
    "\1\0\4\27\4\0\1\360\20\27\3\0\1\27\1\0"+
    "\1\27\1\0\4\27\23\0\1\27\4\0\1\27\1\0"+
    "\1\27\1\0\1\27\1\0\4\27\4\0\1\27\1\361"+
    "\17\27\3\0\1\27\1\0\1\27\1\0\2\27\1\362"+
    "\1\27\23\0\1\27\4\0\1\27\1\0\1\27\1\0"+
    "\1\27\1\0\4\27\4\0\1\363\20\27\3\0\1\27"+
    "\1\0\1\27\1\0\4\27\23\0\1\27\4\0\1\27"+
    "\1\0\1\27\1\0\1\27\1\0\4\27\4\0\2\27"+
    "\1\364\16\27\3\0\1\27\1\0\1\27\1\0\4\27"+
    "\23\0\1\27\4\0\1\27\1\0\1\27\1\0\1\27"+
    "\1\0\4\27\4\0\13\27\1\365\5\27\3\0\1\27"+
    "\1\0\1\27\1\0\4\27\23\0\1\27\4\0\1\27"+
    "\1\0\1\27\1\0\1\27\1\0\4\27\4\0\1\366"+
    "\20\27\3\0\1\27\1\0\1\27\1\0\4\27\23\0"+
    "\1\27\4\0\1\27\51\0\1\367\31\0\1\27\1\0"+
    "\1\27\1\0\4\27\4\0\13\27\1\370\5\27\3\0"+
    "\1\27\1\0\1\27\1\0\4\27\23\0\1\27\4\0"+
    "\1\27\20\0\1\371\106\0\1\372\74\0\1\373\70\0"+
    "\1\374\113\0\1\375\105\0\1\376\72\0\1\377\66\0"+
    "\1\u0100\126\0\1\u0101\52\0\1\27\1\0\1\27\1\0"+
    "\4\27\4\0\3\27\1\u0102\15\27\3\0\1\27\1\0"+
    "\1\27\1\0\4\27\23\0\1\27\4\0\1\27\51\0"+
    "\1\u0103\101\0\1\u0104\101\0\1\u0105\1\0\1\u0106\55\0"+
    "\1\u0107\44\0\1\u0107\16\0\2\u0108\1\0\1\u0108\37\0"+
    "\1\u0109\14\0\1\u010a\21\0\1\u010b\2\0\1\u010c\66\0"+
    "\1\267\1\0\1\267\1\0\4\267\4\0\21\267\3\0"+
    "\1\267\1\0\1\267\1\0\4\267\23\0\1\267\4\0"+
    "\1\267\11\0\1\u010d\2\0\1\u010e\65\0\14\271\1\0"+
    "\65\271\14\274\1\0\65\274\1\0\1\u010f\1\0\1\u010f"+
    "\1\0\1\u010f\1\0\1\u010f\7\0\1\u010f\3\0\1\u010f"+
    "\2\0\1\u010f\4\0\1\u010f\45\0\1\u010f\5\0\1\u0110"+
    "\73\0\1\u0110\1\0\1\u0111\1\0\1\u0111\1\0\1\u0111"+
    "\1\0\1\u0111\7\0\1\u0111\3\0\1\u0111\2\0\1\u0111"+
    "\4\0\1\u0111\45\0\1\u0111\76\117\2\0\2\117\14\0"+
    "\1\311\76\0\1\310\2\0\1\311\117\0\1\u0112\77\0"+
    "\1\u0113\52\0\1\321\3\0\1\321\73\0\1\321\1\0"+
    "\1\27\1\0\1\27\1\0\4\27\4\0\1\27\1\341"+
    "\17\27\3\0\1\27\1\0\1\27\1\0\4\27\23\0"+
    "\1\27\4\0\1\27\1\0\1\27\1\0\1\u0114\1\0"+
    "\4\27\4\0\21\27\3\0\1\27\1\0\1\27\1\0"+
    "\4\27\23\0\1\27\4\0\1\27\1\0\1\27\1\0"+
    "\1\u0115\1\0\4\27\4\0\21\27\3\0\1\27\1\0"+
    "\1\27\1\0\4\27\23\0\1\27\4\0\1\27\1\0"+
    "\1\27\1\0\1\27\1\0\4\27\4\0\1\u0116\1\27"+
    "\1\u0117\3\27\1\u0118\3\27\1\u0119\1\27\1\u011a\4\27"+
    "\3\0\1\27\1\0\1\27\1\0\4\27\23\0\1\u0119"+
    "\4\0\1\27\1\0\1\27\1\0\1\27\1\0\4\27"+
    "\4\0\3\27\1\u011b\15\27\3\0\1\27\1\0\1\27"+
    "\1\0\4\27\23\0\1\27\4\0\1\27\1\0\1\27"+
    "\1\0\1\27\1\0\4\27\4\0\4\27\1\u011c\14\27"+
    "\3\0\1\27\1\0\1\27\1\0\4\27\23\0\1\27"+
    "\4\0\1\27\1\0\1\27\1\0\1\27\1\0\4\27"+
    "\4\0\1\27\1\u011d\17\27\3\0\1\27\1\0\1\27"+
    "\1\0\4\27\23\0\1\27\4\0\1\27\1\0\1\27"+
    "\1\0\1\27\1\0\4\27\4\0\16\27\1\u011e\2\27"+
    "\3\0\1\27\1\0\1\27\1\0\4\27\23\0\1\27"+
    "\4\0\1\27\1\0\1\27\1\0\1\27\1\0\4\27"+
    "\4\0\4\27\1\u011f\14\27\3\0\1\27\1\0\1\27"+
    "\1\0\4\27\23\0\1\27\4\0\1\27\1\0\1\27"+
    "\1\0\1\u0120\1\0\4\27\4\0\21\27\3\0\1\27"+
    "\1\0\1\27\1\0\4\27\23\0\1\27\4\0\1\27"+
    "\1\0\1\27\1\0\1\27\1\0\4\27\4\0\1\u0121"+
    "\15\27\1\u0122\2\27\3\0\1\27\1\0\1\27\1\0"+
    "\4\27\23\0\1\27\4\0\1\27\1\0\1\27\1\0"+
    "\1\27\1\0\4\27\4\0\4\27\1\u0123\14\27\3\0"+
    "\1\27\1\0\1\27\1\0\4\27\23\0\1\27\4\0"+
    "\1\27\1\0\1\27\1\0\1\27\1\0\4\27\4\0"+
    "\5\27\1\u0124\13\27\3\0\1\27\1\0\1\27\1\0"+
    "\4\27\23\0\1\27\4\0\1\27\1\0\1\27\1\0"+
    "\1\27\1\0\4\27\4\0\1\27\1\u0125\17\27\3\0"+
    "\1\27\1\0\1\27\1\0\4\27\23\0\1\27\4\0"+
    "\1\27\1\0\1\27\1\0\1\27\1\0\4\27\4\0"+
    "\1\u0126\20\27\3\0\1\27\1\0\1\27\1\0\4\27"+
    "\23\0\1\27\4\0\1\27\1\0\1\27\1\0\1\27"+
    "\1\0\4\27\4\0\1\u0127\6\27\1\u0128\11\27\3\0"+
    "\1\27\1\0\1\27\1\0\4\27\23\0\1\27\4\0"+
    "\1\27\1\0\1\27\1\0\1\27\1\0\4\27\4\0"+
    "\4\27\1\u0129\14\27\3\0\1\27\1\0\1\27\1\0"+
    "\4\27\23\0\1\27\4\0\1\27\1\0\1\27\1\0"+
    "\1\u012a\1\0\4\27\4\0\21\27\3\0\1\27\1\0"+
    "\1\27\1\0\4\27\23\0\1\27\4\0\1\27\1\0"+
    "\1\27\1\0\1\27\1\0\4\27\4\0\11\27\1\u012b"+
    "\7\27\3\0\1\27\1\0\1\27\1\0\4\27\23\0"+
    "\1\27\4\0\1\27\1\0\1\27\1\0\1\u012c\1\0"+
    "\4\27\4\0\21\27\3\0\1\27\1\0\1\27\1\0"+
    "\4\27\23\0\1\27\4\0\1\27\1\0\1\27\1\0"+
    "\1\27\1\0\4\27\4\0\1\27\1\u012d\10\27\1\u012e"+
    "\6\27\3\0\1\27\1\0\1\27\1\0\4\27\23\0"+
    "\1\u012e\4\0\1\27\1\0\1\27\1\0\1\27\1\0"+
    "\4\27\4\0\12\27\1\u012f\6\27\3\0\1\27\1\0"+
    "\1\27\1\0\4\27\23\0\1\u012f\4\0\1\27\1\0"+
    "\1\27\1\0\1\u0130\1\0\4\27\4\0\21\27\3\0"+
    "\1\27\1\0\1\27\1\0\4\27\23\0\1\27\4\0"+
    "\1\27\1\0\1\27\1\0\1\27\1\0\4\27\4\0"+
    "\1\27\1\u0131\17\27\3\0\1\27\1\0\1\27\1\0"+
    "\4\27\23\0\1\27\4\0\1\27\1\0\1\27\1\0"+
    "\1\27\1\0\4\27\4\0\1\27\1\u0132\17\27\3\0"+
    "\1\27\1\0\1\27\1\0\4\27\23\0\1\27\4\0"+
    "\1\27\1\0\1\27\1\0\1\27\1\0\4\27\4\0"+
    "\7\27\1\u0133\11\27\3\0\1\27\1\0\1\27\1\0"+
    "\4\27\23\0\1\27\4\0\1\27\1\0\1\27\1\0"+
    "\1\27\1\0\4\27\4\0\7\27\1\u0134\11\27\3\0"+
    "\1\27\1\0\1\27\1\0\4\27\23\0\1\27\4\0"+
    "\1\27\1\0\1\27\1\0\1\27\1\0\4\27\4\0"+
    "\4\27\1\u0135\14\27\3\0\1\27\1\0\1\27\1\0"+
    "\4\27\23\0\1\27\4\0\1\27\1\0\1\27\1\0"+
    "\1\27\1\0\4\27\4\0\16\27\1\u0136\2\27\3\0"+
    "\1\27\1\0\1\27\1\0\4\27\23\0\1\27\4\0"+
    "\1\27\1\0\1\27\1\0\1\27\1\0\4\27\4\0"+
    "\10\27\1\u0137\10\27\3\0\1\27\1\0\1\27\1\0"+
    "\4\27\23\0\1\27\4\0\1\27\20\0\1\u0138\77\0"+
    "\1\u0139\107\0\1\u013a\123\0\1\u013b\53\0\1\u013c\110\0"+
    "\1\u013d\44\0\1\u013d\35\0\1\u013e\104\0\1\u013f\76\0"+
    "\1\u0140\52\0\1\27\1\0\1\27\1\0\2\27\1\u0141"+
    "\1\27\4\0\21\27\3\0\1\27\1\0\1\27\1\0"+
    "\4\27\23\0\1\27\4\0\1\27\3\0\1\u0142\2\0"+
    "\3\u0142\1\0\1\u0106\2\0\21\u0142\3\0\1\u0142\1\0"+
    "\1\u0142\1\0\4\u0142\23\0\1\u0142\33\0\1\u0143\64\0"+
    "\2\u0108\1\0\1\u0108\54\0\1\u010a\65\0\1\u0144\65\0"+
    "\1\u0145\54\0\1\u010c\101\0\1\u010e\72\0\1\306\73\0"+
    "\1\306\1\0\1\306\1\0\1\306\1\0\1\306\1\0"+
    "\1\306\7\0\1\306\3\0\1\306\2\0\1\306\4\0"+
    "\1\306\45\0\1\306\35\0\1\u0146\61\0\1\u0147\65\0"+
    "\1\27\1\0\1\27\1\0\4\27\4\0\10\27\1\u0148"+
    "\10\27\3\0\1\27\1\0\1\27\1\0\4\27\23\0"+
    "\1\27\4\0\1\27\1\0\1\27\1\0\1\27\1\0"+
    "\4\27\4\0\1\u0149\20\27\3\0\1\27\1\0\1\27"+
    "\1\0\4\27\23\0\1\27\4\0\1\27\1\0\1\27"+
    "\1\0\1\27\1\0\4\27\4\0\6\27\1\u014a\12\27"+
    "\3\0\1\27\1\0\1\27\1\0\4\27\23\0\1\27"+
    "\4\0\1\27\1\0\1\27\1\0\1\u014b\1\0\4\27"+
    "\4\0\21\27\3\0\1\27\1\0\1\27\1\0\4\27"+
    "\23\0\1\27\4\0\1\27\1\0\1\27\1\0\1\27"+
    "\1\0\4\27\4\0\3\27\1\u014c\15\27\3\0\1\27"+
    "\1\0\1\27\1\0\4\27\23\0\1\27\4\0\1\27"+
    "\1\0\1\27\1\0\1\27\1\0\4\27\4\0\14\27"+
    "\1\u014d\4\27\3\0\1\27\1\0\1\27\1\0\4\27"+
    "\23\0\1\27\4\0\1\27\1\0\1\27\1\0\1\27"+
    "\1\0\4\27\4\0\15\27\1\u014e\3\27\3\0\1\27"+
    "\1\0\1\27\1\0\4\27\23\0\1\27\4\0\1\27"+
    "\1\0\1\27\1\0\1\27\1\0\4\27\4\0\21\27"+
    "\3\0\1\27\1\0\1\27\1\0\1\u014f\3\27\23\0"+
    "\1\27\4\0\1\27\1\0\1\27\1\0\1\27\1\0"+
    "\4\27\4\0\17\27\1\u0150\1\27\3\0\1\27\1\0"+
    "\1\27\1\0\4\27\23\0\1\27\4\0\1\27\1\0"+
    "\1\27\1\0\1\27\1\0\4\27\4\0\7\27\1\u0151"+
    "\11\27\3\0\1\27\1\0\1\27\1\0\4\27\23\0"+
    "\1\27\4\0\1\27\1\0\1\27\1\0\1\27\1\0"+
    "\4\27\4\0\1\27\1\u0152\17\27\3\0\1\27\1\0"+
    "\1\27\1\0\4\27\23\0\1\27\4\0\1\27\1\0"+
    "\1\27\1\0\1\27\1\0\4\27\4\0\10\27\1\u0153"+
    "\10\27\3\0\1\27\1\0\1\27\1\0\4\27\23\0"+
    "\1\27\4\0\1\27\1\0\1\27\1\0\1\27\1\0"+
    "\4\27\4\0\7\27\1\u0154\11\27\3\0\1\27\1\0"+
    "\1\27\1\0\4\27\23\0\1\27\4\0\1\27\1\0"+
    "\1\27\1\0\1\27\1\0\4\27\4\0\16\27\1\u0155"+
    "\2\27\3\0\1\27\1\0\1\27\1\0\4\27\23\0"+
    "\1\27\4\0\1\27\1\0\1\27\1\0\1\27\1\0"+
    "\4\27\4\0\6\27\1\u0156\12\27\3\0\1\27\1\0"+
    "\1\27\1\0\4\27\23\0\1\27\4\0\1\27\1\0"+
    "\1\27\1\0\1\27\1\0\4\27\4\0\10\27\1\u0157"+
    "\10\27\3\0\1\27\1\0\1\27\1\0\4\27\23\0"+
    "\1\27\4\0\1\27\1\0\1\27\1\0\1\27\1\0"+
    "\4\27\4\0\4\27\1\u0158\14\27\3\0\1\27\1\0"+
    "\1\27\1\0\4\27\23\0\1\27\4\0\1\27\1\0"+
    "\1\27\1\0\1\27\1\0\4\27\4\0\10\27\1\u0159"+
    "\10\27\3\0\1\27\1\0\1\27\1\0\4\27\23\0"+
    "\1\27\4\0\1\27\1\0\1\27\1\0\1\27\1\0"+
    "\4\27\4\0\16\27\1\u015a\2\27\3\0\1\27\1\0"+
    "\1\27\1\0\4\27\23\0\1\27\4\0\1\27\1\0"+
    "\1\27\1\0\1\27\1\0\4\27\4\0\16\27\1\u015b"+
    "\2\27\3\0\1\27\1\0\1\27\1\0\4\27\23\0"+
    "\1\27\4\0\1\27\1\0\1\27\1\0\1\27\1\0"+
    "\4\27\4\0\1\27\1\u015c\17\27\3\0\1\27\1\0"+
    "\1\27\1\0\4\27\23\0\1\27\4\0\1\27\1\0"+
    "\1\27\1\0\1\27\1\0\4\27\4\0\1\27\1\u015d"+
    "\17\27\3\0\1\27\1\0\1\27\1\0\4\27\23\0"+
    "\1\27\4\0\1\27\1\0\1\27\1\0\1\27\1\0"+
    "\4\27\4\0\1\u015e\20\27\3\0\1\27\1\0\1\27"+
    "\1\0\4\27\23\0\1\27\4\0\1\27\1\0\1\27"+
    "\1\0\1\27\1\0\4\27\4\0\1\27\1\u015f\17\27"+
    "\3\0\1\27\1\0\1\27\1\0\4\27\23\0\1\27"+
    "\4\0\1\27\1\0\1\27\1\0\1\27\1\0\4\27"+
    "\4\0\12\27\1\u0160\6\27\3\0\1\27\1\0\1\27"+
    "\1\0\4\27\23\0\1\u0160\4\0\1\27\1\0\1\27"+
    "\1\0\1\27\1\0\4\27\4\0\1\u0161\20\27\3\0"+
    "\1\27\1\0\1\27\1\0\4\27\23\0\1\27\4\0"+
    "\1\27\1\0\1\27\1\0\1\27\1\0\4\27\4\0"+
    "\11\27\1\u0162\7\27\3\0\1\27\1\0\1\27\1\0"+
    "\4\27\23\0\1\27\4\0\1\27\1\0\1\27\1\0"+
    "\1\27\1\0\4\27\4\0\13\27\1\u0163\5\27\3\0"+
    "\1\27\1\0\1\27\1\0\4\27\23\0\1\27\4\0"+
    "\1\27\1\0\1\27\1\0\1\27\1\0\4\27\4\0"+
    "\1\u0164\20\27\3\0\1\27\1\0\1\27\1\0\4\27"+
    "\23\0\1\27\4\0\1\27\1\0\1\27\1\0\1\u0165"+
    "\1\0\4\27\4\0\21\27\3\0\1\27\1\0\1\27"+
    "\1\0\4\27\23\0\1\27\4\0\1\27\1\0\1\27"+
    "\1\0\1\27\1\0\4\27\4\0\21\27\3\0\1\27"+
    "\1\0\1\27\1\0\1\u0166\3\27\23\0\1\27\4\0"+
    "\1\27\1\0\1\27\1\0\1\27\1\0\4\27\4\0"+
    "\1\27\1\u0167\17\27\3\0\1\27\1\0\1\27\1\0"+
    "\4\27\23\0\1\27\4\0\1\27\21\0\1\u0168\63\0"+
    "\1\u0169\6\0\1\u016a\31\0\1\u016b\44\0\1\u016c\75\0"+
    "\1\u016d\131\0\1\u016e\51\0\1\u016f\113\0\1\u0170\105\0"+
    "\1\u0171\113\0\1\u0172\47\0\1\27\1\0\1\27\1\0"+
    "\4\27\4\0\16\27\1\u0173\2\27\3\0\1\27\1\0"+
    "\1\27\1\0\4\27\23\0\1\27\4\0\1\27\1\0"+
    "\1\u0142\1\0\1\u0142\1\0\4\u0142\1\u0174\2\0\1\u0175"+
    "\21\u0142\3\0\1\u0142\1\0\1\u0142\1\0\4\u0142\23\0"+
    "\1\u0142\4\0\1\u0142\30\0\1\u0176\104\0\1\u0177\57\0"+
    "\1\u0178\1\u0179\1\0\1\u0179\122\0\1\u017a\45\0\1\27"+
    "\1\0\1\27\1\0\4\27\4\0\2\27\1\u017b\16\27"+
    "\3\0\1\27\1\0\1\27\1\0\4\27\23\0\1\27"+
    "\4\0\1\27\1\0\1\27\1\0\1\27\1\0\4\27"+
    "\4\0\6\27\1\u017c\12\27\3\0\1\27\1\0\1\27"+
    "\1\0\4\27\23\0\1\27\4\0\1\27\1\0\1\27"+
    "\1\0\1\27\1\0\4\27\4\0\11\27\1\u017d\7\27"+
    "\3\0\1\27\1\0\1\27\1\0\4\27\23\0\1\27"+
    "\4\0\1\27\1\0\1\27\1\0\1\27\1\0\4\27"+
    "\4\0\13\27\1\u017e\5\27\3\0\1\27\1\0\1\27"+
    "\1\0\4\27\23\0\1\27\4\0\1\27\1\0\1\27"+
    "\1\0\1\27\1\0\4\27\4\0\1\u017f\20\27\3\0"+
    "\1\27\1\0\1\27\1\0\4\27\23\0\1\27\4\0"+
    "\1\27\1\0\1\27\1\0\1\27\1\0\4\27\4\0"+
    "\1\u0180\20\27\3\0\1\27\1\0\1\27\1\0\4\27"+
    "\23\0\1\27\4\0\1\27\1\0\1\27\1\0\1\27"+
    "\1\0\4\27\4\0\2\27\1\u0181\16\27\3\0\1\27"+
    "\1\0\1\27\1\0\4\27\23\0\1\27\4\0\1\27"+
    "\1\0\1\27\1\0\1\u0182\1\0\4\27\4\0\21\27"+
    "\3\0\1\27\1\0\1\27\1\0\4\27\23\0\1\27"+
    "\4\0\1\27\1\0\1\27\1\0\1\27\1\0\4\27"+
    "\4\0\4\27\1\u0183\14\27\3\0\1\27\1\0\1\27"+
    "\1\0\4\27\23\0\1\27\4\0\1\27\1\0\1\27"+
    "\1\0\1\27\1\0\4\27\4\0\13\27\1\u0184\5\27"+
    "\3\0\1\27\1\0\1\27\1\0\4\27\23\0\1\27"+
    "\4\0\1\27\1\0\1\27\1\0\1\27\1\0\4\27"+
    "\4\0\7\27\1\u0185\11\27\3\0\1\27\1\0\1\27"+
    "\1\0\4\27\23\0\1\27\4\0\1\27\1\0\1\27"+
    "\1\0\1\u0186\1\0\4\27\4\0\21\27\3\0\1\27"+
    "\1\0\1\27\1\0\4\27\23\0\1\27\4\0\1\27"+
    "\1\0\1\27\1\0\1\u0187\1\0\4\27\4\0\21\27"+
    "\3\0\1\27\1\0\1\27\1\0\4\27\23\0\1\27"+
    "\4\0\1\27\1\0\1\27\1\0\1\27\1\0\4\27"+
    "\4\0\11\27\1\u0188\7\27\3\0\1\27\1\0\1\27"+
    "\1\0\4\27\23\0\1\27\4\0\1\27\1\0\1\27"+
    "\1\0\1\27\1\0\4\27\4\0\12\27\1\u0189\6\27"+
    "\3\0\1\27\1\0\1\27\1\0\4\27\23\0\1\u0189"+
    "\4\0\1\27\1\0\1\27\1\0\1\27\1\0\4\27"+
    "\4\0\11\27\1\u018a\7\27\3\0\1\27\1\0\1\27"+
    "\1\0\4\27\23\0\1\27\4\0\1\27\1\0\1\27"+
    "\1\0\1\27\1\0\4\27\4\0\1\u018b\20\27\3\0"+
    "\1\27\1\0\1\27\1\0\4\27\23\0\1\27\4\0"+
    "\1\27\1\0\1\27\1\0\1\27\1\0\4\27\4\0"+
    "\10\27\1\u018c\10\27\3\0\1\27\1\0\1\27\1\0"+
    "\4\27\23\0\1\27\4\0\1\27\1\0\1\27\1\0"+
    "\1\27\1\0\4\27\4\0\11\27\1\u018d\7\27\3\0"+
    "\1\27\1\0\1\27\1\0\4\27\23\0\1\27\4\0"+
    "\1\27\1\0\1\27\1\0\1\27\1\0\4\27\4\0"+
    "\15\27\1\u018e\3\27\3\0\1\27\1\0\1\27\1\0"+
    "\4\27\23\0\1\27\4\0\1\27\1\0\1\27\1\0"+
    "\1\27\1\0\4\27\4\0\10\27\1\u018f\10\27\3\0"+
    "\1\27\1\0\1\27\1\0\4\27\23\0\1\27\4\0"+
    "\1\27\1\0\1\27\1\0\1\27\1\0\4\27\4\0"+
    "\13\27\1\u0190\5\27\3\0\1\27\1\0\1\27\1\0"+
    "\4\27\23\0\1\27\4\0\1\27\3\0\1\u0191\6\0"+
    "\1\u0192\31\0\1\u0193\100\0\1\u0194\50\0\1\u016a\31\0"+
    "\1\u016b\56\0\1\u0195\106\0\1\u0196\71\0\1\u0171\101\0"+
    "\1\u0197\110\0\1\u0198\66\0\1\u0171\31\0\1\u0199\102\0"+
    "\1\u019a\35\0\1\27\1\0\1\27\1\0\4\27\4\0"+
    "\4\27\1\u019b\14\27\3\0\1\27\1\0\1\27\1\0"+
    "\4\27\23\0\1\27\4\0\1\27\14\0\1\u0175\102\0"+
    "\1\u019c\114\0\1\u019d\65\0\1\u0179\103\0\1\u019e\64\0"+
    "\1\27\1\0\1\27\1\0\4\27\4\0\12\27\1\u019f"+
    "\6\27\3\0\1\27\1\0\1\27\1\0\4\27\23\0"+
    "\1\u019f\4\0\1\27\1\0\1\27\1\0\1\27\1\0"+
    "\4\27\4\0\4\27\1\u01a0\14\27\3\0\1\27\1\0"+
    "\1\27\1\0\4\27\23\0\1\27\4\0\1\27\1\0"+
    "\1\27\1\0\1\u01a1\1\0\4\27\4\0\21\27\3\0"+
    "\1\27\1\0\1\27\1\0\4\27\23\0\1\27\4\0"+
    "\1\27\1\0\1\27\1\0\1\27\1\0\4\27\4\0"+
    "\1\27\1\u01a2\17\27\3\0\1\27\1\0\1\27\1\0"+
    "\4\27\23\0\1\27\4\0\1\27\1\0\1\27\1\0"+
    "\1\27\1\0\4\27\4\0\4\27\1\u01a3\14\27\3\0"+
    "\1\27\1\0\1\27\1\0\4\27\23\0\1\27\4\0"+
    "\1\27\1\0\1\27\1\0\1\u01a4\1\0\4\27\4\0"+
    "\21\27\3\0\1\27\1\0\1\27\1\0\4\27\23\0"+
    "\1\27\4\0\1\27\1\0\1\27\1\0\1\27\1\0"+
    "\4\27\4\0\1\27\1\u01a5\17\27\3\0\1\27\1\0"+
    "\1\27\1\0\4\27\23\0\1\27\4\0\1\27\1\0"+
    "\1\27\1\0\1\u01a6\1\0\4\27\4\0\21\27\3\0"+
    "\1\27\1\0\1\27\1\0\4\27\23\0\1\27\4\0"+
    "\1\27\1\0\1\27\1\0\1\27\1\0\4\27\4\0"+
    "\10\27\1\u01a7\10\27\3\0\1\27\1\0\1\27\1\0"+
    "\4\27\23\0\1\27\4\0\1\27\1\0\1\27\1\0"+
    "\1\27\1\0\4\27\4\0\5\27\1\u01a8\13\27\3\0"+
    "\1\27\1\0\1\27\1\0\4\27\23\0\1\27\4\0"+
    "\1\27\1\0\1\27\1\0\1\27\1\0\4\27\4\0"+
    "\5\27\1\u01a9\13\27\3\0\1\27\1\0\1\27\1\0"+
    "\4\27\23\0\1\27\4\0\1\27\1\0\1\27\1\0"+
    "\1\27\1\0\4\27\4\0\1\27\1\u01aa\17\27\3\0"+
    "\1\27\1\0\1\27\1\0\4\27\23\0\1\27\4\0"+
    "\1\27\1\0\1\27\1\0\1\27\1\0\4\27\4\0"+
    "\12\27\1\u01ab\6\27\3\0\1\27\1\0\1\27\1\0"+
    "\4\27\23\0\1\u01ab\4\0\1\27\1\0\1\27\1\0"+
    "\1\27\1\0\4\27\4\0\15\27\1\u01ac\3\27\3\0"+
    "\1\27\1\0\1\27\1\0\4\27\23\0\1\27\4\0"+
    "\1\27\1\0\1\27\1\0\1\27\1\0\4\27\4\0"+
    "\3\27\1\u01ad\15\27\3\0\1\27\1\0\1\27\1\0"+
    "\4\27\23\0\1\27\4\0\1\27\1\0\1\27\1\0"+
    "\1\27\1\0\4\27\4\0\7\27\1\u01ae\11\27\3\0"+
    "\1\27\1\0\1\27\1\0\4\27\23\0\1\27\4\0"+
    "\1\27\1\0\1\27\1\0\1\u01af\1\0\4\27\4\0"+
    "\21\27\3\0\1\27\1\0\1\27\1\0\4\27\23\0"+
    "\1\27\4\0\1\27\33\0\1\u01b0\60\0\1\u0192\31\0"+
    "\1\u0193\40\0\1\u01b1\101\0\1\u0171\114\0\1\u01b2\75\0"+
    "\1\u0197\31\0\1\u01b3\100\0\1\u01b4\50\0\1\u019a\31\0"+
    "\1\u01b5\72\0\1\u01b6\55\0\2\u01b7\1\0\1\u01b7\76\0"+
    "\2\u01b8\1\0\1\u01b8\66\0\1\27\1\0\1\27\1\0"+
    "\4\27\4\0\16\27\1\u01b9\2\27\3\0\1\27\1\0"+
    "\1\27\1\0\4\27\23\0\1\27\4\0\1\27\1\0"+
    "\1\27\1\0\1\27\1\0\4\27\4\0\16\27\1\u01ba"+
    "\2\27\3\0\1\27\1\0\1\27\1\0\4\27\23\0"+
    "\1\27\4\0\1\27\1\0\1\27\1\0\1\27\1\0"+
    "\4\27\4\0\11\27\1\u01bb\7\27\3\0\1\27\1\0"+
    "\1\27\1\0\4\27\23\0\1\27\4\0\1\27\1\0"+
    "\1\27\1\0\1\u01bc\1\0\4\27\4\0\21\27\3\0"+
    "\1\27\1\0\1\27\1\0\4\27\23\0\1\27\4\0"+
    "\1\27\1\0\1\27\1\0\1\27\1\0\4\27\4\0"+
    "\5\27\1\u01bd\13\27\3\0\1\27\1\0\1\27\1\0"+
    "\4\27\23\0\1\27\4\0\1\27\1\0\1\27\1\0"+
    "\1\27\1\0\4\27\4\0\11\27\1\u01be\7\27\3\0"+
    "\1\27\1\0\1\27\1\0\4\27\23\0\1\27\4\0"+
    "\1\27\1\0\1\27\1\0\1\27\1\0\4\27\4\0"+
    "\5\27\1\u01bf\13\27\3\0\1\27\1\0\1\27\1\0"+
    "\4\27\23\0\1\27\4\0\1\27\1\0\1\27\1\0"+
    "\1\27\1\0\4\27\4\0\5\27\1\u01c0\13\27\3\0"+
    "\1\27\1\0\1\27\1\0\4\27\23\0\1\27\4\0"+
    "\1\27\1\0\1\27\1\0\1\27\1\0\4\27\4\0"+
    "\1\u01c1\20\27\3\0\1\27\1\0\1\27\1\0\4\27"+
    "\23\0\1\27\4\0\1\27\1\0\1\27\1\0\1\27"+
    "\1\0\4\27\4\0\5\27\1\u01c2\13\27\3\0\1\27"+
    "\1\0\1\27\1\0\4\27\23\0\1\27\4\0\1\27"+
    "\1\0\1\27\1\0\1\27\1\0\4\27\4\0\10\27"+
    "\1\u01c3\10\27\3\0\1\27\1\0\1\27\1\0\4\27"+
    "\23\0\1\27\4\0\1\27\1\0\1\27\1\0\1\u01c4"+
    "\1\0\4\27\4\0\21\27\3\0\1\27\1\0\1\27"+
    "\1\0\4\27\23\0\1\27\4\0\1\27\1\0\1\27"+
    "\1\0\1\27\1\0\4\27\4\0\5\27\1\u01c5\13\27"+
    "\3\0\1\27\1\0\1\27\1\0\4\27\23\0\1\27"+
    "\4\0\1\27\25\0\1\u0192\104\0\1\u016a\63\0\1\u01b2"+
    "\31\0\1\u01c6\47\0\1\u01b4\31\0\1\u01c7\53\0\1\u01c8"+
    "\66\0\1\u01c9\2\0\3\u01c9\2\u01b7\1\0\1\u01b7\21\u01c9"+
    "\3\0\1\u01c9\1\0\1\u01c9\1\0\4\u01c9\16\0\1\u01ca"+
    "\4\0\1\u01c9\16\0\2\u01b8\1\0\1\u01b8\4\0\1\u01cb"+
    "\61\0\1\27\1\0\1\27\1\0\4\27\4\0\13\27"+
    "\1\u01cc\5\27\3\0\1\27\1\0\1\27\1\0\4\27"+
    "\23\0\1\27\4\0\1\27\1\0\1\27\1\0\1\27"+
    "\1\0\4\27\4\0\11\27\1\u01cd\7\27\3\0\1\27"+
    "\1\0\1\27\1\0\4\27\23\0\1\27\4\0\1\27"+
    "\1\0\1\27\1\0\1\27\1\0\4\27\4\0\15\27"+
    "\1\u01ce\3\27\3\0\1\27\1\0\1\27\1\0\4\27"+
    "\23\0\1\27\4\0\1\27\1\0\1\27\1\0\1\27"+
    "\1\0\4\27\4\0\3\27\1\u01cf\15\27\3\0\1\27"+
    "\1\0\1\27\1\0\4\27\23\0\1\27\4\0\1\27"+
    "\1\0\1\27\1\0\1\27\1\0\4\27\4\0\1\27"+
    "\1\u01d0\17\27\3\0\1\27\1\0\1\27\1\0\4\27"+
    "\23\0\1\27\4\0\1\27\1\0\1\27\1\0\1\27"+
    "\1\0\4\27\4\0\3\27\1\u01d1\15\27\3\0\1\27"+
    "\1\0\1\27\1\0\4\27\23\0\1\27\4\0\1\27"+
    "\1\0\1\27\1\0\1\27\1\0\4\27\4\0\5\27"+
    "\1\u01d2\13\27\3\0\1\27\1\0\1\27\1\0\4\27"+
    "\23\0\1\27\4\0\1\27\1\0\1\27\1\0\1\27"+
    "\1\0\4\27\4\0\3\27\1\u01d3\15\27\3\0\1\27"+
    "\1\0\1\27\1\0\4\27\23\0\1\27\4\0\1\27"+
    "\11\0\2\u01c8\1\0\1\u01c8\22\0\1\270\43\0\1\u01c9"+
    "\1\0\1\u01c9\1\0\4\u01c9\2\u01d4\1\0\1\u01d4\21\u01c9"+
    "\3\0\1\u01c9\1\0\1\u01c9\1\0\4\u01c9\23\0\1\u01c9"+
    "\4\0\1\u01c9\3\0\1\u01c9\2\0\3\u01c9\4\0\21\u01c9"+
    "\3\0\1\u01c9\1\0\1\u01c9\1\0\4\u01c9\23\0\1\u01c9"+
    "\40\0\1\u01d5\47\0\1\27\1\0\1\u01d6\1\0\4\27"+
    "\4\0\21\27\3\0\1\27\1\0\1\27\1\0\4\27"+
    "\23\0\1\27\4\0\1\27\1\0\1\27\1\0\1\27"+
    "\1\0\4\27\4\0\15\27\1\u01d7\3\27\3\0\1\27"+
    "\1\0\1\27\1\0\4\27\23\0\1\27\4\0\1\27"+
    "\1\0\1\27\1\0\1\27\1\0\4\27\4\0\10\27"+
    "\1\u01d8\10\27\3\0\1\27\1\0\1\27\1\0\4\27"+
    "\23\0\1\27\4\0\1\27\1\0\1\27\1\0\1\27"+
    "\1\0\4\27\4\0\1\u01d9\20\27\3\0\1\27\1\0"+
    "\1\27\1\0\4\27\23\0\1\27\4\0\1\27\1\0"+
    "\1\27\1\0\1\27\1\0\4\27\4\0\10\27\1\u01da"+
    "\10\27\3\0\1\27\1\0\1\27\1\0\4\27\23\0"+
    "\1\27\4\0\1\27\1\0\1\27\1\0\1\27\1\0"+
    "\4\27\4\0\10\27\1\u01db\10\27\3\0\1\27\1\0"+
    "\1\27\1\0\4\27\23\0\1\27\4\0\1\27\3\0"+
    "\1\u01dc\2\0\3\u01dc\2\u01d4\1\0\1\u01d4\21\u01dc\3\0"+
    "\1\u01dc\1\0\1\u01dc\1\0\4\u01dc\23\0\1\u01dc\32\0"+
    "\1\u01dd\55\0\1\27\1\0\1\27\1\0\4\27\4\0"+
    "\11\27\1\u01de\7\27\3\0\1\27\1\0\1\27\1\0"+
    "\4\27\23\0\1\27\4\0\1\27\1\0\1\27\1\0"+
    "\1\27\1\0\4\27\4\0\3\27\1\u01df\15\27\3\0"+
    "\1\27\1\0\1\27\1\0\4\27\23\0\1\27\4\0"+
    "\1\27\1\0\1\27\1\0\1\27\1\0\4\27\4\0"+
    "\5\27\1\u01e0\13\27\3\0\1\27\1\0\1\27\1\0"+
    "\4\27\23\0\1\27\4\0\1\27\1\0\1\27\1\0"+
    "\1\27\1\0\4\27\4\0\11\27\1\u01e1\7\27\3\0"+
    "\1\27\1\0\1\27\1\0\4\27\23\0\1\27\4\0"+
    "\1\27\1\0\1\u01dc\1\0\1\u01dc\1\0\4\u01dc\2\u01e2"+
    "\1\0\1\u01e2\21\u01dc\3\0\1\u01dc\1\0\1\u01dc\1\0"+
    "\4\u01dc\3\0\1\u01e3\17\0\1\u01dc\4\0\1\u01dc\43\0"+
    "\1\u01e4\37\0\1\27\1\0\1\u01e5\1\0\4\27\4\0"+
    "\21\27\3\0\1\27\1\0\1\27\1\0\4\27\23\0"+
    "\1\27\4\0\1\27\1\0\1\27\1\0\1\27\1\0"+
    "\4\27\4\0\10\27\1\u01e6\10\27\3\0\1\27\1\0"+
    "\1\27\1\0\4\27\23\0\1\27\4\0\1\27\1\0"+
    "\1\27\1\0\1\27\1\0\4\27\4\0\5\27\1\u01e7"+
    "\13\27\3\0\1\27\1\0\1\27\1\0\4\27\23\0"+
    "\1\27\4\0\1\27\1\0\1\27\1\0\1\u01e8\1\0"+
    "\4\27\4\0\21\27\3\0\1\27\1\0\1\27\1\0"+
    "\4\27\23\0\1\27\4\0\1\27\11\0\2\u01e2\1\0"+
    "\1\u01e2\37\0\1\u01e3\102\0\1\u01e9\50\0\1\u01ea\110\0"+
    "\1\u01eb\111\0\1\u01ec\41\0\1\u01ed\107\0\2\u01ed\1\0"+
    "\1\u01ed\34\0\1\u01ee\41\0\2\u01ee\1\0\1\u01ee\20\0"+
    "\1\u01ef\37\0\1\u01f0\1\u01f1\35\0\1\u01f2\104\0\1\u01f3"+
    "\101\0\1\u01f4\101\0\1\u01f5\76\0\1\u01f6\101\0\1\u01f7"+
    "\60\0\2\u01f5\1\0\1\u01f5\22\0\1\u01f8\77\0\1\u01f9"+
    "\101\0\1\u01fa\141\0\1\u01f5\102\0\1\u01f5\3\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[25344];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\14\0\2\1\1\11\11\1\1\11\24\1\1\11\11\1"+
    "\5\11\2\1\3\11\2\1\1\11\6\1\2\11\3\1"+
    "\1\11\3\1\1\11\4\1\1\11\1\1\1\11\3\1"+
    "\1\11\4\1\2\11\1\1\1\0\4\1\1\0\1\11"+
    "\6\1\2\11\1\0\35\1\3\11\1\1\2\11\1\1"+
    "\12\0\1\1\1\11\2\1\2\11\1\1\1\0\2\11"+
    "\2\1\6\11\2\1\1\0\1\11\4\0\1\1\4\11"+
    "\2\1\1\11\1\0\1\1\1\11\1\0\4\11\2\0"+
    "\1\1\1\0\44\1\1\11\1\1\11\0\1\1\3\11"+
    "\3\0\1\1\1\0\1\1\1\11\1\1\1\11\3\1"+
    "\2\0\44\1\11\0\1\1\2\0\1\11\3\0\40\1"+
    "\3\0\1\11\7\0\2\1\1\11\2\0\1\1\1\11"+
    "\1\0\26\1\2\0\1\11\5\0\1\11\1\0\1\1"+
    "\3\0\21\1\3\0\1\11\1\0\1\11\3\0\15\1"+
    "\2\11\4\0\10\1\2\0\6\1\2\0\4\1\3\0"+
    "\4\1\1\11\16\0\1\11\2\0";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[506];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the textposition at the last state to be included in yytext */
  private int zzPushbackPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */
	private final LinkedList commentList = new LinkedList();
	private String heredoc = null;
    private boolean asp_tags = false;
    private boolean short_tags_allowed = true;
    private StateStack stack = new StateStack();
    private char zzOld_buffer[] = new char[ZZ_BUFFERSIZE];
    private int zzOld_pushbackPos;
    protected int commentStartPosition;

	private AST ast;

    public void setAST(AST ast) {
    	this.ast = ast;
    }
    
	public PHPVersion getPHPVersion() {
		return PHPVersion.PHP4;
	}
    
	public void setInScriptingState() {
		yybegin(ST_IN_SCRIPTING);
	}

	public void resetCommentList() {
		commentList.clear();
	}
	
	public LinkedList getCommentList() {
		return commentList;
	}
	
	protected void addComment(int type) {
		int leftPosition = getTokenStartPosition();
		Comment comment = new Comment(commentStartPosition, leftPosition + getTokenLength(), this.ast, type);
		commentList.add(comment);
	}	

	public void setUseAspTagsAsPhp(boolean useAspTagsAsPhp) {
		asp_tags = useAspTagsAsPhp;
	}
	
	public void setUseShortTags(boolean useShortTags) {
		short_tags_allowed = useShortTags;
	}
	
    private void pushState(int state) {
        stack.pushStack(zzLexicalState);
        yybegin(state);
    }

    private void popState() {
        yybegin(stack.popStack());
    }

    public int getCurrentLine() {
        return yyline;
    }

    protected int getTokenStartPosition() {
        return zzStartRead - zzPushbackPos;
    }

    protected int getTokenLength() {
        return zzMarkedPos - zzStartRead;
    }

    public int getLength() {
        return zzEndRead - zzPushbackPos;
    }
    
	private void handleCommentStart() {
		commentStartPosition = getTokenStartPosition();
	}
	
	private void handleLineCommentEnd() {
         addComment(Comment.TYPE_SINGLE_LINE);
    }

    private void handleMultilineCommentEnd() {
    	addComment(Comment.TYPE_MULTILINE);
    }

    private void handlePHPDocEnd() {
		addComment(Comment.TYPE_PHPDOC);
    }
    
    protected void handleVarComment() {
    	commentStartPosition = zzStartRead;
    	addComment(Comment.TYPE_MULTILINE);
    }

    private Symbol createFullSymbol(int symbolNumber) {
        Symbol symbol = createSymbol(symbolNumber);
        symbol.value = yytext();
        return symbol;
    }

    protected Symbol createSymbol(int symbolNumber) {
        int leftPosition = getTokenStartPosition();
        return new Symbol(symbolNumber, leftPosition, leftPosition + getTokenLength());
    }
    
    public int[] getParamenters(){
    	return new int[]{zzMarkedPos, zzPushbackPos, zzCurrentPos, zzStartRead, zzEndRead, yyline};
    }
    
	protected boolean parsePHPDoc(){	
		final IDocumentorLexer documentorLexer = getDocumentorLexer(zzReader);
		if(documentorLexer == null){
			return false;
		}
		yypushback(zzMarkedPos - zzStartRead);
		int[] parameters = getParamenters();
		documentorLexer.reset(zzReader, zzBuffer, parameters);
		Object phpDocBlock = documentorLexer.parse();
		commentList.add(phpDocBlock);
		reset(zzReader, documentorLexer.getBuffer(), documentorLexer.getParamenters());
		return true;
	}
	
	
	protected IDocumentorLexer getDocumentorLexer(java.io.Reader  reader) {
		return null;
	}
	
	public void reset(java.io.Reader  reader, char[] buffer, int[] parameters){
		this.zzReader = reader;
		this.zzBuffer = buffer;
		this.zzMarkedPos = parameters[0];
		this.zzPushbackPos = parameters[1];
		this.zzCurrentPos = parameters[2];
		this.zzStartRead = parameters[3];
		this.zzEndRead = parameters[4];
		this.yyline = parameters[5];  
		this.yychar = this.zzStartRead - this.zzPushbackPos;
	}


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public PhpAstLexer(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public PhpAstLexer(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 192) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzPushbackPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead < 0) {
      return true;
    }
    else {
      zzEndRead+= numRead;
      return false;
    }
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = zzPushbackPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void zzDoEOF() throws java.io.IOException {
    if (!zzEOFDone) {
      zzEOFDone = true;
      yyclose();
    }
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public java_cup.runtime.Symbol next_token() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      boolean zzR = false;
      for (zzCurrentPosL = zzStartRead; zzCurrentPosL < zzMarkedPosL;
                                                             zzCurrentPosL++) {
        switch (zzBufferL[zzCurrentPosL]) {
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          yyline++;
          zzR = false;
          break;
        case '\r':
          yyline++;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
          }
          break;
        default:
          zzR = false;
        }
      }

      if (zzR) {
        // peek one character ahead if it is \n (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof) 
            zzPeek = false;
          else 
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
      if (zzMarkedPosL > zzStartRead) {
        switch (zzBufferL[zzMarkedPosL-1]) {
        case '\n':
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          zzAtBOL = true;
          break;
        case '\r': 
          if (zzMarkedPosL < zzEndReadL)
            zzAtBOL = zzBufferL[zzMarkedPosL] != '\n';
          else if (zzAtEOF)
            zzAtBOL = false;
          else {
            boolean eof = zzRefill();
            zzMarkedPosL = zzMarkedPos;
            zzEndReadL = zzEndRead;
            zzBufferL = zzBuffer;
            if (eof) 
              zzAtBOL = false;
            else 
              zzAtBOL = zzBufferL[zzMarkedPosL] != '\n';
          }
          break;
        default:
          zzAtBOL = false;
        }
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      if (zzAtBOL)
        zzState = ZZ_LEXSTATE[zzLexicalState+1];
      else
        zzState = ZZ_LEXSTATE[zzLexicalState];


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 58: 
          { return createSymbol(ParserConstants.T_LOGICAL_OR);
          }
        case 158: break;
        case 45: 
          { popState();
    return createFullSymbol(ParserConstants.T_STRING);
          }
        case 159: break;
        case 139: 
          { return createSymbol(ParserConstants.T_REQUIRE);
          }
        case 160: break;
        case 52: 
          { return createFullSymbol(ParserConstants.T_DNUMBER);
          }
        case 161: break;
        case 85: 
          { pushState(ST_LOOKING_FOR_VARNAME);
    return createSymbol(ParserConstants.T_DOLLAR_OPEN_CURLY_BRACES);
          }
        case 162: break;
        case 17: 
          { return createSymbol(ParserConstants.T_TIMES);
          }
        case 163: break;
        case 54: 
          { return createSymbol(ParserConstants.T_INC);
          }
        case 164: break;
        case 8: 
          { handleCommentStart();
	yybegin(ST_ONE_LINE_COMMENT);
//	yymore();
          }
        case 165: break;
        case 116: 
          { return createSymbol(ParserConstants.T_UNSET);
          }
        case 166: break;
        case 21: 
          { return createSymbol(ParserConstants.T_OR);
          }
        case 167: break;
        case 11: 
          { return createSymbol(ParserConstants.T_NEKUDOTAIM);
          }
        case 168: break;
        case 48: 
          { //	yymore();
          }
        case 169: break;
        case 84: 
          { if (yylength() == 2) {
        yypushback(1);
    }
    return createSymbol(ParserConstants.T_CHARACTER);
          }
        case 170: break;
        case 81: 
          { return createFullSymbol(ParserConstants.T_VARIABLE);
          }
        case 171: break;
        case 32: 
          { /* This is a temporary fix which is dependant on flex and it's implementation */
    if (!stack.isEmpty()) {
        popState();
    }
    return createSymbol(ParserConstants.T_CURLY_CLOSE);
          }
        case 172: break;
        case 44: 
          { yypushback(yylength());
    popState();
          }
        case 173: break;
        case 72: 
          { return createSymbol(ParserConstants.T_DIV_EQUAL);
          }
        case 174: break;
        case 31: 
          { pushState(ST_IN_SCRIPTING);
    return createSymbol(ParserConstants.T_CURLY_OPEN);
          }
        case 175: break;
        case 82: 
          { yybegin(YYINITIAL);
    return createSymbol(ParserConstants.T_SEMICOLON);  /* implicit ';' at php-end tag */
          }
        case 176: break;
        case 100: 
          { return createSymbol(ParserConstants.T_SR_EQUAL);
          }
        case 177: break;
        case 74: 
          { if (asp_tags) {
        yybegin(YYINITIAL);
        return createSymbol(ParserConstants.T_SEMICOLON);  /* implicit ';' at php-end tag */
    } else {
        return createSymbol(ParserConstants.T_INLINE_HTML);
    }
          }
        case 178: break;
        case 150: 
          { return createSymbol(ParserConstants.T_CLASS_C);
          }
        case 179: break;
        case 35: 
          { yybegin(ST_BACKQUOTE);
    return createSymbol(ParserConstants.T_BACKQUATE);
          }
        case 180: break;
        case 104: 
          { return createSymbol(ParserConstants.T_SL_EQUAL);
          }
        case 181: break;
        case 106: 
          { return createSymbol(ParserConstants.T_ELSE);
          }
        case 182: break;
        case 133: 
          { return createSymbol(ParserConstants.T_GLOBAL);
          }
        case 183: break;
        case 114: 
          { return createSymbol(ParserConstants.T_BREAK);
          }
        case 184: break;
        case 57: 
          { return createSymbol(ParserConstants.T_DO);
          }
        case 185: break;
        case 15: 
          { return createSymbol(ParserConstants.T_NOT);
          }
        case 186: break;
        case 109: 
          { return createSymbol(ParserConstants.T_LIST);
          }
        case 187: break;
        case 89: 
          { String text = yytext();
    int length = text.length();
    text = text.trim();
    boolean foundNP = false;
    if (text.endsWith(";")) {
        text = text.substring(0, text.length() - 1);
        foundNP = true;
    }
    if (text.equals(heredoc)) {
        if (foundNP) {
            yypushback(length - text.length());
        }
        heredoc = null;
        yybegin(ST_IN_SCRIPTING);
        return createSymbol(ParserConstants.T_END_HEREDOC);
    } else {
        return createFullSymbol(ParserConstants.T_STRING);
    }
          }
        case 188: break;
        case 117: 
          { return createSymbol(ParserConstants.T_CONST);
          }
        case 189: break;
        case 155: 
          { return createSymbol(ParserConstants.T_FUNC_C);
          }
        case 190: break;
        case 29: 
          { return createSymbol(ParserConstants.T_QUESTION_MARK);
          }
        case 191: break;
        case 132: 
          { return createSymbol(ParserConstants.T_DOUBLE_CAST);
          }
        case 192: break;
        case 152: 
          { return createSymbol(ParserConstants.T_ENDFOREACH);
          }
        case 193: break;
        case 40: 
          { yybegin(ST_IN_SCRIPTING);
    return createSymbol(ParserConstants.T_QUATE);
          }
        case 194: break;
        case 128: 
          { return createSymbol(ParserConstants.T_STATIC);
          }
        case 195: break;
        case 107: 
          { return createSymbol(ParserConstants.T_ECHO);
          }
        case 196: break;
        case 49: 
          { String yytext = yytext();
	switch (yytext.charAt(yytext.length() - 1)) {
		case '?':
		case '%':
		case '>':
			yypushback(1);
			break;
		default:
			handleLineCommentEnd();
			yybegin(ST_IN_SCRIPTING);
	}
//	yymore();
          }
        case 197: break;
        case 130: 
          { return createSymbol(ParserConstants.T_RETURN);
          }
        case 198: break;
        case 141: 
          { return createSymbol(ParserConstants.T_ARRAY_CAST);
          }
        case 199: break;
        case 27: 
          { return createSymbol(ParserConstants.T_TILDA);
          }
        case 200: break;
        case 87: 
          { switch (yytext().charAt(1)) {
        case 'n':
            break;
        case 't':
            break;
        case 'r':
            break;
        case '\\':
            break;
        case '$':
            break;
        case '{':
            break;
        default:
            return createSymbol(ParserConstants.T_BAD_CHARACTER);
    }
    return createSymbol(ParserConstants.T_CHARACTER);
          }
        case 201: break;
        case 50: 
          { if (asp_tags) {
        yybegin(ST_IN_SCRIPTING);
		//return T_OPEN_TAG;
    } else {
        return createSymbol(ParserConstants.T_INLINE_HTML);
    }
          }
        case 202: break;
        case 4: 
          { return createSymbol(ParserConstants.T_NEKUDA);
          }
        case 203: break;
        case 136: 
          { return createSymbol(ParserConstants.T_DEFAULT);
          }
        case 204: break;
        case 73: 
          { handleCommentStart();
    yybegin(ST_COMMENT);
          }
        case 205: break;
        case 124: 
          { yybegin(ST_IN_SCRIPTING);
	//return T_OPEN_TAG;
          }
        case 206: break;
        case 68: 
          { return createSymbol(ParserConstants.T_IS_NOT_EQUAL);
          }
        case 207: break;
        case 64: 
          { return createSymbol(ParserConstants.T_IS_GREATER_OR_EQUAL);
          }
        case 208: break;
        case 6: 
          { return createSymbol(ParserConstants.T_PLUS);
          }
        case 209: break;
        case 129: 
          { return createSymbol(ParserConstants.T_SWITCH);
          }
        case 210: break;
        case 20: 
          { return createSymbol(ParserConstants.T_REFERENCE);
          }
        case 211: break;
        case 77: 
          { return createSymbol(ParserConstants.T_BOOLEAN_AND);
          }
        case 212: break;
        case 23: 
          { return createSymbol(ParserConstants.T_SEMICOLON);
          }
        case 213: break;
        case 91: 
          { handlePHPDocEnd();
     yybegin(ST_IN_SCRIPTING);
          }
        case 214: break;
        case 9: 
          { return createSymbol(ParserConstants.T_MINUS);
          }
        case 215: break;
        case 2: 
          { // do nothing
          }
        case 216: break;
        case 149: 
          { return createSymbol(ParserConstants.T_ENDSWITCH);
          }
        case 217: break;
        case 55: 
          { return createSymbol(ParserConstants.T_PLUS_EQUAL);
          }
        case 218: break;
        case 26: 
          { return createSymbol(ParserConstants.T_CLOSE_RECT);
          }
        case 219: break;
        case 94: 
          { return createSymbol(ParserConstants.T_LOGICAL_XOR);
          }
        case 220: break;
        case 90: 
          { handleMultilineCommentEnd();
    yybegin(ST_IN_SCRIPTING);
          }
        case 221: break;
        case 65: 
          { return createSymbol(ParserConstants.T_PAAMAYIM_NEKUDOTAYIM);
          }
        case 222: break;
        case 151: 
          { return createSymbol(ParserConstants.T_ENDDECLARE);
          }
        case 223: break;
        case 135: 
          { return createSymbol(ParserConstants.T_INCLUDE);
          }
        case 224: break;
        case 111: 
          { handleCommentStart();
          }
        case 225: break;
        case 83: 
          { return createFullSymbol(ParserConstants.T_CONSTANT_ENCAPSED_STRING);
          }
        case 226: break;
        case 67: 
          { return createSymbol(ParserConstants.T_IS_EQUAL);
          }
        case 227: break;
        case 120: 
          { return createSymbol(ParserConstants.T_ARRAY);
          }
        case 228: break;
        case 25: 
          { return createSymbol(ParserConstants.T_OPEN_RECT);
          }
        case 229: break;
        case 96: 
          { return createSymbol(ParserConstants.T_FOR);
          }
        case 230: break;
        case 147: 
          { return createSymbol(ParserConstants.T_OBJECT_CAST);
          }
        case 231: break;
        case 36: 
          { /* treat numbers (almost) as strings inside encapsulated strings */
    return createFullSymbol(ParserConstants.T_NUM_STRING);
          }
        case 232: break;
        case 138: 
          { return createSymbol(ParserConstants.T_FOREACH);
          }
        case 233: break;
        case 148: 
          { return createSymbol(ParserConstants.T_STRING_CAST);
          }
        case 234: break;
        case 76: 
          { return createSymbol(ParserConstants.T_AND_EQUAL);
          }
        case 235: break;
        case 119: 
          { return createSymbol(ParserConstants.T_WHILE);
          }
        case 236: break;
        case 98: 
          { return createSymbol(ParserConstants.T_NEW);
          }
        case 237: break;
        case 60: 
          { return createSymbol(ParserConstants.T_DEC);
          }
        case 238: break;
        case 51: 
          { if (short_tags_allowed || yylength()>2) { /* yyleng>2 means it's not <? but <script> */
        yybegin(ST_IN_SCRIPTING);
        //return T_OPEN_TAG;
    } else {
        return createSymbol(ParserConstants.T_INLINE_HTML);
    }
          }
        case 239: break;
        case 59: 
          { return createSymbol(ParserConstants.T_AS);
          }
        case 240: break;
        case 125: 
          { return createSymbol(ParserConstants.T_ELSEIF);
          }
        case 241: break;
        case 75: 
          { return createSymbol(ParserConstants.T_MOD_EQUAL);
          }
        case 242: break;
        case 102: 
          { return createSymbol(ParserConstants.T_IS_IDENTICAL);
          }
        case 243: break;
        case 19: 
          { return createSymbol(ParserConstants.T_PRECENT);
          }
        case 244: break;
        case 66: 
          { return createSymbol(ParserConstants.T_DOUBLE_ARROW);
          }
        case 245: break;
        case 28: 
          { return createSymbol(ParserConstants.T_DOLLAR);
          }
        case 246: break;
        case 16: 
          { return createSymbol(ParserConstants.T_RGREATER);
          }
        case 247: break;
        case 3: 
          { return createFullSymbol(ParserConstants.T_LNUMBER);
          }
        case 248: break;
        case 126: 
          { return createSymbol(ParserConstants.T_ENDFOR);
          }
        case 249: break;
        case 22: 
          { return createSymbol(ParserConstants.T_KOVA);
          }
        case 250: break;
        case 53: 
          { return createSymbol(ParserConstants.T_CONCAT_EQUAL);
          }
        case 251: break;
        case 47: 
          { popState();
    pushState(ST_IN_SCRIPTING);
    return createFullSymbol(ParserConstants.T_STRING_VARNAME);
          }
        case 252: break;
        case 123: 
          { heredoc = yytext().substring(3).trim();    // for '<<<'
    yybegin(ST_HEREDOC);
    return createSymbol(ParserConstants.T_START_HEREDOC);
          }
        case 253: break;
        case 118: 
          { return createSymbol(ParserConstants.T_CLASS);
          }
        case 254: break;
        case 92: 
          { if (asp_tags || yytext().charAt(0)!='%') { /* asp comment? */
   		handleLineCommentEnd();
        yypushback(yylength());
		yybegin(ST_IN_SCRIPTING);
		//return T_COMMENT;
	}
          }
        case 255: break;
        case 115: 
          { return createSymbol(ParserConstants.T_ISSET);
          }
        case 256: break;
        case 157: 
          { handleVarComment();
    //return createFullSymbol(ParserConstants.T_VAR_COMMENT);
          }
        case 257: break;
        case 33: 
          { yybegin(ST_DOUBLE_QUOTES);
    return createSymbol(ParserConstants.T_QUATE);
          }
        case 258: break;
        case 112: 
          { return createSymbol(ParserConstants.T_ENDIF);
          }
        case 259: break;
        case 46: 
          { yypushback(yylength());
    popState();
    pushState(ST_IN_SCRIPTING);
          }
        case 260: break;
        case 71: 
          { return createSymbol(ParserConstants.T_MUL_EQUAL);
          }
        case 261: break;
        case 18: 
          { return createSymbol(ParserConstants.T_DIV);
          }
        case 262: break;
        case 127: 
          { /* not a keyword, hust for recognize constans.*/
    return createFullSymbol(ParserConstants.T_DEFINE);
          }
        case 263: break;
        case 156: 
          { return createSymbol(ParserConstants.T_REQUIRE_ONCE);
          }
        case 264: break;
        case 5: 
          { return createFullSymbol(ParserConstants.T_STRING);
          }
        case 265: break;
        case 43: 
          { yybegin(ST_IN_SCRIPTING);
    return createSymbol(ParserConstants.T_BACKQUATE);
          }
        case 266: break;
        case 97: 
          { return createSymbol(ParserConstants.T_USE);
          }
        case 267: break;
        case 13: 
          { return createSymbol(ParserConstants.T_CLOSE_PARENTHESE);
          }
        case 268: break;
        case 42: 
          { yybegin(ST_IN_SCRIPTING);
    return createSymbol(ParserConstants.T_SINGLE_QUATE);
          }
        case 269: break;
        case 113: 
          { return createSymbol(ParserConstants.T_EMPTY);
          }
        case 270: break;
        case 39: 
          { return createSymbol(ParserConstants.T_CURLY_CLOSE);
          }
        case 271: break;
        case 143: 
          { return createSymbol(ParserConstants.T_LINE);
          }
        case 272: break;
        case 1: 
          { return createSymbol(ParserConstants.T_INLINE_HTML);
          }
        case 273: break;
        case 88: 
          { return createSymbol(ParserConstants.T_CHARACTER);
          }
        case 274: break;
        case 105: 
          { if (!parsePHPDoc()) {
handleCommentStart();
yybegin(ST_DOCBLOCK);
}
          }
        case 275: break;
        case 78: 
          { return createSymbol(ParserConstants.T_OR_EQUAL);
          }
        case 276: break;
        case 110: 
          { return createSymbol(ParserConstants.T_CASE);
          }
        case 277: break;
        case 144: 
          { return createSymbol(ParserConstants.T_FILE);
          }
        case 278: break;
        case 62: 
          { return createSymbol(ParserConstants.T_MINUS_EQUAL);
          }
        case 279: break;
        case 134: 
          { return createSymbol(ParserConstants.T_EXTENDS);
          }
        case 280: break;
        case 37: 
          { return createFullSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
          }
        case 281: break;
        case 137: 
          { return createSymbol(ParserConstants.T_DECLARE);
          }
        case 282: break;
        case 122: 
          { return createSymbol(ParserConstants.T_INT_CAST);
          }
        case 283: break;
        case 140: 
          { return createSymbol(ParserConstants.T_UNSET_CAST);
          }
        case 284: break;
        case 38: 
          { return createSymbol(ParserConstants.T_CURLY_OPEN);
          }
        case 285: break;
        case 12: 
          { return createSymbol(ParserConstants.T_OPEN_PARENTHESE);
          }
        case 286: break;
        case 86: 
          { pushState(ST_IN_SCRIPTING);
    yypushback(yylength()-1);
    return createSymbol(ParserConstants.T_CURLY_OPEN);
          }
        case 287: break;
        case 131: 
          { return createSymbol(ParserConstants.T_BOOL_CAST);
          }
        case 288: break;
        case 41: 
          { return createSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
          }
        case 289: break;
        case 99: 
          { return createSymbol(ParserConstants.T_LOGICAL_AND);
          }
        case 290: break;
        case 93: 
          { String text = yytext();
    if ((text.charAt(1)=='%' && asp_tags)
        || (text.charAt(1)=='?' && short_tags_allowed)) {
        yybegin(ST_IN_SCRIPTING);
        //return T_OPEN_TAG_WITH_ECHO;
    } else {
        return createSymbol(ParserConstants.T_INLINE_HTML);
    }
          }
        case 291: break;
        case 14: 
          { return createSymbol(ParserConstants.T_EQUAL);
          }
        case 292: break;
        case 56: 
          { return createSymbol(ParserConstants.T_IF);
          }
        case 293: break;
        case 24: 
          { return createSymbol(ParserConstants.T_COMMA);
          }
        case 294: break;
        case 103: 
          { return createSymbol(ParserConstants.T_IS_NOT_IDENTICAL);
          }
        case 295: break;
        case 69: 
          { return createSymbol(ParserConstants.T_IS_SMALLER_OR_EQUAL);
          }
        case 296: break;
        case 108: 
          { return createSymbol(ParserConstants.T_EVAL);
          }
        case 297: break;
        case 79: 
          { return createSymbol(ParserConstants.T_BOOLEAN_OR);
          }
        case 298: break;
        case 154: 
          { return createSymbol(ParserConstants.T_OLD_FUNCTION);
          }
        case 299: break;
        case 63: 
          { return createSymbol(ParserConstants.T_SR);
          }
        case 300: break;
        case 145: 
          { return createSymbol(ParserConstants.T_FUNCTION);
          }
        case 301: break;
        case 10: 
          { return createSymbol(ParserConstants.T_LGREATER);
          }
        case 302: break;
        case 101: 
          { return createSymbol(ParserConstants.T_VAR);
          }
        case 303: break;
        case 142: 
          { return createSymbol(ParserConstants.T_ENDWHILE);
          }
        case 304: break;
        case 80: 
          { return createSymbol(ParserConstants.T_XOR_EQUAL);
          }
        case 305: break;
        case 146: 
          { return createSymbol(ParserConstants.T_CONTINUE);
          }
        case 306: break;
        case 61: 
          { pushState(ST_LOOKING_FOR_PROPERTY);
    return createSymbol(ParserConstants.T_OBJECT_OPERATOR);
          }
        case 307: break;
        case 95: 
          { return createFullSymbol(ParserConstants.T_EXIT);
          }
        case 308: break;
        case 34: 
          { yybegin(ST_SINGLE_QUOTE);
    return createSymbol(ParserConstants.T_SINGLE_QUATE);
          }
        case 309: break;
        case 121: 
          { return createSymbol(ParserConstants.T_PRINT);
          }
        case 310: break;
        case 70: 
          { return createSymbol(ParserConstants.T_SL);
          }
        case 311: break;
        case 153: 
          { return createSymbol(ParserConstants.T_INCLUDE_ONCE);
          }
        case 312: break;
        case 7: 
          { 
          }
        case 313: break;
        case 30: 
          { return createSymbol(ParserConstants.T_AT);
          }
        case 314: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            zzDoEOF();
              {     return createSymbol(sym.EOF);
 }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }

  /**
   * Runs the scanner on input files.
   *
   * This is a standalone scanner, it will print any unmatched
   * text to System.out unchanged.
   *
   * @param argv   the command line, contains the filenames to run
   *               the scanner on.
   */
  public static void main(String argv[]) {
    if (argv.length == 0) {
      System.out.println("Usage : java PhpAstLexer <inputfile>");
    }
    else {
      for (int i = 0; i < argv.length; i++) {
        PhpAstLexer scanner = null;
        try {
          scanner = new PhpAstLexer( new java.io.FileReader(argv[i]) );
          while ( !scanner.zzAtEOF ) scanner.next_token();
        }
        catch (java.io.FileNotFoundException e) {
          System.out.println("File not found : \""+argv[i]+"\"");
        }
        catch (java.io.IOException e) {
          System.out.println("IO error scanning file \""+argv[i]+"\"");
          System.out.println(e);
        }
        catch (Exception e) {
          System.out.println("Unexpected exception:");
          e.printStackTrace();
        }
      }
    }
  }


}
