/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.SourceRange;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.codeassist.ICompletionReporter;
import org.eclipse.php.internal.core.codeassist.contexts.AbstractCompletionContext;
import org.eclipse.php.internal.core.codeassist.strategies.GlobalTypesStrategy;
import org.eclipse.php.internal.core.typeinference.FakeConstructor;

public abstract class AbstractClassInstantiationStrategy
extends GlobalTypesStrategy {
    public AbstractClassInstantiationStrategy(ICompletionContext context, int trueFlag, int falseFlag) {
        super(context, trueFlag, falseFlag);
    }

    public AbstractClassInstantiationStrategy(ICompletionContext context) {
        this(context, 0, 0);
    }

    public void apply(ICompletionReporter reporter) throws BadLocationException {
        IType[] types;
        ICompletionContext context = this.getContext();
        AbstractCompletionContext concreteContext = (AbstractCompletionContext)context;
        IType enclosingClass = null;
        try {
            IModelElement parent;
            IModelElement enclosingElement = concreteContext.getSourceModule().getElementAt(concreteContext.getOffset());
            while (enclosingElement instanceof IField) {
                enclosingElement = enclosingElement.getParent();
            }
            if (enclosingElement instanceof IMethod && (parent = ((IMethod)enclosingElement).getParent()) instanceof IType) {
                enclosingClass = (IType)parent;
            }
        }
        catch (ModelException e) {
            PHPCorePlugin.log(e);
        }
        SourceRange replaceRange = this.getReplacementRange(context);
        String suffix = this.getSuffix(concreteContext);
        IType[] iTypeArray = types = this.getTypes(concreteContext);
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            if (!concreteContext.getCompletionRequestor().isContextInformationMode()) {
                FakeConstructor ctorMethod = FakeConstructor.createFakeConstructor(null, type, type.equals(enclosingClass));
                reporter.reportMethod((IMethod)ctorMethod, suffix, replaceRange);
            } else {
                IMethod[] ctors = FakeConstructor.getConstructors(type, type.equals(enclosingClass));
                if (ctors != null && ctors.length == 2) {
                    if (ctors[1] != null) {
                        reporter.reportMethod(ctors[1], suffix, replaceRange);
                    } else if (ctors[0] == null) {
                        reporter.reportType(type, suffix, replaceRange);
                    }
                }
            }
            ++n2;
        }
    }

    public String getSuffix(AbstractCompletionContext abstractContext) {
        int nextChar = 32;
        try {
            nextChar = abstractContext.getNextChar();
        }
        catch (BadLocationException e) {
            PHPCorePlugin.log(e);
        }
        return 40 == nextChar ? "" : "()";
    }
}

