/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import java.util.Arrays;
import java.util.LinkedList;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.SourceRange;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.codeassist.CodeAssistUtils;
import org.eclipse.php.internal.core.codeassist.ICompletionReporter;
import org.eclipse.php.internal.core.codeassist.contexts.AbstractCompletionContext;
import org.eclipse.php.internal.core.codeassist.strategies.GlobalElementStrategy;
import org.eclipse.php.internal.core.model.PhpModelAccess;
import org.eclipse.php.internal.core.typeinference.FakeMethod;

public class GlobalTypesStrategy
extends GlobalElementStrategy {
    protected final int trueFlag;
    protected final int falseFlag;
    protected static final IType[] EMPTY = new IType[0];

    public GlobalTypesStrategy(ICompletionContext context, int trueFlag, int falseFlag) {
        super(context, null);
        this.trueFlag = trueFlag;
        this.falseFlag = falseFlag;
    }

    public GlobalTypesStrategy(ICompletionContext context) {
        this(context, 0, 0);
    }

    public SourceRange getReplacementRange(ICompletionContext context) throws BadLocationException {
        SourceRange replacementRange = super.getReplacementRange(context);
        if (replacementRange.getLength() > 0) {
            return new SourceRange(replacementRange.getOffset(), replacementRange.getLength() - 1);
        }
        return replacementRange;
    }

    public void apply(ICompletionReporter reporter) throws BadLocationException {
        ICompletionContext context = this.getContext();
        AbstractCompletionContext abstractContext = (AbstractCompletionContext)context;
        SourceRange replacementRange = this.getReplacementRange(abstractContext);
        IType[] types = this.getTypes(abstractContext);
        String suffix = "";
        String nsSuffix = this.getNSSuffix(abstractContext);
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            try {
                int flags = type.getFlags();
                reporter.reportType(type, PHPFlags.isNamespace(flags) ? nsSuffix : suffix, replacementRange, this.getExtraInfo());
            }
            catch (ModelException e) {
                PHPCorePlugin.log(e);
            }
            ++n2;
        }
    }

    protected IType[] getTypes(AbstractCompletionContext context) throws BadLocationException {
        IType[] types;
        String prefix = context.getPrefix();
        if (prefix.startsWith("$")) {
            return EMPTY;
        }
        IDLTKSearchScope scope = this.createSearchScope();
        if (context.getCompletionRequestor().isContextInformationMode()) {
            return PhpModelAccess.getDefault().findTypes(prefix, ISearchEngine.MatchRule.EXACT, this.trueFlag, this.falseFlag, scope, null);
        }
        LinkedList<IType> result = new LinkedList<IType>();
        if (prefix.length() > 1 && prefix.toUpperCase().equals(prefix)) {
            types = PhpModelAccess.getDefault().findTypes(prefix, ISearchEngine.MatchRule.CAMEL_CASE, this.trueFlag, this.falseFlag, scope, null);
            result.addAll(Arrays.asList(types));
        }
        types = PhpModelAccess.getDefault().findTypes(prefix, ISearchEngine.MatchRule.PREFIX, this.trueFlag, this.falseFlag, scope, null);
        result.addAll(Arrays.asList(types));
        return result.toArray(new IType[result.size()]);
    }

    protected void addSelf(AbstractCompletionContext context, ICompletionReporter reporter) throws BadLocationException {
        String prefix = context.getPrefix();
        SourceRange replaceRange = this.getReplacementRange(context);
        if (CodeAssistUtils.startsWithIgnoreCase("self", prefix) && (!context.getCompletionRequestor().isContextInformationMode() || prefix.length() == 4)) {
            String suffix = this.getSuffix(context);
            IType selfClassData = CodeAssistUtils.getSelfClassData(context.getSourceModule(), context.getOffset());
            if (selfClassData != null) {
                try {
                    ISourceRange sourceRange;
                    IMethod ctor = null;
                    IMethod[] iMethodArray = selfClassData.getMethods();
                    int n = iMethodArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMethod method = iMethodArray[n2];
                        if (method.isConstructor()) {
                            ctor = method;
                            break;
                        }
                        ++n2;
                    }
                    if (ctor != null) {
                        sourceRange = selfClassData.getSourceRange();
                        FakeMethod ctorMethod = new FakeMethod((ModelElement)selfClassData, "self", sourceRange.getOffset(), sourceRange.getLength(), sourceRange.getOffset(), sourceRange.getLength()){

                            public boolean isConstructor() throws ModelException {
                                return true;
                            }
                        };
                        ctorMethod.setParameters(ctor.getParameters());
                        reporter.reportMethod((IMethod)ctorMethod, suffix, replaceRange);
                    } else {
                        sourceRange = selfClassData.getSourceRange();
                        reporter.reportMethod((IMethod)new FakeMethod((ModelElement)selfClassData, "self", sourceRange.getOffset(), sourceRange.getLength(), sourceRange.getOffset(), sourceRange.getLength()), "()", replaceRange);
                    }
                }
                catch (ModelException e) {
                    PHPCorePlugin.log(e);
                }
            }
        }
    }

    public String getNSSuffix(AbstractCompletionContext abstractContext) {
        String nextWord = null;
        try {
            nextWord = abstractContext.getNextWord();
        }
        catch (BadLocationException e) {
            PHPCorePlugin.log(e);
        }
        return "\\".equals(nextWord) ? "" : "\\";
    }

    public String getSuffix(AbstractCompletionContext abstractContext) {
        String nextWord = null;
        try {
            nextWord = abstractContext.getNextWord();
        }
        catch (BadLocationException e) {
            PHPCorePlugin.log(e);
        }
        return "::".equals(nextWord) ? "" : "::";
    }

    protected Object getExtraInfo() {
        return null;
    }
}

