/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phar;

import org.eclipse.php.internal.core.phar.IAchiveOutputEntry;
import org.eclipse.php.internal.core.phar.PharFile;
import org.eclipse.php.internal.core.phar.PharUtil;

public class PharEntry
implements IAchiveOutputEntry {
    private String name;
    private int csize;
    private int size;
    private int position;
    private byte[] sizeByte;
    private long time;
    private byte[] crc;
    private byte[] bitMappedFlag;
    private String content;
    private String metadata;

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public byte[] getSizeByte() {
        return this.sizeByte;
    }

    public void setSizeByte(byte[] sizeByte) {
        this.sizeByte = PharUtil.getCopy(sizeByte);
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getCsize() {
        return this.csize;
    }

    public void setCsize(int csize) {
        this.csize = csize;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public byte[] getCrcByte() {
        return this.crc;
    }

    public void setCrcByte(byte[] crc) {
        this.crc = PharUtil.getCopy(crc);
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public byte[] getBitMappedFlag() {
        return this.bitMappedFlag;
    }

    public void setBitMappedFlag(byte[] bitMappedFlag) {
        this.bitMappedFlag = PharUtil.getCopy(bitMappedFlag);
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public boolean isDirectory() {
        return this.name.endsWith("/");
    }

    public boolean isCompressed() {
        return this.getCompressedType() != 0;
    }

    public int getCompressedType() {
        int result = 0;
        if ((this.bitMappedFlag[1] & 0x10) != 0) {
            result = 1;
        } else if ((this.bitMappedFlag[1] & 0x20) != 0) {
            result = 2;
        }
        return result;
    }

    public int getEnd() {
        return this.position + this.csize;
    }

    public long getCompressedSize() {
        return this.csize;
    }

    public long getCrc() {
        return this.toLong(this.crc);
    }

    private long toLong(byte[] crc2) {
        return PharFile.getInt(crc2);
    }

    public int getMethod() {
        return this.getCompressedType();
    }

    public void setCompressedSize(long csize) {
        this.setCsize((int)csize);
    }

    public void setCrc(long crc) {
        this.crc = PharEntry.toByte(crc);
    }

    public static byte[] toByte(long crc2) {
        byte[] result = new byte[]{(byte)(crc2 & 0xFFL), (byte)(crc2 >> 8 & 0xFFL), (byte)(crc2 >> 16 & 0xFFL), (byte)(crc2 >> 24 & 0xFFL)};
        return result;
    }

    public void setMethod(int method) {
        if (this.bitMappedFlag == null) {
            this.bitMappedFlag = new byte[4];
        }
        this.bitMappedFlag[1] = (byte)(this.bitMappedFlag[1] & 0x9F);
        if (2 == method) {
            this.bitMappedFlag[1] = (byte)(this.bitMappedFlag[1] & 0x20);
        } else if (1 == method) {
            this.bitMappedFlag[1] = (byte)(this.bitMappedFlag[1] & 0x10);
        }
    }

    public void setSize(long size) {
        this.setSize((int)size);
    }
}

