/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.php.internal.core.compiler.ast.nodes.GlobalStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.IfStatement;
import org.eclipse.php.internal.core.typeinference.Declaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeclarationScope {
    private Map<String, LinkedList<Declaration>> decls = new HashMap<String, LinkedList<Declaration>>();
    private IContext context;
    private Stack<Statement> innerBlocks = new Stack();

    public DeclarationScope(IContext context) {
        this.context = context;
    }

    public IContext getContext() {
        return this.context;
    }

    public void enterInnerBlock(Statement s) {
        if (!this.innerBlocks.isEmpty() && this.innerBlocks.peek() == s) {
            return;
        }
        this.innerBlocks.push(s);
    }

    public void exitInnerBlock() {
        if (!this.innerBlocks.isEmpty()) {
            this.innerBlocks.pop();
        }
    }

    public int getInnerBlockLevel() {
        return this.innerBlocks.size();
    }

    public Map<String, LinkedList<Declaration>> getAllDeclarations() {
        return this.decls;
    }

    public Declaration[] getDeclarations(String varName) {
        LinkedList<Declaration> result = new LinkedList<Declaration>();
        LinkedList<Declaration> varDecls = this.decls.get(varName);
        if (varDecls != null) {
            for (Declaration decl : varDecls) {
                if (decl == null) continue;
                result.add(decl);
            }
        }
        return result.toArray(new Declaration[result.size()]);
    }

    public void addDeclaration(String varName, ASTNode declNode) {
        Declaration decl;
        LinkedList<Declaration> varDecls = this.decls.get(varName);
        if (varDecls == null) {
            varDecls = new LinkedList();
            this.decls.put(varName, varDecls);
        }
        int level = this.innerBlocks.size();
        while (varDecls.size() > level + 1) {
            varDecls.removeLast();
        }
        while (varDecls.size() < level) {
            varDecls.addLast(null);
        }
        if (varDecls.size() > level && (decl = varDecls.get(level)) != null) {
            if (level > 0) {
                Statement block = (Statement)this.innerBlocks.get(level - 1);
                if (this.isInSameBlock(block, decl.getNode(), declNode)) {
                    decl.setNode(declNode);
                    return;
                }
            } else {
                decl.setNode(declNode);
                return;
            }
        }
        varDecls.addLast(new Declaration(declNode instanceof GlobalStatement, declNode));
    }

    private boolean isInSameBlock(Statement block, ASTNode oldNode, ASTNode newNode) {
        if (block instanceof IfStatement) {
            IfStatement ifStatement = (IfStatement)block;
            Statement oldBlock = this.getBlock(ifStatement, oldNode);
            Statement newBlock = this.getBlock(ifStatement, newNode);
            if (oldBlock != null && oldBlock == newBlock) {
                return this.isInSameBlock(newBlock, oldNode, newNode);
            }
            return false;
        }
        return true;
    }

    private Statement getBlock(IfStatement ifStatement, ASTNode node) {
        Statement falseStatement = ifStatement.getFalseStatement();
        Statement trueStatement = ifStatement.getTrueStatement();
        if (trueStatement != null && trueStatement.sourceStart() <= node.sourceStart() && trueStatement.sourceEnd() >= node.sourceEnd()) {
            return trueStatement;
        }
        if (falseStatement != null && falseStatement.sourceStart() <= node.sourceStart() && falseStatement.sourceEnd() >= node.sourceEnd()) {
            return falseStatement;
        }
        return null;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("Variable Declarations (").append(this.context).append("): \n\n");
        for (String varName : this.decls.keySet()) {
            buf.append(varName).append(" => { \n\n");
            LinkedList<Declaration> varDecls = this.decls.get(varName);
            if (varDecls != null) {
                for (Declaration declNode : varDecls) {
                    buf.append(declNode.toString()).append(", \n\n");
                }
            }
            buf.append("}, \n\n");
        }
        return buf.toString();
    }
}

