/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference.evaluators;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.dltk.ast.ASTListNode;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.references.TypeReference;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.evaluation.types.AmbiguousType;
import org.eclipse.dltk.ti.GoalState;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.ISourceModuleContext;
import org.eclipse.dltk.ti.goals.GoalEvaluator;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.internal.core.compiler.ast.nodes.ClassDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.FullyQualifiedReference;
import org.eclipse.php.internal.core.compiler.ast.nodes.NamespaceReference;
import org.eclipse.php.internal.core.typeinference.PHPClassType;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.typeinference.context.INamespaceContext;
import org.eclipse.php.internal.core.typeinference.context.MethodContext;

public class TypeReferenceEvaluator
extends GoalEvaluator {
    private TypeReference typeReference;
    private IEvaluatedType result;

    public TypeReferenceEvaluator(IGoal goal, TypeReference typeReference) {
        super(goal);
        this.typeReference = typeReference;
    }

    public IGoal[] init() {
        IContext context = this.goal.getContext();
        String className = this.typeReference.getName();
        if ("self".equals(className)) {
            MethodContext methodContext;
            IEvaluatedType instanceType;
            if (context instanceof MethodContext && (instanceType = (methodContext = (MethodContext)context).getInstanceType()) instanceof PHPClassType) {
                this.result = instanceType;
            }
        } else if ("parent".equals(className)) {
            if (context instanceof MethodContext) {
                LinkedList types;
                block13: {
                    MethodContext methodContext = (MethodContext)context;
                    ModuleDeclaration rootNode = methodContext.getRootNode();
                    final MethodDeclaration methodDecl = methodContext.getMethodNode();
                    types = new LinkedList();
                    try {
                        rootNode.traverse(new ASTVisitor(){
                            private TypeDeclaration currentType;
                            private boolean found;

                            public boolean visit(MethodDeclaration s) throws Exception {
                                if (s == methodDecl && this.currentType instanceof ClassDeclaration) {
                                    ClassDeclaration classDecl = (ClassDeclaration)this.currentType;
                                    ASTListNode superClasses = classDecl.getSuperClasses();
                                    List childs = superClasses.getChilds();
                                    for (ASTNode node : childs) {
                                        NamespaceReference namespace = null;
                                        SimpleReference reference = null;
                                        if (node instanceof SimpleReference && (reference = (SimpleReference)node) instanceof FullyQualifiedReference) {
                                            FullyQualifiedReference ref = (FullyQualifiedReference)node;
                                            namespace = ref.getNamespace();
                                        }
                                        if (namespace == null || namespace.getName().equals("")) {
                                            types.add(new PHPClassType(reference.getName()));
                                            continue;
                                        }
                                        types.add(new PHPClassType(namespace.getName(), reference.getName()));
                                    }
                                    this.found = true;
                                }
                                return !this.found;
                            }

                            public boolean visit(TypeDeclaration s) throws Exception {
                                this.currentType = s;
                                return !this.found;
                            }

                            public boolean endvisit(TypeDeclaration s) throws Exception {
                                this.currentType = null;
                                return super.endvisit(s);
                            }

                            public boolean visit(ASTNode n) throws Exception {
                                return !this.found;
                            }
                        });
                    }
                    catch (Exception e) {
                        if (!DLTKCore.DEBUG) break block13;
                        e.printStackTrace();
                    }
                }
                if (types.size() == 1) {
                    this.result = (IEvaluatedType)types.get(0);
                } else if (types.size() > 1) {
                    this.result = new AmbiguousType(types.toArray(new IEvaluatedType[types.size()]));
                }
            }
        } else {
            int offset;
            ISourceModule sourceModule;
            String fullyQualifiedName;
            String extractedNamespace;
            String parentNamespace = null;
            if (context instanceof INamespaceContext) {
                parentNamespace = ((INamespaceContext)context).getNamespace();
            }
            if (this.typeReference instanceof FullyQualifiedReference && (extractedNamespace = PHPModelUtils.extractNamespaceName(fullyQualifiedName = ((FullyQualifiedReference)this.typeReference).getFullyQualifiedName(), sourceModule = ((ISourceModuleContext)context).getSourceModule(), offset = this.typeReference.sourceStart())) != null) {
                parentNamespace = extractedNamespace;
                className = PHPModelUtils.getRealName(fullyQualifiedName, sourceModule, offset, className);
            }
            this.result = parentNamespace != null ? new PHPClassType(parentNamespace, className) : new PHPClassType(className);
        }
        return IGoal.NO_GOALS;
    }

    public Object produceResult() {
        return this.result;
    }

    public IGoal[] subGoalDone(IGoal subgoal, Object result, GoalState state) {
        return IGoal.NO_GOALS;
    }
}

