/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference.evaluators.phpdoc;

import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.ti.GoalState;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocTag;
import org.eclipse.php.internal.core.index.IPHPDocAwareElement;
import org.eclipse.php.internal.core.typeinference.PHPClassType;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.typeinference.PHPSimpleTypes;
import org.eclipse.php.internal.core.typeinference.PHPTypeInferenceUtils;
import org.eclipse.php.internal.core.typeinference.evaluators.AbstractMethodReturnTypeEvaluator;

public class PHPDocMethodReturnTypeEvaluator
extends AbstractMethodReturnTypeEvaluator {
    private static final Pattern PIPE_PATTERN = Pattern.compile("\\|");
    private final List<IEvaluatedType> evaluated = new LinkedList<IEvaluatedType>();

    public PHPDocMethodReturnTypeEvaluator(IGoal goal) {
        super(goal);
    }

    public IGoal[] init() {
        IMethod[] iMethodArray = this.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4;
            Object[] objectArray;
            IMethod method = iMethodArray[n2];
            IType currentNamespace = PHPModelUtils.getCurrentNamespace((IModelElement)method);
            if (method instanceof IPHPDocAwareElement) {
                String[] typeNames = ((IPHPDocAwareElement)method).getReturnTypes();
                if (typeNames != null) {
                    objectArray = typeNames;
                    n4 = typeNames.length;
                    n3 = 0;
                    while (n3 < n4) {
                        Object typeName = objectArray[n3];
                        IEvaluatedType type = this.getEvaluatedType((String)typeName, currentNamespace);
                        if (type != null) {
                            this.evaluated.add(type);
                        }
                        ++n3;
                    }
                }
            } else {
                PHPDocBlock docBlock = PHPModelUtils.getDocBlock(method);
                if (docBlock != null) {
                    objectArray = docBlock.getTags();
                    n4 = objectArray.length;
                    n3 = 0;
                    while (n3 < n4) {
                        Object tag = objectArray[n3];
                        if (((PHPDocTag)tag).getTagKind() == 6) {
                            SimpleReference[] simpleReferenceArray = ((PHPDocTag)tag).getReferences();
                            int n5 = simpleReferenceArray.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                String[] typesNames;
                                SimpleReference reference = simpleReferenceArray[n6];
                                String[] stringArray = typesNames = PIPE_PATTERN.split(reference.getName());
                                int n7 = typesNames.length;
                                int n8 = 0;
                                while (n8 < n7) {
                                    String typeName = stringArray[n8];
                                    IEvaluatedType type = this.getEvaluatedType(typeName, currentNamespace);
                                    if (type != null) {
                                        this.evaluated.add(type);
                                    }
                                    ++n8;
                                }
                                ++n6;
                            }
                        }
                        ++n3;
                    }
                }
            }
            ++n2;
        }
        return IGoal.NO_GOALS;
    }

    private IEvaluatedType getEvaluatedType(String typeName, IType currentNamespace) {
        Object type = PHPSimpleTypes.fromString(typeName);
        if (type == null) {
            if (typeName.indexOf(92) != -1 || currentNamespace == null) {
                type = new PHPClassType(typeName);
            } else if (currentNamespace != null) {
                type = new PHPClassType(currentNamespace.getElementName(), typeName);
            }
        }
        return type;
    }

    public Object produceResult() {
        return PHPTypeInferenceUtils.combineTypes(this.evaluated);
    }

    public IGoal[] subGoalDone(IGoal subgoal, Object result, GoalState state) {
        return IGoal.NO_GOALS;
    }
}

