/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.preferences;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.internal.filesystem.local.LocalFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.preferences.IPHPExesListener;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org.eclipse.php.internal.debug.core.preferences.PHPExesEvent;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PHPexes {
    private static final String NULL_PLACE_HOLDER = "null";
    private static final String SEPARATOR_FOR_PHPVERSION = "/";
    private static final String DEFAULT_ATTRIBUTE = "default";
    private static final String EXTENSION_POINT_NAME = "phpExe";
    private static final String LOCATION_ATTRIBUTE = "location";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String DEBUGGER_ID_ATTRIBUTE = "debuggerID";
    private static final String PHPEXE_TAG = "phpExe";
    public static final String SEPARATOR = ";";
    private static final String VERSION_ATTRIBUTE = "version";
    public static final String ZEND_DEBUGGER_ID = "org.eclipse.php.debug.core.zendDebugger";
    private static Object lock = new Object();
    private static PHPexes instance;
    private HashMap<String, HashMap<String, PHPexeItem>> items = new HashMap();
    private HashMap<String, PHPexeItem> defaultItems = new HashMap();
    private HashMap<PHPVersion, PHPexeItem> defaultItemsForPHPVersion = new HashMap();
    private final LinkedList<IPHPExesListener> listeners = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PHPexes getInstance() {
        Object object = lock;
        synchronized (object) {
            if (instance == null) {
                instance = new PHPexes();
            }
            return instance;
        }
    }

    private PHPexes() {
        this.load();
    }

    public static void changePermissions(File file) {
        LocalFile localFile;
        IFileInfo info;
        if (!Platform.getOS().equals("win32") && !(info = (localFile = new LocalFile(file)).fetchInfo()).getAttribute(4)) {
            info.setAttribute(4, true);
            try {
                localFile.putInfo(info, 1024, null);
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
        }
    }

    public void addItem(PHPexeItem item) {
        String debuggerId = item.getDebuggerID();
        HashMap<String, PHPexeItem> map = this.items.get(debuggerId);
        if (map == null) {
            map = new HashMap();
            this.items.put(debuggerId, map);
        }
        if (map.isEmpty()) {
            this.setDefaultItem(item);
        }
        map.put(item.getName(), item);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            PHPExesEvent phpExesEvent = new PHPExesEvent(item);
            ((IPHPExesListener)iter.next()).phpExeAdded(phpExesEvent);
        }
    }

    public PHPexeItem getDefaultItem(String debuggerId) {
        return this.defaultItems.get(debuggerId);
    }

    public boolean hasItems(String debuggerId) {
        HashMap<String, PHPexeItem> map = this.items.get(debuggerId);
        return map != null && map.size() > 0;
    }

    public boolean hasItems() {
        return this.getAllItems().length > 0;
    }

    public PHPexeItem[] getEditableItems() {
        Set<String> installedDebuggers = PHPDebuggersRegistry.getDebuggersIds();
        ArrayList<PHPexeItem> list = new ArrayList<PHPexeItem>();
        for (String debuggerId : installedDebuggers) {
            HashMap<String, PHPexeItem> installedExes = this.items.get(debuggerId);
            if (installedExes == null) continue;
            Set<String> exeNames = installedExes.keySet();
            for (String name : exeNames) {
                PHPexeItem exeItem = installedExes.get(name);
                if (!exeItem.isEditable()) continue;
                list.add(exeItem);
            }
        }
        return list.toArray(new PHPexeItem[list.size()]);
    }

    public PHPexeItem getItem(String debuggerId, String name) {
        HashMap<String, PHPexeItem> map = this.items.get(debuggerId);
        if (map == null) {
            return null;
        }
        return map.get(name);
    }

    public PHPexeItem getItemForFile(String exeFilePath, String iniFilePath) {
        Set<String> installedDebuggers = PHPDebuggersRegistry.getDebuggersIds();
        for (String debuggerId : installedDebuggers) {
            HashMap<String, PHPexeItem> installedExes = this.items.get(debuggerId);
            if (installedExes == null) continue;
            Set<String> exeNames = installedExes.keySet();
            for (String name : exeNames) {
                PHPexeItem exeItem = installedExes.get(name);
                boolean iniEquals = true;
                if (iniFilePath == null) {
                    iniEquals = exeItem.getINILocation() == null;
                } else {
                    boolean bl = exeItem.getINILocation() == null ? iniFilePath == null || iniFilePath.equals("") : (iniEquals = iniFilePath.equals(exeItem.getINILocation().toString()));
                }
                if (!iniEquals || !exeFilePath.equals(exeItem.getExecutable().toString())) continue;
                return exeItem;
            }
        }
        return null;
    }

    public PHPexeItem[] getItems(String debuggerId) {
        HashMap<String, PHPexeItem> installedExes = this.items.get(debuggerId);
        if (installedExes == null) {
            return null;
        }
        PHPexeItem[] retItems = new PHPexeItem[installedExes.size()];
        return installedExes.values().toArray(retItems);
    }

    public PHPexeItem[] getAllItems() {
        ArrayList<PHPexeItem> allItems = new ArrayList<PHPexeItem>();
        Set<String> debuggers = this.items.keySet();
        for (String debugger : debuggers) {
            HashMap<String, PHPexeItem> debuggerItems = this.items.get(debugger);
            if (debuggerItems == null) continue;
            Collection<PHPexeItem> exeItems = debuggerItems.values();
            for (PHPexeItem item : exeItems) {
                allItems.add(item);
            }
        }
        return allItems.toArray(new PHPexeItem[allItems.size()]);
    }

    private void load() {
        String[] defaults;
        String[] defaultItemForPHPVersions;
        Preferences prefs = PHPProjectPreferences.getModelPreferences();
        this.items = new HashMap();
        this.loadExtensions();
        String namesString = prefs.getString(PHPDebugCorePreferenceNames.INSTALLED_PHP_NAMES);
        if (namesString == null) {
            namesString = "";
        }
        String[] names = namesString.length() > 0 ? namesString.split(SEPARATOR) : new String[]{};
        String locationsString = prefs.getString(PHPDebugCorePreferenceNames.INSTALLED_PHP_LOCATIONS);
        if (locationsString == null) {
            locationsString = "";
        }
        String[] phpExecutablesLocations = locationsString.length() > 0 ? locationsString.split(SEPARATOR) : new String[]{};
        String inisString = prefs.getString(PHPDebugCorePreferenceNames.INSTALLED_PHP_INIS);
        if (inisString == null) {
            inisString = "";
        }
        String[] phpIniLocations = inisString.length() > 0 ? inisString.split(SEPARATOR) : new String[phpExecutablesLocations.length];
        String debuggersString = prefs.getString(PHPDebugCorePreferenceNames.INSTALLED_PHP_DEBUGGERS);
        if (debuggersString == null) {
            debuggersString = "";
        }
        String[] debuggers = debuggersString.length() > 0 ? debuggersString.split(SEPARATOR) : new String[]{};
        String defaultItemForPHPVersionString = prefs.getString(PHPDebugCorePreferenceNames.INSTALLED_PHP_DEFAULT_FOR_VERSIONS);
        if (defaultItemForPHPVersionString == null) {
            defaultItemForPHPVersionString = "";
        }
        String[] stringArray = defaultItemForPHPVersions = defaultItemForPHPVersionString.length() > 0 ? defaultItemForPHPVersionString.split(SEPARATOR) : new String[]{};
        assert (names.length == phpExecutablesLocations.length);
        int i = 0;
        while (i < phpExecutablesLocations.length) {
            boolean filterItem;
            String iniLocation = NULL_PLACE_HOLDER.equals(phpIniLocations[i]) ? null : phpIniLocations[i];
            final PHPexeItem item = new PHPexeItem(names[i], phpExecutablesLocations[i], iniLocation, debuggers[i]);
            if (defaultItemForPHPVersions.length == phpExecutablesLocations.length && !NULL_PLACE_HOLDER.equals(defaultItemForPHPVersions[i])) {
                String[] phpVersions = defaultItemForPHPVersions[i].length() > 0 ? defaultItemForPHPVersions[i].split(SEPARATOR_FOR_PHPVERSION) : new String[]{};
                int j = 0;
                while (j < phpVersions.length) {
                    PHPVersion phpVersion = PHPVersion.byAlias((String)phpVersions[j]);
                    if (phpVersion != null) {
                        item.addPHPVersionToDefaultList(phpVersion);
                        this.defaultItemsForPHPVersion.put(phpVersion, item);
                    }
                    ++j;
                }
            }
            if (item.getExecutable() != null && !(filterItem = WorkbenchActivityHelper.filterItem((Object)new IPluginContribution(){

                public String getLocalId() {
                    return item.getDebuggerID();
                }

                public String getPluginId() {
                    return "org.eclipse.php.debug.core";
                }
            }))) {
                this.addItem(item);
            }
            ++i;
        }
        String defaultsString = prefs.getString(PHPDebugCorePreferenceNames.INSTALLED_PHP_DEFAULTS);
        if (defaultsString == null) {
            defaultsString = "";
        }
        String[] stringArray2 = defaults = defaultsString.length() > 0 ? defaultsString.split(SEPARATOR) : new String[]{};
        int n = defaults.length;
        int n2 = 0;
        while (n2 < n) {
            String defaultExe = stringArray2[n2];
            String[] debuggerDefault = defaultExe.split("=");
            if (debuggerDefault.length == 2) {
                this.setDefaultItem(debuggerDefault[0], debuggerDefault[1]);
            }
            ++n2;
        }
    }

    private void loadExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor(PHPDebugPlugin.getID(), "phpExe");
        boolean isWindows = System.getProperty("os.name").toLowerCase().startsWith("windows");
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            block12: {
                IConfigurationElement element = iConfigurationElementArray[n2];
                if ("phpExe".equals(element.getName())) {
                    String name = element.getAttribute(NAME_ATTRIBUTE);
                    String location = element.getAttribute(LOCATION_ATTRIBUTE);
                    String version = element.getAttribute(VERSION_ATTRIBUTE);
                    String debuggerID = element.getAttribute(DEBUGGER_ID_ATTRIBUTE);
                    if (debuggerID == null || debuggerID.equals("")) {
                        debuggerID = ZEND_DEBUGGER_ID;
                    }
                    boolean isDefault = "true".equalsIgnoreCase(element.getAttribute(DEFAULT_ATTRIBUTE));
                    if (isWindows) {
                        location = String.valueOf(location) + ".exe";
                    }
                    String pluginId = element.getDeclaringExtension().getNamespaceIdentifier();
                    final String finalDebuggerID = debuggerID;
                    boolean filterItem = WorkbenchActivityHelper.filterItem((Object)new IPluginContribution(){

                        public String getLocalId() {
                            return finalDebuggerID;
                        }

                        public String getPluginId() {
                            return "org.eclipse.php.debug.core";
                        }
                    });
                    if (!filterItem) {
                        boolean itemFound;
                        block11: {
                            URL url = FileLocator.find((Bundle)Platform.getBundle((String)pluginId), (IPath)new Path(location), new HashMap());
                            itemFound = false;
                            if (url != null) {
                                try {
                                    url = FileLocator.resolve((URL)url);
                                    String filename = url.getFile();
                                    File file = new File(filename);
                                    if (!file.exists()) break block11;
                                    PHPexeItem newItem = new PHPexeItem(name, file, null, debuggerID, false);
                                    if (newItem == null || newItem.getExecutable() == null || newItem.getVersion() == null) break block12;
                                    if (version != null) {
                                        newItem.setVersion(version);
                                    }
                                    this.addItem(newItem);
                                    if (isDefault) {
                                        this.setDefaultItem(newItem);
                                    }
                                    itemFound = true;
                                }
                                catch (IOException iOException) {}
                            }
                        }
                        if (!itemFound) {
                            PHPDebugPlugin.getDefault().getLog().log((IStatus)new Status(1, PHPDebugPlugin.getID(), 1001, "PHP executable " + location + " not found neither in plugin " + pluginId + " nor in fragments attached to it", null));
                        }
                    }
                }
            }
            ++n2;
        }
    }

    public void removeItem(PHPexeItem item) {
        String debuggerID = item.getDebuggerID();
        HashMap<String, PHPexeItem> exes = this.items.get(debuggerID);
        PHPexeItem removedItem = null;
        if (exes != null) {
            removedItem = exes.remove(item.getName());
        }
        if (removedItem != null && removedItem.isDefault()) {
            this.defaultItems.remove(debuggerID);
            Iterator<PHPexeItem> iterator = exes.values().iterator();
            if (iterator.hasNext()) {
                this.setDefaultItem(iterator.next());
            }
        }
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            PHPExesEvent phpExesEvent = new PHPExesEvent(item);
            ((IPHPExesListener)iter.next()).phpExeRemoved(phpExesEvent);
        }
    }

    public void setDefaultItem(PHPexeItem defaultItem) {
        String debuggerID = defaultItem.getDebuggerID();
        PHPexeItem oldDefault = this.defaultItems.get(debuggerID);
        if (oldDefault == defaultItem) {
            return;
        }
        if (oldDefault != null) {
            oldDefault.setDefault(false);
        }
        defaultItem.setDefault(true);
        this.defaultItems.put(debuggerID, defaultItem);
    }

    public void setDefaultItem(String debuggerID, String defaultItemName) {
        PHPexeItem item = this.getItem(debuggerID, defaultItemName);
        if (item != null) {
            this.setDefaultItem(item);
        }
    }

    public void save() {
        Preferences prefs = PHPProjectPreferences.getModelPreferences();
        PHPexeItem[] phpItems = this.getEditableItems();
        StringBuffer locationsString = new StringBuffer();
        StringBuffer inisString = new StringBuffer();
        StringBuffer namesString = new StringBuffer();
        StringBuffer debuggersString = new StringBuffer();
        StringBuffer defaultItemForPHPVersionString = new StringBuffer();
        int i = 0;
        while (i < phpItems.length) {
            PHPexeItem item = phpItems[i];
            if (i > 0) {
                locationsString.append(SEPARATOR);
                inisString.append(SEPARATOR);
                namesString.append(SEPARATOR);
                debuggersString.append(SEPARATOR);
                defaultItemForPHPVersionString.append(SEPARATOR);
            }
            locationsString.append(item.getExecutable().toString());
            inisString.append(item.getINILocation() != null ? item.getINILocation().toString() : NULL_PLACE_HOLDER);
            namesString.append(item.getName());
            debuggersString.append(item.getDebuggerID());
            if (item.geDefaultForPHPVersionSize() > 0) {
                int j = 0;
                while (j < item.geDefaultForPHPVersionSize()) {
                    if (j > 0) {
                        defaultItemForPHPVersionString.append(SEPARATOR_FOR_PHPVERSION);
                    }
                    defaultItemForPHPVersionString.append(item.getPHPVersionAtDefaultList(j).getAlias());
                    ++j;
                }
            } else {
                defaultItemForPHPVersionString.append(NULL_PLACE_HOLDER);
            }
            ++i;
        }
        prefs.setValue(PHPDebugCorePreferenceNames.INSTALLED_PHP_NAMES, namesString.toString());
        prefs.setValue(PHPDebugCorePreferenceNames.INSTALLED_PHP_LOCATIONS, locationsString.toString());
        prefs.setValue(PHPDebugCorePreferenceNames.INSTALLED_PHP_INIS, inisString.toString());
        prefs.setValue(PHPDebugCorePreferenceNames.INSTALLED_PHP_DEBUGGERS, debuggersString.toString());
        prefs.setValue(PHPDebugCorePreferenceNames.INSTALLED_PHP_DEFAULT_FOR_VERSIONS, defaultItemForPHPVersionString.toString());
        StringBuffer defaultsString = new StringBuffer();
        Iterator<PHPexeItem> iterator = this.defaultItems.values().iterator();
        while (iterator.hasNext()) {
            PHPexeItem exeItem = iterator.next();
            defaultsString.append(exeItem.getDebuggerID());
            defaultsString.append('=');
            defaultsString.append(exeItem.getName());
            if (!iterator.hasNext()) continue;
            defaultsString.append(SEPARATOR);
        }
        prefs.setValue(PHPDebugCorePreferenceNames.INSTALLED_PHP_DEFAULTS, defaultsString.toString());
        PHPDebugPlugin.getDefault().savePluginPreferences();
    }

    public void addPHPExesListener(IPHPExesListener listener) {
        this.listeners.add(listener);
    }

    public void removePHPExesListener(IPHPExesListener listener) {
        this.listeners.remove(listener);
    }

    public void setItemDefaultForPHPVersion(PHPexeItem phPexeItem, PHPVersion phpVersion) {
        PHPexeItem oldItem = this.defaultItemsForPHPVersion.get(phpVersion);
        if (oldItem != null) {
            oldItem.removePHPVersionToDefaultList(phpVersion);
        }
        phPexeItem.addPHPVersionToDefaultList(phpVersion);
        this.defaultItemsForPHPVersion.put(phpVersion, phPexeItem);
    }

    public PHPexeItem getDefaultItemForPHPVersion(PHPVersion phpVersion) {
        return this.defaultItemsForPHPVersion.get(phpVersion);
    }

    public HashMap<PHPVersion, PHPexeItem> getDefaultItemsForPHPVersion() {
        return this.defaultItemsForPHPVersion;
    }

    public PHPexeItem[] getCompatibleItems(PHPexeItem[] allItems, PHPVersion version) {
        String versionNumber = version.getAlias().substring(3);
        ArrayList<PHPexeItem> list = new ArrayList<PHPexeItem>();
        int i = 0;
        while (i < allItems.length) {
            if (allItems[i].getVersion() != null && allItems[i].getVersion().compareTo(versionNumber) >= 0) {
                list.add(allItems[i]);
            }
            ++i;
        }
        PHPexeItem[] result = list.toArray(new PHPexeItem[list.size()]);
        return result;
    }
}

