/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.configuration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.wst.sse.core.internal.text.rules.SimpleStructuredTypedRegion;
import org.eclipse.wst.sse.ui.internal.provisional.style.StructuredPresentationReconciler;

public class PHPStructuredPresentationReconciler
extends StructuredPresentationReconciler {
    private static final String CSS_STYLE = "org.eclipse.wst.css.STYLE";
    private Map fRepairers;
    private static final Set<String> fTypeSet = new HashSet<String>();

    static {
        fTypeSet.add(CSS_STYLE);
    }

    ITypedRegion getWholeRegion(ITypedRegion[] wholePartitions, ITypedRegion originalRegion) {
        if (fTypeSet.contains(originalRegion.getType())) {
            int i = 0;
            int jumpto = -1;
            while (i < wholePartitions.length) {
                ITypedRegion r = wholePartitions[i];
                if (wholePartitions[i].getType().equals(originalRegion.getType())) {
                    jumpto = this.getFollowingCSS(wholePartitions, i);
                    r = new SimpleStructuredTypedRegion(r.getOffset(), wholePartitions[jumpto].getOffset() + wholePartitions[jumpto].getLength() - r.getOffset(), originalRegion.getType());
                    if (originalRegion.getOffset() >= r.getOffset() && originalRegion.getOffset() + originalRegion.getLength() <= r.getOffset() + r.getLength()) {
                        return r;
                    }
                    i = jumpto + 2;
                    continue;
                }
                ++i;
            }
        }
        return null;
    }

    protected TextPresentation createPresentation(IRegion damage, IDocument document) {
        try {
            int validLength = Math.min(damage.getLength(), document.getLength() - damage.getOffset());
            if (this.fRepairers == null || this.fRepairers.isEmpty()) {
                TextPresentation presentation = new TextPresentation(damage, 1);
                presentation.setDefaultStyleRange(new StyleRange(damage.getOffset(), validLength, null, null));
                return presentation;
            }
            TextPresentation presentation = new TextPresentation(damage, 1000);
            ITypedRegion[] partitions = TextUtilities.computePartitioning((IDocument)document, (String)this.getDocumentPartitioning(), (int)damage.getOffset(), (int)validLength, (boolean)false);
            if (partitions != null && partitions.length > 0) {
                int start = damage.getOffset();
                int length = validLength;
                ITypedRegion[] wholePartitions = TextUtilities.computePartitioning((IDocument)document, (String)this.getDocumentPartitioning(), (int)0, (int)document.getLength(), (boolean)false);
                ITypedRegion newRegion = this.getWholeRegion(wholePartitions, partitions[0]);
                if (newRegion != null) {
                    start = newRegion.getOffset();
                }
                if ((newRegion = this.getWholeRegion(wholePartitions, partitions[partitions.length - 1])) != null) {
                    length = newRegion.getOffset() + newRegion.getLength() - start;
                }
                partitions = TextUtilities.computePartitioning((IDocument)document, (String)this.getDocumentPartitioning(), (int)start, (int)length, (boolean)false);
            }
            HashSet<StyleRange> fRangeSet = new HashSet<StyleRange>();
            int jumpto = -1;
            int i = 0;
            while (i < partitions.length) {
                Iterator iterator;
                ITypedRegion r = partitions[i];
                if (r.getType().equals(CSS_STYLE)) {
                    if (i > jumpto) {
                        jumpto = this.getFollowingCSS(partitions, i);
                        IPresentationRepairer repairer = this.getRepairer((r = new SimpleStructuredTypedRegion(r.getOffset(), partitions[jumpto].getOffset() + partitions[jumpto].getLength() - r.getOffset(), CSS_STYLE)).getType());
                        if (repairer != null) {
                            repairer.createPresentation(presentation, r);
                            iterator = presentation.getAllStyleRangeIterator();
                            while (iterator.hasNext()) {
                                StyleRange styleRange = (StyleRange)iterator.next();
                                if (styleRange.start < r.getOffset() || styleRange.start + styleRange.length > r.getOffset() + r.getLength()) continue;
                                int j = i + 1;
                                while (j < jumpto) {
                                    ITypedRegion typedRegion = partitions[j];
                                    if (styleRange.start < typedRegion.getOffset() && styleRange.start + styleRange.length > typedRegion.getOffset() + typedRegion.getLength()) {
                                        int end = styleRange.start + styleRange.length;
                                        styleRange.length = typedRegion.getOffset() - styleRange.start;
                                        fRangeSet.add(styleRange);
                                        styleRange = new StyleRange(typedRegion.getOffset() + typedRegion.getLength(), end - (typedRegion.getOffset() + typedRegion.getLength()), styleRange.foreground, styleRange.background, styleRange.fontStyle);
                                    } else {
                                        if (styleRange.start < typedRegion.getOffset() && styleRange.start + styleRange.length > typedRegion.getOffset()) {
                                            styleRange.length = typedRegion.getOffset() - styleRange.start;
                                            break;
                                        }
                                        if (styleRange.start >= typedRegion.getOffset() && styleRange.start + styleRange.length <= typedRegion.getOffset() + typedRegion.getLength()) {
                                            styleRange = null;
                                            break;
                                        }
                                        if (styleRange.start > typedRegion.getOffset() && styleRange.start < typedRegion.getOffset() + typedRegion.getLength() && styleRange.start + styleRange.length > typedRegion.getOffset() + typedRegion.getLength()) {
                                            styleRange.length = styleRange.start + styleRange.length - (typedRegion.getOffset() + typedRegion.getLength());
                                            styleRange.start = typedRegion.getOffset() + typedRegion.getLength();
                                        } else if (styleRange.start + styleRange.length < typedRegion.getOffset()) break;
                                    }
                                    j += 2;
                                }
                                if (styleRange == null) continue;
                                fRangeSet.add(styleRange);
                            }
                        }
                    }
                } else {
                    int oldLength = 0;
                    iterator = presentation.getAllStyleRangeIterator();
                    while (iterator.hasNext()) {
                        iterator.next();
                        ++oldLength;
                    }
                    IPresentationRepairer repairer = this.getRepairer(r.getType());
                    if (repairer != null) {
                        repairer.createPresentation(presentation, r);
                    }
                    Iterator iterator2 = presentation.getAllStyleRangeIterator();
                    while (iterator2.hasNext()) {
                        StyleRange styleRange = (StyleRange)iterator2.next();
                        if (--oldLength >= 0) continue;
                        fRangeSet.add(styleRange);
                    }
                }
                ++i;
            }
            ArrayList<StyleRange> fRanges = new ArrayList<StyleRange>();
            for (StyleRange styleRange : fRangeSet) {
                fRanges.add(styleRange);
            }
            Collections.sort(fRanges, new Comparator<StyleRange>(){

                @Override
                public int compare(StyleRange o1, StyleRange o2) {
                    return o1.start - o2.start;
                }
            });
            presentation = new TextPresentation(damage, fRanges.size());
            for (StyleRange styleRange : fRanges) {
                if (styleRange.start + styleRange.length <= damage.getOffset()) continue;
                if (styleRange.start <= damage.getOffset() && styleRange.start + styleRange.length > damage.getOffset() && styleRange.start + styleRange.length <= damage.getOffset() + validLength) {
                    int rangeEnd = styleRange.start + styleRange.length;
                    styleRange.start = damage.getOffset();
                    styleRange.length = rangeEnd - damage.getOffset();
                    this.addStyleRange(presentation, styleRange);
                    continue;
                }
                if (styleRange.start >= damage.getOffset() && styleRange.start < damage.getOffset() + validLength && styleRange.start + styleRange.length > damage.getOffset() + validLength) {
                    styleRange.length = damage.getOffset() + validLength - styleRange.start;
                    this.addStyleRange(presentation, styleRange);
                    continue;
                }
                if (styleRange.start < damage.getOffset() || styleRange.start + styleRange.length > damage.getOffset() + validLength) continue;
                this.addStyleRange(presentation, styleRange);
            }
            return presentation;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private void addStyleRange(TextPresentation presentation, StyleRange styleRange) {
        if (styleRange.length > 0) {
            presentation.addStyleRange(styleRange);
        }
    }

    private int getFollowingCSS(ITypedRegion[] partitions, int i) {
        int result = i++;
        while (i < partitions.length) {
            if (i + 1 >= partitions.length || !partitions[i].getType().equals("org.eclipse.php.PHP_DEFAULT") || !partitions[i + 1].getType().equals(CSS_STYLE)) break;
            result += 2;
            i += 2;
        }
        return result;
    }

    public void setRepairer(IPresentationRepairer repairer, String contentType) {
        super.setRepairer(repairer, contentType);
        Assert.isNotNull((Object)contentType);
        if (this.fRepairers == null) {
            this.fRepairers = new HashMap();
        }
        if (repairer == null) {
            this.fRepairers.remove(contentType);
        } else {
            this.fRepairers.put(contentType, repairer);
        }
    }
}

