/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.highlighters;

import java.util.Collection;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ClassName;
import org.eclipse.php.internal.core.ast.nodes.FieldAccess;
import org.eclipse.php.internal.core.ast.nodes.FunctionInvocation;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.MethodInvocation;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.typeinference.IModelAccessCache;
import org.eclipse.php.internal.ui.editor.highlighter.AbstractSemanticApply;
import org.eclipse.php.internal.ui.editor.highlighter.AbstractSemanticHighlighting;
import org.eclipse.php.internal.ui.editor.highlighter.ModelUtils;

public class DeprecatedHighlighting
extends AbstractSemanticHighlighting {
    public AbstractSemanticApply getSemanticApply() {
        return new DeprecatedApply();
    }

    public void initDefaultPreferences() {
        this.getStyle().setStrikethroughByDefault(true);
    }

    public int getPriority() {
        return 12;
    }

    public String getDisplayName() {
        return "Deprecated members";
    }

    protected class DeprecatedApply
    extends AbstractSemanticApply {
        protected DeprecatedApply() {
        }

        public boolean visit(Program program) {
            try {
                IModelElement[] children;
                IModelElement[] iModelElementArray = children = DeprecatedHighlighting.this.getSourceModule().getChildren();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    IModelElement[] children1;
                    IModelElement child = iModelElementArray[n2];
                    if (ModelUtils.isDeprecated(child)) {
                        DeprecatedHighlighting.this.highlight(((IMember)child).getNameRange());
                    }
                    IModelElement[] iModelElementArray2 = children1 = ((IParent)child).getChildren();
                    int n3 = children1.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IModelElement child1 = iModelElementArray2[n4];
                        if (ModelUtils.isDeprecated(child1)) {
                            DeprecatedHighlighting.this.highlight(((IMember)child1).getNameRange());
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
            catch (ModelException e) {
                Logger.logException((Throwable)e);
            }
            return true;
        }

        public boolean visit(ClassName classConst) {
            if (classConst.getName() instanceof Identifier) {
                Collection types;
                String className = ((Identifier)classConst.getName()).getName();
                IModelAccessCache cache = classConst.getAST().getBindingResolver().getModelAccessCache();
                if (cache != null && (types = cache.getTypes(DeprecatedHighlighting.this.getSourceModule(), className, null, null)) != null) {
                    for (IType type : types) {
                        if (!ModelUtils.isDeprecated((IModelElement)type)) continue;
                        DeprecatedHighlighting.this.highlight((ASTNode)classConst);
                        break;
                    }
                }
            }
            return true;
        }

        public boolean visit(FieldAccess fieldAccess) {
            IField field = ModelUtils.getField(fieldAccess);
            if (field != null && ModelUtils.isDeprecated((IModelElement)field)) {
                DeprecatedHighlighting.this.highlight((ASTNode)fieldAccess.getMember());
            }
            return true;
        }

        public boolean visit(MethodInvocation methodInv) {
            IMethod method = ModelUtils.getMethod(methodInv);
            if (method != null && ModelUtils.isDeprecated((IModelElement)method)) {
                DeprecatedHighlighting.this.highlight((ASTNode)methodInv.getMethod().getFunctionName());
            }
            return true;
        }

        public boolean visit(FunctionInvocation funcInv) {
            Collection functions;
            IModelAccessCache cache;
            if (!(funcInv.getParent() instanceof MethodInvocation) && (cache = funcInv.getAST().getBindingResolver().getModelAccessCache()) != null && (functions = cache.getGlobalFunctions(DeprecatedHighlighting.this.getSourceModule(), ModelUtils.getFunctionName(funcInv.getFunctionName()), null)) != null) {
                for (IMethod function : functions) {
                    if (!ModelUtils.isDeprecated((IModelElement)function)) continue;
                    DeprecatedHighlighting.this.highlight((ASTNode)funcInv.getFunctionName());
                    break;
                }
            }
            return true;
        }
    }
}

