/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.pbs.ui.wizards;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ptp.core.attributes.BooleanAttribute;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.IntegerAttribute;
import org.eclipse.ptp.rm.pbs.ui.PBSUIPlugin;
import org.eclipse.ptp.rm.pbs.ui.data.AttributePlaceholder;
import org.eclipse.ptp.rm.pbs.ui.data.PBSBatchScriptTemplate;
import org.eclipse.ptp.rm.pbs.ui.messages.Messages;
import org.eclipse.ptp.rm.pbs.ui.utils.WidgetUtils;
import org.eclipse.ptp.rm.ui.launch.RMLaunchConfigurationDynamicTabWidgetListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PBSRMLaunchConfigurationDynamicTabWizardPage
extends WizardPage {
    private Properties constrained;
    private Composite container;
    private final RMLaunchConfigurationDynamicTabWidgetListener listener;
    private Map<String, AttributePlaceholder> pbsJobAttributes;
    private final Map<Control, AttributePlaceholder> valueWidgets;

    public PBSRMLaunchConfigurationDynamicTabWizardPage(Map<Control, AttributePlaceholder> valueWidgets, RMLaunchConfigurationDynamicTabWidgetListener listener, PBSBatchScriptTemplate template) {
        super("");
        this.valueWidgets = valueWidgets;
        this.listener = listener;
        if (template != null) {
            this.pbsJobAttributes = template.getPbsJobAttributes();
        }
        this.loadConstraints();
    }

    public void createControl(Composite parent) {
        this.container = WidgetUtils.createAnonymousNonFillingGroup(parent, 3);
        WidgetUtils.createLabel(this.container, Messages.DynamicTabWizardPage_ATTRIBUTE, 16384, 1).setForeground(WidgetUtils.DKMG);
        WidgetUtils.createLabel(this.container, Messages.DynamicTabWizardPage_VALUE, 16384, 1).setForeground(WidgetUtils.DKMG);
        WidgetUtils.createLabel(this.container, Messages.DynamicTabWizardPage_DESCRIPTION, 16384, 1).setForeground(WidgetUtils.DKMG);
        if (this.pbsJobAttributes != null) {
            for (AttributePlaceholder ap : this.pbsJobAttributes.values()) {
                if (Messages.PBSAttributeInternalExtension.equals(ap.getToolTip())) continue;
                IAttribute<?, ?, ?> attr = ap.getAttribute();
                String name = ap.getName();
                String descr = attr.getDefinition().getDescription();
                Label l = WidgetUtils.createLabel(this.container, name, 16384, 1);
                l.setToolTipText(ap.getToolTip());
                this.valueWidgets.put(this.getValueWidget(this.container, ap.getDefaultString(), attr), ap);
                l = WidgetUtils.createLabel(this.container, descr, 16384, 1);
                l.setForeground(WidgetUtils.DKBL);
            }
        }
        this.setControl((Control)this.container);
    }

    private Control getValueWidget(Composite container, String defaultString, IAttribute<?, ?, ?> attr) {
        String value = attr.getValueAsString();
        Object c = null;
        if (attr instanceof BooleanAttribute) {
            Button b = WidgetUtils.createButton(container, "", null, 32, 1, false, (SelectionListener)this.listener);
            if ("true".equals(value)) {
                b.setSelection(true);
            }
            c = b;
        } else if (attr instanceof IntegerAttribute) {
            c = WidgetUtils.createSpinner(container, null, Integer.parseInt(defaultString), Integer.MAX_VALUE, Integer.parseInt(value), 1, false, (ModifyListener)this.listener);
        } else {
            String name = attr.getDefinition().getId();
            String constraints = this.constrained.getProperty(name);
            if (constraints != null) {
                String[] items = constraints.split(",");
                c = WidgetUtils.createItemCombo(container, null, items, items[0], "", false, (ModifyListener)this.listener, 1);
            } else {
                c = name.equals("destination") ? WidgetUtils.createItemCombo(container, null, new String[0], null, "", false, (ModifyListener)this.listener, 1) : WidgetUtils.createText(container, value, true, (ModifyListener)this.listener, null);
            }
            c.setForeground(WidgetUtils.DKRD);
        }
        return c;
    }

    private void loadConstraints() {
        block12: {
            Bundle bundle = PBSUIPlugin.getDefault().getBundle();
            URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(Messages.DynamicTabWizardPage_constraints), null);
            if (url == null) {
                return;
            }
            InputStream s = null;
            this.constrained = new Properties();
            try {
                try {
                    s = url.openStream();
                    this.constrained.load(s);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        s.close();
                    }
                    catch (IOException iOException) {}
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    s.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                s.close();
            }
            catch (IOException iOException) {}
        }
    }
}

