/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.proxy.core;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.ptp.proxy.event.IProxyEvent;
import org.eclipse.ptp.rm.proxy.core.attributes.AttributeDefinition;
import org.eclipse.ptp.rm.proxy.core.element.ElementManager;
import org.eclipse.ptp.rm.proxy.core.element.IElement;
import org.eclipse.ptp.rm.proxy.core.event.IEventFactory;
import org.eclipse.ptp.rm.proxy.core.parser.IParser;
import org.eclipse.ptp.utils.core.RangeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Controller {
    private Queue<String> debugFiles = null;
    private final String command;
    private final IEventFactory eventFactory;
    private final IParser parser;
    private int baseID = 0;
    private Controller parentController = null;
    public ElementManager currentElements = new ElementManager();
    private FilterData filter = null;
    private final AttributeDefinition attrDef;

    public Controller(String command, AttributeDefinition attrDef, IEventFactory eventFactory, IParser parser) {
        this.command = command;
        this.attrDef = attrDef;
        this.eventFactory = eventFactory;
        this.parser = parser;
    }

    public Controller(String command, AttributeDefinition attrDef, IEventFactory eventFactory, IParser parser, Controller parentController) {
        this(command, attrDef, eventFactory, parser);
        this.parentController = parentController;
    }

    private Set<IElement> filterElements(Set<IElement> elements) {
        if (this.filter == null) {
            return elements;
        }
        HashSet<IElement> ret = new HashSet<IElement>();
        for (IElement t : elements) {
            if (!this.filter.pattern.matcher(t.getAttribute(this.filter.key)).matches()) continue;
            ret.add(t);
        }
        return ret;
    }

    private int getParentIDFromKey(String parentKey) {
        int parentID = 0;
        parentID = this.parentController != null ? this.parentController.currentElements.getElementIDByKey(parentKey) : this.baseID;
        return parentID;
    }

    public Set<IElement> parse() throws Exception {
        InputStream is = null;
        if (this.debugFiles != null) {
            String file = this.debugFiles.poll();
            is = this.readFile(file);
            this.debugFiles.add(file);
        } else {
            is = this.readProgramOutput(this.command);
        }
        return this.parser.parse(this.attrDef, is);
    }

    private InputStream readFile(String path) throws IOException {
        return new BufferedInputStream(new FileInputStream(new File(path)));
    }

    private InputStream readProgramOutput(String string) throws IOException {
        String[] args = string.split(" ");
        Process p = Runtime.getRuntime().exec(args);
        return new BufferedInputStream(p.getInputStream());
    }

    public void setBaseID(int baseID) {
        if (this.parentController != null) {
            throw new AssertionError((Object)"Illegal to specify baseID and parentController!");
        }
        this.baseID = baseID;
    }

    public void setDebug(String ... files) {
        this.debugFiles = new LinkedList<String>(Arrays.asList(files));
    }

    public void setFilter(String key, String pattern) {
        this.filter = new FilterData(key, pattern);
    }

    public List<IProxyEvent> update() throws Exception {
        Set<IElement> eList = this.parse();
        eList = this.filterElements(eList);
        this.currentElements.update(eList);
        ElementManager addedElements = this.currentElements.getAddedElements();
        ElementManager removedElements = this.currentElements.getRemovedElements();
        ElementManager changedElements = this.currentElements.getChangedElements();
        ArrayList<IProxyEvent> events = new ArrayList<IProxyEvent>();
        List<List<String>> allNewArgs = addedElements.serializeSplittedByParent();
        for (List<String> newEventArgs : allNewArgs) {
            newEventArgs.set(0, Integer.toString(this.getParentIDFromKey(newEventArgs.get(0))));
            events.add(this.eventFactory.createNewEvent(newEventArgs.toArray(new String[0])));
        }
        RangeSet removedIDs = removedElements.getElementIDsAsRange();
        if (removedIDs.size() > 0) {
            events.add(this.eventFactory.createRemoveEvent(new String[]{removedIDs.toString()}));
        }
        if (changedElements.size() > 0) {
            List<String> changedArgs = changedElements.serialize();
            events.add(this.eventFactory.createChangeEvent(changedArgs.toArray(new String[0])));
        }
        return events;
    }

    class FilterData {
        String key;
        Pattern pattern;

        public FilterData(String key, String pattern) {
            this.key = key;
            this.pattern = Pattern.compile(pattern);
        }
    }
}

