/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import java.text.MessageFormat;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.rap.demo.controls.Util;
import org.eclipse.rwt.graphics.Graphics;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class TreeTab
extends ExampleTab {
    private static final int INITIAL_COLUMNS = 5;
    private static final int INITIAL_ITEMS = 15;
    private Tree tree;
    private boolean showImages = true;
    private final Image treeImage = Graphics.getImage((String)"resources/tree_item.gif", (ClassLoader)this.getClass().getClassLoader());

    public TreeTab(CTabFolder topFolder) {
        super(topFolder, "Tree");
    }

    protected void createStyleControls(final Composite parent) {
        this.createStyleButton("BORDER", 2048);
        this.createStyleButton("CHECK", 32);
        this.createStyleButton("MULTI", 2);
        this.createStyleButton("NO_SCROLL", 16);
        this.createVisibilityButton();
        this.createEnablementButton();
        this.createImagesButton(parent);
        this.createAddNodeButton(parent);
        this.createDisposeNodeButton(parent);
        this.createSelectAllButton(parent);
        this.createDeselectAllButton(parent);
        this.createSelectButton(parent);
        this.createDeselectButton(parent);
        this.createSetSelectionButton(parent);
        this.createShowColumnControl();
        this.createFgColorButton();
        this.createBgColorButton();
        this.createBgImageButton();
        this.createFontChooser();
        final Button itemFgButton = this.createPropertyButton("Custom foreground on 1st item", 32);
        itemFgButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem item = TreeTab.this.tree.getItem(0);
                Display display = parent.getDisplay();
                Color green = display.getSystemColor(5);
                item.setForeground((Color)(itemFgButton.getSelection() ? green : null));
            }
        });
        final Button itemBgButton = this.createPropertyButton("Custom background on 1st item", 32);
        itemBgButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem item = TreeTab.this.tree.getItem(0);
                Display display = parent.getDisplay();
                Color red = display.getSystemColor(4);
                item.setBackground((Color)(itemBgButton.getSelection() ? red : null));
            }
        });
        final Button itemGrayButton2 = this.createPropertyButton("Gray out 2nd item", 32);
        itemGrayButton2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeTab.this.tree.getItem(1).setGrayed(itemGrayButton2.getSelection());
            }
        });
        Button columnsAlignmentButton = this.createPropertyButton("Change columns alignment", 8);
        columnsAlignmentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TreeColumn col1 = TreeTab.this.tree.getColumn(1);
                if (col1.getAlignment() == 131072) {
                    col1.setAlignment(16384);
                } else {
                    col1.setAlignment(131072);
                }
                TreeColumn col2 = TreeTab.this.tree.getColumn(2);
                if (col2.getAlignment() == 0x1000000) {
                    col2.setAlignment(16384);
                } else {
                    col2.setAlignment(0x1000000);
                }
            }
        });
    }

    protected void createExampleControls(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        int style = this.getStyle();
        this.tree = new Tree(parent, style);
        this.tree.setLayoutData((Object)new GridData(1808));
        int i = 0;
        while (i < 5) {
            TreeColumn col1 = new TreeColumn(this.tree, 0);
            col1.setText("Col " + i);
            col1.setWidth(150);
            ++i;
        }
        i = 0;
        while (i < 15) {
            TreeItem item = new TreeItem(this.tree, 0);
            int j = 0;
            while (j < 5) {
                item.setText(j, "Node_" + (i + 1) + "." + j);
                ++j;
            }
            if (i % 2 == 0) {
                TreeItem subitem = new TreeItem(item, 0);
                int j2 = 0;
                while (j2 < 5) {
                    subitem.setText(j2, "Subnode_" + (i + 1) + "." + j2);
                    ++j2;
                }
            }
            ++i;
        }
        if (this.showImages) {
            TreeTab.changeImage(this.tree, this.treeImage);
        }
        final Label lblTreeEvent = new Label(parent, 0);
        lblTreeEvent.setLayoutData((Object)new GridData(300, 22));
        Menu treeMenu = new Menu((Control)this.tree);
        MenuItem treeMenuItem = new MenuItem(treeMenu, 8);
        treeMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TreeItem item = TreeTab.this.tree.getSelection()[0];
                String itemText = "null";
                if (item != null) {
                    item.getText();
                }
                String message = "You requested a context menu for: " + itemText;
                MessageDialog.openInformation((Shell)TreeTab.this.tree.getShell(), (String)"Information", (String)message);
            }
        });
        treeMenuItem.setText("TreeContextMenuItem");
        this.tree.setMenu(treeMenu);
        this.tree.addTreeListener(new TreeListener(){

            public void treeCollapsed(TreeEvent event) {
                Item item = (Item)event.item;
                lblTreeEvent.setText("Collapsed: " + item.getText());
            }

            public void treeExpanded(TreeEvent event) {
                Item item = (Item)event.item;
                lblTreeEvent.setText("Expanded: " + item.getText());
            }
        });
        this.tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String msg = "Selected: ";
                TreeItem item = (TreeItem)event.item;
                if ((TreeTab.this.getStyle() & 0x20) != 0) {
                    msg = String.valueOf(msg) + (item.getChecked() ? "[x] " : "[ ] ");
                }
                msg = String.valueOf(msg) + item.getText();
                switch (event.detail) {
                    case 0: {
                        msg = String.valueOf(msg) + ", detail: SWT.NONE";
                        break;
                    }
                    case 32: {
                        msg = String.valueOf(msg) + ", detail: SWT.CHECK";
                    }
                }
                lblTreeEvent.setText(msg);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                String title = "Widget Default Selected";
                Item item = (Item)event.item;
                String message = "Widget default selected on " + item.getText() + " received";
                MessageDialog.openInformation((Shell)TreeTab.this.getShell(), (String)title, (String)message);
            }
        });
        this.tree.setSelection(this.tree.getItem(0));
        this.tree.setHeaderVisible(true);
        this.registerControl((Control)this.tree);
    }

    private void createImagesButton(Composite parent) {
        final Button button = new Button(parent, 2);
        button.setText("Show Images");
        button.setSelection(true);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TreeTab.this.showImages = button.getSelection();
                TreeTab.changeImage(TreeTab.this.tree, TreeTab.this.showImages ? TreeTab.this.treeImage : null);
            }
        });
    }

    private void createAddNodeButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Add child item");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (TreeTab.this.tree.getSelectionCount() > 0) {
                    TreeItem selection = TreeTab.this.tree.getSelection()[0];
                    TreeItem treeItem = new TreeItem(selection, 0);
                    Object[] args = new Object[]{new Integer(selection.getItemCount()), selection.getText()};
                    String text = MessageFormat.format("SubItem {0} of {1}", args);
                    treeItem.setText(text);
                    treeItem.setChecked(true);
                    if (TreeTab.this.showImages) {
                        treeItem.setImage(TreeTab.this.treeImage);
                    }
                }
            }
        });
    }

    private void createDisposeNodeButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Dispose Selected Item");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (TreeTab.this.tree.getSelectionCount() > 0) {
                    TreeItem selection = TreeTab.this.tree.getSelection()[0];
                    selection.dispose();
                }
            }
        });
    }

    private void createSelectAllButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Select All");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TreeTab.this.tree.selectAll();
            }
        });
    }

    private void createDeselectAllButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Deselect All");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TreeTab.this.tree.deselectAll();
            }
        });
    }

    private void createSelectButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Select second node");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (TreeTab.this.tree.getItemCount() > 1) {
                    TreeTab.this.tree.select(TreeTab.this.tree.getItem(1));
                }
            }
        });
    }

    private void createDeselectButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Deselect second node");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (TreeTab.this.tree.getItemCount() > 1) {
                    TreeTab.this.tree.deselect(TreeTab.this.tree.getItem(1));
                }
            }
        });
    }

    private void createSetSelectionButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Set selection to first node");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (TreeTab.this.tree.getItemCount() > 0) {
                    TreeTab.this.tree.setSelection(TreeTab.this.tree.getItem(0));
                }
            }
        });
    }

    private void createShowColumnControl() {
        Composite composite = new Composite(this.styleComp, 0);
        RowLayout layout = new RowLayout(256);
        layout.center = true;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setText("Column");
        final Text text = new Text(composite, 2048);
        Util.textSizeAdjustment(label, (Control)text);
        text.setText(String.valueOf(this.tree.getColumnCount() - 1));
        Button button = new Button(composite, 8);
        button.setText("Show");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    int index = Integer.parseInt(text.getText());
                    TreeColumn column = TreeTab.this.tree.getColumn(index);
                    TreeTab.this.tree.showColumn(column);
                }
                catch (Exception exception) {}
            }
        });
    }

    private static void changeImage(Tree tree, Image image) {
        TreeItem[] items = tree.getItems();
        int i = 0;
        while (i < items.length) {
            TreeTab.changeImage(items[i], image);
            ++i;
        }
    }

    private static void changeImage(TreeItem item, Image image) {
        item.setImage(image);
        TreeItem[] items = item.getItems();
        int i = 0;
        while (i < items.length) {
            TreeTab.changeImage(items[i], image);
            ++i;
        }
    }
}

