/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.engine;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rwt.internal.ConfigurationReader;
import org.eclipse.rwt.internal.EngineConfig;
import org.eclipse.rwt.internal.IConfiguration;
import org.eclipse.rwt.internal.IEngineConfig;
import org.eclipse.rwt.internal.resources.ResourceManagerImpl;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.service.ServiceContext;
import org.eclipse.rwt.internal.service.ServiceManager;

public class RWTDelegate
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    static /* synthetic */ Class class$0;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        IEngineConfig engineConfig = this.getEngineConfig();
        try {
            ConfigurationReader.setEngineConfig(engineConfig);
            this.createResourceManagerInstance();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding("UTF-8");
        if (request.getPathInfo() != null) {
            RWTDelegate.handleInvalidRequest(request, response);
            return;
        }
        HttpServletRequest wrappedRequest = this.getWrappedRequest(request);
        try {
            ServiceContext context = new ServiceContext(wrappedRequest, response);
            ContextProvider.setContext(context);
            this.createSessionStore();
            ServiceManager.getHandler().service();
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            ContextProvider.disposeContext();
            throw throwable;
        }
        {
            Object var5_7 = null;
            ContextProvider.disposeContext();
            return;
        }
    }

    public String getServletInfo() {
        return "RAP Servlet Delegate";
    }

    protected HttpServletRequest getWrappedRequest(HttpServletRequest req) throws ServletException {
        return req;
    }

    private IEngineConfig getEngineConfig() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.internal.IEngineConfig");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String name = clazz.getName();
        ServletContext servleContext = this.getServletContext();
        IEngineConfig result = (IEngineConfig)servleContext.getAttribute(name);
        if (result == null) {
            result = new EngineConfig(servleContext.getRealPath("/"));
            servleContext.setAttribute(name, (Object)result);
        }
        return result;
    }

    private void createResourceManagerInstance() {
        IConfiguration configuration = ConfigurationReader.getConfiguration();
        String resources = configuration.getInitialization().getResources();
        ResourceManagerImpl.createInstance(this.getWebAppBase().toString(), resources);
    }

    private File getWebAppBase() {
        IEngineConfig engineConfig = ConfigurationReader.getEngineConfig();
        return engineConfig.getServerContextDir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSessionStore() {
        RWTDelegate rWTDelegate = this;
        synchronized (rWTDelegate) {
            ContextProvider.getSession();
        }
    }

    static void handleInvalidRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if ("/".equals(request.getPathInfo())) {
            String redirectUrl = RWTDelegate.createRedirectUrl(request);
            response.sendRedirect(response.encodeRedirectURL(redirectUrl));
        } else {
            response.sendError(404);
        }
    }

    static String createRedirectUrl(HttpServletRequest request) {
        String result = String.valueOf(request.getContextPath()) + request.getServletPath();
        Enumeration parameterNames = request.getParameterNames();
        if (parameterNames.hasMoreElements()) {
            result = String.valueOf(result) + "?";
            boolean first = true;
            while (parameterNames.hasMoreElements()) {
                String parameterName = (String)parameterNames.nextElement();
                if (!first) {
                    result = String.valueOf(result) + "&";
                }
                result = String.valueOf(result) + parameterName;
                result = String.valueOf(result) + "=";
                result = String.valueOf(result) + request.getParameter(parameterName);
                first = false;
            }
        }
        return result;
    }
}

