/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.lifecycle;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.rwt.AdapterFactory;
import org.eclipse.rwt.internal.lifecycle.IDisplayLifeCycleAdapter;
import org.eclipse.rwt.internal.lifecycle.LifeCycleAdapterException;
import org.eclipse.rwt.internal.lifecycle.LifeCycleAdapterUtil;
import org.eclipse.rwt.lifecycle.ILifeCycleAdapter;
import org.eclipse.rwt.lifecycle.IWidgetLifeCycleAdapter;
import org.eclipse.swt.internal.widgets.displaykit.DisplayLCAFacade;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;

public final class LifeCycleAdapterFactory
implements AdapterFactory {
    private static final Class[] ADAPTER_LIST;
    private static IDisplayLifeCycleAdapter displayAdapter;
    private static final Map widgetAdapters;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.lifecycle.ILifeCycleAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        ADAPTER_LIST = classArray;
        widgetAdapters = new HashMap();
    }

    public Object getAdapter(Object adaptable, Class adapter) {
        ILifeCycleAdapter result = null;
        if (this.isDisplayLCA(adaptable, adapter)) {
            result = LifeCycleAdapterFactory.getDisplayLCA();
        } else if (this.isWidgetLCA(adaptable, adapter)) {
            result = LifeCycleAdapterFactory.getWidgetLCA(adaptable.getClass());
        }
        return result;
    }

    public Class[] getAdapterList() {
        return ADAPTER_LIST;
    }

    private boolean isDisplayLCA(Object adaptable, Class adapter) {
        if (adaptable instanceof Display) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rwt.lifecycle.ILifeCycleAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (adapter == clazz) {
                return true;
            }
        }
        return false;
    }

    private static synchronized ILifeCycleAdapter getDisplayLCA() {
        if (displayAdapter == null) {
            displayAdapter = DisplayLCAFacade.getDisplayLCA();
        }
        return displayAdapter;
    }

    private boolean isWidgetLCA(Object adaptable, Class adapter) {
        if (adaptable instanceof Widget) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rwt.lifecycle.ILifeCycleAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (adapter == clazz) {
                return true;
            }
        }
        return false;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static synchronized ILifeCycleAdapter getWidgetLCA(Class clazz) {
        ILifeCycleAdapter result = (ILifeCycleAdapter)widgetAdapters.get(clazz);
        if (result == null) {
            Class<?> clazz2;
            IWidgetLifeCycleAdapter adapter = null;
            Class superClass = clazz;
            boolean bl = true;
            do {
                if (!bl || (bl = false) || !true) {
                    adapter = LifeCycleAdapterFactory.loadWidgetLCA(superClass);
                    if (adapter == null) {
                        superClass = superClass.getSuperclass();
                    }
                }
                if ((clazz2 = class$1) != null) continue;
                try {
                    clazz2 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            } while (!clazz2.equals(superClass) && adapter == null);
            widgetAdapters.put(clazz, adapter);
            result = adapter;
        }
        if (result == null) {
            String text = "Failed to obtain life cycle adapter for class ''{0}''.";
            Object[] params = new Object[]{clazz.getName()};
            String msg = MessageFormat.format(text, params);
            throw new LifeCycleAdapterException(msg);
        }
        return result;
    }

    private static IWidgetLifeCycleAdapter loadWidgetLCA(Class clazz) {
        IWidgetLifeCycleAdapter result = null;
        String packageName = clazz.getPackage().getName();
        String[] variants = LifeCycleAdapterUtil.getPackageVariants(packageName);
        int i = 0;
        while (result == null && i < variants.length) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(variants[i]);
            buffer.append(".");
            String simpleClassName = LifeCycleAdapterUtil.getSimpleClassName(clazz);
            buffer.append(simpleClassName.toLowerCase());
            buffer.append("kit.");
            buffer.append(simpleClassName);
            buffer.append("LCA");
            String classToLoad = buffer.toString();
            ClassLoader loader = clazz.getClassLoader();
            try {
                Class<?> adapterClass = loader.loadClass(classToLoad);
                result = (IWidgetLifeCycleAdapter)adapterClass.newInstance();
            }
            catch (Throwable throwable) {}
            ++i;
        }
        return result;
    }
}

