/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.lifecycle;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.internal.widgets.displaykit.DisplayLCAFacade;
import org.eclipse.swt.widgets.Widget;

public final class UITestUtil {
    static boolean enabled;

    static {
        String property = System.getProperty("org.eclipse.rwt.enableUITests");
        enabled = Boolean.valueOf(property);
    }

    public static void writeId(Widget widget) throws IOException {
        if (!UITestUtil.isInitialized(widget) && UITestUtil.isEnabled()) {
            String id = WidgetUtil.getId(widget);
            if (!UITestUtil.isValidId(id)) {
                String text = "The widget id contains illegal characters: ''{0}''";
                String msg = MessageFormat.format(text, id);
                throw new IllegalArgumentException(msg);
            }
            DisplayLCAFacade.writeTestWidgetId(widget, id);
        }
    }

    public static boolean isEnabled() {
        return enabled;
    }

    private static boolean isInitialized(Widget widget) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter(widget);
        return adapter.isInitialized();
    }

    static boolean isValidId(String id) {
        boolean result = id != null && id.length() > 0 && Character.isLetter(id.charAt(0));
        int i = 1;
        while (result && i < id.length()) {
            char ch = id.charAt(i);
            result &= Character.isLetter(ch) || UITestUtil.isNumber(ch) || ch == '.' || ch == '_' || ch == ':';
            ++i;
        }
        return result;
    }

    private static boolean isNumber(char ch) {
        return ch >= '0' && ch <= '9';
    }

    private UITestUtil() {
    }
}

